#include "sysdep.h"
#include "Char.h"

/*========================================================================*
 *	ץȥ
 *========================================================================*/
static	Char	Char_ToAscii (Char cc) ;

/*========================================================================*
 *	Хѿ
 *========================================================================*/

Char
Char_MakeAscii (char ch)
{
	return	Char_Make (KCHARSET_ASCII, ch & 0x7F) ;
}

Char
Char_Make (int nSet, int nCode)
{
	return	((nSet & 0x7F) << 24) | (nCode & 0xFFFF) ;
}

int
Char_IsAscii (Char cc)
{
	int	nCharSet ;
	int	nCode ;
	nCharSet	= CHAR_CHARSET (cc) ;
	nCode		= CHAR_CODE (cc) ;
	return	(KCHARSET_ASCII <= nCharSet && nCharSet < KCHARSET_2BYTES_CHARACTER && nCode < 0x80) ;
}

int
Char_IsNul (Char cc)
{
	return	(CHAR_CODE (cc) == '\0' && Char_IsAscii (cc)) ;
}

int
Char_Is2ByteChara (Char cc)
{
	int		nSet ;
	nSet	= CHAR_CHARSET (cc) ;
	return	(KCHARSET_2BYTES_CHARACTER <= nSet && nSet < MAX_CHARSET) ;
}

int
Char_DifferenceAscii (Char cc, char ch)
{
	return	Char_Difference (cc, Char_MakeAscii (ch)) ;
}

int
Char_Difference (Char chLeft, Char chRight)
{
	if (Char_IsAscii (chLeft))
		chLeft	= Char_ToAscii (chLeft) ;

	if (Char_IsAscii (chRight))
		chRight	= Char_ToAscii (chRight) ;

	return	(chLeft - chRight) ;
}

Char
Char_ToLower (Char cc)
{
	if (Char_IsAscii (cc) && ('A' <= CHAR_CODE (cc) && CHAR_CODE (cc) <= 'Z'))
		return	Char_MakeAscii ((char)(CHAR_CODE (cc) + 'a' - 'A')) ;
	return	cc ;
}

Char
Char_ToUpper (Char cc)
{
	if (Char_IsAscii (cc) && ('a' <= CHAR_CODE (cc) && CHAR_CODE (cc) <= 'z'))
		return	Char_MakeAscii ((char)(CHAR_CODE (cc) + 'A' - 'a')) ;
	return	cc ;
}

/*========================================================================*
 *	ؿ
 *========================================================================*/

/*
 *	ʸŪ˥ѹ롣
 */
Char
Char_ToAscii (Char cc)
{
	return	(KCHARSET_ASCII << 24) | CHAR_CODE (cc) ;
}


