;;; skk.el --- SKK (Simple Kana to Kanji conversion program)
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997,
;;               1998, 1999
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Maintainer: Hideki Sakurada <sakurada@kuis.kyoto-u.ac.jp>
;;             Murata Shuuichirou <mrt@astec.co.jp>
;;             Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Version: $Id: skk.el,v 1.2 2002/11/28 13:55:31 tatari Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2002/11/28 13:55:31 $

;; SKK is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either versions 2, or (at your option) any later
;; version.

;; SKK is distributed in the hope that it will be useful but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:
;;
;; SKK-MODE is a mode for inputting Japanese to a current buffer which is
;; composed of four minor modes described below.
;;
;;      +----------------------+-------- skk-mode -----+----------------------+
;;      |                      |                       |                      |
;;      |                      |                       |                      |
;;  skk-j-mode           skk-latin-mode      skk-jisx0208-latin-mode   skk-abbrev-mode
;;                           ASCII               JISX0208 LATIN         ABBREVIATION
;;                  (C-j wakes up skk-j-mode)   (ZEN'KAKU EIMOJI)
;;
;; skk-j-mode-map     skk-latin-mode-map  skk-jisx0208-latin-mode-map skk-abbrev-mode-map
;; skk-katakana: nil
;;   HIRAKANA
;;
;;  skk-j-mode-map
;; skk-katakana: t
;;   KATAKANA

;;; Code:
(require 'skk-foreword)

(defconst skk-version "10.62a")
(defconst skk-major-version (string-to-int (substring skk-version 0 2)))
(defconst skk-minor-version (string-to-int (substring skk-version 3)))
(defconst skk-emacs-type 'mule4)

;;;###autoload
(defun skk-version ()
  (interactive)
  (if (not (interactive-p))
      skk-version
    (save-match-data
      (let* ((raw-date "$Date: 2002/11/28 13:55:31 $")
             (year (substring raw-date 7 11))
             (month (substring raw-date 12 14))
             (date (substring raw-date 15 17)))
        (if (string-match "^0" month)
            (setq month (substring month (match-end 0))))
        (if (string-match "^0" date)
            (setq date (substring date (match-end 0))))
        (message "SKK version %s of %s, APEL inside"
                 skk-version
                 (concat (car (rassoc month skk-month-alist))
                         " " date ", " year))))))

;;;; variables declaration
;;; user variables

(defvar skk-init-file (expand-file-name "~/.skkinput.el")
  "*SKK νե̾
skk.el 9.x  ~/.emacs ǤΥޥǽȤʤä")

;;;###autoload
(defgroup skk nil "SKK basic customization."
  :prefix "skk-"
  :group 'japanese
  :group 'input-method)

(defgroup skk-faces nil
  "Faces used by SKK."
  :group 'skk
  :group 'faces)

(defcustom skk-special-midashi-char-list '(?> ?< ??)
  "*ƬϤΤΥץեåեåΥꥹȡ"
  ;;  "*List of prefix and suffix keys for entering `settoji' and `setsubiji'."
  :type '(repeat character)
  :group 'skk)

(defcustom skk-mode-hook nil
  "*SKK ưȤΥեå
¾ˡskk-auto-fill-mode-hookskk-load-hook, skk-init-file Ǥ⥫
ޥǽ"
  ;; "*Hook run at SKK startup.  This hook is also run
  ;;in skk-auto-fill-mode after skk-auto-fill-mode-hook.
  ;;skk-auto-fill-mode-hook, skk-load-hook, skk-init-file may also be used
  ;;for customization."
  :type 'hook
  :group 'skk)

(defcustom skk-auto-fill-mode-hook nil
  "*skk-auto-fill-mode ưȤΥեå
¾ˡskk-mode-hook, skk-load-hook, skk-init-file Ǥ⥫ޥ
ǽ"
  ;;  "*Hook run at startup of skk-auto-fill-mode.
  ;;skk-mode-hookskk-load-hook, skk-init-file may also be used for
  ;;customization."
  :type 'hook
  :group 'skk)

(defcustom skk-load-hook nil
  "*skk.el ɤȤΥեå
¾ˡskk-mode-hook, skk-auto-fill-mode-hook, skk-init-file Ǥ⥫
ޥǽ"
  ;;  "*Hook run when SKK is loaded.
  ;;skk-auto-fill-mode-hookskk-mode-hook, skk-init-file may also be used
  ;;for customization."
  :type 'hook
  :group 'skk)

(defcustom skk-search-end-function nil
  "*ñ측λ˥뤵ؿ
δؿѤƸñ̤ͥѹʤɤκȤǽ
HENKAN-BUFFER, MIDASI, OKURIGANA, ENTRY  4 ȼʤäƥ뤵롣
ù ENTRY ֤ȡ
δؿϡХåեǥ뤵ΤǡѴԤʤäХåեʾ
ФȤϡHENKAN-BUFFER Ѥ롣"
  :type '(choice function (const nil))
  :group 'skk)

(defcustom skk-update-end-function nil
  "*Ŀͼιλ˥뤵ؿ
HENKAN-BUFFER, MIDASI, OKURIGANA, WORD, PURGE  5 ȼʤäƥ뤵롣
δؿϡХåեǥ뤵ΤǡѴԤʤäХåեʾ
ФȤϡHENKAN-BUFFER Ѥ롣
skk-kakutei-initialize 뤵ˤδؿ뤵ΤǡǸγ
˴ؤե饰ϡδؿ椫黲Ȥ뤳ȤǤ롣"
  :type '(choice function (const nil))
  :group 'skk)

(defcustom skk-kakutei-end-function nil
  "*˥뤵ؿ
KAKUTEI-WORD ȼʤäơѴԤʤäХåեǥ뤵롣
skk-kakutei-initialize 뤵ˤδؿ뤵ΤǡǸγ
˴ؤե饰ϡδؿ椫黲Ȥ뤳ȤǤ롣"
  :type '(choice function (const nil))
  :group 'skk)

(defcustom skk-kakutei-jisyo nil
  "*ǽ˸뼭
Non-nil ǡ skk-search-prog-list ǤˤѿѤƤС
ꤵ줿򸡺ΤХåեɤ߹ߡԤʤ
ФϡȤƤʤФʤʤ
ƸФκǽΥȥꤷʤ (ʣΥȥ꤬äƤ 2 ܰʹߤ
ȥ̵뤵)
skk-search-prog-list ͤꤹ뤳Ȥˤꡢоݤμѹν
ѹǽ"
  ;;  "*The first dictionary to be searched.
  ;;If non-nil, and this variable is used as a component of
  ;;`skk-search-prog-list', the indicated dictionary is read into a
  ;;buffer and searched.
  ;;The keys must be sorted.
  ;;Only the first entry in each key is checked; if several entries are
  ;;present the second and following entries are ignored.
  ;;By setting the value of `skk-search-prog-list' the dictionaries
  ;;searched and the order of search can be changed."
  :type '(choice file (const nil))
  :group 'skk)

(defcustom skk-initial-search-jisyo nil
  "*桼θ˸뼭
ФϡȤƤʤФʤʤ
Non-nil ǡ skk-search-prog-list ǤˤѿѤƤС
ꤵ줿򸡺ΤХåեɤ߹ߡԤʤ
skk-search-prog-list ͤꤹ뤳Ȥˤꡢоݤμѹν
ѹǽ"
  ;;  "*This dictionary is searched before the user's personal dictionary.
  ;;The keys must be sorted.
  ;;If non-nil, and this variable is used as a component of
  ;;`skk-search-prog-list', the indicated dictionary is read into a
  ;;buffer and searched.
  ;;By setting the value of `skk-search-prog-list' the dictionaries
  ;;searched and the order of search can be changed."
  :type '(choice file (const nil))
  :group 'skk)

(defcustom skk-large-jisyo nil
  "*桼θθ˸뼭
ФϡȤƤʤФʤʤ
Non-nil ǡ skk-search-prog-list ǤˤѿѤƤС
ꤵ줿򸡺ΤХåեɤ߹ߡԤʤ
skk-search-prog-list ͤꤹ뤳Ȥˤꡢоݤμѹν
ѹǽ"
  :type '(choice file (const nil))
  :group 'skk)

(defcustom skk-aux-large-jisyo nil
  "*SKK СǺǸ˸뼭
ФϡȤƤʤФʤʤ
Non-nil ǡ skk-search-prog-list ǤˤѿѤƤС
SKK СȤԤ
SKK С active ǤʤСꤵ줿Хåեɤ߹ࡣ
skk-search-prog-list ͤꤹ뤳Ȥˤꡢоݤμѹν
ѹǽ
ͤꤹ뤳Ȥˤꡢskk-server.el  autoload 롣"
  :type '(choice file (const nil))
  :group 'skk)

(defcustom skk-search-prog-list
  '((skk-search-kakutei-jisyo-file skk-kakutei-jisyo 10000 t)
    (skk-search-jisyo-file skk-initial-search-jisyo 10000 t)
    (skk-search-jisyo-file skkinput-jisyo 0 t)
    (skk-search-jisyo-file skk-jisyo 0 t)
    ;; skk-auto.el ɤȲǤץ饹롣
    ;;(skk-okuri-search)
    (skk-search-jisyo-file skk-large-jisyo 10000)
    ;; skk-server.el ɤȲǤץ饹롣
    ;;(skk-search-server skk-aux-large-jisyo 10000)
    ;; skk-server-host ⤷ skk-servers-list ꤹȡskk-server.el
    ;;  autoload 롣
   )
  "*ؿоݤμꤹ뤿Υꥹȡ
Ѵ֤ S ꥹȤηɽΡ
skk-search ؿ skk-search-prog-list  car ؽ֤ S ɾ
ԤѴԤʤ"
  :type '(repeat
	  (list (function :tag "Search funcition")
		(choice :tag "Dictionary" file (const nil))
		(choice :tag "Minimum region size to be binary-searched"
			integer (const nil))
		(choice :tag "Quietly reading dictionary to Emacs buffer"
			(const t) (const nil))))
  :group 'skk)

(defcustom skkinput-jisyo (expand-file-name "~/.skkinput-jisyo")
  "*skkinput Υ桼"
  :type 'file
  :group 'skk)

(defcustom skk-jisyo (expand-file-name "~/.skk-jisyo")
  "*SKK Υ桼"
  :type 'file
  :group 'skk)

(defcustom skk-backup-jisyo (expand-file-name "~/.skkinput-jisyo.BAK")
  "*SKK Υ桼ΥХååץե롣"
  :type 'file
  :group 'skk)

(defcustom skk-jisyo-code nil
  "*Non-nil ǤСͤǼХåեδɤꤹ롣
Mule Ǥϡ*euc-japan*, *sjis*, *junet*
ޤ\"euc\", \"ujis\", \"sjis\", \"jis\" ʤɤʸˤäƤ꤬ǽ"
  :type '(choice symbol string)
  :group 'skk)

(defcustom skk-keep-record t
  "*Non-nil ǤСѴ˴ؤ뵭Ͽ skk-record-file ˼롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-record-file (expand-file-name "~/.skkinput-record")
  "*桼פե롣
񥻡֤λñϿԤäΨΤθ
롣"
  :type 'file
  :group 'skk)

(defcustom skk-kakutei-key "\C-j"
  "*ѴγưԤ"
  :type 'string
  :group 'skk)

(defcustom skk-previous-candidate-char ?x
  "*skk-previous-candidate Ƥ饯"
  :type 'character
  :group 'skk)

(defcustom skk-try-completion-char ?\011 ; TAB
  "*Ф䴰ưԤʤ饯"
  :type 'character
  :group 'skk)

(defcustom skk-next-completion-char ?.
  "*Ф䴰ưǡθϤ륭饯"
  :type 'character
  :group 'skk)

(defcustom skk-previous-completion-char ?,
  "*Ф䴰ưǡθϤ륭饯"
  :type 'character
  :group 'skk)

(defcustom skk-start-henkan-char ?\040	; SPC
  "*Ѵ򳫻Ϥ륭饯"
  :type 'character
  :group 'skk)

(defcustom skk-start-henkan-with-completion-char ?\240 ; M-SPC
  "*Ф䴰ʤ颧⡼ɤ륭饯"
  :type 'character
  :group 'skk)

(defcustom skk-backward-and-set-henkan-point-char ?\321 ; M-Q
  "*ݥȤᤷƢ⡼ɤ륭饯"
  :type 'character
  :group 'skk)

(defcustom skk-use-viper nil
  "*Non-nil ǤСVIPER б롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-henkan-okuri-strictly nil
  "*Non-nil ǤСФ겾̾פȤȤƽϤ롣
㤨СΤ褦ʼ񥨥ȥ꤬skk-jisyo \(ץ饤١ȼ\) ˤä

  \"k //¿/[/¿/]/[//]/\"

\"*\" ѴȤ\"¿\" ΤߤϤ\"礯\" Ϥʤ

SKK-JISYO.[SML] 겾̾ȥϾ嵭ηˤʤäƤʤΤǡskk-jisyo 
ꤢμ񥨥ȥ꤬ηΤΤ򤢤ޤޤǤʤϡΥץ
 on ˤ뤳ȤǡñϿäƤޤΤդ뤳ȡ

skk-process-okuri-early ͤ nil ʤо嵭η skk-jisyo 롣

Emacs 19 ١ Mule ʤСΥեɾ뤳ȤǡñϿ
ȤŪˤΥץ nil ˤ뤳ȤǤ롣

    \(add-hook 'minibuffer-setup-hook
              \(function
               \(lambda \(\)
                 \(if \(and \(boundp 'skk-henkan-okuri-strictly\)
                          skk-henkan-okuri-strictly
                          \(not \(eq last-command 'skk-purge-from-jisyo\)\) \)
                     \(progn
                       \(setq skk-henkan-okuri-strictly nil\)
                       \(put 'skk-henkan-okuri-strictly 'temporary-nil t\) \)\)\)\)\)

    \(add-hook 'minibuffer-exit-hook
              \(function
               \(lambda \(\)
                 \(if \(get 'skk-henkan-okuri-strictly 'temporary-nil\)
                     \(progn
                       \(put 'skk-henkan-okuri-strictly 'temporary-nil nil\)
                       \(setq skk-henkan-okuri-strictly t\) \)\)\)\)\)

Υץѻϡskk-process-okuri-early ͤ nil ǤʤФʤʤ
\(˥塼СѤƥޥϼưŪĴ\)"
  :type 'boolean
  :group 'skk)

(defcustom skk-henkan-strict-okuri-precedence nil
  "*Non-nil ǤСФ겾̾פͥ褷ɽ롣
㤨СΤ褦ʼ񥨥ȥ꤬skk-jisyo \(ץ饤١ȼ\) ˤä

  \"k //¿/[/¿/]/[//]/\"

\"*\" ѴȤޤ\"¿\" Ϥ
 \"礯\" Ϥ롣

\"礯\"ʤɤθϤäȤñϿˤϤäƤޤΤ
ʤҤȤˤᡣ

Υץѻϡskk-process-okuri-early ͤ nil ǤʤФʤʤ
ޤ skk-henkan-okuri-strictly  non-nil ΤȤϡѿ̵뤵롣
\(˥塼СѤƥޥϼưŪĴ\)"
  :type 'boolean
  :group 'skk)

(defcustom skk-auto-okuri-process nil
  "*Non-nil ǤС겾̾ʬưǧѴԤ
㤨С

    \"Uresii (\"UreSii\" ǤϤʤ) -> 򤷤\"

Τ褦Ѵ롣âskk-jisyo  \(ץ饤١ȼ\) 

    \"s //[//]/\"

Τ褦ʷˤʤäƤ뤳ȤɬפǤ \(SKK-JISYO.[SML] Ϥηб
ƤʤΤǡskk-jisyo ˤΥȥ꤬ʤФʤʤ\)

Υץѻϡskk-process-okuri-early ͤ nil ǤʤФʤʤ
\(˥塼СѤƥޥϼưŪĴ\)"
  :type 'boolean
  :group 'skk)

(defcustom skk-process-okuri-early nil
  "*Non-nil ǤС겾̾Υ޻ץեåϻѴ򳫻Ϥ롣
㤨С

    \"UgoK -> ưk\"

겾̾ʬʤޤѴƤ뤳ȤˤʤΤǡskk-jisyo 겾̾б
ĹʤĤޤ

    \"k /ư/\"

Τ褦ʷ֤ΤޤޤȤʤ롣

    \"k /ư/[/ư/]/[/ư/]/[/ư/]/[/ư/]/[/ư/]/\"

Τ褦ʥȥ꤬ skk-jisyo ˤС˲ʤ

nil ǤС겾̾ϤλѴϤ롣㤨С

    \"UgoK -> *k\", \"UgoKu -> ư\"

Υץ on ˤ skk-mode ưȡξΩǤʤץǤ
skk-kakutei-early, skk-auto-okuri-process, skk-henkan-okuri-strictly  nil 
åȤ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-egg-like-newline nil
  "*Non-nil ǤС⡼ɤǲԤ򥿥פƤꤹΤߤǲԤʤ"
  :type 'boolean
  :group 'skk)

(defcustom skk-kakutei-early t
  "*Non-nil Ǥ skk-insert ƤФ줿Ȥ˸ߤθꤹ롣
㤨С

    \"Ƥ ->  -> s -> ꤹ\"

Τ褦Ѵ塢֤פ prefix Ǥ \"s\" Ϥǳꤹ롣
nil ǤС㤨

    \"Ƥ ->  -> s -> ꤹ -> ꤹ롣\"

Τ褦 skk-kakutei ľܡܤ˥뤹ޤ \(Ϥꡢ
⡼ɤäꤹȴŪ skk-kakutei 򥳡뤹\) ϡꤷʤΤǡ
δ֤ϡѴӤʤȤʤɤǽ

Υץѻϡskk-process-okuri-early ͤ nil ǤʤФʤʤ
\(˥塼СѤƥޥϼưŪĴ\)"
  :type 'boolean
  :group 'skk)

(defcustom skk-delete-implies-kakutei t
  "*Non-nil ǤС⡼ɤ BS 򲡤ȡΰʸꤹ롣
nil ǤСθɽ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-allow-spaces-newlines-and-tabs t
  "*Non-nil ǤСФ˥ڡ֡ԤäƤ⤽Ѵ뤳Ȥǽ
㤨СΤ褦 ˲ԤäƤƤѴǽǤ롣

     \"
  \"
   -> \"̾\"

ͤ nil ǤСǽΥڡǸФڤͤƤޤʹߤΥڡ
֡Ԥ̵뤵롣
ͤϡskk-start-henkan, skk-latin-henkan, skk-katakana-henkan,
skk-hiragana-henkan, skk-jisx0208-latin-henkan ڤ
skk-backward-and-set-henkan-point ư˱ƶ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-convert-okurigana-into-katakana nil
  "*Non-nil ǤСʥ⡼ɤѴȤ겾̾⥫ʤѴ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-delete-okuri-when-quit nil
  "*Non-nil ǤСꤢѴ \"C-g\" 򲡤겾̾ä⡼ɤ롣
㤨С

    \"* -> 㤯 -> \"C-g\" ->\"

nil ǤС겾̾ޤ᤿Ф򤽤Τޤ޻Ĥ⡼ɤ롣㤨С

    \"* -> 㤯 -> \"C-g\" -> ʤ\""
  :type 'boolean
  :group 'skk)

(defcustom skk-henkan-show-candidates-keys '(?a ?s ?d ?f ?j ?k ?l)
  "*˥塼Ǹ򤹤Ȥ򥭡Υꥹȡ
\"x\", \" \" ڤ \"C-g\" ʳ 7 ĤΥ (char type) ޤɬפ
롣\"x\", \" \" ڤ \"C-g\" ϸˤ줾̤ʻŻ˳
ƤƤΤǡΥꥹȤˤϴޤʤȡ"
  :type '(repeat character)
  :group 'skk)

(defcustom skk-status-indicator 'left
  "*SKK ξ֤⡼ɹԤΤɤɽ뤫롣
left Ǥкüɽ롣
ʤХޥʡ⡼ɤȤƤɽˡ롣"
  :type '(choice (const minor-mode)
		 (const left))
  :group 'skk)

(defcustom skk-latin-mode-string " SKK"
  "*SKK  latin (ascii) ⡼ɤǤȤ˥⡼ɥ饤ɽʸ"
  :type 'string
  :group 'skk)

(defcustom skk-hiragana-mode-string " "
  "*Ҥ餬ʥ⡼ɤǤȤ˥⡼ɥ饤ɽʸ"
  :type 'string
  :group 'skk)

(defcustom skk-katakana-mode-string " "
  "*ʥ⡼ɤǤȤ˥⡼ɥ饤ɽʸ"
  :type 'string
  :group 'skk)

(defcustom skk-jisx0208-latin-mode-string " "
  "*ѥ⡼ɤǤȤ˥⡼ɥ饤ɽʸ"
  :type 'string
  :group 'skk)

(defcustom skk-abbrev-mode-string " a"
  "*SKK abbrev ⡼ɤǤȤ˥⡼ɥ饤ɽʸ"
  :type 'string
  :group 'skk)

(defcustom skk-echo t
  "*Non-nil ǤС̾ʸΥץեåɽ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-use-numeric-conversion t
  "*Non-nil ǤСѴԤ"
  :type 'boolean
  :group 'skk)

(defcustom skk-rom-kana-base-rule-list
  '(("a" nil ("" . ""))
    ("bb" "b" ("" . ""))
    ("ba" nil ("" . ""))
    ("be" nil ("" . ""))
    ("bi" nil ("" . ""))
    ("bo" nil ("" . ""))
    ("bu" nil ("" . ""))
    ("bya" nil ("ӥ" . "Ӥ"))
    ("bye" nil ("ӥ" . "Ӥ"))
    ("byi" nil ("ӥ" . "Ӥ"))
    ("byo" nil ("ӥ" . "Ӥ"))
    ("byu" nil ("ӥ" . "Ӥ"))
    ("cc" "c" ("" . ""))
    ("cha" nil ("" . ""))
    ("che" nil ("" . ""))
    ("chi" nil ("" . ""))
    ("cho" nil ("" . ""))
    ("chu" nil ("" . ""))
    ("cya" nil ("" . ""))
    ("cye" nil ("" . ""))
    ("cyi" nil ("" . ""))
    ("cyo" nil ("" . ""))
    ("cyu" nil ("" . ""))
    ("dd" "d" ("" . ""))
    ("da" nil ("" . ""))
    ("de" nil ("" . ""))
    ("dha" nil ("ǥ" . "Ǥ"))
    ("dhe" nil ("ǥ" . "Ǥ"))
    ("dhi" nil ("ǥ" . "Ǥ"))
    ("dho" nil ("ǥ" . "Ǥ"))
    ("dhu" nil ("ǥ" . "Ǥ"))
    ("di" nil ("" . ""))
    ("do" nil ("" . ""))
    ("du" nil ("" . ""))
    ("dya" nil ("¥" . "¤"))
    ("dye" nil ("¥" . "¤"))
    ("dyi" nil ("¥" . "¤"))
    ("dyo" nil ("¥" . "¤"))
    ("dyu" nil ("¥" . "¤"))
    ("e" nil ("" . ""))
    ("ff" "f" ("" . ""))
    ("fa" nil ("ե" . "դ"))
    ("fe" nil ("ե" . "դ"))
    ("fi" nil ("ե" . "դ"))
    ("fo" nil ("ե" . "դ"))
    ("fu" nil ("" . ""))
    ("fya" nil ("ե" . "դ"))
    ("fye" nil ("ե" . "դ"))
    ("fyi" nil ("ե" . "դ"))
    ("fyo" nil ("ե" . "դ"))
    ("fyu" nil ("ե" . "դ"))
    ("gg" "g" ("" . ""))
    ("ga" nil ("" . ""))
    ("ge" nil ("" . ""))
    ("gi" nil ("" . ""))
    ("go" nil ("" . ""))
    ("gu" nil ("" . ""))
    ("gya" nil ("" . ""))
    ("gye" nil ("" . ""))
    ("gyi" nil ("" . ""))
    ("gyo" nil ("" . ""))
    ("gyu" nil ("" . ""))
    ;;("h" "" ("" . ""))
    ("ha" nil ("" . ""))
    ("he" nil ("" . ""))
    ("hi" nil ("" . ""))
    ("ho" nil ("" . ""))
    ("hu" nil ("" . ""))
    ("hya" nil ("ҥ" . "Ҥ"))
    ("hye" nil ("ҥ" . "Ҥ"))
    ("hyi" nil ("ҥ" . "Ҥ"))
    ("hyo" nil ("ҥ" . "Ҥ"))
    ("hyu" nil ("ҥ" . "Ҥ"))
    ("i" nil ("" . ""))
    ("jj" "j" ("" . ""))
    ("ja" nil ("" . ""))
    ("je" nil ("" . ""))
    ("ji" nil ("" . ""))
    ("jo" nil ("" . ""))
    ("ju" nil ("" . ""))
    ("jya" nil ("" . ""))
    ("jye" nil ("" . ""))
    ("jyi" nil ("" . ""))
    ("jyo" nil ("" . ""))
    ("jyu" nil ("" . ""))
    ("kk" "k" ("" . ""))
    ("ka" nil ("" . ""))
    ("ke" nil ("" . ""))
    ("ki" nil ("" . ""))
    ("ko" nil ("" . ""))
    ("ku" nil ("" . ""))
    ("kya" nil ("" . ""))
    ("kye" nil ("" . ""))
    ("kyi" nil ("" . ""))
    ("kyo" nil ("" . ""))
    ("kyu" nil ("" . ""))
    ("ma" nil ("" . ""))
    ("me" nil ("" . ""))
    ("mi" nil ("" . ""))
    ("mo" nil ("" . ""))
    ("mu" nil ("" . ""))
    ("mya" nil ("ߥ" . "ߤ"))
    ("mye" nil ("ߥ" . "ߤ"))
    ("myi" nil ("ߥ" . "ߤ"))
    ("myo" nil ("ߥ" . "ߤ"))
    ("myu" nil ("ߥ" . "ߤ"))
    ("n" nil ("" . ""))
    ("n'" nil ("" . ""))
    ("na" nil ("" . ""))
    ("ne" nil ("" . ""))
    ("ni" nil ("" . ""))
    ("nn" nil ("" . ""))
    ("no" nil ("" . ""))
    ("nu" nil ("" . ""))
    ("nya" nil ("˥" . "ˤ"))
    ("nye" nil ("˥" . "ˤ"))
    ("nyi" nil ("˥" . "ˤ"))
    ("nyo" nil ("˥" . "ˤ"))
    ("nyu" nil ("˥" . "ˤ"))
    ("o" nil ("" . ""))
    ("pp" "p" ("" . ""))
    ("pa" nil ("" . ""))
    ("pe" nil ("" . ""))
    ("pi" nil ("" . ""))
    ("po" nil ("" . ""))
    ("pu" nil ("" . ""))
    ("pya" nil ("ԥ" . "Ԥ"))
    ("pye" nil ("ԥ" . "Ԥ"))
    ("pyi" nil ("ԥ" . "Ԥ"))
    ("pyo" nil ("ԥ" . "Ԥ"))
    ("pyu" nil ("ԥ" . "Ԥ"))
    ("rr" "r" ("" . ""))
    ("ra" nil ("" . ""))
    ("re" nil ("" . ""))
    ("ri" nil ("" . ""))
    ("ro" nil ("" . ""))
    ("ru" nil ("" . ""))
    ("rya" nil ("" . ""))
    ("rye" nil ("ꥧ" . "ꤧ"))
    ("ryi" nil ("ꥣ" . "ꤣ"))
    ("ryo" nil ("" . ""))
    ("ryu" nil ("" . ""))
    ("ss" "s" ("" . ""))
    ("sa" nil ("" . ""))
    ("se" nil ("" . ""))
    ("sha" nil ("" . ""))
    ("she" nil ("" . ""))
    ("shi" nil ("" . ""))
    ("sho" nil ("" . ""))
    ("shu" nil ("" . ""))
    ("si" nil ("" . ""))
    ("so" nil ("" . ""))
    ("su" nil ("" . ""))
    ("sya" nil ("" . ""))
    ("sye" nil ("" . ""))
    ("syi" nil ("" . ""))
    ("syo" nil ("" . ""))
    ("syu" nil ("" . ""))
    ("tt" "t" ("" . ""))
    ("ta" nil ("" . ""))
    ("te" nil ("" . ""))
    ("tha" nil ("ƥ" . "Ƥ"))
    ("the" nil ("ƥ" . "Ƥ"))
    ("thi" nil ("ƥ" . "Ƥ"))
    ("tho" nil ("ƥ" . "Ƥ"))
    ("thu" nil ("ƥ" . "Ƥ"))
    ("ti" nil ("" . ""))
    ("to" nil ("" . ""))
    ("tsu" nil ("" . ""))
    ("tu" nil ("" . ""))
    ("tya" nil ("" . ""))
    ("tye" nil ("" . ""))
    ("tyi" nil ("" . ""))
    ("tyo" nil ("" . ""))
    ("tyu" nil ("" . ""))
    ("u" nil ("" . ""))
    ("vv" "v" ("" . ""))
    ("va" nil ("" . ""))
    ("ve" nil ("" . ""))
    ("vi" nil ("" . ""))
    ("vo" nil ("" . ""))
    ("vu" nil ("" . ""))
    ("ww" "w" ("" . ""))
    ("wa" nil ("" . ""))
    ("we" nil ("" . ""))
    ("wi" nil ("" . ""))
    ("wo" nil ("" . ""))
    ("wu" nil ("" . ""))
    ("xx" "x" ("" . ""))
    ("xa" nil ("" . ""))
    ("xe" nil ("" . ""))
    ("xi" nil ("" . ""))
    ("xka" nil ("" . ""))
    ("xke" nil ("" . ""))
    ("xo" nil ("" . ""))
    ("xtsu" nil ("" . ""))
    ("xtu" nil ("" . ""))
    ("xu" nil ("" . ""))
    ("xwa" nil ("" . ""))
    ("xwe" nil ("" . ""))
    ("xwi" nil ("" . ""))
    ("xya" nil ("" . ""))
    ("xyo" nil ("" . ""))
    ("xyu" nil ("" . ""))
    ("yy" "y" ("" . ""))
    ("ya" nil ("" . ""))
    ("ye" nil ("" . ""))
    ("yo" nil ("" . ""))
    ("yu" nil ("" . ""))
    ("zz" "z" ("" . ""))
    ("z," nil "")
    ("z-" nil "")
    ("z." nil "")
    ("z/" nil "")
    ("z[" nil "")
    ("z]" nil "")
    ("za" nil ("" . ""))
    ("ze" nil ("" . ""))
    ("zh" nil "")
    ("zi" nil ("" . ""))
    ("zj" nil "")
    ("zk" nil "")
    ("zl" nil "")
    ("zo" nil ("" . ""))
    ("zu" nil ("" . ""))
    ("zya" nil ("" . ""))
    ("zye" nil ("" . ""))
    ("zyi" nil ("" . ""))
    ("zyo" nil ("" . ""))
    ("zyu" nil ("" . ""))
    ("." nil skk-current-kuten)
    ("," nil skk-current-touten)
    ("-" nil "")
    (":" nil "")
    (";" nil "")
    ("?" nil "")
    ("[" nil "")
    ("]" nil "")
    ("l" nil skk-latin-mode)
    ("q" nil skk-toggle-kana)
    ("L" nil skk-jisx0208-latin-mode)
    ("Q" nil skk-set-henkan-point-subr)
    ("X" nil skk-purge-from-jisyo)
    ("/" nil skk-abbrev-mode)
    ("$" nil skk-display-code-for-char-at-point)
    ("@" nil skk-today)
    ("\\" nil skk-input-by-code-or-menu)
   )
  ;; 󥹥ȤˤƤޤʤΤϡ޻ϤȤ̤
  ;; ͤ⤤뤫Ǥ
  "*ϤФѴʸ򸽤魯ȥޥȥܵ§
ꥹȤγǤϡΥꥹȷƤʤФʤʤ

\(ߤΥϾ[@0][@1]...[@n] ǽΥϾ \)

\(â\"@\" Ϣ\) ̣롣

Ϥ˻ǤΤϡʸʸ car, cdr ˻ dot pair
ؿ̾ܥΤ줫dot pair ϡʥ⡼ɤΤȤ car ʸ
󡢤ʥ⡼ɤΤȤ cdr ʸ롣ʸΤ߻ꤵ
Ƥϡϥ⡼ɤˤ餺ʸ롣
ʸؿˤĤƤϡinsert Ū˸ƤɬפϤʤʸ
֤ɤʸʤؿˤĤƤϲġ

ѿ١ skk-rom-kana-rule-list ɲä졢skk-mode
ư skk-rule-tree Ȥڤη˥ѥ뤵롣
2 ĤΥ롼ꥹȤ˽ʣ륭꤬ϡ
skk-rom-kana-rule-list ͥ褵롣"
  :type '(repeat
	  (list string string
		(choice function string (cons string string))))
  :group 'skk)

(defcustom skk-rom-kana-rule-list
  '(
    ;; 桼ιߤ꤬ʬ줽Ǥϡ
    ;; skk-rom-kana-base-rule-list 餳ذܤޤ礦...
    ("hh" "h" ("" . ""))
    ;; when you may want to insert ֤ޡby "gamma"...
    ("mm" "m" ("" . ""))
   )
  "*ϤФѴʸ򸽤魯ȥޥȥܵ§ǡ桼ɲäԤʤΡ
١Ȥʤ skk-rom-kana-base-rule-list ˤѿɲä졢
skk-mode ư skk-rule-tree Ȥڤη˥ѥ뤵롣
2 ĤΥ롼ꥹȤ˽ʣ륭꤬ϡѿͥ
褵롣

ꥹȤγǤϡΥꥹȷƤʤФʤʤ

\(ߤΥϾ[@0][@1]...[@n] ǽΥϾ \)

\(â\"@\" Ϣ\) ̣롣

ϤμˤĤƤϡskk-rom-kana-base-rule-list 򻲾ȤΤȡ
桼ɲä롼

    \(setq skk-rom-kana-rule-list
      '\(
        \(\"hh\" \"h\" \(\"\" . \"\"\)\)
        \(\"@\" nil \"\"\)
        ...
        \)

Τ褦 .emacs  skk-init-file ľܽ񤯤Τڡ

ǥեȤǤϡ\(\"hh\" \"h\" \(\"\" . \"\"\)\) ȤǤ
ꤵƤ뤬\"ohhira\" -> \"Ҥ\" Τ褦 \"hh\" ¥
ʤСskk-rom-kana-rule-list 

    \(\"hh\" \"h\" \(\"\" . \"\"\)\)

ȤǤä
ޤ`@'  skk-today (դ) ư `' 
Ϥϡskk-rom-kana-rule-list 

    \(\"@\" nil \"\"\)

ȤǤä롣skk-mode εư skk-rom-kana-rule-list ѹ
Ԥʤä硢ȿǤˤ M-x skk-restart ¹Ԥɬ
롣"
  :type '(repeat
	  (list string string
		(choice function string (cons string string))))
  :group 'skk)

(defcustom skk-kana-input-search-function
  (function
   (lambda ()
     (save-match-data
       (and (string-match "^h\\([bcdfghjklmnpqrstvwxz]\\)$" skk-prefix)
	    (member (char-to-string (preceding-char)) '("" ""))
	    (cons '("" . "") (match-string 1 skk-prefix))))))
  "*롼ꥹȤ˵ʤѴ롼ؿ
skk-rom-kana-base-rule-list  skk-rom-kana-rule-list ǤƸ
˥뤵롣Ϥʤ

\(ߤϤФ . \"³ unfixed prefix\"\)

Ȥ֤ϤμˤĤƤϡskk-rom-kana-base-rule-list 
ȤΤȡ

ǥեȤǤϡ\"\" θ \"h\" + ҲϤ \"\" + ³
Ѥ unfixed prefix ѴƤ롣"
  :type 'function
  :group 'skk)

(defcustom skk-okuri-char-alist nil
  "*겾̤̾겾̾Ѵ롼򵭽Ҥ륨ꥹȡ"
  :type '(repeat (cons string string))
  :group 'skk)

(defcustom skk-downcase-alist nil
  "*Ѵ (ʸ޻) ξʸؤѴ§ɽ魯ꥹȡ
ѴϤ򳫻ϤݡSKK ǤʸϤԤʤΤǡ
skk-set-henkan-point ǤʸѴȤԤʤΥ
ꥹȤʸ -> ʸѴ롼񤤤ƤȤǡϤΥ
ޥԤʤȤǤ롣ΥꥹȤ null ξϡñ
downcase 롣"
  :type '(repeat (cons character character))
  :group 'skk)

(defcustom skk-jisx0208-latin-vector
  [nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   ""  "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" nil]
  "*skk-jisx0208-latin-insert ǻȤʸơ֥롣
б֤ʸ󤬤Сѥ⡼ɤǳΥ򲡤Ȥǡб
ʸ롣
㤨СڡбơȾѥڡ褦ѹС
skk.el Υɸ (⤷ skk-load-hook Ѥ)

     \(aset skk-jisx0208-latin-vector 32 \" \"\)

Ȥ뤫⤷ϡskk-jisx0208-latin-vector  32  (0 ֤) ͤ \" \"
Ȥ褦 skk-jisx0208-latin-vector ľܽ񤭡setq 롣32 ϡ? (Ⱦѥ
ڡ char type) ɾȤ͡"
  :type 'vector
  :group 'skk)

(defcustom skk-use-face nil
  "*Non-nil ǤСEmacs  face εǽѤѴϥ饤ɽ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-henkan-face 'highlight
  "*Ѵ face °skk-use-face  non-nil ΤȤΤͭ
Emacs ɸե default, modeline, region, secondary-selection,
highlight, underline, bold, italic, bold-italic ¾ face 
ꤹ뤳Ȥǽ
 face ꤹˤ skk-make-face Ѥơ

      \(skk-make-face 'DimGray/PeachPuff1\)
      \(setq skk-henkan-face 'DimGray/PeachPuff1\)

Τ褦ˤΤڡforeground  background οǤʤŤä face
ϡskk-make-face ǤбǤʤΤǡEmacs  hilit19.el 
hilit-lookup-face-create ʤɤѤ롣դۿϡcanna.el 
canna:attribute-alist ɤ㤫⤷ʤ"
  :type 'face
  :group 'skk)

(defcustom skk-use-color-cursor nil
  "*Non-nil ǤСSKK ⡼ɤϥ⡼ɤ˱ƥ˿դ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-default-cursor-color nil
  "*SKK Υդ򼨤뿧
skk-use-color-cursor  non-nil ΤȤ˻Ѥ롣"
  :group 'skk)

(defcustom skk-hiragana-cursor-color "coral4"
  "*ʥ⡼ɤ򼨤뿧
skk-use-color-cursor  non-nil ΤȤ˻Ѥ롣"
  :type 'string
  :group 'skk)

(defcustom skk-katakana-cursor-color  "forestgreen"
  "*ʥ⡼ɤ򼨤뿧
skk-use-color-cursor  non-nil ΤȤ˻Ѥ롣"
  :type 'string
  :group 'skk)

(defcustom skk-jisx0208-latin-cursor-color "gold"
  "*ѱѻ⡼ɤ򼨤뿧
skk-use-color-cursor  non-nil ΤȤ˻Ѥ롣"
  :type 'string
  :group 'skk)

(defcustom skk-latin-cursor-color     "ivory4"
  "*⡼ɤ򼨤뿧
skk-use-color-cursor  non-nil ΤȤ˻Ѥ롣"
  :type 'string
  :group 'skk)

(defcustom skk-abbrev-cursor-color "royalblue"
  "*abbrev ⡼ɤ򼨤뿧
skk-use-color-cursor  non-nil ΤȤ˻Ѥ롣"
  :type 'string
  :group 'skk)

(defcustom skk-report-set-cursor-error t
  "*Non-nil ǤС顼ޥåڤ줬硢顼åɽ롣
nil ǤСɽʤ"
  :type 'boolean
  :group 'skk)

(defcustom skk-use-cursor-change t
  "*Non-nil ǤСOvwrt ޥʡ⡼ɻ˥̤롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-auto-insert-paren nil
  "*Non-nil ǤС2 ĤʸޤȤʸδ֤˥ư롣
㤨С\"\" ϤȤ \"\" ưŪξäδ֤
ư롣
ʸϡskk-auto-paren-string-alist ǻꤹ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-auto-paren-string-alist
  '(("" . "") ("" . "") ("(" . ")") ("" . "")
    ("{" . "}")("" . "") ("" . "") ("" . "")
    ("[" . "]") ("" . "") ("" . "") ("" . "")
    ("\"" . "\"")("" . "") ("`" . "'")
    ;;("<" . ">") ;; skk-special-midashi-char-list ˤʸ
   )
  "*ưŪФˤʤʸϤ뤿Ϣۥꥹȡ
 skk-auto-insert-paren  non-nil ξ硢car ʸ줿Ȥ
 cdr ʸưŪ졢Ϥ 2 Ĥʸδ֤˰
ư롣
skk-special-midashi-char-list ǤˤʤäƤʸϡ
skk-auto-paren-string-alist ˴ޤƤ롣 "
  :type '(repeat (cons string string))
  :group 'skk)

(defcustom skk-japanese-message-and-error nil
  "*Non-nil ǤСSKK Υåȥ顼ܸɽ롣
nil ǤСѸɽ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-set-henkan-point-key
  '(?A ?B ?C ?D ?E ?F ?G ?H ?I ?J ?K ?M ?N ?O ?P ?R ?S ?T ?U ?V ?W ?Y ?Z)
  "*Ѵγ륭Υꥹȡ"
  :type '(repeat character)
  :group 'skk)

(defcustom skk-jisyo-save-count 50
  "*ͤǤСβ񤬹줿Ȥ˼ưŪ˥֤롣
nil ǤСΥȥ֤Ԥʤʤ"
  :type '(choice integer (const nil))
  :group 'skk)

(defcustom skk-byte-compile-init-file nil
  "*Non-nil ǤСskk-mode ư skk-init-file Хȥѥ뤹롣
Τ˸ȡ

  (1)skk-init-file Хȥѥ뤷ե뤬ʤ
  (2)skk-init-file ȤΥХȥѥѥեӤơԤ
     Ȥ

 skk-init-file Хȥѥ뤹롣
nil ǤСskk-init-file ȤΥХȥѥѤߥեӤ
skk-init-file ȤϡΥХȥѥѥեä"
  :type 'boolean
  :group 'skk)

(defcustom skk-count-private-jisyo-candidates-exactly nil
  "*Non-nil ǤСEmacs λȤΤ˸Ŀͼθ롣
nil ǤС1 Ԥʣθ䤬äƤ 1 Ȥƿ롣
׻̤ϡskk-record-file ¸롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-compare-jisyo-size-when-saving t
  "*Non-nil ǤСskk-jisyo Υֻ˥ե륵ΥåԤʤ
󥻡֤ skk-jisyo Ⱥ󥻡֤褦Ȥ뼭ȤΥӤԤʤ
Ԥ礭Ȥ˥桼˥֤³뤫ɤγǧ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-auto-start-henkan t
  "*ñʸζڤ򼨤ʸǸˤ꼫ưŪѴ򳫻Ϥ롣
skk-auto-start-henkan-keyword-list ˤñʸζڤ򼨤ʸꤹ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-auto-start-henkan-keyword-list
  '("" "" "" "" "" "" "" "" "" "" ")" ";" ":"
    "" "" "" "" "" "" "" "" "" "}" "]" "?" "."
    "," "!")
  ;; ޤꥭɤ¿ʤȡ̾Ѵˤ롩
  "*ưѴ򳫻Ϥ륭ɡ
skk-auto-start-henkan  non-nil ΤȤΥꥹȤǤʸ
ȡSPC 򲡤ȤʤưŪѴ򳫻Ϥ롣"
  :type '(repeat string)
  :group 'skk)

(defcustom skk-search-excluding-word-pattern-function nil
  "*Ŀͼ˼ޤʤʸΥѥ򸡺ؿꤹ롣
ꤷʸϤ funcall 롣

SKK ǤѴԤʤäʸƸĿͼ˼ޤ뤬
ѿǻꤵ줿ؿ non-nil ֤ȤʸϸĿͼ˼
ʤ

㤨Сѿ˲Τ褦ʻꤹȡѴˤ (SKK abbrev mode
ǤѴ) ʤΤߤʤʸƳꤷƤ⡢Ŀ
˼ޤʤ

  \(setq skk-search-excluding-word-pattern-function
        \(function
         \(lambda \(kakutei-word\)
         ;; δؿ t ֤ȤϡʸϸĿͼ˼ޤʤ
           \(save-match-data
             \(and
            ;; ʤѴǡ
              \(not skk-okuri-char\)
            ;; 줬ʤΤߤ鹽Ƥơ
              \(string-match \"^[-]+$\" kakutei-word\)
            ;; SKK abbrev mode ʳǤѴ
              \(or \(not skk-abbrev-mode\)
                ;; Ф줬ʡҤ餬ʰʳΤȤ
                ;; \(ǢޡդȤϡФ줬ʸǤ⡢
                ;; skk-abbrev-mode t ˤʤäƤʤ\)
                  \(not \(string-match \"^[^--]+$\" skk-henkan-key\)\) \)\)\)\)\)\)

ʤѴˤ᤿ĿͼˤϥʤΤߤθߤ
ʤʤɡĿͼɬװʾĤΤޤŪ˻ѤǤ롣

ʤĿͼ˼ޤʤФˤĤƤ䴰ʤΤǡդ뤳ȡ"
  :type 'function
  :group 'skk)

(defcustom skk-update-jisyo-function 'skk-update-jisyo-original
  "*skk-update-jisyo ǻѤؿ"
  :type 'function
  :group 'skk)

(defcustom skk-save-jisyo-function 'skk-save-jisyo-original
  "*skk-save-jisyo ǻѤؿ"
  :type 'function
  :group 'skk)

(defcustom skk-count-jisyo-candidates-function
  'skk-count-jisyo-candidates-original
  "*skk-count-jisyo-candidates ǻѤؿ"
  :type 'function
  :group 'skk)

(defcustom skk-public-jisyo-to-be-searched-function
  'skk-public-jisyo-to-be-searched-original
  "*skk-public-jisyo-has-entry-p ǻѤؿ"
  :type 'function
  :group 'skk)

(defcustom skk-use-look nil
  "*Non-nil ǤСUNIX look ޥɤѤ䴰ѴԤʤ
SKK abbrev ⡼ɤ䴰ԤʤȡĿͼ򸡺ԤǡUNIX look ޥ
ɤˤñ䴰Ԥʤ㤨С

  confe \(TAB\)
  ---> conference

SKK abbrev ⡼ɤǡֱʸ + ꥹפˤѴԤʤȡlook ޥ
ˤ뤢ޤԤʤȤǤ롣㤨С

 confere* \(SPC\)
  ---> conference

ξ֤ǳꤹȡ`confere*' 򸫽Ф졢`conference' Ȥ륨ȥ
Ŀͼɲä롣`skk-search-excluding-word-pattern-function' ˤ
ꡢꤷƤ⤳Τ褦ʥȥɲäʤ褦ꤹ뤳ȤǤ롣"
  :type 'boolean
  :group 'skk)

(defcustom skk-kana-rom-vector
  ["x" "a" "x" "i" "x" "u" "x" "e" "x" "o" "k" "g" "k" "g" "k" "g"
   "k" "g" "k" "g" "s" "z" "s" "j" "s" "z" "s" "z" "s" "z" "t" "d"
   "t" "d" "x" "t" "d" "t" "d" "t" "d" "n" "n" "n" "n" "n" "h" "b"
   "p" "h" "b" "p" "h" "b" "p" "h" "b" "p" "h" "b" "p" "m" "m" "m"
   "m" "m" "x" "y" "x" "y" "x" "y" "r" "r" "r" "r" "r" "x" "w" "x"
   "x" "w" "n"]
  "*skk-remove-common ǻѤ뤫ʸ޻ؤѴ롼롣
γ뤫ʸ򤽤ʸΥ޻ץեåǸ路Ρ
                                  
                                  
                                  
                                  
                                  
        
줾Τʸ겾̾ǤˤɤΥ޻ץեåб
Τꤹ뤳ȤǤ롣֤ס֤ס֤աפʸˤĤơб
޻ץեå \"z\", \"c\",\"f\" ѹ˾⤢Ǥ
skk-auto-okuri-process ͤ non-nil ΤȤ뤤ϥѴԤʤ
ȤȤ롣"
  :type 'vector
  :group 'skk)

(defcustom skk-henkan-overlay-priority 600
  "*Ѵ˽Ťͤ overlay  priority
㤨СViper  R ޥɤˤ replace ԤʤȤˡ
viper-replace-overlay Ȥ priority 400  overlay Ťͤ뤬
skk-henkan-overlay-priority ΥǥեͤϤ overlay 
priority ⤤Τǡͥ褷ɽ롣"
  :type 'integer
  :group 'skk)

(defcustom skk-kuten-touten-alist '((jp . ("" . "")) (en . ("" . "")))
  "*Υꥹȡ
Ǥηϡ

   \(ܥ . \(ɽ魯ʸ . ɽ魯ʸ\)\)

Ȥ cons cellܥʬϡ`jp' ⤷ `en' Ȥ
skk-toggle-kutouten Ϥȥڤ괹롣
ǥեȤζΥפϡ`skk-kutouten-type' ǻꤹ롣"
  :type '(repeat (cons (choice (const jp) (const en))
		       (cons string string) ))
  :group 'skk)

(skk-deflocalvar skk-kutouten-type 'jp
  "*ǥեȤζΥס`jp' ⤷ `en' Ȥܥ롣")

(defcustom skk-read-from-minibuffer-function nil
  "*ñϿ⡼ɤ read-from-minibuffer  INITIAL-CONTENTS 󶡤 funcition
 function ʸ֤ʤФʤʤ
㤨Сskk-henkan-key 򤽤Τޤ initial-contents ȤѤȤ
ϡ
  \(setq skk-read-from-minibuffer-function
        \(function \(lambda \(\) skk-henkan-key\)\) \)
Ȼꤹ롣"
  :type 'function
  :group 'skk)

(defvar skk-latin-mode-map nil "*ASCII ⡼ɤΥޥåס")
(or skk-latin-mode-map
    (let ((map (make-sparse-keymap)))
      ;; .skk  skk-kakutei-key ѹǽˤʤ褦ˡ
      ;;(define-key map skk-kakutei-key 'skk-kakutei)
      (setq skk-latin-mode-map map)))

(defvar skk-j-mode-map nil "*ʥ⡼ɤΥޥåס")
(or skk-j-mode-map
    (let ((map (make-sparse-keymap)))
      (substitute-key-definition 'self-insert-command 'skk-insert map
				 global-map)
      ;; for Mule-2.x
;      (substitute-key-definition 'egg-self-insert-command 'skk-insert map
;				 global-map)
;      (substitute-key-definition 'canna-self-insert-command 'skk-insert map
;				 global-map)
;      (substitute-key-definition 'canna-henkan-region-or-self-insert
;				 'skk-insert map global-map)
;      (substitute-key-definition 'can-n-egg-self-insert-command 'skk-insert map
;				 global-map)
      ;; .skk  skk-kakutei-key ѹǽˤʤ褦ˡ
      ;;(define-key map skk-kakutei-key 'skk-kakutei)
      (setq skk-j-mode-map map)))

(defvar skk-jisx0208-latin-mode-map nil "*ѥ⡼ɤΥޥåס")
(or skk-jisx0208-latin-mode-map
    (let ((map (make-sparse-keymap))
	  (i 0))
      (while (< i 128)
	(and (aref skk-jisx0208-latin-vector i)
	     (define-key map (char-to-string i) 'skk-jisx0208-latin-insert))
	(setq i (1+ i)))
      (define-key map "\C-q" 'skk-latin-henkan)
      (setq skk-jisx0208-latin-mode-map map)))

(defvar skk-abbrev-mode-map nil "*SKK abbrev ⡼ɤΥޥåס")
(or skk-abbrev-mode-map
    (let ((map (make-sparse-keymap)))
      (define-key map "," 'skk-abbrev-comma)
      (define-key map "." 'skk-abbrev-period)
      (define-key map "\C-q" 'skk-jisx0208-latin-henkan)
      ;; .skk  skk-kakutei-key ѹǽˤʤ褦ˡ
      ;;(define-key map skk-kakutei-key 'skk-kakutei)
      (setq skk-abbrev-mode-map map)))

;;; -- internal constants and variables
;; ---- global ones.
;;(defvar skk-henkan-face 'skk-henkan-face)
(defconst skk-month-alist
  '(("Jan" . "1") ("Feb" . "2") ("Mar" . "3") ("Apr" . "4") ("May" . "5")
    ("Jun" . "6") ("Jul" . "7") ("Aug" . "8") ("Sep" . "9") ("Oct" . "10")
    ("Nov" . "11") ("Dec" . "12"))
  "Ѹη̾ȻѿϢۥꥹȡ

ѿѸη̾ΤߤϤΤǤС٥Ȥä®
Ѹη̾黻ѿϤΤǤϢۥꥹȤǤʤ̵ʤΤǡ¿
Ū˻ѤǤ褦ϢۥꥹȤη֤롣"
  ;;  "Alist of English month abbreviations and numerical values.
  ;;
  ;;Although it is faster to use a vector if we only want to output
  ;;month abbreviations given the ordinal, without the alist it's
  ;;unreasonable [sic] to output the ordinal given the abbreviation,
  ;;so for multi-purpose utility we use the alist form."
 )

(defconst skk-coding-system-alist
  '(("euc" . euc-japan)
    ("ujis" . euc-japan)
    ("sjis". shift_jis)
    ("jis" . junet))
  "coding-system ʸɽȡܥɽϢۥꥹȡ")

(defconst skk-default-jisx0208-latin-vector
  ;; note that skk-jisx0208-latin-vector is a user variable.
  ;; skk.el  .emacs ʤɤǡskk-jisx0208-latin-vector ̤ͤ桼
  ;; ľܽ񤤤ꡢskk.el ɸˤͤ aset ľܤäꤷ
  ;;  default-value  skk-jisx0208-latin-vector ˥뤳Ȥ
  ;; skk-default-jisx0208-latin-vector ͤݻ뤳ȤǤ褦
  ;; ˾ʤ...
  [nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   nil  nil  nil  nil  nil  nil  nil  nil
   ""  "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" ""
   "" "" "" "" "" "" "" nil]
  "skk-jisx0208-latin-region ǻȤʸơ֥롣
\"ascii\" -> \"\" Τ褦ʸؤѴԤݤѤ롣")

(defconst skk-kanji-len (length "")
  "ʸĹMule[1-3] Ǥ 3 ˤʤ롣Mule4, XEmacs Ǥ 1")

(defconst skk-kana-cleanup-command-list
  '(skk-delete-backward-char skk-insert skk-previous-candidate))

(defvar skk-rule-tree nil
  "޻ -> Ѵξܵ§ɽĥ꡼ν֡
skk-mode εư skk-rom-kana-base-rule-list 
skk-rom-kana-rule-list ڤη˥ѥ뤵롣")

(defvar skk-insert-new-word-function nil
  "Ȥ funcall ؿ¸ѿ")

(skk-deflocalvar skk-input-mode-string skk-hiragana-mode-string
  "SKK ϥ⡼ɤ򼨤ʸskk-mode ưϡskk-hiragana-mode-string")

(defvar skk-isearch-message nil
  "skk-isearch ؿ򥳡뤹뤿Υե饰
Non-nil ǤСskk-isearch-message ؿ򥳡뤹롣")

(defvar skk-mode-invoked nil
  "Non-nil ǤСEmacs ư skk-mode ưȤ򼨤")

(defvar skk-kakutei-count 0
  "ѴꤷȤݻѿ
skk-record-file  \":\" ܤΥ󥿡")

(defvar skk-touroku-count 0
  "ϿȤݻѿ
skk-record-file  \"Ͽ:\" ܤΥ󥿡")

(defvar skk-update-jisyo-count 0
  "򹹿
Υ󥿡ο skk-jisyo-save-count ʾȤʤäȤ˥桼Υ
ȥ֤Ԥʤ롣
Υ֤Ԥʤȥ˥饤롣")

(defvar skk-minibuffer-origin-mode nil
  "ϥ⡼ɤɽ魯ܥ롣
ͭͤϡ`hiragana', `katakana', `abbrev', `latin', `jisx0208-latin' ⤷
nil Τ줫")

;; Create mutex object for locking jisyo-save
(defvar skk-jisyo-mutex (get-mutex-create nil nil))

;; ---- buffer local variables
;; <ե饰>
;;(skk-deflocalvar skk-current-henkan-data
;;  '(
;;    ;; global variables
;;    ;; ХåեѿΥǥեͤꤹȡľܽ񴹤
;;    ;; ¾ΥХåե鸫ͤѤäƤޤglobal ʥե饰Ϥ
;;    ;; ѤƥǥեͿƤ
;;    (invoked . nil) ; Emacs ư skk-mode ưȤ򼨤
;;    (isearch-message . nil) ; skk-isearch ؿ򥳡뤹뤿Υե饰
;;    (kakutei-count . 0) ; ѴꤷȤݻѿ
;;    (minibuffer-origin-mode . nil) ;ϥ⡼ɤɽ魯ܥ
;;    (touroku-count . 0) ; ϿȤݻѿ
;;    (update-jisyo-count . 0) ; 򹹿
;;    ;; buffer-local variables.
;;    ;;(current-search-prog-list . nil) ;skk-search-prog-list θߤͤ¸ꥹ
;;    ;;(exit-show-candidates . nil) ;ߥ˥ХåեǸ򼡡ɽơ䤬ԤȤ򼨤
;;    ;;(henkan-active . nil) ; ⡼ (Ѵ) Ǥ뤳Ȥ򼨤
;;    ;;(henkan-count . -1) ;skk-henkan-list ΥꥹȤΥǥǸߤθ򺹤
;;    ;;(henkan-end-point . nil) ; ѴλݥȤ򼨤ޡ
;;    ;;(henkan-in-minibuff-flag . nil) ;ߥ˥ХåեǼϿԤäȤˤΥե饰Ω
;;    ;;(henkan-key . nil) ;Ѵ٤Ф
;;    ;;(henkan-list . nil) ; Ѵ̤θΥꥹ
;;    ;;(henkan-okurigana . nil) ;ߤѴ겾̾ʬ
;;    ;;(henkan-on . nil) ; ⡼ (ѴоݤʸΤΥ⡼) Ǥ뤳Ȥ򼨤
;;    ;;(henkan-start-point . nil) ; ѴϥݥȤ򼨤ޡ
;;    ;;(kakutei-flag . nil) ; ꤷɤ򸫤Ĥ֤Ǥ뤳Ȥؤ
;;    ;;(kana-start-point . nil) ;ʸγϥݥȤ򼨤ޡ
;;    ;;(katakana . nil) ; ϥ⡼ɤʥ⡼ɤǤ뤳Ȥ򼨤
;;    ;;(okuri-ari-max . nil) ; ͭꥨȥνλ򼨤Хåեݥ
;;    ;;(okuri-ari-min . nil) ; ͭꥨȥγ򼨤Хåեݥ
;;    ;;(okuri-char . nil) ;Ѵ٤겾̾ʬΥץեå
;;    ;;(okuri-index-max . -1) ;skk-henkan-list ΥǥǼư⤷ϥѸǸǸθؤ
;;    ;;(okuri-index-min . -1) ;skk-henkan-list ΥǥǼư⤷ϥѸǸǽθؤ
;;    ;;(okuri-nasi-min . nil) ; ʤȥγ򼨤Хåեݥ
;;    ;;(okurigana . nil) ; 겾̾ʬǤ뤳Ȥ򼨤
;;    ;;(okurigana-start-point . nil) ; 겾̾γϥݥȤ򼨤ޡ
;;    ;;(prefix . "") ; Ϥ뤫ʤꤹ뤿Υץեå
;;    ;;(previous-point . nil) ;ѿݻݥȤߤΥݥȤȰۤʤ硢skk-with-point-move ȤƤʤޥɤưȡskk-after-point-move ư
;;    ;;(self-insert-non-undo-count . 1) ;skk-insert ⤷ skk-jisx0208-latin-insert Ϣ³Ϥʸɽ魯󥿡
;;   ))

(skk-deflocalvar skk-mode nil
  "Non-nil ǤСȥХåեǸ skk-mode ưƤ뤳Ȥ򼨤")

(skk-deflocalvar skk-latin-mode nil
  "Non-nil ǤСϥ⡼ɤ ASCII ⡼ɤǤ뤳Ȥ򼨤")

(skk-deflocalvar skk-j-mode nil
  "Non-nil ǤСϥ⡼ɤʡʥ⡼ɤǤ뤳Ȥ򼨤")

(skk-deflocalvar skk-katakana nil
  "Non-nil ǤСϥ⡼ɤʥ⡼ɤǤ뤳Ȥ򼨤
\"(and (not skk-katakana) skk-j-mode))\"  t ǤСʥ⡼ɤǤ뤳Ȥ
")

(skk-deflocalvar skk-jisx0208-latin-mode nil
  "Non-nil ǤСϥ⡼ɤѥ⡼ɤǤ뤳Ȥ򼨤")

(skk-deflocalvar skk-abbrev-mode nil
  "Non-nil ǤСϥ⡼ɤ SKK abbrev ⡼ɤǤ뤳Ȥ򼨤")

(skk-deflocalvar skk-okurigana nil
  "Non-nil ǤС겾̾ʬǤ뤳Ȥ򼨤")

(skk-deflocalvar skk-henkan-on nil
  "Non-nil ǤС⡼ \(ѴоݤʸΤΥ⡼\) Ǥ뤳Ȥ򼨤")

(skk-deflocalvar skk-henkan-active nil
  "Non-nil ǤС⡼ \(Ѵ\) Ǥ뤳Ȥ򼨤")

(skk-deflocalvar skk-kakutei-flag nil
  "Non-nil ʤꤷɤ򸫤Ĥ֤Ǥ뤳Ȥؤ
skk-henkan, skk-search-kakutei-jisyo-file, skk-henkan-show-candidates,
skk-henkan-in-minibuff  skk-kakutei-save-and-init-variables ѹȤ
롣")

(skk-deflocalvar skk-exit-show-candidates nil
  "ߥ˥ХåեǸ򼡡ɽơ䤬ԤȤ non-nil Ȥʤ롣
ͤϥꥹȤǡcar  skk-henkan-show-candidate ؿ while 롼פ
򼨤ѿ loop ͤcdr ˺Ǹ˥ߥ˥Хåեɽ 1 
θ䷲κǸǤؤǥ롣
skk-henkan-show-candidates, skk-henkan-in-minibuff 
skk-kakutei-save-and-init-variables ѹȤ롣")

;; <ޥå״Ϣ>
(skk-deflocalvar skk-current-rule-tree nil
  "޻ -> Ѵξܵ§ɽ魯ĥ꡼θξ֡
޻ϤνǤ skk-rule-tree Ʊξ֤ǡʸϤʤ
Ĥ졢ڤ򤿤ɤäƤ椯֤ܤɽ")

;; <Ϣѿ>
(skk-deflocalvar skk-okuri-ari-min nil
  "SKK ͭꥨȥγ򼨤Хåեݥȡ")

(skk-deflocalvar skk-okuri-ari-max nil
  "SKK ͭꥨȥνλ򼨤Хåեݥȡ
skk-jisyo ΥХåեǤϼιɬפ뤿˥ޡ롣")

(skk-deflocalvar skk-okuri-nasi-min nil
  "SKK ʤȥγ򼨤Хåեݥȡ
skk-jisyo ΥХåեǤϼιɬפ뤿˥ޡ롣")

;; <¾>
(skk-deflocalvar skk-mode-line nil
  "SKK Υ⡼ɤ򼨤⡼ɥ饤ʸ
skk-mode-string, skk-hiragana-mode-string, skk-katakana-mode-string
and skk-jisx0208-latin-mode-string Τ줫롣")

(skk-deflocalvar skk-previous-point nil
  "skk-with-point-move Ϣѿ
ѿݻݥȤߤΥݥȤȰۤʤ硢skk-with-point-move 
ȤƤʤޥɤưȡskk-after-point-move ư롣")

;; "" бȥ꤬ skk-roma-kana-[aiue] ˤ뤿ᡢ""  nil 
;; Ǥʤ
(skk-deflocalvar skk-prefix ""
  "Ϥ뤫ʤꤹ뤿Υץեå")

(skk-deflocalvar skk-henkan-start-point nil
  "ѴϥݥȤ򼨤ޡ")

(skk-deflocalvar skk-henkan-end-point nil
  "ѴλݥȤ򼨤ޡ")

(skk-deflocalvar skk-kana-start-point nil
  "ʸγϥݥȤ򼨤ޡ")

(skk-deflocalvar skk-okurigana-start-point nil
  "겾̾γϥݥȤ򼨤ޡ")

(skk-deflocalvar skk-henkan-key nil
  "Ѵ٤Ф졣
㤨С\"\" ѴСskk-henkan-key ˤ \"\" 롣
\"*\" Τ褦ꤢѴξˤϡ\"u\" Τ褦ˡʬ
ɤߤ + 겾̾κǽʸΥ޻Υץեå롣")

(skk-deflocalvar skk-okuri-char nil
  "Ѵ٤겾̾ʬΥץեå
㤨С\"*\" ѴȤϡskk-okuri-char  \"r\"
skk-okuri-char  non-nil ǤСꤢѴǤ뤳Ȥ򼨤")

(skk-deflocalvar skk-henkan-okurigana nil
  "ߤѴ겾̾ʬ
㤨С\"ޤ*\" ѴСskk-henkan-okurigana ˤ \"\" 
롣")

(skk-deflocalvar skk-last-kakutei-henkan-key nil
  "꼭ˤǸ˳ꤷȤθФ졣
꼭ˤľ x 򲡤ȳ꤬ɥơξ֤
θФ줬ȥХåե롣")

(skk-deflocalvar skk-henkan-list nil
  "Ѵ̤θΥꥹȡ
㤨С\"*\" ȤѴСskk-henkan-list 
(\"\" \"\" \"̵\" \"˴\") Τ褦ˤʤ롣")

(skk-deflocalvar skk-henkan-count -1
  "skk-henkan-list ΥꥹȤΥǥǸߤθ򺹤Ρ")

(skk-deflocalvar skk-self-insert-non-undo-count 1
  "skk-insert ⤷ skk-jisx0208-latin-insert Ϣ³Ϥʸɽ魯󥿡
Emacs ΥꥸʥưǤϡself-insert-command ˥Хɤ줿Ϥϡ
Ϣ³ 20 ޤǤ 1 ĤΥɥоݤȤʤ롣ư򥨥ߥ졼Ȥ뤿
󥿡Υ󥿡20 ʲǤȤϡϤΤӤ
cancel-undo-boundary 뤵롣")

(skk-deflocalvar skk-current-search-prog-list nil
  "skk-search-prog-list θߤͤ¸ꥹȡ
ǽѴ skk-search-prog-list ƤͤݻѴ򷫤֤Ӥ 1
ĤŤûʤäƤ椯")

;; for skk-undo-kakutei
(skk-deflocalvar skk-last-henkan-data nil
  "Ǹ˹ԤʤäѴ˴ؤǡΥꥹȡ
ǥեȤΥϡhenkan-key, henkan-okurigana,
okuri-char, henkan-list γƥܥ롣
\(skk-num  require ƤȤϡnum-list ɲä\)")

(skk-deflocalvar skk-henkan-overlay nil
  "ɽȤ˻Ѥ Overlay")

(skk-deflocalvar skk-henkan-in-minibuff-flag nil
  "ߥ˥ХåեǼϿԤäȤˤΥե饰Ωġ
skk-remove-common ǻȤ롣")

(skk-deflocalvar skk-okuri-index-min -1
  "skk-henkan-list ΥǥǼư⤷ϥѸǸǽθؤΡ")

(skk-deflocalvar skk-okuri-index-max -1
  "skk-henkan-list ΥǥǼư⤷ϥѸǸǸθؤΡ")

(set-modified-alist
 'minor-mode-map-alist
 (list (cons 'skk-latin-mode skk-latin-mode-map)
       (cons 'skk-abbrev-mode skk-abbrev-mode-map)
       (cons 'skk-j-mode skk-j-mode-map)
       (cons 'skk-jisx0208-latin-mode skk-jisx0208-latin-mode-map)))

;;;; defadvices.
;; defadvice ȡǥ桼εǽդƹ defadvice 
;; ư

;; cover to original functions.

(defadvice keyboard-quit (around skk-ad activate)
  "⡼ɤǤСɽƢ⡼ɤ᤹ (ФϻĤ)
⡼ɤǤСФ롣
嵭ΤɤΥ⡼ɤǤʤ keyboard-quit Ʊư򤹤롣"
  (cond
   ;; SKK is not invoked in the current buffer.
   ((not skk-mode) ad-do-it)
   ;;  mode (Kakutei input mode).
   ((not skk-henkan-on)
    (cond ((skk-get-prefix skk-current-rule-tree)
	   (skk-erase-prefix 'clean))
	  (t ad-do-it)))
   ;;  mode (Conversion mode).
   (skk-henkan-active
    (setq skk-henkan-count 0)
    (if (and skk-delete-okuri-when-quit skk-henkan-okurigana)
	(let ((count (/ (length skk-henkan-okurigana) skk-kanji-len)))
	  (skk-previous-candidate)
	  ;; Ǥ delete-backward-char Ϥʤ٥
	  (delete-backward-char count))
      (skk-previous-candidate)))
   ;;  mode (Midashi input mode).
   (t (skk-erase-prefix 'clean)
      (and (> (point) skk-henkan-start-point)
	   (delete-region (point) skk-henkan-start-point))
      (skk-kakutei))))

(defadvice abort-recursive-edit (around skk-ad activate)
  "⡼ɤǤСɽƢ⡼ɤ᤹ (ФϻĤ)
⡼ɤǤСФ롣
嵭ΤɤΥ⡼ɤǤʤ abort-recursive-edit Ʊư򤹤롣"
  (skk-remove-minibuffer-setup-hook
   'skk-j-mode-on 'skk-setup-minibuffer
   (function (lambda () (add-hook 'pre-command-hook 'skk-pre-command nil 'local))))
  (cond ((not skk-mode) ad-do-it)
	((not skk-henkan-on)
	 (cond ((skk-get-prefix skk-current-rule-tree)
		(skk-erase-prefix 'clean))
	       (t ad-do-it)))
        (skk-henkan-active
         (setq skk-henkan-count 0)
         (if (and skk-delete-okuri-when-quit skk-henkan-okurigana)
             (let ((count (/ (length skk-henkan-okurigana) skk-kanji-len)))
               (skk-previous-candidate)
               ;; Ǥ delete-backward-char Ϥʤ٥
               (delete-backward-char count))
           (skk-previous-candidate)))
	(t (skk-erase-prefix 'clean)
	   (and (> (point) skk-henkan-start-point)
		(delete-region (point) skk-henkan-start-point))
	   (skk-kakutei))))
	
(defadvice newline (around skk-ad activate)
  "skk-egg-like-newline  non-nil ä顢Ѵ newline ǳΤ߹ԤԤʤ"
  (if (not (or skk-j-mode skk-abbrev-mode))
      ad-do-it
    (let (
	  ;;(arg (ad-get-arg 0))
          ;; skk-kakutei ¹Ԥ skk-henkan-on ̵ͤ nil ˤʤ
          ;; Τǡ¸Ƥɬפ롣
          (no-newline (and skk-egg-like-newline skk-henkan-on))
	  (auto-fill-function (and (interactive-p) auto-fill-function)))
      ;; fill Ƥ nil äƤ :-<
      ;;(if (skk-kakutei)
      ;;    (setq arg (1- arg)))
      ;;(if skk-mode
      ;;    (let ((opos (point)))
      ;;      ;; skk-kakutei (skk-do-auto-fill) ˤäƹԤޤ֤줿 arg  1 ĸ餹
      ;;      (skk-kakutei)
      ;;      (if (and (not (= opos (point))) (integerp arg))
      ;;          (ad-set-arg 0 (1- arg)))))
      (and skk-mode (skk-kakutei))
      (if (not no-newline)
	  ad-do-it))))

(defadvice newline-and-indent (around skk-ad activate)
  "skk-egg-like-newline  non-nil ä顢Ѵ newline-and-indent ǳΤ߹ԤԤʤ"
  (if (not (or skk-j-mode skk-abbrev-mode))
      ad-do-it
    (let ((no-newline (and skk-egg-like-newline skk-henkan-on))
	  (auto-fill-function (and (interactive-p) auto-fill-function)))
      (and skk-mode (skk-kakutei))
      (or no-newline ad-do-it))))

(defadvice exit-minibuffer (around skk-ad activate)
  "skk-egg-like-newline  non-nil ä顢Ѵ exit-minibuffer ǳΤ߹Ԥ"
  (skk-remove-minibuffer-setup-hook
   'skk-j-mode-on 'skk-setup-minibuffer
   (function (lambda ()
	       (add-hook 'pre-command-hook 'skk-pre-command nil 'local))))
  (if (not (or skk-j-mode skk-abbrev-mode))
      ad-do-it
    (let ((no-newline (and skk-egg-like-newline skk-henkan-on)))
      (and skk-mode (skk-kakutei))
      (or no-newline ad-do-it))))

(defadvice picture-mode-exit (before skk-ad activate)
  "SKK ΥХåեѿ̵ˤpicture-mode-exit 򥳡뤹롣
picture-mode ФȤˤΥХåե SKK ưν"
  (and skk-mode (skk-kill-local-variables)))

(defadvice undo (before skk-ad activate)
  "SKK ⡼ɤ on ʤ skk-self-insert-non-undo-count 롣"
  (and skk-mode (setq skk-self-insert-non-undo-count 0)))

;;; XXX interactive subr with args.
(defadvice kill-buffer (before skk-ad activate)
  "SKK ΢⡼ɤä顢ꤷƤХåե򥭥뤹롣
  ХåեΥ塢SKK Υ⡼ɤ˽οѤ롣"
  (interactive "bKill buffer: ")
  (and skk-mode skk-henkan-on (interactive-p) (skk-kakutei)))

(defadvice save-buffers-kill-emacs (before skk-ad activate)
  (run-hooks 'skk-before-kill-emacs-hook))

(defadvice minibuffer-keyboard-quit (around skk-ad activate)
  ;; for delsel.el
  (if (and skk-mode
	   (not (and delete-selection-mode transient-mark-mode mark-active)))
      (keyboard-quit)
    ad-do-it))

;;;; mode setup

;;;###autoload
(defun skk-mode (&optional arg)
  "ܸϥ⡼ɡ
ޥʡ⡼ɤΰǡꥸʥΥ⡼ɤˤϱƶͿʤ
ΰͿ SKK ⡼ɤȴ롣

An input mode for Japanese, converting romanized phonetic strings to kanji.

A minor mode, it should not affect the use of any major mode or
orthogonal minor modes.

In the initial SKK mode, hiragana submode, the mode line indicator is
\"\".  Lowercase romaji entry is automatically converted to
hiragana where possible.  The lowercase characters `q' and `l' change
submodes of SKK, and `x' is used as a prefix indicating a small kana.

`q' is used to toggle between hiragana and katakana \(mode line
indicator \"\"\) entry submodes.

`l' is used to enter ASCII submode \(mode line indicator \"SKK\"\).
Uppercase `L' enters JISX0208 latin \(wide ASCII\) submode \(mode line
indicator \"\"\).  `\C-j' returns to hiragana submode from either
ASCII submode.

Kanji conversion is complex, but the basic principle is that the user
signals the appropriate stem to be matched against dictionary keys by
the use of uppercase letters.  Because SKK does not use grammatical
information, both the beginning and the end of the stem must be marked.

For non-inflected words \(eg, nouns\) consisting entirely of kanji, the
simplest way to invoke conversion is to enter the reading of the kanji,
the first character only in uppercase.  A leading \"\" indicates that
kanji conversion is in progress.  After entering the reading, press
space.  This invokes dictionary lookup, and the hiragana reading will be
redisplayed in kanji as the first candidate.  Pressing space again gives
the next candidate.  Further presses of space produce further candidates,
as well as a list of the next few candidates in the minibuffer.  Eg,
\"Benri\" => \"٤\", and pressing space produces \"\" \(the solid
triangle indicates that conversion is in progress\).  Backspace steps
through the candidate list in reverse.

A candidate can be accepted by pressing `\C-j', or by entering a
self-inserting character.  \(Unlike other common Japanese input methods,
RET not only accepts the current candidate, but also inserts a line
break.\)

Inflected words \(verbs and adjectives\), like non-inflected words, begin
entry with a capital letter.  However, for these words the end of the
kanji string is signaled by capitalizing the next mora.  Eg, \"TuyoI\"
=> \"\".  If no candidate is available at that point, the inflection
point will be indicated with an asterisk \"*\", and trailing characters
will be displayed until a candidate is recognized.  It will be
immediately displayed \(pressing space is not necessary\).  Space and
backspace are used to step forward and backward through the list of
candidates.

For more information, see the `skk' topic in Info.  \(Japanese only.\)

A tutorial is available in Japanese or English via \"M-x skk-tutorial\".
Use a prefix argument to choose the language.  The default is system-
dependent."
  (interactive "P")
  (setq skk-mode (cond ((null arg) (not skk-mode))
                       ;; -  -1 Ѵ롣
                       ((> (prefix-numeric-value arg) 0) t)))
  (if (not skk-mode)
      ;; exit skk-mode
      (progn
        (let ((skk-mode t)) (skk-kakutei))
        (skk-mode-off)
	(and (eq skk-status-indicator 'left)
	     (setq skk-input-mode-string ""))
	(and (eq skk-emacs-type 'xemacs) (easy-menu-remove skk-menu)))
    ;; enter skk-mode
    (if (not skk-mode-invoked)
        ;; enter skk-mode for the first time in this session
        (progn
	  (and (eq skk-emacs-type 'xemacs)
	       (boundp 'preloaded-file-list)
	       (member "skk-leim" preloaded-file-list)
	       ;; require dummy file.
	       (require 'skk-vars))
          (skk-setup-init-file)
          (load skk-init-file t)
	  (skk-setup-modeline)
;	  (require 'skk-autoloads)
;	  (if (or (memq skk-emacs-type '(mule3 mule4))
;		  (and (eq skk-emacs-type 'xemacs)
;		       (or
;			;; XEmacs 21 or later.
;			(> emacs-major-version 20)
;			;; XEmacs 20.4 or later.
;			(> emacs-minor-version 2))))
;	      (require 'skk-leim))
	  (if skk-use-numeric-conversion (require 'skk-num))
          (if skk-keep-record
	      (skk-create-file skk-record-file
			       "SKK εϿѥեޤ"
			       "I have created an SKK record file for you"))
	  (skk-create-file skkinput-jisyo
			   "skkinput ζޤ"
			   "I have created an empty SKK Jisyo file for you")
	  (skk-create-file skk-jisyo
			   "SKK ζޤ"
			   "I have created an empty SKK Jisyo file for you")
	  (skk-regularize)
          (setq skk-mode-invoked t)))
    ;; ʲ skk-mode 뤿Ӥ٥뤵륳ɡ
;    (and skk-use-viper (require 'skk-viper))
;    (and (or skk-use-color-cursor skk-use-cursor-change)
;	 (require 'skk-cursor))
    ;; .skk  skk-kakutei-key ѹǽˤʤ褦ˡ
    (define-key skk-abbrev-mode-map skk-kakutei-key 'skk-kakutei)
    (define-key skk-abbrev-mode-map (char-to-string skk-start-henkan-char)
      'skk-start-henkan)
    (define-key skk-abbrev-mode-map (char-to-string skk-try-completion-char)
      'skk-try-completion)
    (define-key skk-latin-mode-map skk-kakutei-key 'skk-kakutei)
    (define-key skk-j-mode-map skk-kakutei-key 'skk-kakutei)
    (define-key skk-j-mode-map (char-to-string skk-try-completion-char)
      'skk-insert)
    (define-key skk-j-mode-map (char-to-string skk-previous-candidate-char)
      'skk-previous-candidate)
    (define-key skk-jisx0208-latin-mode-map skk-kakutei-key 'skk-kakutei)
    (define-key minibuffer-local-map skk-kakutei-key 'skk-kakutei)
    (define-key minibuffer-local-completion-map skk-kakutei-key 'skk-kakutei)
    (if skk-use-viper
	()
      (define-key skk-j-mode-map
	(char-to-string skk-start-henkan-with-completion-char)
	'skk-start-henkan-with-completion)
      (define-key skk-abbrev-mode-map
	(char-to-string skk-start-henkan-with-completion-char)
 	'skk-start-henkan-with-completion)
      (define-key skk-j-mode-map
 	(char-to-string skk-backward-and-set-henkan-point-char)
 	'skk-backward-and-set-henkan-point)
      (define-key skk-jisx0208-latin-mode-map
 	(char-to-string skk-backward-and-set-henkan-point-char)
 	'skk-backward-and-set-henkan-point)
     )
    (skk-setup-delete-backward-char)
    ;; XEmacs doesn't have minibuffer-local-ns-map
    (and (boundp 'minibuffer-local-ns-map)
	 (define-key minibuffer-local-ns-map skk-kakutei-key 'skk-kakutei))
    ;; To terminate kana input.
    (make-local-hook 'pre-command-hook)
    (add-hook 'pre-command-hook 'skk-pre-command nil 'local)
    (make-local-hook 'post-command-hook)
    (add-hook 'post-command-hook 'skk-after-point-move nil 'local)
    (and (eq skk-status-indicator 'left)
	 (setq skk-input-mode-string skk-hiragana-mode-string))
    (skk-j-mode-on)
    (and (eq skk-emacs-type 'xemacs) (easy-menu-add skk-menu))
    (run-hooks 'skk-mode-hook)))

;;;###autoload
(defun skk-auto-fill-mode (&optional arg)
  "ܸϥ⡼ɡưޤ֤ǽդ
ޥʡ⡼ɤΰǡꥸʥΥ⡼ɤˤϱƶͿʤ
ΰͿȡŪ auto-fill-mode ڤ SKK ⡼ɤ롣
ΰͿ auto-fill-mode ڤ SKK ⡼ɤȴ롣"
  (interactive "P")
  (let ((auto-fill
         (cond ((null arg) (not auto-fill-function))
               ((> (prefix-numeric-value arg) 0) t))))
    (auto-fill-mode (if auto-fill 1 -1))
    (skk-mode arg)
    (run-hooks 'skk-auto-fill-mode-hook)))

(defun skk-kill-emacs-without-saving-jisyo (&optional query)
  "SKK 򥻡֤ʤǡEmacs λ롣"
  (interactive "P")
  ;; format ˻ϡskk-yes-or-no-p ȤȤäƾĹˤʤ롣
  (if (yes-or-no-p
       (format (if skk-japanese-message-and-error
                   "¸򤻤 %s λޤɤǤ"
                 "Do you really wish to kill %s without saving Jisyo? ")
               (cond ((eq skk-emacs-type 'xemacs) "XEmacs")
		     (t "Mule"))))
      (let ((buff (skk-get-jisyo-buffer skkinput-jisyo 'nomsg)))
	(ad-disable-advice 'save-buffers-kill-emacs 'before 'skk-ad)
	(ad-activate 'save-buffers-kill-emacs)
	(remove-hook 'skk-before-kill-emacs-hook 'skk-save-jisyo) ; fail safe.
	(if buff
	    (progn (set-buffer buff)
		   (set-buffer-modified-p nil)
		   (kill-buffer buff)))
	(save-buffers-kill-emacs query))))

(defun skk-restart ()
  "skk-init-file κƥɵڤӳƼƥåȥåפθ塢SKK ⡼ɤư롣"
  (interactive)
  (let (skk-mode-invoked) (skk-mode 1)))

(defun skk-regularize ()
  ;; SKK ưޤ뤿ᡢѿ桼ѿĴԤʤ
  (skk-setup-auto-paren)
  (setq skk-rule-tree
	(skk-compile-rule-list skk-rom-kana-base-rule-list skk-rom-kana-rule-list))
  (and (not (featurep 'skk-server))
       (or (and (boundp 'skk-servers-list) skk-servers-list)
	   (or (and (boundp 'skk-server-host) skk-server-host)
	       (getenv "SKKSERVER")))
       (require 'skk-server))
  (and (featurep 'skk-server)
       ;; skk-search-server ϥСƤȤΤǡʤ
       (skk-adjust-search-prog-list-for-server-search 'non-del))
  (and skk-auto-okuri-process (skk-adjust-search-prog-list-for-auto-okuri))
  (and skk-use-look (require 'skk-look))
  (skk-setup-delete-selection-mode)
  (skk-adjust-user-option))

(defun skk-setup-delete-backward-char ()
  (let ((commands '(backward-delete-char-untabify
		    backward-delete-char
		    backward-or-forward-delete-char
		    delete-backward-char
		    picture-backward-clear-column
		    ;; following two are SKK adviced.
		    ;;viper-del-backward-char-in-insert
		    ;;vip-del-backward-char-in-insert
		   ))
	keys)
    (while commands
      (setq keys (where-is-internal (car commands) overriding-local-map)
	    commands (cdr commands))
      (while keys
	(define-key skk-abbrev-mode-map (car keys) 'skk-delete-backward-char)
	(define-key skk-j-mode-map (car keys) 'skk-delete-backward-char)
	(setq keys (cdr keys))))))

(defun skk-setup-init-file ()
  ;; skk-byte-compile-init-file  non-nil ξǡskk-init-file Хȥ
  ;; ѥ뤷ե뤬¸ߤʤΥХȥѥѥե
  ;; skk-init-file Ȥϡskk-init-file Хȥѥ뤹롣
  ;;
  ;; skk-byte-compile-init-file  nil ξǡskk-init-file Хȥ
  ;; 뤷ե skk-init-file ȤϡΥХȥѥ
  ;; ѥեä
  (save-match-data
    (let* ((init-file (expand-file-name skk-init-file))
           (elc (concat init-file
                        (if (string-match "\\.el$" init-file)
                            "c"
                          ".elc"))))
      (if skk-byte-compile-init-file
          (and (file-exists-p init-file)
	       (or (not (file-exists-p elc))
		   (file-newer-than-file-p init-file elc))
	       (save-window-excursion ; for keep window configuration.
		 (skk-message "%s Хȥѥ뤷ޤ" "Byte-compile %s"
			      skk-init-file)
		 (sit-for 2)
		 (byte-compile-file init-file)))
        (and (file-exists-p init-file)
	     (file-exists-p elc)
	     (file-newer-than-file-p init-file elc)
	     (delete-file elc))))))

(defun skk-emulate-original-map (arg)
  ;; ϤФơSKK Υ⡼ɤǤϤʤEmacs ΥꥸʥΥդ
  ;; ޥɤ¹Ԥ롣
  (let ((prefix-arg arg)
        (keys (skk-command-key-sequence (this-command-keys) this-command)))
    (if (not keys)
        ;; no alternative commands.  may be invoked by M-x.
        nil
      (let (skk-mode skk-latin-mode skk-j-mode skk-abbrev-mode skk-jisx0208-latin-mode
                     command)
        (setq command (key-binding keys))
        (if (eq command this-command)
            ;; avoid recursive calling of skk-emulate-original-map.
            nil
          ;; if no bindings are found, call `undefined'.  it's
          ;; original behaviour.
          (skk-cancel-undo-boundary)
	  (setq this-command command) ; added by Takashi SAKAMOTO (2002/11/25)
          (command-execute (or command (function undefined))))))))

(defun skk-command-key-sequence (key command)
  ;; KEY  universal arguments COMMAND ¹Ԥ륭֤
  ;; `execute-extended-command' ˤäƥޥɤ¹Ԥ줿ϡnil ֤
  (while (not (or (zerop (length key))
                  (eq command (key-binding key))))
    (setq key (vconcat (cdr (append key nil)))))
  (and (not (zerop (length key))) key))

(defun skk-setup-delete-selection-mode ()
  ;; Delete Selection ⡼ɤ SKK ȤäܸϤФƤⵡǽ褦
  ;; åȥåפ롣
  (and (featurep 'delsel)
       (not (get 'skk-insert 'delete-selection))
       (mapcar (function (lambda (func) (put func 'delete-selection t)))
	       '(skk-current-kuten
		 skk-current-touten
		 skk-input-by-code-or-menu
		 skk-insert
		 skk-today))))

(defun skk-setup-auto-paren ()
  (if (and skk-auto-insert-paren skk-auto-paren-string-alist)
      (let ((strlst (mapcar 'char-to-string skk-special-midashi-char-list))
	    rulealst str alist)
	(while strlst
	  ;; skk-auto-paren-string-alist 椫顢skk-special-midashi-char-list
	  ;; Ǥ˴ϢΤ
	  (remove-alist 'skk-auto-paren-string-alist (car strlst))
	  (setq strlst (cdr strlst)))
	(if (null (memq t (mapcar (function
				   (lambda (e)
				     (skk-ascii-char-p (string-to-char (car e)))))
				  skk-auto-paren-string-alist)))
	    nil
	  (setq alist skk-auto-paren-string-alist
		rulealst (nconc (mapcar (function (lambda (e) (nth 2 e)))
					skk-rom-kana-rule-list)
				(mapcar (function (lambda (e) (nth 2 e)))
					skk-rom-kana-base-rule-list)))
	  (while alist
	    (setq str (car (car alist)))
	    (and (skk-ascii-char-p (string-to-char str))
		 ;; ʸäƤ륻Ĵ٤ơ줫Υ˥Х
		 ;; Ƥʤɤǧ롣
		 (null (assoc str rulealst))
		 (null (rassoc str rulealst))
		 ;; դ褦ȤƤ륭¾νʸ˥Хɤ
		 ;; Ƥʤɤǧ롣
		 (null (assoc str skk-rom-kana-base-rule-list))
		 (null (assoc str skk-rom-kana-rule-list))
		 ;; skk-auto-paren-string-alist γǤ car ʸ
		 ;; ascii char Ǥϡskk-rom-kana-rule-list,
		 ;; skk-rom-kana-base-rule-list ˤʸ񤭹 (
		 ;;  ascii char  skk-rom-kana-rule-list,
		 ;; skk-rom-kana-base-rule-list ˽ɬפʤ ---
		 ;; skk-emulate-original-mapˤϤԤʤ ---
		 ;; skk-auto-paren-string-alist ˻ꤵ줿Фˤʤ
		 ;; ʸΤˤϡȤʤʸ񤤤Ƥɬפ
		 ;; )
		 (setq skk-rom-kana-rule-list (cons (list str nil str)
						    skk-rom-kana-rule-list)))
	    (setq alist (cdr alist)))))))

(defun skk-adjust-user-option ()
  ;; ξΩǤʤץĴԤʤ
  (and skk-process-okuri-early
       ;; skk-process-okuri-early ͤ non-nil ǤȤ˲ͤ non-nil
       ;; ǤưʤΤǤѿ̤ͥ⤯
       (setq skk-kakutei-early nil
	     skk-auto-okuri-process nil
	     skk-henkan-okuri-strictly nil
	     skk-henkan-strict-okuri-precedence nil)))

(defun skk-try-completion (arg)
  "⡼ɤǸФ䴰Ԥ
ʳΥ⡼ɤǤϡꥸʥΥդΥޥɤ򥨥ߥ졼Ȥ롣"
  (interactive "P")
  (skk-with-point-move
   (if (and skk-henkan-on (not skk-henkan-active))
       (progn
	 (setq this-command 'skk-completion)
	 (skk-completion (not (eq last-command 'skk-completion))))
     (skk-emulate-original-map arg))))

(defun skk-latin-mode (arg)
  "SKK Υ⡼ɤ latin (ascii) ⡼ɤѹ롣"
  (interactive "P")
  (skk-kakutei)
  (skk-latin-mode-on))

(defun skk-jisx0208-latin-mode (arg)
  "SKK Υ⡼ɤѱѻϥ⡼ɤѹ롣"
  (interactive "P")
  (skk-kakutei)
  (skk-jisx0208-latin-mode-on))

(defun skk-abbrev-mode (arg)
  "ascii ʸ򥭡ˤѴԤϥ⡼ɡ"
  (interactive "*P")
  (and skk-henkan-on (not skk-henkan-active)
       (skk-error "ˢ⡼ɤäƤޤ" "Already in  mode"))
  (skk-kakutei)
  (skk-set-henkan-point-subr)
  (skk-abbrev-mode-on))

(defun skk-toggle-kana (arg)
  "⡼ɤǡҤ餬ʥ⡼ɤȥʥ⡼ɤȥڤؤ롣
⡼ɤǤϡskk-henkan-start-point (ľ) ȥδ֤ʸ

    Ҥ餬 <=> 
    ѱѿ <=> ascii

Τ褦Ѵ롣"
  (interactive "P")
  (cond ((and skk-henkan-on (not skk-henkan-active))
         (let (char)
           (skk-save-point
	    (goto-char skk-henkan-start-point)
	    ;; "" Ǥʸ̤Ƚ̤ǤʤΤǡݥȤʤ롣
	    (while (looking-at "")
	      (forward-char 1))
	    (setq char (skk-what-char-type)))
           (skk-set-marker skk-henkan-end-point (point))
           (cond ((eq char 'hiragana)
                  (skk-katakana-henkan arg))
                 ((eq char 'katakana)
                  (skk-hiragana-henkan arg))
                 ((eq char 'jisx0208-latin)
                  (skk-latin-henkan arg))
		 ((eq char 'ascii)
		  (skk-jisx0208-latin-henkan arg)))))
	((and (skk-in-minibuffer-p) (not skk-j-mode))
	 ;; ߥ˥Хåեؤν
	 (skk-j-mode-on))
	(t (setq skk-katakana (not skk-katakana))))
  (skk-kakutei))

(defun skk-misc-for-picture ()
  ;; picture-mode äȤ SKK ưξ֤᤹
  ;; edit-picture-hook  add-hook ƻѤ롣
  ;;
  ;; ¸ΥХåե picture mode ˤȤpicture-mode ؿ
  ;; kill-all-local-variables ؿƤФʤΤǡSKK ϢΥХåե
  ;; ѿΥХåեͤΤޤޤˤʤäƤޤǡpicture mode ä
  ;; Ȥ˥եåѤƤΥХåեѿ kill 롣
  ;; RMS  picture-mode  kill-all-local-variables ؿƤФʤΤϡХ
  ;; ǤϤʤȸäƤ
  ;;
  ;; picture-mode  SKK ѤϤ򤷤ˡBS ʸäʤ
  ;; ΤϡSKK ԶǤϤʤpicture.el  (move-to-column-force ؿ
  ;; ǻѤƤ move-to-column ʸ̵뤷Ϳ
  ;; Ȥ˥ưǤʤ) Ǥ롣äʸ˥ݥȤ
  ;; C-c C-d ǰʸŤľäˡϤʤ
  (and skk-mode (skk-kill-local-variables)))

(defun skk-kill-local-variables ()
  ;; SKK ϢΥХåեѿ̵ˤ롣
  (skk-mode -1)
  (let ((lv (buffer-local-variables))
        v vstr)
    (while lv
      (setq v (car (car lv))
            lv (cdr lv)
            vstr (prin1-to-string v))
      (and (> (length vstr) 3) (string= "skk-" (substring vstr 0 4))
	   (kill-local-variable v)))))

;;;; kana inputting functions

(defun skk-insert (&optional arg)
  "SKK ʸϤԤʤ"
  ;; skk-rom-kana-\\(base-\\)*rule-list  caddr ˴ؿ񤭡δؿǡ
  ;;  (ʸʳ) ư򤵤ǤʤϤ
  ;; ʸԤʤȤΥåȡǥåȤˤĤơ
  ;;
  ;; å; ɬ skk-kana-input ̤Τǡunfixed prefix + ȥꥬ
  ;; ʸԤʤäƤδؿƤӽФ뤳ȤǤ롣
  ;;
  ;; ǥå; 뤵줿ؿǡȼʸꤹ뤳ȤϤǤ뤬
  ;; skk-rom-kana-\\(base-\\)*rule-list Ԥʤʤ (ʸ
  ;; ˴ؿ̾ꤵƤ뤫顣ؿǡskk-kana-input 򥳡뤹ȡ
  ;; ̵¥롼פ˴٤äƤޤ)ؿǥꥸʥΥȥޥåפư
  ;; ߥ졼Ȥȡ桼ʸѹǤʤ
  ;;
  ;; ޤskk-input-vector Ѥskk-rom-kana-\\(base-\\)*rule-list 
  ;; ٤ʸ椵Ȥ顢ǽʸ¤ꤳʤ
  ;;
  ;; 嵭ιͻ顢Τ褦ˤ᤿
  ;;
  ;; (1)ʸϡskk-rom-kana-\\(base-\\)*rule-list ʳǤϹԤʤ
  ;;    
  ;; (2)ȥꥬ桼ѿȤΥ줿礫ɤȽϡ
  ;;    skk-insert ǹԤʤŬʴؿ򥳡뤹롣
  ;; (3)(2)Υ桼ѿϡskk-abbrev-mode-map ΥʤɤǤ⻲Ȥ뤳
  ;;    ȤȤǽʸ¤ưޤ롣
  ;; (4)unfixed prefix + ȥꥬνɬפ˱Ƴؿ
  ;;    ࡣ
  (interactive "*p")
  (skk-with-point-move
   (let ((ch last-command-char))
     (cond (
	    ;; start writing a midasi key.
	    (or (and (memq ch skk-set-henkan-point-key)
		     (or skk-okurigana
			 (not (skk-get-prefix skk-current-rule-tree))
			 (not (skk-select-branch skk-current-rule-tree ch))))
		(and skk-henkan-on (memq ch skk-special-midashi-char-list)))
	    ;; normal pattern
	    ;; skk-set-henkan-point -> skk-kana-input.
	    (skk-set-henkan-point arg))
	   ;; start conversion.
	   ((and skk-henkan-on (eq ch skk-start-henkan-char))
	    (skk-start-henkan arg))
	   ;; for completion.
	   ((and skk-henkan-on (not skk-henkan-active))
	    (cond ((eq ch skk-try-completion-char)
		   (setq this-command 'skk-completion)
		   (skk-completion (not (eq last-command 'skk-completion))))
		  ((eq last-command 'skk-completion)
		   (cond ((eq ch skk-next-completion-char)
			  (setq this-command 'skk-completion)
			  (skk-completion nil))
			 ((eq ch skk-previous-completion-char)
			  (setq this-command 'skk-completion)
			  (skk-previous-completion))
			 (t (skk-kana-input arg))))
		  (t (skk-kana-input arg))))
	   ;; just input Kana.
	   (t (skk-kana-input arg))))))

(defun skk-kana-input (&optional arg)
  ;;"ʸϤԤ롼"
  ;; Message-Id: <19980610190611B.sakurada@kuis.kyoto-u.ac.jp>
  ;; From: Hideki Sakurada <sakurada@kuis.kyoto-u.ac.jp>
  ;; Date: Wed, 10 Jun 1998 19:06:11 +0900 (JST)
  ;;
  ;;  skk-kana-input , ñ,
  ;; 餫롼ڤηɽƤ, Ϥ
  ;; ڤé, ʾéʤʤä餽Ͽ
  ;; Ƥ벾̾Ϥ. ȤߤǤ.
  ;;
  ;; 㤨, n a t ΤߤʤʲΥ롼
  ;;
  ;;     a   
  ;;     n   
  ;;     nn  
  ;;     na  
  ;;     ta  
  ;;     tt   ( t)
  ;;
  ;; 롼ڤѴ,
  ;;
  ;;                 /
  ;;                /   
  ;;           a   / t     n
  ;;              /         
  ;;                        
  ;;             |           / 
  ;;         a   | t      a /     n
  ;;             |         /       
  ;;                            
  ;;          ( "t")
  ;;
  ;; Ȥˤʤޤ.
  ;;
  ;; (ڤκ) `a' Ϥ, ڤκ
  ;; ֤פ˰ưޤ. ˤɤΤ褦ϤƤ,
  ;; 겼ˤɤʤΤ, ֤פϤƺޤ.
  ;; 롼˼֤ꤵƤ, ꤵƤ
  ;; ʸ򥭥塼ᤷƤ麬ޤ.
  ;;
  ;; ֤ `n' Ϥ, ֤פ˰ưޤ.
  ;;  `a' ޤ `n' ϤФ겼ˤɤ
  ;; ΤǼϤ򸫤ޤǤޤϤޤ.
  ;;  `t' Ϥ줿, `t' ǤϲˤɤʤΤ,
  ;; ֤פϤ `t' 򥭥塼ᤷޤ.
  ;;
  ;; , , ֤򤽤줾 skk-rule-tree,
  ;; skk-current-rule-tree ɽ.
  ;; ڤ򲼤ˤɤ, Ȥ, skk-select-branch 
  ;; Ѥ,
  ;;
  ;;   (skk-select-branch rule-tree ?a)
  ;;
  ;; Τ褦ˤޤ. ֤ꤵƤ뤫(("". "")ʤ),
  ;; ("t" ʤ), 줾 skk-get-kana,
  ;; skk-get-nextstate Ǽޤ.
  ;; don't echo key strokes in the minibuffer.
  (let ((echo-keystrokes 0)
	(queue (list last-command-char)))
    (while queue
      (if (not (skk-get-prefix skk-current-rule-tree))
	  (progn
	    (skk-set-marker skk-kana-start-point (point))
	    (setq skk-current-rule-tree skk-rule-tree))
	(skk-erase-prefix))
      (setq skk-prefix (concat (skk-get-prefix skk-current-rule-tree)
			       (char-to-string last-command-char)))
      (let ((next (skk-select-branch skk-current-rule-tree (car queue)))
	    data)
	(if next
	    ;; can go down SKK-CURRENT-RULE-TREE
	    (if (skk-get-branch-list next)
		;; NEXT have at least one branch
		(progn
		  (and skk-henkan-active
		       skk-kakutei-early
		       (not skk-process-okuri-early)
		       (skk-kakutei))
		  (setq queue (cdr queue)
			skk-current-rule-tree next))
	      ;; NEXT does not have any branch (i.e. NEXT is a leaf)
	      (setq data (skk-get-kana next)
		    queue (nconc (string-to-char-list (skk-get-nextstate next))
				 (cdr queue))
		    skk-current-rule-tree nil))
	  ;; can not go down SKK-CURRENT-RULE-TREE
	  (let ((d (skk-get-kana skk-current-rule-tree)))
	    (if d
		;; SKK-CURRENT-RULE-TREE have a roma->kana rule
		(setq data d
		      queue
		      (nconc (string-to-char-list
			      (skk-get-nextstate skk-current-rule-tree))
			     queue)
		      skk-current-rule-tree nil)
	      ;; SKK-CURRENT-RULE-TREE does not have any roma->kana rule
	      (let ((dd (and skk-kana-input-search-function
			     (funcall skk-kana-input-search-function))))
		(if dd
		    (setq data (car dd)
			  queue (nconc (string-to-char-list (cdr dd))
				       (cdr queue))
			  skk-current-rule-tree nil)
		  (if (eq skk-current-rule-tree skk-rule-tree)
		      ;; typo on the root of tree
		      (setq queue nil
			    skk-current-rule-tree nil)
		    ;; otherwise move to root of the tree, and redo
		    (setq skk-current-rule-tree nil)))))))
	(if (not data)
	    (if skk-current-rule-tree
		(progn
		  ;;(digit-argument arg)
		  ;; 󡢤褦ʬ󡣤Ȥꤢ
		  (or skk-isearch-message (setq prefix-arg arg))
		  (setq skk-prefix (skk-get-prefix skk-current-rule-tree))
		  (skk-insert-prefix skk-prefix))
	      ;;(skk-kana-cleanup 'force)
	      (and skk-henkan-active (skk-kakutei))
	      (setq skk-prefix "")
	      (or queue
		  (skk-emulate-original-map (skk-make-raw-arg arg))))
	  (skk-cancel-undo-boundary)
	  (setq skk-prefix "")
	  (and (functionp data)
	       (setq data (funcall data (skk-make-raw-arg arg))))
	  (if (not (stringp (if (consp data) (car data) data)))
	      nil
	    (let* ((str (if (consp data) (if skk-katakana (car data) (cdr data))
			  data))
		   (pair (and skk-auto-insert-paren
			      (cdr (assoc str skk-auto-paren-string-alist))))
		   (count0 arg) (count1 arg) (inserted 0))
	      (and skk-henkan-active
		   skk-kakutei-early (not skk-process-okuri-early)
		   (skk-kakutei))
	      ;; arg ¸Ƥʤȡ0 ˤʤäƤޤqueue
	      ;; ޤäƤƺ٤ؤä褿ȤʸϤ
	      ;; Ǥʤʤ롣
	      (while (> count0 0)
		(skk-insert-str str)
		(setq count0 (1- count0)))
	      (if (not pair)
		  nil
		(while (> count1 0)
		  (if (not (string= pair (char-to-string (following-char))))
		      (progn
			(setq inserted (1+ inserted))
			(skk-insert-str pair)))
		  (setq count1 (1- count1)))
		(or (= inserted 0) (backward-char inserted)))
	      (and skk-okurigana (null queue) (skk-set-okurigana))))))
      ;; XXX I don't know how skk-isearch-message works....
      (and skk-isearch-message (skk-isearch-message)))))

;; tree procedure (ĥ꡼˥뤿Υ󥿡ե)
(defun skk-search-tree (tree char-list)
  ;; TREE κü CHAR-LIST ˽äƤɤ롣
  ;;  nil  ̤ڤȤ֤,
  ;; ԤϤɤʤä CHAR-LIST λĤȤɤʤʤä
  ;; ڤȤ֤
  (catch 'return
    (let (next char rest)
      (while char-list
	(setq char (car char-list)
	      rest (cdr char-list)
	      next (skk-select-branch tree char))
	(if next
	    (setq tree next
		  char-list rest)
	  (throw 'return (cons char-list tree))))
      (cons nil tree))))

(defun skk-add-rule (tree rule)
  (let* ((prefix (nth 0 rule))
	 (l (length prefix))
	 (result (skk-search-tree tree (string-to-char-list prefix)))
	 (rest (car result))
	 (addpoint (cdr result)))
    (while rest
      (let ((addtree
	     (skk-make-rule-tree (car rest)
				 (substring prefix 0 (1+ (- l (length rest))))
				 nil nil nil)))
	(skk-add-branch addpoint addtree)
	(setq addpoint addtree
	      rest (cdr rest))))
    (skk-set-nextstate addpoint (nth 1 rule))
    (skk-set-kana addpoint (nth 2 rule))))

(defun skk-delete-rule (tree string)
  ;;  STRING Ф롼롼 TREE 
  (catch 'return
    (let ((char-list (string-to-char-list string))
	  (cutpoint tree)
	  (cuttree (car (skk-get-branch-list tree)))
					; TREE κФޤ1ܤʤ
					; Τ˰Ƥ
	  next)
      (while char-list
	(setq next (skk-select-branch tree (car char-list))
	      char-list (cdr char-list))
	(if next
	    (if (> (length (skk-get-branch-list tree)) 1)
		(setq cutpoint tree	; ޤ2ܰʾλ cutpoint cuttree
		      cuttree next	;  update
		      tree next)
	      (setq tree next))
	  (throw 'return nil)))
      (skk-set-branch-list cutpoint
			   (delq cuttree (skk-get-branch-list cutpoint))))))

;; convert skk-rom-kana-rule-list to skk-rule-tree.
;; The rule tree follows the following syntax:
;; <branch-list>  := nil | (<tree> . <branch-list>)
;; <tree>         := (<char> <prefix> <nextstate> <kana> <branch-list>)
;; <kana>         := (<Ҥ餬ʸ> . <ʸ>) | nil
;; <char>         := <Ѿʸ>
;; <nextstate>    := <Ѿʸʸ> | nil
(defun skk-compile-rule-list (&rest l)
  ;; rule-list ڤη˥ѥ뤹롣
  (let ((tree (skk-make-rule-tree nil "" nil nil nil))
	rule ll)
    (while l
      (setq ll (car l)
	    l (cdr l))
      (while ll
	(setq rule (car ll)
	      ll (cdr ll))
	(skk-add-rule tree rule)))
    tree))

(defun skk-insert-str (str)
  ;; STR 롣ɬפǤ self-insert-after-hook 
  ;; 뤹롣overwrite-mode ǤСŬڤ˾񤭤Ԥ
  (insert-and-inherit str)
  (if (and skk-henkan-on (not skk-henkan-active))
      (and skk-auto-start-henkan (not skk-okurigana) (skk-auto-start-henkan str))
    (and (boundp 'self-insert-after-hook) self-insert-after-hook
	 (funcall self-insert-after-hook (- (point) (length str)) (point)))
    (and overwrite-mode
	 (skk-del-char-with-pad (skk-ovwrt-len (string-width str))))))

(defun skk-ovwrt-len (len)
  ;; 񤭤ɤĹ֤
  (min (string-width
	(buffer-substring-no-properties
	 (point) (skk-save-point (end-of-line) (point))))
       len))

(defun skk-del-char-with-pad (length)
  ;; Ĺ LENGTH ʸõ롣ĴΤᡢɬפǤС˥ڡ
  ;; 롣
  (let ((p (point)) (len 0))
    (while (< len length)
      (forward-char 1)
      (setq len (string-width (buffer-substring-no-properties (point) p))))
    (delete-region p (point))
    (or (= length len)
        (progn
	  (insert-and-inherit " ")
          (backward-char 1)))))

(defun skk-cancel-undo-boundary ()
  ;; skk-insert, skk-jisx0208-latin-insert Ϣ³Ϥ
  ;; 줿 20 ʸ 1 ΥɥоݤȤ롣`20' 
  ;; keyboard.c 줿ޥåʥСMule-2.3 ź
  ;;  egg.el 򻲹ͤˤ
  (if (and (< skk-self-insert-non-undo-count 20)
           (memq last-command
                 '(skk-insert
                   skk-jisx0208-latin-insert
                   ;; SKK abbrev ⡼ɤǤϡʸϤ Emacs ꥸ
                   ;;  self-insert-command ˤԤʤƤΤǡ
                   ;; skk-self-insert-non-undo-count 򥤥󥯥Ȥ뤳
                   ;; ǤʤΤǡɥ򥨥ߥ졼ȤǤʤ
                   ;; ⡢ޤԥꥪɤǡ
                   ;; skk-abbrev-comma  skk-abbrev-period ȤȤˤʤ
                   ;;  (self-insert-command ʳΥޥɤȤäƤޤΤ)
		   ;; ꥸʥΥɥεǽ»ʤäƤޤ
		   ;; ȤƤϡSKK abbrev ⡼ɤϾάȤƤ
		   ;; Ф뤿Υ⡼ɤǤΤǡĹФ
		   ;; 뤳ȤϤޤʤ⾮ȹͤ롣
                   ;;skk-abbrev-comma
                   ;;skk-abbrev-period
		  )))
      (progn
        (cancel-undo-boundary)
	(if (null skk-current-rule-tree)
	    ;; ޤʸƤʤȤϡundo count 򥤥󥯥
	    ;; ʤ
	    (setq skk-self-insert-non-undo-count
		  (1+ skk-self-insert-non-undo-count))))
    (setq skk-self-insert-non-undo-count 1)))

(defun skk-translate-okuri-char (okurigana)
  (and skk-okuri-char-alist
       (cdr (assoc (skk-substring-head-character okurigana) skk-okuri-char-alist))))

(defun skk-set-okurigana ()
  ;; Ф줫 skk-henkan-okurigana, skk-henkan-key γͤ򥻥åȤ롣
  (cancel-undo-boundary)
  (and skk-katakana (skk-hiragana-region skk-henkan-start-point (point)))
  (skk-set-marker skk-henkan-end-point skk-okurigana-start-point)
  ;; just in case
  (skk-save-point
    (goto-char skk-okurigana-start-point)
    (or (eq (following-char) ?*) (insert-and-inherit "*")))
  (setq skk-henkan-okurigana (buffer-substring-no-properties
                              (1+ skk-okurigana-start-point)
                              (point)))
  (setq skk-henkan-key (concat (buffer-substring-no-properties
				skk-henkan-start-point
				skk-henkan-end-point)
			       (or (skk-translate-okuri-char
				    skk-henkan-okurigana)
				   skk-okuri-char))
        skk-prefix "")
  (delete-region skk-okurigana-start-point (1+ skk-okurigana-start-point))
  (setq skk-henkan-count 0)
  (skk-henkan)
  (setq skk-okurigana nil))

;;;; other inputting functions

(defun skk-toggle-kutouten ()
  "μȥѹ롣"
  (interactive)
  (setq skk-kutouten-type (if (eq skk-kutouten-type 'jp) 'en 'jp))
  (and (interactive-p)
       (skk-message ": `%s'  : `%s'"
		    "Kuten: `%s'  Touten: `%s'"
		    (skk-current-kuten nil) (skk-current-touten nil))))

(defun skk-current-kuten (arg)
  ;; just ignore arg.
  (car (cdr (assq skk-kutouten-type skk-kuten-touten-alist))))

(defun skk-current-touten (arg)
  ;; just ignore arg.
  (cdr (cdr (assq skk-kutouten-type skk-kuten-touten-alist))))

(defun skk-abbrev-period (arg)
  "SKK abbrev ⡼ɤǸФ䴰ԤäƤǤСθɽ롣
䴰ľǤʤСꥸʥΥդΥޥɤ򥨥ߥ졼Ȥ롣
SKK abbrev ⡼ɰʳǤϡskk-insert-period ؿѤ뤳ȡ"
  (interactive "*P")
  (skk-with-point-move
   (if (eq last-command 'skk-completion)
       (progn
	 (setq this-command 'skk-completion)
	 (skk-completion nil))
     (skk-emulate-original-map arg))))

(defun skk-abbrev-comma (arg)
  "SKK abbrev ⡼ɤǸФ䴰ԤäƤǤСľθɽ롣
䴰ľǤʤСꥸʥΥդΥޥɤ򥨥ߥ졼Ȥ롣
SKK abbrev ⡼ɰʳǤϡskk-insert-comma ؿѤ뤳ȡ"
  (interactive "*P")
  (skk-with-point-move
   (if (eq last-command 'skk-completion)
       (progn
	 (setq this-command 'skk-completion)
	 (skk-previous-completion))
     (skk-emulate-original-map arg))))

(defun skk-jisx0208-latin-insert (arg)
  "ʸ򥫥ȥХåե롣
skk-jisx0208-latin-vector ơ֥ȤơǸϤ줿бʸ
롣
skk-auto-insert-paren ͤ non-nil ξǡskk-auto-paren-string-alist 
бʸ󤬤Ȥϡбʸ (ä) ưŪ롣"
  (interactive "*p")
  (skk-with-point-move
   (let* ((str (aref skk-jisx0208-latin-vector last-command-char))
	  (arg2 arg)
	  (pair-str
	   (and skk-auto-insert-paren
		(cdr (assoc str skk-auto-paren-string-alist))))
	  (pair-str-inserted 0))
     (if (not str)
	 (skk-emulate-original-map arg)
       (skk-cancel-undo-boundary)
       (while (> arg 0)
	 (skk-insert-str str)
	 (setq arg (1- arg)))
       (if (not pair-str)
	   nil
	 (while (> arg2 0)
	   (if (not (string= pair-str (char-to-string (following-char))))
	       (progn
		 (setq pair-str-inserted (1+ pair-str-inserted))
		 (skk-insert-str pair-str)))
	   (setq arg2 (1- arg2)))
	 (or (= pair-str-inserted 0) (backward-char pair-str-inserted)))))))

(defun skk-delete-backward-char (arg)
  "⡼ɤ skk-delete-implies-kakutei  non-nil äľʸäƳꤹ롣
⡼ɤ skk-delete-implies-kakutei  nil äɽ롣
⡼ɤ`'ΥݥȤǼ¹Ԥȳꤹ롣
ϥ⡼ɤǡʥץեåʤСʥץեåä"
  (interactive "*P")
  (skk-with-point-move
   (let ((count (prefix-numeric-value arg)))
     (cond (skk-henkan-active
	    (if (and (not skk-delete-implies-kakutei)
		     (= skk-henkan-end-point (point)))
		(skk-previous-candidate)
	      ;; overwrite-mode ǡݥȤʸ˰ϤޤƤ
	      ;;  delete-backward-char ȤȡʸϾäȾ
	      ;; ʸʬ backward ˥ݥȤʤ (Emacs
	      ;; 19.31 ˤƳǧ)ѴθФƤ
	      ;; delete-backward-char ɬʸ 1 ʸʬ backward
	      ;; äɤ
	      (if overwrite-mode
		  (progn
		    (backward-char count)
		    (delete-char count arg))
		(skk-emulate-original-map arg))
	      ;; XXX assume skk-prefix has no multibyte chars.
	      (if (> (length skk-prefix) count)
		  (setq skk-prefix (substring skk-prefix 0 (- (length skk-prefix) count)))
		(setq skk-prefix ""))
	      (and (>= skk-henkan-end-point (point)) (skk-kakutei))))
	   ((and skk-henkan-on (>= skk-henkan-start-point (point)))
	    (setq skk-henkan-count 0)
	    (skk-kakutei))
	   ;; θФФƤ delete-backward-char ɬʸ 1
	   ;; ʸʬ backward äɤ
	   ((and skk-henkan-on overwrite-mode)
	    (backward-char count)
	    (delete-char count arg))
	   (t
	    (skk-delete-okuri-mark)
	    (if (skk-get-prefix skk-current-rule-tree)
		(skk-erase-prefix 'clean)
	      (skk-emulate-original-map arg)))))))

;;;; henkan routines
(defun skk-henkan ()
  ;; ʤѴᥤ롼
  (let (mark new-word kakutei-henkan)
    (if (string= skk-henkan-key "")
        (skk-kakutei)
      ;; we use mark to go back to the correct position after henkan
      (or (eobp) (setq mark (skk-save-point (forward-char 1) (point-marker))))
      (if (not skk-henkan-active)
          (progn
            (skk-change-marker)
            (setq skk-current-search-prog-list skk-search-prog-list)))
      ;; skk-henkan-1 椫饳뤵 skk-henkan-show-candidate  throw
      ;; 롣ǥåϡ?x ȥ꡼ᤵƤΤǡ
      ;; δؿФơskk-previous-candidates ؤ椯
      (catch 'unread
        (setq new-word (or (skk-henkan-1) (skk-henkan-in-minibuff))
              kakutei-henkan skk-kakutei-flag)
        (and new-word (skk-insert-new-word new-word)))
      (if mark
          (progn
            (goto-char mark)
            ;; ȤƤʤޡϡGarbage Collection 뤵줿
            ;; ˲뤬ޤǤδ֡ƥȤΤɤؤƤȡ
            ;; ƥȤΥåץǡȤκݤˤΥޡͤ򹹿ɬפ
            ;; Τǡɤؤʤ褦ˤ롣
            (skk-set-marker mark nil)
	    (backward-char 1))
        (goto-char (point-max)))
      (and kakutei-henkan
	   (skk-kakutei (if (skk-numeric-p)
			    (skk-get-current-candidate-simply 'noconv)
			  new-word))))))

(defun skk-henkan-1 ()
  ;; skk-henkan Υ֥롼
  (let (new-word)
    (if (= skk-henkan-count 0)
        (progn
          (and (eq last-command 'skk-undo-kakutei-henkan)
	       (eq (car (car skk-current-search-prog-list))
		   'skk-search-kakutei-jisyo-file)
	       ;; in this case, we should not search kakutei jisyo.
	       (setq skk-current-search-prog-list
		     (cdr skk-current-search-prog-list)))
          (setq skk-henkan-list (skk-search))
          (if (null skk-henkan-list)
              nil
            (setq new-word (skk-get-current-candidate))
            (and skk-kakutei-flag
		 ;; found the unique candidate in kakutei jisyo
		 (setq this-command 'skk-kakutei-henkan))))
      ;; Ѵ 1 ʾΤȤ
      (setq new-word (skk-get-current-candidate))
      (or new-word
          ;; 򸫤Ĥ뤫skk-current-search-prog-list ˤ
          ;; ޤ skk-search Ϣ³ƥ뤹롣
          (while (and skk-current-search-prog-list (not new-word))
            (setq skk-henkan-list (skk-nunion skk-henkan-list (skk-search))
                  new-word (skk-get-current-candidate))))
      (and new-word (> skk-henkan-count 3)
	   ;; show candidates in minibuffer
	   (setq new-word (skk-henkan-show-candidates))))
    new-word))

(defun skk-get-current-candidate ()
  (if (skk-numeric-p)
      (let (val)
        (skk-num-uniq)
        (setq val (skk-num-convert (skk-get-current-candidate-simply)))
        (if (not skk-num-recompute-key)
            val
          (skk-num-uniq)
          (skk-num-convert (skk-get-current-candidate-simply))))
    (skk-get-current-candidate-simply)))

(defun skk-henkan-show-candidates ()
  ;; ߥ˥ХåեѴ䷲ɽ롣
  (skk-save-point
   (let* ((candidate-keys ; ɽѤΥꥹ
           (mapcar
	    (function (lambda (c)
			(and (memq c '(?\C-g ?\040 ?x)) ; ?\040 is SPC.
			     (skk-error "`%s' ̵ʥꤵƤޤ"
					"Illegal key in `%s'"
					"skk-henkan-show-candidates-keys"))
			(char-to-string (upcase c))))
	    skk-henkan-show-candidates-keys))
          key-num-alist ; ѤϢۥꥹ
          (key-num-alist1 ; key-num-alist ȤΩƤ뤿κϢۥꥹȡ
           (let ((count 6))
             (mapcar (function (lambda (key) (prog1 (cons key count)
                                               (setq count (1- count)))))
                     ;; դޤˤƤơɽοʤä
                     ;; ƬĤ롣
                     (reverse skk-henkan-show-candidates-keys))))
          (loop 0)
          inhibit-quit
          henkan-list new-one str reverse n)
     ;; Emacs 19.28  Overlay äƤʤȡ insert 
     ;; skk-henkan-key ˲Τ Overlay äƤޤ
     (and skk-use-face (skk-henkan-face-off))
     (delete-region skk-henkan-start-point skk-henkan-end-point)
     (while loop
       (if str
           (let (message-log-max)
             (message str))
         (cond (reverse
                (setq loop (1- loop)
                      henkan-list (nthcdr (+ 4 (* loop 7)) skk-henkan-list)
                      reverse nil))
               (skk-exit-show-candidates
                ;; 䤬ԤƤޤäơskk-henkan-show-candidates ->
                ;; skk-henkan-in-minibuff -> skk-henkan
                ;; -> skk-henkan-show-candidates νǡƤӤδؿƤФ
                ;; Ȥϡ henkan-list  loop ׻롣
                (setq henkan-list (nthcdr skk-henkan-count skk-henkan-list)
                      loop (car skk-exit-show-candidates)
                      skk-exit-show-candidates nil))
               (t
                ;; skk-henkan-show-candidates-keys κǽΥб
                ;; ФƤޤǥ³롣
                (and (skk-numeric-p) (skk-num-uniq))
                (while (and skk-current-search-prog-list
                            (null (nthcdr (+ 11 (* loop 7)) skk-henkan-list)))
                  (setq skk-henkan-list
                        (skk-nunion skk-henkan-list (skk-search)))
                  (and (skk-numeric-p) (skk-num-uniq)))
                (and (skk-numeric-p) (skk-num-convert*7))
                (setq henkan-list (nthcdr (+ 4 (* loop 7)) skk-henkan-list))))
         (setq n (skk-henkan-show-candidate-subr candidate-keys henkan-list)))
       (if (> n 0)
           (condition-case nil
               (let* ((event (skk-read-event))
                      (char (event-to-character event))
                      num)
		 (if (eq skk-emacs-type 'xemacs)
		     (message "")) ; clear out candidates in echo area
                 (if (null char)
                     (skk-unread-event event)
                   (setq key-num-alist (nthcdr (- 7 n) key-num-alist1))
                   (and key-num-alist
			(setq num (cdr (or (assq char key-num-alist)
					   (if (skk-lower-case-p char)
					       (assq (upcase char) key-num-alist)
					     (assq (downcase char) key-num-alist))))))
                   (cond (num
                          (setq new-one (nth num henkan-list)
                                skk-henkan-count (+ 4 (* loop 7) num)
                                skk-kakutei-flag t
                                loop nil
                                str nil))
                         ((eq char ?\040) ; SPC
                          (if (or skk-current-search-prog-list
                                  (nthcdr 7 henkan-list))
                              (setq loop (1+ loop)
                                    str nil)
                            ;; 䤬Ԥδؿȴ롣
                            (let ((last-showed-index (+ 4 (* loop 7))))
                              (setq skk-exit-show-candidates
                                    ;; cdr ϡϿ˺Ǹɽ
                                    ;; ䷲Ǻǽθؤǥ
                                    (cons loop last-showed-index))
                              ;; Ͽ롣skk-henkan-count 
                              ;; skk-henkan-list κǸθμ (¸ߤʤ
                              ;; --- nil)ؤ
                              (setq skk-henkan-count (+ last-showed-index n)
                                    loop nil
                                    str nil))))
                         ((eq char skk-previous-candidate-char)	; ?x
                          (if (= loop 0)
                              ;; skk-henkan-show-candidates Ƥξ֤
                              ;; 
                              (progn
                                (setq skk-henkan-count 4)
                                (skk-unread-event (character-to-event
						   skk-previous-candidate-char))
                                ;; skk-henkan ޤǰ쵤 throw 롣
                                (throw 'unread nil))
                            ;; θ䷲򥨥ꥢɽ롣
                            (setq reverse t
                                  str nil)))
			 ;; 줬ʤ quit ǤʤΡ
			 ((and (eq skk-emacs-type 'xemacs)
			       (eq char (quit-char)))
			  (signal 'quit nil))
                         (t (skk-message "\"%c\" ͭʥǤϤޤ"
                                         "\"%c\" is not valid here!"
                                         char)
                            (sit-for 1)))))
             (quit
              ;; skk-previous-candidate 
              (setq skk-henkan-count 0)
              (skk-unread-event (character-to-event skk-previous-candidate-char))
              ;; skk-henkan ޤǰ쵤 throw 롣
              (throw 'unread nil)))))  ; end of while loop
     (if (consp new-one)
         (cdr new-one)
       new-one))))

(defun skk-henkan-show-candidate-subr (keys candidates)
  ;; key  candidates Ȥ߹碌 7 Ĥθ䷲ ( 7 ʤ
  ;; 餽Ǥڤ) ʸꡢߥ˥Хåեɽ롣
  (let ((workinglst
	 ;; CANDIDATES Ƭ 7 ĤΤߤΥꥹȡ
	 (let ((count 0) e v)
	   (while (> 7 count)
	     (setq e (nth count candidates))
	     (if e
		 (setq v (cons e v)
		       count (1+ count))
	       (setq count 7)))
	   (nreverse v)))
	(n 0) str cand message-log-max)
    (if (not (car workinglst))
        nil
      (setq workinglst (skk-truncate-message workinglst))
      (setq n 1
            ;; ǽθ˶򤯤äĤʤ褦˺ǽθ˼
            ;; Ф
            str (concat (car keys) ":" (if (consp (car workinglst))
                                            (cdr (car workinglst))
                                          (car workinglst))))
      ;; Ĥ 6 ĤФȸδ֤ǤĤʤ
      (while (and (< n 7) (setq cand (nth n workinglst)))
        (setq cand (if (consp cand) (cdr cand) cand)
              str (concat str "  " (nth n keys) ":" cand)
              n (1+ n)))
      (message "%s  [Ĥ %d%s]"
               str (length (nthcdr n candidates))
               (make-string (length skk-current-search-prog-list) ?+)))
    ;; ɽ֤
    n))

(defun skk-truncate-message (l)
  (let* (
	 ;; L äƤ뤽줾 () ʸΥꥹȡ
	 (width-list
	  (mapcar
	   (function (lambda (e) (string-width (if (consp e) (cdr e) e))))
	   l))
	 ;; 
	 (candidates-num (length l))
	 ;; ʳ˥ꥢɽʤʸ
	 ;; (string-width "  [Ĥ 100+]") -> 13
	 ;; ` F:'ʤɤθΤɽ width 3 ʸ󤬸ʬ롣
	 ;; ꥢκǽθ϶դƤʤΤ 1-
	 (parts-len (+ 13 (1- (* 3 candidates-num))))
	 ;; ǡȡǤɤˤʤ뤫
	 (message-width (apply '+ parts-len width-list))
	 (diff (- (window-width) message-width))
	 (count 0) (plus 0) max)
    (if (> diff 0)
	;; window-width ˼ޤäƤв⤷ʤ
	l
      ;; 줾θκ򲾷᤹롣
      (setq max (/ (float (- (window-width) parts-len)) candidates-num))
      (while width-list
	(if (> (car width-list) max)
	    (setq count (1+ count))
	  (setq plus (+ (- max (car width-list)) plus)))
	(setq width-list (cdr width-list)))
      ;; ʤĹ򽸤ƺ
      (setq max (truncate (/ (+ plus (- (window-width) parts-len))
			     candidates-num)))
      (mapcar
       (function
	(lambda (e)
	  ;; ʾʸ
	  (cond ((and (stringp e) (> (string-width e) max))
		 ;; ˼ޤ褦û롣
		 (concat (truncate-string-to-width e (- max 3)) "..."))
		((and (consp e) (> (string-width (cdr e)) max))
		 (cons (car e)
		       (concat (truncate-string-to-width (cdr e) (- max 3))
			       "...")))
		(t e))))
       l))))

(defun skk-henkan-in-minibuff ()
  ;; ߥ˥ХåեǼϿ򤷡Ͽȥʸ֤
  (save-match-data
    (let ((enable-recursive-minibuffers t)
          ;; Ѵ isearch message Фʤ褦ˤ롣
          skk-isearch-message new-one)
      (add-hook 'minibuffer-setup-hook 'skk-j-mode-on)
      (add-hook
       'minibuffer-setup-hook
       (function (lambda ()
		   (add-hook 'pre-command-hook 'skk-pre-command nil 'local))))
      (condition-case nil
          (setq new-one
                (read-from-minibuffer
                 (concat (or (and (skk-numeric-p) (skk-num-henkan-key))
                             (if skk-okuri-char
                                 (skk-compute-henkan-key2)
                               skk-henkan-key))
                         " ")
		 (if (and (not skk-okuri-char)
			  skk-read-from-minibuffer-function)
		     (funcall skk-read-from-minibuffer-function))))
        (quit
         (setq new-one "")))
      (if (string= new-one "")
          (if skk-exit-show-candidates
              ;; ߥ˥Хåեɽ䤬ԤƼϿäʸ
              ;; Ͽ줿硣Ǹ˥ߥ˥Хåեɽ䷲ɽ
              ;; 롣
              (progn
                (setq skk-henkan-count (cdr skk-exit-show-candidates))
                (skk-henkan))
            ;; skk-henkan-show-candidates ˸䤬Ԥ
            (setq skk-henkan-count (1- skk-henkan-count))
            (if (= skk-henkan-count -1)
                (progn
                  ;; ꤢѴǼϿꡢʸϿ塢
                  ;; ޤ޺ʤȤѴ
                  ;; skk-henkan-okurigana, skk-okuri-char ͤ nil ˤʤ
                  ;; С줾ͤ˸Ť겾̾äޤޤǸ˼
                  ;; 롣
                  (setq skk-henkan-okurigana nil
                        skk-okurigana nil
                        skk-okuri-char nil)
                  (skk-change-marker-to-white))
              ;; skk-henkan-count  -1 ǤʤСȥХåեǤϺǸ
              ;; ɽޤޤʤΤ (ɽϢǤϲ⤷ʤƤ⡢⤦
              ;; ˾ߤξ֤ˤʤäƤ) ⤷ʤ
             ))
        ;; ߥ˥ХåեѴʸ󤬤 (ʸǤʤ) Ȥ
        ;; ζ
        (and (string-match "[ ]+$" new-one)
	     (setq new-one (substring new-one 0 (match-beginning 0))))
        (if (skk-numeric-p)
            (setq new-one (skk-num-process-user-minibuf-input new-one))
          ;; θ䤬ˡκǸ˿äΤ
          ;; ä
          (setq skk-henkan-list (nconc skk-henkan-list (list new-one))
                ;; ե饰򥪥ˤ롣
                skk-kakutei-flag t))
        (setq skk-henkan-in-minibuff-flag t
              skk-touroku-count (1+ skk-touroku-count)))
      ;; (nth skk-henkan-count skk-henkan-list)  nil 鼭Ͽ
      ;; äƤ롣skk-henkan-count 򥤥󥯥ȤɬפϤʤ
      ;; (setq skk-henkan-count (1+ skk-henkan-count))
      ;; new-one ʸä nil ֤
      (if (not (string= new-one "")) new-one))))

(defun skk-compute-henkan-key2 ()
  ;; skk-henkan-okurigana  non-nil ʤ skk-henkan-key 顢Ĥ
  ;; skk-henkan-key2 ȸƤФƤΤ롣
  ;; skk-henkan-key2 Ȥϡִʬɤ + "*" + 겾̾פηʸ
  ;; 
  (if skk-henkan-okurigana
      (save-match-data
 	(string-match "[a-z]+$" skk-henkan-key)
 	(concat (substring skk-henkan-key 0 (match-beginning 0))
 		"*" skk-henkan-okurigana))))

(defun skk-setup-minibuffer ()
  ;; ȥХåեϥ⡼ɤ˽ߥ˥Хåեϥ⡼ɤꤹ롣
  (cond ((eq skk-minibuffer-origin-mode 'hiragana)
	 (skk-j-mode-on))
	((eq skk-minibuffer-origin-mode 'katakana)
	 (skk-j-mode-on t))
	((eq skk-minibuffer-origin-mode 'abbrev)
	 (skk-abbrev-mode-on))
	((eq skk-minibuffer-origin-mode 'latin)
	 (skk-latin-mode-on))
	((eq skk-minibuffer-origin-mode 'jisx0208-latin)
	 (skk-jisx0208-latin-mode-on))))

(defun skk-previous-candidate (&optional arg)
  "⡼ɤǤСθɽ롣
⡼ɰʳǤϥȥХåե \"x\" 롣
꼭ˤľ˸Ƥ֤ȳ꤬ɥơξ֤
ľθФ줬ȥХåե롣"
  (interactive "*p")
  (skk-with-point-move
   (if (not skk-henkan-active)
       (if (not (eq last-command 'skk-kakutei-henkan))
	   (skk-kana-input arg)
	 ;; restore the state just before the last kakutei henkan.
	 (delete-region skk-henkan-start-point (point))
	 (skk-set-henkan-point-subr)
	 (insert-and-inherit (skk-get-last-henkan-data 'henkan-key))
	 (setq this-command 'skk-undo-kakutei-henkan))
     (if (string= skk-henkan-key "")
	 nil
       (let ((mark
	      (if (not (eobp))
		  (skk-save-point (forward-char 1) (point-marker)))))
	 (skk-save-point
	  (if (= skk-henkan-count 0)
	      (progn
		(and skk-okuri-char
		     ;; roman prefix for okurigana should be removed.
		     (setq skk-henkan-key (substring skk-henkan-key 0 -1)))
		(setq skk-henkan-count -1
		      skk-henkan-in-minibuff-flag nil
		      skk-henkan-list nil
		      skk-henkan-okurigana nil
		      skk-okuri-char nil
		      skk-okuri-index-min -1
		      skk-okuri-index-max -1
		      skk-okurigana nil
		      skk-prefix "")
		(and (skk-numeric-p) (skk-num-initialize))
		;; Emacs 19.28  Overlay äƤʤȡ insert 
		;;  skk-henkan-key ˲Τ Overlay äƤޤ
		(and skk-use-face (skk-henkan-face-off))
		(delete-region skk-henkan-start-point skk-henkan-end-point)
		(goto-char skk-henkan-end-point)
		(insert-and-inherit skk-henkan-key)
		(skk-change-marker-to-white))
	    (setq skk-henkan-count (1- skk-henkan-count))
	    (skk-insert-new-word (skk-get-current-candidate-simply))))
	 (if mark
	     (progn
	       (goto-char mark)
	       (skk-set-marker mark nil)
	       (backward-char 1))
	   (goto-char (point-max)))
	 (and skk-abbrev-mode (= skk-henkan-count -1) (skk-abbrev-mode-on)))))))

(defun skk-insert-new-word (word)
  ;; ФäξѴ̤ʸ롣
  (let (func)
    ;; Emacs 19.28  Overlay äƤʤȡ insert 
    ;; skk-henkan-key ˲Τ Overlay äƤޤ
    (and skk-use-face (skk-henkan-face-off))
    (delete-region skk-henkan-start-point skk-henkan-end-point)
    (goto-char skk-henkan-start-point)
    ;; (^_^;) Τ褦ʸФФread-from-string Ƥ֤ȥ顼ˤʤ
    ;; ǡcondition-case ǤΥ顼ޤ롣
    (condition-case nil
	(setq func (car (read-from-string word)))
      (error (setq func word)))
    (condition-case nil
	(insert-and-inherit (if (and (listp func)
				     (functionp (car func)))
				(eval func) word))
      ;; ʸ֤ʤ Lisp ץɾƤ⥨顼ˤʤʤ
      (error nil))
    (skk-set-marker skk-henkan-end-point (point))
    (and skk-use-face (skk-henkan-face-on))
    (and skk-insert-new-word-function
	 (funcall skk-insert-new-word-function))))

(defun skk-kakutei (&optional word)
  "ɽƤǳꤷιԤ
ȥХåե SKK ⡼ɤˤʤäƤʤä SKK ⡼ɤ롣
ץʥ WORD ϤȡɽƤȤ̵ط WORD ǳ
ꤹ롣"
  ;; read only ǥ顼ˤʤ褦ˤ read only Хåե SKK ưǤ
  ;; ʤʤ롣
  (interactive)
  (let ((inhibit-quit t)
	converted kakutei-word)
    (if (not skk-henkan-on)
	nil
      (if (not skk-henkan-active)
	  nil
	(setq kakutei-word
	      ;; 꼭θǳꤷȤϡˤθ񤭹ɬפ
	      ;; ɬפʤȻפäƤ䴰ԤʤȤϡ
	      ;; Ŀͼ򻲾Ȥ (꼭ϻȤʤ) Τǡ¿񸻤Ȼ
	      ;; ̵֤̤ˤƤ⡢Ŀͼ˳꼭Υȥ񤭹ǹ
	      ;; ⤷Ƥ
	      (or word (skk-get-current-candidate-simply (skk-numeric-p))))
	(if (or
	     (and (not skk-search-excluding-word-pattern-function) kakutei-word)
	     (and
	      kakutei-word skk-search-excluding-word-pattern-function
	      (not
	       (funcall skk-search-excluding-word-pattern-function kakutei-word))))
	    (progn
	      (skk-update-jisyo kakutei-word)
	      (if (skk-numeric-p)
		  (progn
		    (setq converted (skk-get-current-candidate-simply))
		    (skk-num-update-jisyo kakutei-word converted))))))
      (if skk-mode
	  (progn
	    (skk-kakutei-cleanup-buffer)
	    ;; KAKUTEI-WORD ʤɤξɬפǤСskk-last-henkan-data 
	    ;; 롣ɬפʥǡѿ˸ꤵʤΤǡˤʤ
	    (and skk-kakutei-end-function (funcall skk-kakutei-end-function))
	    (skk-kakutei-initialize
	     (if (skk-numeric-p) (cons kakutei-word converted) kakutei-word)))))
    (skk-do-auto-fill)
    (if skk-mode
	(skk-j-mode-on skk-katakana)
      ;; ȥХåեǤޤ skk-mode 뤵Ƥʤä顢뤹롣
      (skk-mode 1))))

(defun skk-kakutei-cleanup-buffer ()
  ;; ľΥХåեԤʤ
  (if skk-okurigana
      (progn
        (skk-delete-okuri-mark)
        (and skk-katakana skk-convert-okurigana-into-katakana
	     (skk-katakana-region skk-henkan-end-point (point)))))
  (skk-delete-henkan-markers)
  (and (boundp 'self-insert-after-hook) self-insert-after-hook
       (funcall self-insert-after-hook skk-henkan-start-point (point)))
  (and overwrite-mode
       (skk-del-char-with-pad
	(skk-ovwrt-len
	 (string-width
	  (buffer-substring-no-properties skk-henkan-start-point (point)))))))

(defun skk-kakutei-initialize (&optional kakutei-word)
  ;; ѿνȥɥΤѿ¸Ԥʤ
  (if (and kakutei-word (or (consp kakutei-word)
                            (not (string= kakutei-word ""))))
      (progn
	(setq skk-kakutei-count (1+ skk-kakutei-count))
        ;; skk-undo-kakutei Τ˺ǸѴΥǡ¸롣
	(skk-put-last-henkan-data 'henkan-key skk-henkan-key)
	(skk-put-last-henkan-data 'okuri-char skk-okuri-char)
	(skk-put-last-henkan-data 'henkan-okurigana skk-henkan-okurigana)
	(skk-put-last-henkan-data
	 'henkan-list
	 ;; ꤷƬˤ롣
	 (cons kakutei-word (delete kakutei-word skk-henkan-list)))
	;; (eq last-command 'skk-kakutei-henkan) ǥݡ֥˳ǧǤΤ
	;; Ƥʤ
	;;(skk-put-last-henkan-data
	;; 'kakutei-henkan
	;; (eq this-command 'skk-kakutei-henkan))
	;;
	;; 嵭ʳ henkan data  skk-last-henkan-data ˻Ĥä顢
	;; skk-kakutei-end-function Ѥ롣
	))
  (setq skk-abbrev-mode nil
        skk-exit-show-candidates nil
        skk-henkan-active nil
        skk-henkan-count -1
	skk-henkan-in-minibuff-flag nil
        skk-henkan-key nil
        skk-henkan-list nil
        skk-henkan-okurigana nil
        skk-henkan-on nil
        skk-kakutei-flag nil
        skk-okuri-char nil
	skk-okuri-index-min -1
	skk-okuri-index-max -1
	;; skk-prefix ""
	)
  (and (skk-numeric-p) (skk-num-initialize))
  (and skk-use-look (setq skk-look-completion-words nil)))

(defun skk-undo-kakutei ()
  "ֺǸγ򥢥ɥФФɽ롣
Ǹ˳ꤷȤθϥåפ롣
䤬¾ˤʤȤϡߥ˥ХåեǤμϿ롣"
  (interactive)
  (skk-with-point-move
   (cond ((eq last-command 'skk-undo-kakutei)
	  (skk-error "ꥢɥϢ³ѤǤޤ"
		     "Cannot undo kakutei repeatedly"))
	 (skk-henkan-active
	  (skk-error "⡼ɤǤϳꥢɥǤޤ"
		     "Cannot undo kakutei in  mode"))
	 ( ; skk-henkan-key may be nil or "".
	  (or (not (skk-get-last-henkan-data 'henkan-key))
	      (string= (skk-get-last-henkan-data 'henkan-key) ""))
	  (skk-error "ɥǡޤ" "Lost undo data")))
   (condition-case nil
       (let ((end
	      (if (skk-get-last-henkan-data 'henkan-okurigana)
		  (+ (length (skk-get-last-henkan-data 'henkan-okurigana))
		     skk-henkan-end-point)
		skk-henkan-end-point)))
	 (setq skk-henkan-active t
	       skk-henkan-on t
	       skk-current-search-prog-list
	       (if (eq (car (car skk-search-prog-list))
		       'skk-search-kakutei-jisyo-file)
		   ;; 꼭õƤ̵̣
		   (cdr skk-search-prog-list)
		 skk-search-prog-list))
	 ;; get henkan data back from skk-last-henkan-data.
	 (setq skk-henkan-key (skk-get-last-henkan-data 'henkan-key)
	       skk-henkan-list (skk-get-last-henkan-data 'henkan-list)
	       skk-henkan-okurigana (skk-get-last-henkan-data 'henkan-okurigana)
	       skk-okuri-char (skk-get-last-henkan-data 'okuri-char))
	 (and skk-use-numeric-conversion
	      (setq skk-num-list (skk-get-last-henkan-data 'skk-num-list)))
	 (and (>= (point-max) end)
	      ;; ǸѴʬΥƥȤä겾̾İƤΤʤ
	      ;; (skk-process-okuri-early  non-nil ʤ겾̾İǤʤ)
	      ;; 겾̾ޤ᤿ʬޤǤä
	      (delete-region skk-henkan-start-point end))
	 (goto-char skk-henkan-start-point)
	 (insert-and-inherit "")
	 (skk-set-marker skk-henkan-start-point (point))
	 (if skk-okuri-char
	     (progn			; ꤢ
	       (insert-and-inherit (substring skk-henkan-key 0
					      (1- (length skk-henkan-key))))
	       (skk-set-marker skk-henkan-end-point (point))
	       (and skk-henkan-okurigana (insert-and-inherit skk-henkan-okurigana)))
	   (insert-and-inherit skk-henkan-key)
	   (skk-set-marker skk-henkan-end-point (point)))
	 (skk-message "ꥢɥ" "Undo kakutei!")
	 (setq skk-henkan-count 1)
	 (skk-henkan))
     ;; skk-kakutei-undo ȴϡƼե饰Ƥʤ
     ;; ȼư򤷤褦ȤȤ˥顼ˤʤ롣
     (error (skk-kakutei))
     (quit (skk-kakutei)))))

(defun skk-set-henkan-point (&optional arg)
  ;;"Ѵ򳫻ϤݥȤޡб skk-prefix 첻Ϥ롣"
  (let* ((last-char (skk-downcase last-command-char))
	 (normal (not (eq last-char last-command-char)))
	 (sokuon (and (string= skk-prefix (char-to-string last-char))
		      (/= last-char ?o)))
	 (henkan-active skk-henkan-active))
    (if (or (not skk-henkan-on) skk-henkan-active)
	(if normal
	    (skk-set-henkan-point-subr)
	  (and skk-henkan-on (skk-set-henkan-point-subr))
	  (if henkan-active
	      (skk-emulate-original-map arg)
	    ;; What's to be here?
	    ;;(skk-self-insert arg)
	   ))
      (if (not normal)
	  (progn			; special char
	    (insert-and-inherit last-char)
	    (skk-set-marker skk-henkan-end-point (point))
	    (setq skk-henkan-count 0
		  skk-henkan-key (buffer-substring-no-properties
				  skk-henkan-start-point (point))
		  skk-prefix "")
	    (skk-henkan))
	;; prepare for the processing of okurigana if not skk-okurigana
	;; and the preceding character is not a numeric character.
	;; if the previous char is a special midashi char or a
	;; numeric character, we assume that the user intended to type the
	;; last-command-char in lower case.
	(if (and (or (not (skk-get-prefix skk-current-rule-tree)) ; for KAnji, KanJIru
		     (and
		      (not (= skk-henkan-start-point skk-kana-start-point))
		      (or sokuon	; for TaSSi or TasSi
			  (skk-kana-cleanup)))) ; for NEko
		 (not skk-okurigana)
		 (or (= skk-henkan-start-point (point))
		     (let ((p (char-before)))
		       (not
			(or
			 ;; previous char is a special midashi char
			 (memq p skk-special-midashi-char-list)
			 ;; previous char is an ascii numeric char
			 (and (<= ?0 p) (<= p ?9))
			 ;; previous char is a JIS X 0208 numeric char
			  (and (skk-jisx0208-p p)
			       (= (skk-char-octet p 0) 35) ;?#
			       (<= 48 (skk-char-octet p 1)) ; ?0
			       (<= (skk-char-octet p 1) 57))  ; ?9
			 )))))
	    (if skk-process-okuri-early
		(progn
		  (skk-set-marker skk-henkan-end-point (point))
		  (setq skk-okuri-char (char-to-string last-char))
		  (if sokuon
		      (progn
			(setq skk-henkan-key
			      (concat (buffer-substring-no-properties
				       skk-henkan-start-point
				       skk-kana-start-point)
				      (if skk-katakana "" "")
				      skk-henkan-okurigana))
			(skk-erase-prefix)
			(insert-and-inherit (if skk-katakana " " " "))
			(setq skk-prefix ""
			      skk-henkan-count 0)
			(skk-henkan)
			(delete-backward-char 2))
		    (setq skk-henkan-key (concat
					  (buffer-substring-no-properties
					   skk-henkan-start-point
					   (point))
					  skk-okuri-char))
		    (insert-and-inherit " ")
		    (setq skk-prefix ""
			  skk-henkan-count 0)
		    (skk-henkan)
		    (delete-backward-char 1))
		  ;; we set skk-kana-start-point here, since the marker may no
		  ;; longer point at the correct position after skk-henkan.
		  (skk-set-marker skk-kana-start-point (point)))
	      (if (= skk-henkan-start-point (point))
		  nil
		(if sokuon
		    (progn
		      (skk-erase-prefix 'clean)
		      (insert-and-inherit (if skk-katakana "" ""))))
		(skk-set-marker skk-okurigana-start-point (point))
		(insert-and-inherit "*")
		(skk-set-marker skk-kana-start-point (point))
		(setq skk-okuri-char (char-to-string last-char)
		      skk-okurigana t))))))
    (if normal
	(progn
	  (setq last-command-char last-char)
	  (skk-kana-input arg)))))

(defun skk-start-henkan (arg)
  "⡼ɤǤϴѴ򳫻Ϥ롣⡼ɤǤϼθɽ롣
⡼ɤǡʥ⡼ɤΤޤ޴Ѵ򳫻ϤȡФʿ̾
Ѵ塢Ѵ򳫻Ϥ롣
ФѴˤΤޤ޴ѴԤʤСC-u SPC \(arg  4
ˤʤ\) ȥפ롣"
  (interactive "*p")
  (skk-with-point-move
   (cancel-undo-boundary)
   (if skk-henkan-active
       (progn
	 (setq skk-henkan-count (1+ skk-henkan-count))
	 (skk-henkan))
     (save-match-data
       (let (pos)
	 (skk-kana-cleanup 'force)
	 (and (skk-get-prefix skk-current-rule-tree)
	      ;; Never.  `skk-erase-prefix' called by `skk-kana-cleanup'
	      ;; initializes `skk-prefix'.
	      (skk-error "եåƤʤ skk-prefix ޤ"
			 "Have unfixed skk-prefix"))
	 (setq pos (point))
	 (and (< pos skk-henkan-start-point)
	      (skk-error
	       "뤬Ѵˤޤ"
	       "Henkan end point must be after henkan start point"))
	 (and skk-katakana (= arg 1)
	      (skk-hiragana-region skk-henkan-start-point pos))
	 (setq skk-henkan-key (buffer-substring-no-properties
			       skk-henkan-start-point pos))
	 (and skk-okurigana (string-match "\\* *$" skk-henkan-key)
	      (skk-error
	       "겾̾ǴϿ褦ȤƤޤ"
	       "No okurigana!"))
	 (if skk-allow-spaces-newlines-and-tabs
	     ;; skk-henkan-key  "[ \n\t]+" ˼
	     (while (string-match "[ \n\t]+" skk-henkan-key)
	       (setq skk-henkan-key
		     (concat (substring skk-henkan-key 0 (match-beginning 0))
			     (substring skk-henkan-key (match-end 0)))))
	   (skk-save-point
	    (beginning-of-line)
	    (and (> (point) skk-henkan-start-point)
		 (skk-error
		  "Ѵ˲ԤޤޤƤޤ"
		  "Henkan key may not contain a new line character")))
	   ;; ǽΥڡ skk-henkan-key ڤ
	   (setq skk-henkan-key (substring skk-henkan-key 0
					   (string-match " "
							 skk-henkan-key))))
	 (skk-set-marker skk-henkan-end-point pos)
	 (setq skk-henkan-count 0)
	 (skk-henkan)
	 (if (and skk-abbrev-mode skk-henkan-active)
	     (progn
	       (skk-j-mode-on)
	       (setq skk-abbrev-mode t))))))))

(defun skk-auto-start-henkan (str)
  ;; skk-auto-start-henkan-keyword-list ǤʸȤ˼ưŪ
  ;; (ڡǸʤȤ) Ѵ򳫻Ϥ롣ߥեȼҤ MSDOS  
  ;; FEPWX2+ 
  (and (member str skk-auto-start-henkan-keyword-list)
       (skk-save-point
        (backward-char 1)
        (and (> (point) skk-henkan-start-point)
	     (let ((skk-prefix ""))
	       (skk-start-henkan (prefix-numeric-value current-prefix-arg)))))))

(defun skk-backward-and-set-henkan-point (arg)
  "ݥȤľˤʸƬѴϥݥȤ򼨤 \"\" դ롣
ľˤʸ \(ڡʸʸĹɽ魯֡ ̵
˥åפ\)  skk-what-char-type ˤȽ̤ƱʸҤȤ
ȤƸإåפ롣
âҤ餫ʤξϡ֤פľǡʤξϡ֥פľǻߤޤ롣
C-u ARG  ARG ͿȡʸʬäƱưԤʤ"
  (interactive "*P")
  (if (not skk-mode)
      (skk-emulate-original-map arg)
    (catch 'exit1
      (skk-save-point
       ;; Ȥꤢǽ SPC, TAB,  SPC פ롣
       (skip-chars-backward " \t")
       ;; ꡣ
       (if arg
	   (if (not skk-allow-spaces-newlines-and-tabs)
	       (backward-char (prefix-numeric-value arg))
	     (setq arg (prefix-numeric-value arg))
	     (while (> arg 0)
	       (skip-chars-backward " \t")
	       (if (bolp)
		   ;; Ƭäιޤ뤬arg ϸ餵ʤ
		   (backward-char 1)
		 (backward-char 1)
		 (setq arg (1- arg)))))
	 ;; ʤ
	 (let ((limit
		(if (not skk-allow-spaces-newlines-and-tabs)
		    (skk-save-point (beginning-of-line) (point))
		  (point-min)))
	       ;; 
	       (unknown-chars-regexp
		(if skk-allow-spaces-newlines-and-tabs
		    "[ \n\t]"
		  "[]"))
	       type p)
	   (save-match-data
	     (skk-save-point
	      (backward-char 1)
	      (while (and (> (point) limit)
			  ;; unknown-chars-regexp Ǥʸ̤Ƚ̤Ǥʤ
			  ;; ǡʸ³¤ݥȤХåեƬ
			  ;; ᤹
			  (looking-at unknown-chars-regexp))
		(backward-char 1))
	      (setq type (skk-what-char-type))
	      (if (eq type 'unknown)
		  (throw 'exit1 nil)
		(skk-backward-and-set-henkan-point-1 type)
		(setq p (point))
		(if skk-allow-spaces-newlines-and-tabs
		    (while (and (> (point) limit) (bolp))
		      ;; 1 Ծιء
		      (backward-char 1)
		      ;; ݥȤȽ̤Ǥʤʸ̤ξˤ֤
		      ;; backward إݥȤ᤹
		      ;;(while (and (> (point) limit)
		      ;;            (looking-at unknown-chars-regexp))
		      ;;  (backward-char 1))
		      (if;;(or
			  (> 0 (skk-backward-and-set-henkan-point-1 type))
			  ;;(eq (skk-what-char-type) type))
			  (setq p (point))))))))
	   (goto-char p)
	   (skip-chars-forward unknown-chars-regexp)))
       (skk-set-henkan-point-subr)))))

(defun skk-backward-and-set-henkan-point-1 (type)
  ;; skk-backward-and-set-henkan-point Υ֥롼CHAR μ˱ʸ
  ;; 򥹥åפƥХåեƬ롣
  (cond ((eq type 'hiragana)
         ;; "" ǻߤޤä
         (skip-chars-backward "-"))
        ((eq type 'katakana)
         ;; "" ǻߤޤä
         (skip-chars-backward "-"))
        ((eq type 'jisx0208-latin)
         (skip-chars-backward "-"))
        ((eq type 'ascii)
         (skip-chars-backward " -~"))))

(defun skk-what-char-type ()
  ;; ߤΥݥȤˤʸɤʼफȽ̤롣
  (save-match-data
    (cond ((looking-at "[-]") 'hiragana)
          ((looking-at "[-]") 'katakana)
          ;; "" Ƥ (""  ""  "" δ֤äƤ)
          ((looking-at "[--]") 'jisx0208-latin)
          ((looking-at "[ -~]") 'ascii)
          (t 'unknown))))

(defun skk-set-henkan-point-subr (&optional arg)
  "ʤϤǡݥȤѴϤΥޡ \(\) դ롣
Ϥδؿ skk-set-henkan-point ؿǤ롣"
  (interactive "*P")
  (skk-with-point-move
   (cancel-undo-boundary)
   (if skk-henkan-on (skk-kakutei)
     (skk-kana-cleanup));; XXX
   (if (not (skk-get-prefix skk-current-rule-tree))
       (insert-and-inherit "")
     (skk-erase-prefix)
     (insert-and-inherit "")
     (skk-set-marker skk-kana-start-point (point))
     (skk-insert-prefix))
   (setq skk-henkan-on t)
   (skk-set-marker skk-henkan-start-point (point))))

(defun skk-change-marker ()
  ;; """"Ѥ롣skk-henkan-active ե饰 t ˤ롣
  (skk-save-point
   (goto-char (- skk-henkan-start-point skk-kanji-len))
   (if (looking-at "")
       (progn
	 (cancel-undo-boundary)
	 (let ((buffer-undo-list t))
	     (insert-and-inherit "")
	     (delete-char 1))
	 (setq skk-henkan-active t))
     (skk-kakutei)
     (skk-error "ޤ" "It seems that you have deleted "))))

(defun skk-change-marker-to-white ()
  ;; """"Ѥ롣skk-henkan-active ե饰 nil ˤ롣
  (skk-save-point
   (goto-char (- skk-henkan-start-point skk-kanji-len))
   (cancel-undo-boundary)
   (if (looking-at "")
       (let ((buffer-undo-list t))
	 (insert-and-inherit "")
	 (delete-char 1))
     (goto-char skk-henkan-start-point)
     (insert-and-inherit "")
     (skk-set-marker skk-henkan-start-point (point))
     (skk-message "ޤ" "It seems that you have deleted "))
   (setq skk-henkan-active nil)))

(defun skk-delete-henkan-markers (&optional nomesg)
  ;; Ѵ˥ȥХåեɽ `', `' ޡä
  (if (not (marker-position skk-henkan-start-point))
      nil
    (save-match-data
      (skk-save-point
       (goto-char (- skk-henkan-start-point skk-kanji-len))
       (if skk-henkan-active
	   (progn
	     (and skk-use-face (skk-henkan-face-off))
	     (if (looking-at "")
		 (delete-char 1)
	       (or nomesg
		   (skk-message "ޤ"
				"It seems that you have deleted "))))
	 (if (looking-at "")
	     (delete-char 1)
	   (or nomesg
	       (skk-message "ޤ"
			    "It seems that you have deleted "))))))))

(defun skk-delete-okuri-mark ()
  ;; 겾̾˥ȥХåեɽ `*' ޡä겾̾Ϣ
  ;; ե饰 nil ˥åȤ롣
  (if (or (not skk-okurigana)
	  (not skk-okurigana-start-point)
	  (not (markerp skk-okurigana-start-point))
	  (not (marker-position skk-okurigana-start-point)))
      nil
    (skk-save-point
      (and (eq (char-after skk-okurigana-start-point) ?*) ; ?*
	   (delete-region skk-okurigana-start-point
			  (1+ skk-okurigana-start-point)))
      (setq skk-okurigana nil
            skk-okuri-char nil
            skk-henkan-okurigana nil))))

;;;; jisyo related functions
(defun skk-purge-from-jisyo (&optional arg)
  "⡼ɤǸߤθ򼭽Хåեõ롣"
  (interactive "*P")
  (skk-with-point-move
   (if (and skk-henkan-active (not (string= skk-henkan-key "")))
       (if (not
	    (yes-or-no-p (format
			  (if skk-japanese-message-and-error
			      "%s /%s/%s򼭽񤫤ޤɤǤ"
			    "Really purge \"%s /%s/%s\"?")
			  skk-henkan-key (skk-get-current-candidate-simply)
			  (if (and skk-henkan-okurigana
				   (or skk-henkan-okuri-strictly
				       skk-henkan-strict-okuri-precedence))
			      (concat
			       (if skk-japanese-message-and-error
				   " (겾̾: "
				 "(okurigana: ")
			       skk-henkan-okurigana
			       ") ")
			    " "))))
	   nil
	 ;; skk-henkan-start-point  point ޤǺƤޤäƤ⡢Ѵľ
	 ;;  (ưȤʤ) skk-purge-from-jisyo Ƥ٤ʤ
	 ;; 뤬㤦ذưƤϡ٤ǤʤΤ
	 ;; ǺƤޤǽ롣ǡ겾̾ФĹ
	 ;; ᤿ end ᡢѴ˴ϢĽΤڤ褦
	 ;; 롣
	 (let ((end (if skk-henkan-okurigana (+ (length skk-henkan-okurigana)
						skk-henkan-end-point)
		      skk-henkan-end-point))
	       (word (skk-get-current-candidate-simply (skk-numeric-p))))
	   (skk-update-jisyo word 'purge)
	   ;; Emacs 19.28  Overlay äƤʤȡ insert 
	   ;; skk-henkan-key ˲Τ Overlay äƤޤ
	   (and skk-use-face (skk-henkan-face-off))
	   (delete-region skk-henkan-start-point end)
	   (skk-change-marker-to-white)
	   (skk-kakutei))))))

(defun skk-save-jisyo (&optional quiet)
  "SKK μХåե򥻡֤롣
  ץʥ QUIET  non-nil ǤС񥻡ֻΥåФ
  "
  (interactive "P")
  (mutual-eval skk-jisyo-mutex '(funcall skk-save-jisyo-function quiet)))

(defun skk-save-jisyo-original (&optional quiet)
  ;;"SKK μХåե򥻡֤롣
  ;;ץʥ QUIET  non-nil ǤС񥻡ֻΥåФ
  ;;"
  (let* ((skkinput-jisyo (expand-file-name skkinput-jisyo))
         (jisyo-buffer (skk-get-jisyo-buffer skkinput-jisyo 'nomsg)))
    (if (or (not jisyo-buffer) (not (buffer-modified-p jisyo-buffer)))
        (if (not quiet)
            (progn
	      (skk-message "SKK ¸ɬפϤޤ"
                           "No need to save SKK jisyo")
              (sit-for 1)))
      (with-current-buffer jisyo-buffer
        (let ((inhibit-quit t)
              (tempo-file (skk-make-temp-jisyo)))
          (if (not quiet)
              (skk-message "SKK ¸Ƥޤ..."
                           "Saving SKK jisyo..."))
          (skk-save-jisyo-1 tempo-file)
          (skk-check-size-and-do-save-jisyo tempo-file)
          ;; Υ֤ƽ modified եå nil ˤ롣
          (set-buffer-modified-p nil)
	  (setq skk-update-jisyo-count 0)
          (if (not quiet)
              (progn
                (skk-message "SKK ¸Ƥޤ...λ"
                             "Saving SKK jisyo...done")
                (sit-for 1)))
          (and (eq this-command 'save-buffers-kill-emacs)
	       (skk-record-jisyo-data)))))))

(defun skk-save-jisyo-1 (file)
  (save-match-data
    (let (buffer-read-only)
      (goto-char (point-min))
      (if (re-search-forward "^;; okuri-ari entries.$" nil 'noerror)
          nil
        (skk-error
         "ꤢꥨȥΥإåޤ SKK Υ֤ߤޤ"
         "Header line for okuri-ari entries is missing!  Stop saving SKK jisyo"))
      ;; áȥե $ ǽʤ > hilit19.el
      (if (re-search-forward "^;; okuri-nasi entries.$" nil 'noerror)
          nil
        (skk-error
         "ʤȥΥإåޤ  SKK Υ֤ߤޤ"
         "Header line for okuri-nasi entries is missing!  Stop saving SKK jisyo")))
    (write-region-as-coding-system
     (cond ((and skk-jisyo-code
		 (and (symbolp skk-jisyo-code)
		      (or (coding-system-p skk-jisyo-code)
			  (and (fboundp 'find-coding-system)
			       (find-coding-system skk-jisyo-code)))))
	    skk-jisyo-code)
	   ((and skk-jisyo-code (stringp skk-jisyo-code))
	    (cdr (assoc skk-jisyo-code skk-coding-system-alist)))
	   (t (cdr (assoc "euc" skk-coding-system-alist))))
     1 (point-max) file nil 'nomsg)))

(defun skk-check-size-and-do-save-jisyo (new-file)
  (let ((new-size (nth 7 (file-attributes new-file)))
        old-size)
    (if (= new-size 0)
        (progn
          (delete-file new-file)
          (skk-error "SKK 񤬶ˤʤäƤޤ Υ֤ߤޤ"
                     "Null SKK jisyo!  Stop saving jisyo")))
    (if (or (not skk-compare-jisyo-size-when-saving)
            ;; 켭ȤΥӤԤʤʤ
            (progn
              ;; (1)skk-jisyo ʤ
              ;; (2)new-file  skk-jisyo ƱΥ
              ;;    (skk-(aux-)large-jisyo 鿷ñɤ߹ޤʤäꡢ
              ;;    ñϿԤʤʤäϥƱ)
              ;; (3)new-file 礭
              ;;  (嵭 3 ̤ǤФ)
              (setq old-size (nth 7 (file-attributes skkinput-jisyo)))
              (or (not old-size)
                  (>= new-size old-size))))
        (skk-make-new-jisyo new-file)
      ;; yes-or-no-p ˲newline ȡthis-command ѤäƤޤ
      (let (this-command this-command-char last-command last-command-char)
        (if (skk-yes-or-no-p
             (format
              "skkinput-jisyo  %dbytes ʤޤ֤ɤǤ"
              (- old-size new-size))
             (format
              "New %s will be %dbytes smaller.  Save anyway?"
              skkinput-jisyo (- old-size new-size)))
            ;; Ȥˤ֡
            (skk-make-new-jisyo new-file)
          ;; ֤Ȥߤᡣ
          (delete-file new-file)
;          (with-output-to-temp-buffer "*SKK warning*"
;            (if skk-japanese-message-and-error
;                (progn
;                  (princ "֤褦Ȥ뼭ΥΤΤ⾮ʤäƤޤΤǡ")
;                  (terpri)
;                  (princ "֤ߤޤΥʤäˤ㤨")
;                  (terpri)
;                  (princ "С")
;                  (terpri)
;                  (terpri)
;                  (princ "    M-x skk-purge-from-jisyo ¹Ԥ")
;                  (terpri)
;                  (terpri)
;                  (princ "    .skkinput-jisyo δɤȡ\" *.skkinput-jisyo*\" Хåեδ")
;                  (terpri)
;                  (princ "      ۤʤäƤ롣")
;                  (terpri)
;                  (terpri)
;                  (princ "    \" *.skkinput-jisyo*\" ХåեʬԽ")
;                  (terpri)
;                  (terpri)
;                  (princ "ʤɤͤޤ (ǽ 2 ĤǤС۾ǤϤޤ")
;                  (terpri)
;                  (princ "ǸξϡʤɤΤ褦Խ򤷤ˤޤ)ǧ")
;                  (terpri)
;                  (princ "塢Ť˼Υ֤ԤʤȤ򤪴ᤷޤ")
;                  (terpri)
;                  (terpri)
;                  (princ "μɤ߹ˤϡ")
;                  (terpri)
;                  (terpri)
;                  (princ "    M-x skk-reread-private-jisyo")
;                  (terpri)
;                  (terpri)
;                  (princ "¹ԤƲ"))
;              (princ "As size of your private JISYO to be saved is smaller than the")
;              (terpri)
;              (princ "original, we have stopped saving JISYO.  For example, the following")
;              (terpri)
;              (princ "condition makes a smaller private JISYO;")
;              (terpri)
;              (terpri)
;              (princ "    (a)You executed M-x skk-purge-from-jisyo,")
;              (terpri)
;              (terpri)
;              (princ "    (b)Kanji code of .skkinput-jisyo is different from the one of")
;              (terpri)
;              (princ "       \" *.skkinput-jisyo*\" buffer, or")
;              (terpri)
;              (terpri)
;              (princ "    (c)You edited \" *.skkinput-jisyo*\" buffer manually.")
;              (terpri)
;              (terpri)
;              (princ "The first two conditions are not strange, but the last one depends on")
;              (terpri)
;              (princ "how you edited JISYO.  We strongly recommend to save JISYO")
;              (terpri)
;              (princ "carefully after checking what causes this.")
;              (terpri)
;              (princ "If you want to reread your original private JISYO, type")
;              (terpri)
;              (terpri)
;              (princ "    M-x skk-reread-private-jisyo")
;              (terpri)))
          (skk-error "SKK Υ֤ߤޤ"
                     "Stop saving SKK jisyo!"))))))

(defun skk-make-temp-jisyo ()
  ;; SKK Ŀͼ¸ΤκѤΥեꡢեΥ⡼ɤ
  ;; skk-jisyo ΤΤƱꤹ롣äѥե֤̾
  (let ((tempo-name (skk-make-temp-file "skkdic")))
    (skk-create-file tempo-name)
    ;; temporary file  remote file ꤹ뤳Ȥʤͭʤ
    ;;(if (or
    ;;     ;; XEmacs has efs.el
    ;;     (eq skk-emacs-type 'xemacs)
    ;;     ;; ange-ftp.el does not have a wrapper to set-file-modes.
    ;;     (not (and (featurep 'ange-ftp) (boundp 'ange-ftp-name-format)
    ;;               (string-match (car ange-ftp-name-format) tempo-name))))
    (set-file-modes tempo-name  (file-modes skkinput-jisyo))
    ;;)
    tempo-name))

(defun skk-make-temp-file (prefix)
  (let ((dir
	 (cond ((skk-file-exists-and-writable-p temporary-file-directory)
		(expand-file-name temporary-file-directory))
	       ((and (memq system-type '(ms-dos windows-nt))
		     (skk-file-exists-and-writable-p "a:/temp"))
		;; NEC PC-9800 series.
		"a:/temp")
	       (t (or (file-exists-p "~/tmp") (make-directory-internal "~/tmp"))
		  (or (file-writable-p "~/tmp") (set-file-modes "~/tmp" 1023))
		  "~/tmp"))))
    (make-temp-name
     (concat dir
	     (if (memq (skk-str-ref dir (1- (length dir))) '(?/ ?\\))
		 "" "/")
	     prefix))))

(defun skk-make-new-jisyo (tempo-file)
  ;; TEMPO-FILE 򿷵 skk-jisyo ˤ롣skk-backup-jisyo  non-nil ä
  ;; Хåå׼롣
  (if skk-backup-jisyo
      (progn
        (if (file-exists-p skk-backup-jisyo)
            (delete-file skk-backup-jisyo))
        (rename-file skkinput-jisyo skk-backup-jisyo))
    (delete-file skkinput-jisyo))
  (rename-file tempo-file skkinput-jisyo 'ok-if-already-exists))

(defun skk-reread-private-jisyo (&optional force)
  "Хåեɤ߹Ŀͼ˴ե뤫Хåեغɤ߹ߤ롣
ץʥ FORCE  non-nil ǤС˴γǧ򤷤ʤ"
  (interactive "P")
  (let ((buf (skk-get-jisyo-buffer skkinput-jisyo 'nomsg)))
    (if (and buf
             (or force
                 (skk-yes-or-no-p "ԽθĿͼ˴ޤ"
                                  "Discard your editing private JISYO?")))
        (progn
          (with-current-buffer buf
            (set-buffer-modified-p nil)
            (kill-buffer buf))
          (or
           (skk-get-jisyo-buffer skkinput-jisyo 'nomsg)
           (skk-error "Ŀͼɤ߹ߤ뤳ȤǤޤ"
                      "Cannot reread private JISYO!"))))))

(defun skk-record-jisyo-data ()
  ;; ǡꡢEmacs νλκݤǤСΥǡ
  ;; skk-record-file ¸ʳǤС򥨥롣
  (if (or (not skk-keep-record) (> 1 skk-kakutei-count))
      nil
    (with-temp-file skk-record-file
      (insert-file-contents skk-record-file)
      (goto-char (point-min))
      (insert
       (format
        "%s  Ͽ: %3d  : %4d  Ψ: %3d%%  :%6d\n"
        (current-time-string)
        skk-touroku-count skk-kakutei-count
        (/ (* 100 (- skk-kakutei-count skk-touroku-count))
           skk-kakutei-count)
        (cond ((featurep 'skk-rdbms)
	       ;; RDBMS ȤФäȶ̣פ뤫⤷ʤ
	       ;; ȤꤢƤ
	       (skk-rdbms-count-jisyo-candidates skk-rdbms-private-jisyo-table))
	      (skk-count-private-jisyo-candidates-exactly
	       (skk-count-jisyo-candidates (expand-file-name skkinput-jisyo)))
	       ;; 1  1 Ȥߤʤ
	      (t (with-current-buffer (skk-get-jisyo-buffer skkinput-jisyo 'nomsg)
		   (- (count-lines (point-min) (point-max)) 2)))))))
    (setq skk-touroku-count 0 skk-kakutei-count 0)))

(defun skk-count-jisyo-candidates (file-or-table)
  "SKK θ롣"
  (interactive
   (list (cond ((eq skk-count-jisyo-candidates-function
		    'skk-count-jisyo-candidates-original)
		(read-file-name
		 (format "Jisyo file: (default: %s) " skkinput-jisyo)
		 default-directory skkinput-jisyo 'confirm))
	       ((eq skk-count-jisyo-candidates-function
		    'skk-rdbms-count-jisyo-candidates)
		;; ǡ١եľܥե̾ǻǤ
		;; permission ʤ礬¿...
		;;(read-file-name
		;; (format "Jisyo table: (default: %s) "
		;;	 skk-rdbms-private-jisyo-table))
		skk-rdbms-private-jisyo-table))))
  ;; mule@emacs19.31 ȲΤ褦ˤ (`' Τ褦) Τ
  ;; default-directory ˲Ԥդ
  ;; ̾ϵդʤrsz-mini.el Ȥä resize-minibuffer-mode 
  ;; non-nil ˤƤפ 2 ܤи롣
  ;; (interactive "fե: ")
  (let ((count (funcall skk-count-jisyo-candidates-function file-or-table)))
    (if (interactive-p)
	(message (if (= count 1) "%d candidate" "%d candidates") count)
      count)))

(defun skk-count-jisyo-candidates-original (file)
  ;;"SKK θ롣
  ;;`['  `]' ˰Ϥޤ줿겾̾Υ֥åϿʤ"
  (with-current-buffer (find-file-noselect file)
    (save-match-data
      (let ((count 0)
            (min (point-min))
            (max (and (interactive-p) (point-max)))
            (interactive-p (interactive-p)))
        (goto-char min)
        (if (or
             ;;  skk-save-point Ȥ鷺ݥȤư롣
             (not (re-search-forward "^;; okuri-ari entries.$" nil t nil))
             (not
              (skk-save-point
                (re-search-forward "^;; okuri-nasi entries.$" nil t nil))))
            (skk-error "Υե SKK ǤϤޤ"
                       "This file is not a SKK dictionary"))
	(beginning-of-line)
	(while (looking-at ";")
	  (forward-line 1)
	  (beginning-of-line))
	(search-forward " " nil t)
        (while (search-forward "/" nil t)
          (cond ((or (eolp) (looking-at "\\["))
                 (forward-line 1)
                 (beginning-of-line)
		 (while (looking-at ";")
		   (forward-line 1)
		   (beginning-of-line))
		 (search-forward " " nil t))
                (t
                 (setq count (1+ count))))
          (if interactive-p
              (message "Counting jisyo candidates...%3d%% done"
                       (/ (* 100 (- (point) min)) max))))
	count))))

(defun skk-create-file (file &optional japanese english)
  ;; FILE ʤСFILE Ȥ̾ζե롣
  ;; ץʥ JAPANESE/ENGLISH ꤹȡե夽Υå
  ;; ߥ˥Хåեɽ롣
  (let ((file (expand-file-name file)))
    (or (file-exists-p file)
	(progn
	  (write-region 1 1 file nil 0)
	  (if (or japanese english)
	      (progn
 		(message (if skk-japanese-message-and-error
 			     japanese english))
		(sit-for 3)))))))

(defun skk-get-jisyo-buffer (file &optional nomsg)
  ;; FILE 򳫤 SKK ХåեꡢХåե֤
  ;; ץʥ NOMSG ꤹȥեɤ߹ߤκݤΥå
  ;; ɽʤ
  (if file
      (let ((inhibit-quit t)
            (jisyo-buf (concat " *" (file-name-nondirectory file)
                               "*")))
        ;; ХåեȤƥץ󤵤Ƥʤ顢⤷ʤ
        (or (get-buffer jisyo-buf)
            (with-current-buffer (setq jisyo-buf (get-buffer-create jisyo-buf))
	      (setq file (expand-file-name file))
;              (buffer-disable-undo jisyo-buf)
;              (auto-save-mode -1)
              ;; 󥰥ХåեΥ⡼ɥ饤ϥåץǡȤʤ
              ;;(make-local-variable 'line-number-mode)
              ;;(make-local-variable 'column-number-mode)
              ;;(setq column-number-mode nil
              ;;      line-number-mode nil)
              (setq buffer-read-only nil
                    case-fold-search nil
                    ;; buffer-file-name  nil ˤƤ M-x compile ʤ
		    ;;  save-some-buffers 򥳡뤷Ƥ륳ޥɤ
		    ;; ȤäȤǤ⥻֤뤫ɤҤͤƤʤʤ롣
                    ;; buffer-file-name file
                    ;; cache-long-line-scans nil
                    ;; dabbrev ΥȤʤХåեˤʤʤ褦¸ߤ
                    ;; ⡼̾ˤƤ³ΤѤϤʤϤ
                    major-mode 'skk-jisyo-mode
                    mode-name "SKK dic")
              (or nomsg
                  (skk-message "SKK  %s Хåեɤ߹Ǥޤ..."
                               "Inserting contents of %s ..."
                               (file-name-nondirectory file)))
	      (insert-file-contents file)
;	      (let (enable-character-translation enable-character-unification)
;		(insert-file-contents-as-coding-system
;		 (cond ((and skk-jisyo-code
;			     (and (symbolp skk-jisyo-code)
;				  (or (coding-system-p skk-jisyo-code)
;				      (and (fboundp 'find-coding-system)
;					   (find-coding-system skk-jisyo-code)))))
;			skk-jisyo-code)
;		       ((and skk-jisyo-code (stringp skk-jisyo-code))
;			(cdr (assoc skk-jisyo-code skk-coding-system-alist)))
;		       (t (cdr (assoc "euc" skk-coding-system-alist))))
;		 file))
              (or nomsg
                  (skk-message
                   "SKK  %s Хåեɤ߹Ǥޤ...λ"
                   "Inserting contents of %s ...done"
                   (file-name-nondirectory file)))
              (skk-setup-jisyo-buffer)
              (set-buffer-modified-p nil)
              jisyo-buf)))))

(defun skk-setup-jisyo-buffer ()
  ;; skk-jisyo μХåեǡ
  ;; (1)ХåեǤСإåꡢ
  ;; (2)񥨥ȥ꤬¸μХåեʤСإåɤ
  ;;    å롣
  ;;
  ;; skk-okuri-ari-min  skk-okuri-nasi-min ΰ֤ѹ
  ;;                         skk-okuri-ari-min
  ;;   ;; okuri-ari entries.
  ;;     skk-okuri-ari-min
  ;;
  ;;    skk-okuri-ari-max   skk-okuri-nasi-min
  ;;   ;; okuri-nasi entries.
  ;;     skk-okuri-nasi-min
  ;;
  ;;
  ;; ѹΰ֤ǤСΤ褦ʶξ硢
  ;;
  ;;   ;; okuri-ari entries.
  ;;   ;; okuri-nasi entries.
  ;;
  ;; skk-okuri-ari-min  skk-okuri-ari-max ΥޡŤʤäƤޤ
  ;; skk-okuri-ari-min ΰ֤ȥ꤬ skk-okuri-ari-max Υޡ
  ;; ˲ʤ
  ;;
  ;; δؿΥꥸʥ̾Τϡj-check-jisyo äskk-check-jisyo 
  ;; ̾ˤ skk-tools.el δؿ̾Ƚʣ롣
  ;; case-fold-search ϡХåեǤϾ nil
  (save-match-data
    (if (= (buffer-size) 0)
	;; Хåեä顢إåΤ
	(insert ";; okuri-ari entries.\n" ";; okuri-nasi entries.\n"))
    (goto-char (point-min))
    (if (re-search-forward "^;; okuri-ari entries.$" nil 'noerror)
	;; ݥȤʤΤǡ(point) ǽʬ
	(setq skk-okuri-ari-min (point))
      (skk-error "ꤢꥨȥΥإåޤ"
		 "Header line for okuri-ari entries is missing!"))
    (if (re-search-forward "^;; okuri-nasi entries.$" nil 'noerror)
	(progn
	  (beginning-of-line)
	  ;; ͭʤݥȤǤɤΤХåեԽ
	  ;; ʤäȤΤȤθƥޡˤƤ
	  (setq skk-okuri-ari-max (point-marker))
	  (forward-line 1)
	  (backward-char 1)
	  (setq skk-okuri-nasi-min (point-marker)))
      (skk-error "ʤȥΥإåޤ"
		 "Header line for okuri-nasi entries is missing!"))))

(defun skk-search ()
  ;; skk-current-search-prog-list ǤˤʤäƤץɾơ
  ;; skk-henkan-key򥭡ˤƸԤ
  (let (l)
    (while (and (null l) skk-current-search-prog-list)
      (setq l (eval (car skk-current-search-prog-list))
	    skk-current-search-prog-list (cdr skk-current-search-prog-list)))
    l))

(defun skk-search-jisyo-file (file limit &optional nomsg)
  ;; SKK եޥåȤ FILE  skk-henkan-key 򥭡ˤƸԤ
  ;; ꡼ LIMIT ʲˤʤޤǥХʥꥵԤθ˥
  ;; Ԥ
  ;; LIMIT  0 ǤС˥ΤߤԤ
  ;; 񤬥ȤƤʤΤǤСLIMIT  0 ɬפ롣
  ;; ץʥ NOMSG  non-nil Ǥ skk-get-jisyo-buffer Υ
  ;; Ϥʤ褦ˤ롣
  (let ((jisyo-buffer (skk-get-jisyo-buffer file nomsg)))
    (if jisyo-buffer
        ;; skk-henkan-key  skk-henkan-okurigana ϥȥХåեΥ
        ;; ͡
        (let ((okurigana (or skk-henkan-okurigana skk-okuri-char))
              (midasi
               (if skk-use-numeric-conversion
		   ;; skk-henkan-key  nil ΤȤ롣?
                   (skk-num-compute-henkan-key skk-henkan-key)
                 skk-henkan-key))
	      (henkan-buffer (current-buffer))
              entry-list entry)
          (with-current-buffer jisyo-buffer
            (setq skk-henkan-key midasi
                  entry-list (skk-search-jisyo-file-1 okurigana limit))
            (if entry-list
                (progn
                  (setq entry
                        (cond ((and okurigana skk-henkan-okuri-strictly)
                               ;; 겾̾ƱΥȥΤߤ֤
                               (nth 2 entry-list))
                              ((and okurigana skk-henkan-strict-okuri-precedence)
                               ;; 겾̾ƱΥȥΤˡ
                               ;; ¾ΥȥĤƤ
                               (skk-nunion (nth 2 entry-list) (car entry-list)))
                              (t (car entry-list))))
		  (and skk-search-end-function
		       (setq entry (funcall skk-search-end-function
					    henkan-buffer midasi okurigana entry)))
		  entry)))))))

(defun skk-search-jisyo-file-1 (okurigana limit &optional delete)
  ;; skk-search-jisyo-file Υ֥롼skk-compute-henkan-lists Ѥ
  ;; ФˤĤƤΥȥξ֤
  ;; DELETE  non-nil ǤСMIDASI ˥ޥå륨ȥ롣
  (let ((key (concat "\n" skk-henkan-key " /"))
        min max size p)
    (save-match-data
      ;; skk-okuri-ari-min  skk-okuri-ari-max ϼХåեΥ͡
      (if okurigana
          (setq min skk-okuri-ari-min
                max skk-okuri-ari-max)
        (setq min skk-okuri-nasi-min
              max (point-max)))
      (if (> limit 0)
          (while (progn (setq size (- max min)) (> size limit))
            (goto-char (+ min (/ size 2)))
            (beginning-of-line)
            (setq p (point))
            ;; ꤢʤսӤԤʤ
            (if
                (if okurigana
                    (string< (buffer-substring-no-properties
			      p (1- (search-forward  " ")))
                             skk-henkan-key)
                  (string< skk-henkan-key
                           (buffer-substring-no-properties
			    p (1- (search-forward " ")))))
                (setq max p)
              (setq min p))))
      (goto-char min)
      ;; key ˤäǤ⸡ǽʤ褦˰ʸ롣key 
      ;; Ƭʬ "\n" ޤǤ뤳Ȥա
      (or (bobp) (backward-char 1))
      ;; case-fold-search ϡХåեǤϾ nil
      (if (search-forward key max 'noerror)
	  (prog1
	      (skk-compute-henkan-lists okurigana)
	    (if delete
		(progn
		  (beginning-of-line)
		  (delete-region (point)
				 (progn (forward-line 1) (point))))))))))


(defun skk-compute-henkan-lists (okurigana)
  ;; 񥨥ȥ 4 ĤΥꥹȤʬ򤹤롣
  ;;
  ;; ʤ (㤨С񥨥ȥ "Ƥ󤵤 /ž/ŷ/ŷ/" ν)
  ;; entry1 := ("ž" "ŷ" "ŷ") == ȥ
  ;; entry2 := nil
  ;; entry3 := nil
  ;; entry4 := nil
  ;;
  ;; ꤢ (㤨Сֵ㤯פѴԤäΡ񥨥ȥ
  ;;           "k /˴/̵///[/̵///]/[/˴/]/" ν)
  ;; entry1 := ("˴" "̵" "" "")  == ʬȥ
  ;; entry2 := ("[")                == ¾겾̾Ȥȥ (
  ;;                                     ) + Ѵ겾̾ʬ
  ;; entry3 := ("̵" "" "")       == Ѵ겾̾Ȥǽ
  ;;                                     ȥ
  ;; entry4 := ("]" "[" "˴" "]")   == ¾겾̾Ȥȥ (
  ;;                                     ꡣ)
  ;;
  ;;   * "[" ľ³Ҥ餬ʤ겾̾˻ĴΥȥνޤɽ
  ;;     "]" ϡ겾̾롼פν򼨤
  ;;
  ;; δؿϡѴȡľμΥåץǡȻ 2 ٸƤФ
  ;; (Ѵ˸Ԥä񤬡skk-jisyo Ȥϸ¤ʤΤǡ2 ٷ׻
  ;; ʤ)
  ;;
  ;; Ѵϡskk-henkan-okuri-strictly  non-nil ǤС
  ;; ׻̤ entry3skk-henkan-okuri-strictly  nil Ǥä
  ;;  skk-henkan-strict-okuri-precedence  non-nil 
  ;; (skk-nunion entry3 entry1) Ф
  ;; դĤѿȤ nil ξ entry1 Ф
  (if (not okurigana)
      (list (split-string (buffer-substring-no-properties
			   (point) (progn (end-of-line) (1- (point))))
			  "/") nil nil nil)
    (save-match-data
      (let ((stage 1) (q1 (queue-create)) (q2 (queue-create))
            (q3 (queue-create)) (q4 (queue-create))
            (okuri-key (concat "\[" okurigana)) item headchar)
        (catch 'exit
          (while (not (eolp))
            (setq item (buffer-substring-no-properties
			(point)
			(1- (search-forward "/")))
                  headchar (if (string= item "") (int-char 0) (skk-str-ref item 0)))
            (cond ((and (eq headchar ?\[) (<= stage 2))
                   (if (string= item okuri-key)
                       (progn (queue-enqueue q2 item)
                              (setq stage 3))
                     (setq stage 2)
                     (queue-enqueue q2 item)))
                  ((= stage 1)
                   (queue-enqueue q1 item))
                  ((= stage 2)
                   (queue-enqueue q2 item))
                  ((= stage 3)
                   (if (eq headchar ?\]) ; ?\]
                       (progn (setq stage 4)
                              (queue-enqueue q4 item))
                     (queue-enqueue q3 item)))
                  ((= stage 4)
                   (queue-enqueue q4 item)))))
        ;;        entry1          entry2        entry3          entry4
        (list (queue-all q1) (queue-all q2) (queue-all q3) (queue-all q4))))))

(defun skk-nunion (x y)
  ;; X  Y ½롣ɤӤϡequal ǹԤ롣X  Y
  ;; ˲ŪϢܤ롣
  (cond ((null x) y)
        ((null y) x)
        (t (let ((list2 y))
	     (while list2
	       (let* ((list1 (cons nil x))
		      (oldlist1 list1))
		 (catch 'found
		   (while (cdr list1)
		     (if (equal (car (cdr list1)) (car list2))
			 (throw 'found nil)
		       (setq list1 (cdr list1))))
		   (setcdr list1 (list (car list2)))
		   (setq x (cdr oldlist1)))
	       (setq list2 (cdr list2)))
	      ))
	   x)))

(defun skk-search-kakutei-jisyo-file (file limit &optional nomsg)
  ;; եõꥹȤ֤
  ;; 򸫤Ĥϡѿ skk-kakutei-flag  non-nil 롣
  ;; 䤬Ĥʤäϡnil ֤
  (setq skk-kakutei-flag (skk-search-jisyo-file file limit nomsg)))

(defun skk-update-jisyo (word &optional purge)
  (mutual-eval skk-jisyo-mutex '(funcall skk-update-jisyo-function word purge)))

(defun skk-update-jisyo-original (word &optional purge)
  ;; WORD Ѵ˺ǽθˤʤ褦ˡץ饤١ȼ򹹿롣
  ;; PURGE  non-nil  WORD ͭˤ륨ȥʤ skk-ignore-dic-word
  ;; ؿǥȤȥץ饤١ȼ˺ꡢѴϤ
  ;; 褦ˤ롣
  ;; WORD ͭˤʤСץ饤١ȼμ񥨥ȥ꤫롣
  ;;
  ;; SKK 9.x ꡢץ饤١ȼΥȥˡѹ (9.3 Τ
  ;; 㳰)
  ;;
  ;; ѹ
  ;;         ;; okuri-ari entries.
  ;;     k //[//]/[//]/
  ;;  С   i //[//]/
  ;;     錄s //[//]/[//]/
  ;;     魯r /˺/[/˺/]/
  ;;     狼t /ʬ/Ƚ/[ä/ʬ/Ƚ/]/[ä/ʬ/]/
  ;;        .....
  ;;         i //[//]/
  ;;         ;; okuri-nasi entries.
  ;;  Ѥ   礦 //
  ;;     ˤ夦 //
  ;;      /̾/
  ;;       ...
  ;;         ...
  ;;
  ;; ѹ
  ;;         ;; okuri-ari entries.
  ;;  Ѥ   t //[//]/[//]/
  ;;     i //[//]/
  ;;     s //[//]/[//]/[//]/[//]/
  ;;       s //[//]/[//]/[//]/[//]/
  ;;         ...
  ;;         ...
  ;;         ʤs /Ĺ/ή/[/ή/]/[/Ĺ/]/[/ή/]/
  ;;         ;; okuri-nasi entries.
  ;;  Ѥ   礦 //
  ;;     ˤ夦 //
  ;;      /̾/
  ;;       ...
  ;;         ...
  ;;
  ;; skk-auto-okuri-process  non-nil ΤȤˡ(j-okuri-search )
  ;; skk-okuri-search ϸФĹ˸֤ɬפ롣
  ;; SKK 8.6 ޤǤϡskk-okuri-search  j-okuri-ari-min  j-okuri-ari-max
  ;; ޤǤõĤν˸֤˥ץ饤١ȼ񤬸Ф
  ;; 򥭡Ȥƹ߽˥ȤƤɬפä
  ;; SKK 9.x Ǥϡskk-okuri-search դ򸫽Ф򥭡Ȥƾ
  ;; ˥Ȥ֤ᡢץ饤١ȼΥȤɬפǤʤäơǸ
  ;; ѴΤ (j-okuri-ari-min ) skk-okuri-ari-min ΰ֤
  ;; 롣
  ;;
  (let ((jisyo-buffer (skk-get-jisyo-buffer skkinput-jisyo 'nomsg))
	(midasi
	 (if skk-use-numeric-conversion
	     (skk-num-compute-henkan-key skk-henkan-key)
	   skk-henkan-key))
	(henkan-buffer (current-buffer)))
    (if jisyo-buffer
	(let ((inhibit-quit t) buffer-read-only old-entry okurigana)
	  (if (> skk-okuri-index-min -1)
	      (setq word (skk-remove-common word)
		    midasi skk-henkan-key))
	  (setq okurigana (or skk-henkan-okurigana skk-okuri-char))
	  (with-current-buffer jisyo-buffer
	    ;; ¸ȥ򸡺õ롣٤ȥ꤬ entry1  1
	    ;; Ĥʤword ƱʸǤäƤ⡢ääƤΥ
	    ;;  min ݥȤ˰ưʤФʤʤ (ɤߤ䴰Ԥ
	    ;; ϡmin ݥȤ鸫ФõᡢФۤɡmin
	    ;; ݥȤ˶ᤤȤˤʤФʤʤ)
	    (setq skk-henkan-key midasi
		  old-entry (skk-search-jisyo-file-1 okurigana 0 'delete))
	    (skk-update-jisyo-1 okurigana word old-entry purge)
	    (and skk-update-end-function
		 (funcall skk-update-end-function
			  henkan-buffer midasi okurigana word purge))
	    (setq skk-update-jisyo-count (1+ skk-update-jisyo-count))
	    (if (and skk-jisyo-save-count
		     (= skk-jisyo-save-count skk-update-jisyo-count))
		;; auto save.
		(skk-save-jisyo 'quiet)))))))

(defun skk-update-jisyo-1 (okurigana word old-entry-list purge)
  ;; ¸ȥ꤫׻ entry[1-4] ͤȡѴη word Ȥޡ
  ;; ơʥȥ׻롣
  (let ((entry1 (car old-entry-list)) (entry2 (nth 1 old-entry-list))
        (entry3 (nth 2 old-entry-list)) (entry4 (nth 3 old-entry-list)))
    (if (not purge)
        ;; entry1 ƬΥȥ word ˤ롣
        (setq entry1 (cons word (delete word entry1)))
      ;; ʤ⤷ skk-henkan-okuri-strictly 
      ;; skk-henkan-strict-okuri-precedence  nil ξ硣
      (if (or (not okurigana) (not (or skk-henkan-okuri-strictly
				       skk-henkan-strict-okuri-precedence)))
          ;; entry1  purgeѼˤ륨ȥä顢
          ;; skk-ignore-dic-word ǥȤƼѴϤʤ褦ˤ
          ;; 롣Ѽˤʤʸ word ä
          (if (skk-public-jisyo-has-entry-p okurigana word)
              (setq entry1 (skk-compose-ignore-entry entry1 word))
            (setq entry1 (delete word entry1)))
        ;; ꤢǡ skk-henkan-okuri-strictly 
	;; skk-henkan-strict-okuri-precedence  non-nil ξǡ
        ;;  word ȥڥˤʤ겾̾ okurigana ʤȤ
        (if (and okurigana (or skk-henkan-okuri-strictly
			       skk-henkan-strict-okuri-precedence)
                 (null (member word entry2)) (null (member word entry4)))
            (setq entry1 (delete word entry1))
          ;; ¾ξϲ⤷ʤ
         )))
    (if (null entry1)
        ;; entry1  null ǤС⤦⤹뤳ȤϤʤ
        nil
      (goto-char (if okurigana skk-okuri-ari-min skk-okuri-nasi-min))
      (insert "\n" skk-henkan-key " /")
      ;; entry1 -- ȥ (ʤξ) or ʬȥ (ꤢ
      ;; ξ)
      (insert (mapconcat 'skk-quote-char entry1 "/") "/")
      (if (not okurigana)
          nil
        ;; entry2 ʹߤΥȥΤϡꤢξΤߡ
        ;; ٤ȥ׻Ĵ롣
        (if entry3
            (if (not purge)
                (setq entry3 (cons word (delete word entry3)))
              (setq entry3 (delete word entry3))
              (if (null entry3)
                  ;; entry3 ȤΤʤС"/[/]/" Τ
                  ;; 겾̾ΤߤΥȥʤ褦ˤ (ɬפ
                  ;; Сentry2 κǸ) entry4 ƬΥȥ "]"
                  ;; 
                  (let ((last2 (nthcdr (- (length entry2) 2) entry2)))
                    ;; entry2 κǸϾ "[겾̾" Ȥϸ¤ʤ
                    (and (string= (nth 1 last2) (concat "[" okurigana))
			 (setcdr last2 nil))
                    ;; entry4 ƬϾ "]"
                    (setq entry4 (cdr entry4)))))
          ;; entry3  null Ǥ
          (if (or skk-process-okuri-early purge)
              ;; skk-process-okuri-early  non-nil ʤ겾̾ʬʤΤ
              ;; ⤷ʤ-- Ѥ겾̾狼ʤޤѴƤ
              ;; ΤǡƤΥȥ꤬ entry2 äƤ -- entry3,
              ;; entry4  null
              ;; entry3 ȤΤʤС⤷ʤ -- entry3
              ;;  purge  null ʤ顢entry2  "[" Ǥʤ
              ;; entry4  null  entry[234] ס
              nil
            (setq entry2 (nconc entry2 (list (concat "[" okurigana)))
                  entry3 (list word)
                  ;; purge  entry3  null äΤ entry4  null
                  entry4 (list "]")))))
      (if entry2
          ;; entry2 -- Ѥʤä겾̾Ȥθ䷲ + "[" + 
          ;; Ѥ겾̾ (겾̾Τߡ겾̾Ѥθ
          ;; ䷲ϡentry3 ˴ޤޤ)
          (progn
            (insert (mapconcat 'skk-quote-char entry2 "/") "/")
            ;; entry2  null ʤ entry3  null
            (and entry3
		 ;; entry3 -- Ѥ겾̾Ȥȥ
		 (insert (mapconcat 'skk-quote-char entry3 "/") "/"))
            ;; purge  entry3  null ˤʤä entry4 ĤäƤȤ
            ;; 롣
            (and entry4
		 ;; entry4 -- "]" + ¾겾̾Ȥȥ (entry2 
		 ;; Ĥ)
		 (insert (mapconcat 'skk-quote-char entry4 "/") "/")))))))

(defun skk-quote-char (word)
  ;; ¤鼭񥨥ȥ˴ޤƤϤʤʤʸ WORD ˤС
  ;; ɾȤˤʸȤʤ褦 Lisp ɤ֤
  (save-match-data
    (if (and word
             (string-match "[/\n\r\"]" word)
             ;; we should not quote WORD if it is a symbolic expression
             (not (skk-lisp-prog-p word)))
        (concat "(concat \""
                (mapconcat (function (lambda (c)
                                       (cond ((eq c ?/) "\\057")
                                             ((eq c ?\n) "\\n")
                                             ((eq c ?\r) "\\r")
                                             ((eq c ?\") "\\\"")
                                             ((eq c ?\\) "\\\\")
                                             (t (char-to-string c)))))
                           ;; ʸб char ΥꥹȤʬ򤹤롣
                           (append word nil) "")
                "\")")
      word)))

(defun skk-lisp-prog-p (word)
  ;; word  Lisp ץǤСt ֤
  (let ((l (skk-str-length word)))
    (and (> l 2) (eq (skk-str-ref word 0) ?\() (< (aref word 1) 128)
         (eq (skk-str-ref word (1- l)) ?\)))))

(defun skk-public-jisyo-has-entry-p (okurigana word)
  ;; ͭ MIDASHI ڤӤб WORDS ȥäƤС
  ;; non-nil ֤ץ饤١ȼΥХåեǥ뤵롣
  (let (fn skk-henkan-okuri-strictly skk-henkan-strict-okuri-precedence)
    (if okurigana
        (setq skk-henkan-okurigana okurigana))
    ;; skkserv ȤˤʤäƤ顢skk-server.el ɤ롣
    (and (not (featurep 'skk-server))
	 (or (and (boundp 'skk-servers-list) skk-servers-list)
	     (or (and (boundp 'skk-server-host) skk-server-host)
		 (getenv "SKKSERVER")))
	 (require 'skk-server))
    (setq fn (funcall skk-public-jisyo-to-be-searched-function))
    (and fn (member word (eval fn)))))

(defun skk-public-jisyo-to-be-searched-original ()
  ;; skk-search-prog-list 椫顢礭ʶͭǥץ
  ;; ֤
  (let (fn)
    (and (featurep 'skk-server) (or skk-servers-list skk-server-host)
	 (setq fn (assq 'skk-search-server skk-search-prog-list)))
    ;; skk-search-server ϤޤꥹȤʤСȤˤ礭
    ;; ˤƤ skk-search-jisyo-file ץõ
    (if (and (not fn) (or skk-aux-large-jisyo skk-large-jisyo))
	(let ((spl skk-search-prog-list)
	      cell)
	  (while (setq cell (car spl))
	    (if (and (eq (car cell) 'skk-search-jisyo-file)
		     (memq (nth 1 cell) '(skk-aux-large-jisyo skk-large-jisyo)))
		(setq fn cell
		      spl nil)
	      (setq spl (cdr spl))))))
    fn))

(defun skk-compose-ignore-entry (entry &optional add)
  ;; ENTRY  skk-ignore-dic-word ؿǥȤȥ꤬
  ;; СĤΥȥˤޤȤ롣
  ;; ץʥ ADD ꤵƤ顢ADD ޤ᤿
  ;; skk-ignore-dic-word ȥ롣
  ;;  skk-ignore-dic-word ȥ car ˡʳΥȥ cdr ˤ
  ;; ꥹȤ֤
  (let (l arg e)
    (and add (setq entry (delete add entry)))
    (setq l entry)
    (save-match-data
      (while l
        (setq e (car l)
              l (cdr l))
        (and (string-match "(skk-ignore-dic-word +\\([^\)]+\\))" e)
	     (setq arg (concat arg
			       (substring e (1+ (match-beginning 1))
					  (1- (match-end 1)))
			       "\" \"")
		   entry (delq e entry))))
      (if add
          (setq arg (if arg (concat arg add) add))
        ;;  " \"" ڤȤ
        (setq arg (substring arg 0 -2)))
      (cons (concat "(skk-ignore-dic-word \"" arg "\")") entry))))


(defun skk-katakana-region (start end &optional vcontract)
  "꡼ΤҤ餬ʤ򥫥ʤѴ롣
ץʥ VCONTRACT  non-nil ǤС\"\"  \"\" Ѵ
롣
 START  END ϿǤޡǤɤ"
  (interactive "*r\nP")
  (skk-save-point
   (let (katakana)
     (save-match-data
       (goto-char start)
       (while (re-search-forward  "[-]+" end 'noerror)
	 (setq katakana
	       (skk-hiragana-to-katakana
		(buffer-substring-no-properties (match-beginning 0)
						(match-end 0))))
	 (backward-char (skk-str-length katakana))
	 ;; firstly insert a new string, secondly delete an old string to save
	 ;; the cursor position.
	 (insert-and-inherit katakana)
	 (delete-region (+ (match-beginning 0) (length katakana))
			(+ (match-end 0) (length katakana))))
       (if vcontract
	   (progn
	     (goto-char start)
	     (while (re-search-forward  "" end 'noerror)
	       (backward-char (skk-str-length ""))
	       (let ((vu-len (length "")))
		 (insert-and-inherit "")
		 (delete-region (+ (match-beginning 0) vu-len)
				(+ (match-end 0) vu-len))))))))))

(defun skk-hiragana-region (start end &optional vexpand)
  "꡼ΥʤҤ餬ʤѴ롣
ץʥ VEXPAND  non-nil ǤС\"\"  \"\" Ѵ롣
 START  END ϿǤޡǤɤ
\"\"  \"\" ѹʤ 2 ĤʸбҤ餬ʤʤΤǡ
ʤȤƤϰʤ"
  (interactive "*r\nP")
  (skk-save-point
   (let (hiragana)
     (save-match-data
       (goto-char start)
       (while (re-search-forward  "[-]+" end 'noerror)
	 (setq hiragana
	       (skk-katakana-to-hiragana
		(buffer-substring-no-properties (match-beginning 0)
						(match-end 0))))
	 (backward-char (skk-str-length hiragana))
	 ;; firstly insert a new string, secondly delete an old string to save
	 ;; the cursor position.
	 (insert-and-inherit hiragana)
	 (delete-region (+ (match-beginning 0) (length hiragana))
			(+ (match-end 0) (length hiragana))))
       (if vexpand
	   (progn
	     (goto-char start)
	     (while (re-search-forward  "" end 'noerror)
	       (backward-char (skk-str-length ""))
	       (insert-and-inherit "")
	       (let ((vu-len (length "")))
		 (delete-region (+ (match-beginning 0) vu-len)
				(+ (match-end 0) vu-len))))))))))

(defun skk-jisx0208-latin-region (start end)
  "꡼ ascii ʸбѱʸѴ롣"
  (interactive "*r")
  (skk-save-point
   (save-match-data
     (goto-char end)
     (while (re-search-backward "[ -~]" start 'noerror)
       ;; firstly insert a new char, secondly delete an old char to save
       ;; the cursor position.
       (let* ((c (aref skk-default-jisx0208-latin-vector (following-char)))
	      (c-len (length c)))
	 (insert-and-inherit c)
	 (delete-region (+ (match-beginning 0) c-len)
			(+ (match-end 0) c-len)))))))

(defun skk-latin-region (start end)
  ;; ꡼ѱѿб ascii ʸѴ롣
  ;; egg.el 3.09  hankaku-region 򻲹ͤˤ
  (interactive "*r")
  (skk-save-point
   (save-match-data
     (let (val)
       (goto-char end)
       (while (re-search-backward "\\cS\\|\\cA" start 'noerror)
	 (setq val (skk-jisx0208-to-ascii (char-to-string (following-char))))
	 (if val
	     (progn
	       (insert-and-inherit val)
	       (delete-region (+ (match-beginning 0) 1)
			      (+ (match-end 0) 1)))))))))

(defun skk-katakana-henkan (arg)
  "⡼ɤǤС꡼ΤҤ餬ʤ򥫥ʤѴ롣
⡼ɤǤϲ⤷ʤ
¾Υ⡼ɤǤϡꥸʥΥդǥХɤƤ륳ޥɤ¹
롣"
  (interactive "*P")
  (skk-with-point-move
   (if skk-henkan-on
       (if skk-henkan-active
	   nil
	 (skk-set-marker skk-henkan-end-point (point))
	 (skk-*-henkan-1 'skk-katakana-region skk-henkan-start-point
			 skk-henkan-end-point 'vcontract))
     (skk-emulate-original-map arg))))

(defun skk-hiragana-henkan (arg)
  "⡼ɤǤС꡼ΥʤҤ餬ʤѴ롣
⡼ɤǤϲ⤷ʤ
¾Υ⡼ɤǤϡꥸʥΥդǥХɤƤ륳ޥɤ¹
롣"
  (interactive "*P")
  (skk-with-point-move
   (if skk-henkan-on
       (if skk-henkan-active
	   nil
	 (skk-set-marker skk-henkan-end-point (point))
	 (skk-*-henkan-1 'skk-hiragana-region skk-henkan-start-point
			 skk-henkan-end-point 'vexpand))
     (skk-emulate-original-map arg))))

(defun skk-jisx0208-latin-henkan (arg)
  "⡼ɤǤСascii ʸбѱʸѴ롣
⡼ɤǤϲ⤷ʤ
¾Υ⡼ɤǤϡꥸʥΥդǥХɤƤ륳ޥɤ¹
롣"
  (interactive "*P")
  (skk-with-point-move
   (if skk-henkan-on
       (if skk-henkan-active
	   nil
	 (skk-set-marker skk-henkan-end-point (point))
	 (skk-*-henkan-1 'skk-jisx0208-latin-region skk-henkan-start-point
			 skk-henkan-end-point))
     (skk-emulate-original-map arg))))

(defun skk-latin-henkan (arg)
  "⡼ɤǤСascii ʸбʸѴ롣
⡼ɤǤϲ⤷ʤ
¾Υ⡼ɤǤϡꥸʥΥդǥХɤƤ륳ޥɤ¹
롣"
  (interactive "*P")
  (skk-with-point-move
   (if skk-henkan-on
       (if skk-henkan-active
	   nil
	 (skk-set-marker skk-henkan-end-point (point))
	 (skk-*-henkan-1 'skk-latin-region skk-henkan-start-point
			 skk-henkan-end-point))
     (skk-emulate-original-map arg))))

(defun skk-*-henkan-1 (func &rest args)
  ;; ѴǽɤΥå򤷤 ARGS Ȥ FUNC ŬѤ
  ;; skk-henkan-start-point  skk-henkan-end-point δ֤ʸѴ롣
  (cond ((skk-get-prefix skk-current-rule-tree)
	 (skk-error "եåƤʤ skk-prefix ޤ"
		    "Have unfixed skk-prefix"))
	((< (point) skk-henkan-start-point)
	 (skk-error "뤬Ѵˤޤ"
		    "Henkan end point must be after henkan start point"))
	((and (not skk-allow-spaces-newlines-and-tabs)
	      (skk-save-point (beginning-of-line)
			      (> (point) skk-henkan-start-point)))
	 (skk-error "Ѵ˲ԤޤޤƤޤ"
		    "Henkan key may not contain a new line character")))
  (apply func args)
  (skk-kakutei))

(defun skk-hiragana-to-katakana (hiragana)
  (let ((diff (- ? ?)))
    (mapconcat (function (lambda (e) (char-to-string (+ e diff))))
	       (string-to-int-list hiragana) "")))

(defun skk-katakana-to-hiragana (katakana)
  (let ((diff (- ? ?)))
    (mapconcat (function (lambda (e) (char-to-string (- e diff))))
	       (string-to-int-list katakana) "")))

(defun skk-splice-in (org offset spliced)
  ;; ORG := '(A B C), SPLICED := '(X Y), OFFSET := 1
  ;; -> '(A B X Y C)
  (let (tmp tail)
    (or (> offset 0) (error "Cannot splice in!"))
    (setq tmp (nthcdr (1- offset) org)
          tail (cdr tmp))
    (setcdr tmp nil) ;cut off
    (setcdr tmp (if tail (nconc spliced tail) spliced))
    org))

;; (defun skk-chomp (nth list)
;;   ;; LIST := '(A B C D), NTH := 1
;;   ;; -> '(A B)
;;   (and (> nth -1) (setcdr (nthcdr nth list) nil))
;;   list)

(defun skk-henkan-face-on ()
  ;; skk-use-face  non-nil ξ硢skk-henkan-start-point 
  ;; skk-henkan-end-point δ֤ face ° skk-henkan-face ͤѹ롣
  ;;
  ;; SKK 9.4  Text Properties ѤΤߤơOverlays Ѥ
  ;; ˤ (egg.el, canna.el, wnn-egg.el 򻲹ͤˤ)
  ;; Overlays ϡƥȤΰǤϤʤΤǡХåեʸڤФƤ⥳
  ;; ԡоݤˤʤʤɥ̵뤵ΤǡѴ줿ɽ
  ;; Ūѹˤ Text Properties ⹥ԹǤ롣
  (if (and skk-henkan-face
	   (marker-position skk-henkan-start-point)
	   (marker-position skk-henkan-end-point))
      (skk-face-on skk-henkan-overlay
		   skk-henkan-start-point skk-henkan-end-point
		   skk-henkan-face skk-henkan-overlay-priority)))

(defun skk-henkan-face-off ()
  ;; skk-henkan-start-point  skk-henkan-end-point δ֤ɽѹƤ
  ;; skk-henkan-overlay ä
  (and skk-henkan-face (skk-detach-extent skk-henkan-overlay)))

(defun skk-detach-extent (object)
  (static-cond
   ((eq skk-emacs-type 'xemacs)
    (and (extentp object) (detach-extent object)))
   (t
    (and (overlayp object) (delete-overlay object)))))

(defun skk-make-face (face)
  ;; hilit-lookup-face-create Υ֥åȡtutorial ǿդԤʤǤ
  ;; hilit19 ˰¸Ȥꤢ face Ǻ뤳ȤǤ褦ˡȤ
  ;; ŪǺäΤǡñʿդǤʤޤ긭Ϥʤʣ
  ;; face ꤿͤ hilit-lookup-face-create ȤäƲ
  (or (car (memq face (face-list)))
      (let ((face-name (symbol-name face)))
        (setq face (make-face face))
        (save-match-data
          (if (not (string-match "/" face-name))
              (set-face-foreground face face-name)
            (set-face-foreground
             face
             (substring face-name 0 (match-beginning 0)))
            (set-face-background
             face
             (substring face-name (1+ (match-beginning 0)))))
          face))))

;; skk-auto.el, skk-rdbms.el ξǻȤΤǡskk-auto.el ư
(defun skk-remove-common (word)
  ;; skk-henkan-key  word δ֤˶̤겾̾겾̾ʳʬ
  ;; ʸ֤skk-henkan-key  skk-henkan-okurigana ͤ򥻥åȤ롣
  ;; 㤨Сword == äƤ ǤСskk-henkan-key := "t",
  ;; skk-henkan-okurigana := "ä", word := "" Τ褦ʬ򤷡word ֤
  ;; skk-auto-okuri-process ͤ non-nil ǤȤˤδؿѤ롣
  (if (and (not (skk-numeric-p)) (not skk-abbrev-mode)
           (or skk-henkan-in-minibuff-flag
               (and (<= skk-okuri-index-min skk-henkan-count)
                    (<= skk-henkan-count skk-okuri-index-max))))
      (let ((midasi skk-henkan-key)
            (midasi-len (skk-str-length skk-henkan-key))
            (word-len (skk-str-length word))
            (cont t)
            char pos pos2 midasi-tail word-tail new-word okuri-first
            new-skk-okuri-char new-skk-henkan-key)
        (if (not (and (>= midasi-len 2) (>= word-len 2)))
            nil
          ;; check if both midasi and word end with the same ascii char.
          (if (and (eq (skk-str-ref midasi (1- midasi-len))
		       (skk-str-ref word (1- word-len)))
                   (skk-ascii-char-p (skk-str-ref midasi (1- midasi-len))))
              ;; if so chop off the char from midasi and word.
	      ;; assume size of an ASCII char is always 1.
              (setq midasi (substring midasi 0 -1)
                    midasi-len (1- midasi-len)
                    word (substring word 0 -1)
                    word-len (1- word-len)))
          (setq midasi-tail (skk-substring midasi (1- midasi-len)
					   midasi-len)
		word-tail (skk-substring word (1- word-len)
					 word-len))
          ;; ⤦ŸǤХȥѥ顼ץƥޥ
          ;; 褦 not դˤƤ
          (if (not (and (string= midasi-tail word-tail)
                        (or (and (skk-string<= "" midasi-tail)
                                 (skk-string<= midasi-tail ""))
                            (member midasi-tail '("" "" "" "")))))
              nil
            (setq pos (1- word-len)
                  new-word new-skk-henkan-key)
            (while (and cont (> pos 0))
              (setq char (skk-substring word (1- pos) pos))
              (if (and (skk-string<= "" char) (skk-string<= char ""))
                  ;; char is the right-most Kanji
                  (setq cont nil)
                (setq pos (1- pos))))
            (setq pos2 (- midasi-len (- word-len pos)))
            ;; check if midasi and word has the same tail of length
            (if (not (string= (skk-substring midasi pos2 midasi-len)
                              (skk-substring word pos word-len)))
                nil
              (setq okuri-first (skk-substring word pos (1+ pos)))
              (setq skk-henkan-okurigana
                    (if (and (string= okuri-first "")
                             (<= (+ pos 2) word-len))
                        ;; in this case okuriga consits of two
                        ;; characters, e.g., ֻĤä
                        (skk-substring word pos (+ pos 2))
                      okuri-first))
              (setq new-word (skk-substring word 0 pos)
		    new-skk-okuri-char (skk-okurigana-prefix okuri-first)
		    new-skk-henkan-key (concat
					(skk-substring midasi 0 pos2)
					new-skk-okuri-char))
              (if (not skk-henkan-in-minibuff-flag)
                  (setq word new-word
                        skk-henkan-key new-skk-henkan-key)
                ;; ask if register as okuri-ari word.
                (let (inhibit-quit)	; allow keyboard quit
                  (if (y-or-n-p
                       (format
                        (if skk-japanese-message-and-error
                            "%s /%s/ ꤢꥨȥȤϿޤ"
                          "Shall I register this as okuri-ari entry: %s /%s/ ? ")
                        new-skk-henkan-key new-word))
                      (setq word new-word
			    skk-okuri-char new-skk-okuri-char
                            skk-henkan-key new-skk-henkan-key)
                    (setq skk-henkan-okurigana nil
                          skk-okuri-char nil)
                    (message "")))))))))
  ;; ʬ򤷤 word (겾̾ʬ) ֤
  word)

(defun skk-okurigana-prefix (okurigana)
  (cond ((string= okurigana "")
	 "n")
	((string= okurigana "")
	 (aref skk-kana-rom-vector
	       ;; assume the character is hiragana of JIS X 0208.
	       (- (skk-char-octet
		   (string-to-char (skk-substring skk-henkan-okurigana 1 2))
		   1)
		  33)))
	(t (aref skk-kana-rom-vector
		 (- (skk-char-octet
		     (string-to-char (skk-substring skk-henkan-okurigana 0 1))
		     1)
		    33)))))

;; from type-break.el.  Welcome!
(defun skk-time-difference (a b)
  ;; Compute the difference, in seconds, between a and b, two structures
  ;; similar to those returned by `current-time'.
  ;; Use addition rather than logand since that is more robust; the low 16
  ;; bits of the seconds might have been incremented, making it more than 16
  ;; bits wide.
  (+ (lsh (- (car b) (car a)) 16)
     (- (nth 1 b) (nth 1 a))))

(defun skk-remove-minibuffer-setup-hook (&rest args)
  ;; Remove all args from minibuffer-setup-hook.
  (while args
    (remove-hook 'minibuffer-setup-hook (car args))
    (setq args (cdr args))))

(add-hook 'edit-picture-hook 'skk-misc-for-picture 'append)
;; add 'skk-save-jisyo only to remove easily.
(add-hook 'skk-before-kill-emacs-hook 'skk-save-jisyo)
(add-hook 'minibuffer-exit-hook
          (function
           (lambda ()
	     (remove-hook 'pre-command-hook 'skk-pre-command 'local)
	     (skk-remove-minibuffer-setup-hook
	      'skk-j-mode-on 'skk-setup-minibuffer
	      (function (lambda ()
			  (add-hook 'pre-command-hook 'skk-pre-command nil 'local)))))))

(defun skk-setup-modeline ()
  "⡼ɹԤؤΥơɽ롣"
  (cond ((eq skk-status-indicator 'left)
	 (let ((list
		(cond
		 ((and (fboundp 'face-proportional-p)
		       (face-proportional-p 'modeline))
		  '((skk-latin-mode-string . ("--SKK:" . " SKK"))
		    (skk-hiragana-mode-string . ("--:" . " "))
		    (skk-katakana-mode-string . ("--:" . " "))
		    (skk-jisx0208-latin-mode-string . ("--:" . " "))
		    (skk-abbrev-mode-string . ("--a:" . " a"))))
		 (t
		  '((skk-latin-mode-string . ("--SKK::" . " SKK"))
		    (skk-hiragana-mode-string . ("--:" . " "))
		    (skk-katakana-mode-string . ("--:" . " "))
		    (skk-jisx0208-latin-mode-string . ("--:" . " "))
		    (skk-abbrev-mode-string . ("--a::" . " a")))))))
	   (while list
	     (let ((sym (caar list))
		   (strs (cdar list)))
	       (if (string= (symbol-value sym) (cdr strs))
		   (set sym (car strs))))
	     (setq list (cdr list))))
	 (cond ((eq skk-emacs-type 'xemacs)
		(or (memq 'skk-input-mode-string default-mode-line-format)
		    (setq-default default-modeline-format
				  (append '("" skk-input-mode-string)
					  default-modeline-format)))
		(mapc
		 (function
		  (lambda (buf)
		    (if (buffer-live-p buf)
			(save-excursion
			  (set-buffer buf)
			  (or (memq 'skk-input-mode-string modeline-format)
			      (setq modeline-format
				    (append '("" skk-input-mode-string)
					    modeline-format)))))))
		 (buffer-list)))
	       (t
		(or (memq 'skk-input-mode-string mode-line-format)
		    (setq-default
		     mode-line-format
		     (append '("" skk-input-mode-string)
			     mode-line-format)))))
	 (setq-default skk-input-mode-string "")
	 (force-mode-line-update t))
	(t
	 (setq minor-mode-alist
	       (put-alist 'skk-mode
			  ;; each element of minor-mode-alist is not cons cell.
			  '(skk-input-mode-string) minor-mode-alist)))))

(run-hooks 'skk-load-hook)

(provide 'skk)
;;; Local Variables:
;;; End:
;;; skk.el ends here
