;;; skk-server.el --- SKK СΤΥץ
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996,
;;               1997, 1998, 1999
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Maintainer: Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Version: $Id: skk-server.el,v 1.2 2002/11/28 13:55:31 tatari Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2002/11/28 13:55:31 $

;; This file is part of SKK.

;; SKK is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; SKK is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:
;;
;;; Code:
(require 'skk-foreword)

;;;###autoload
(defgroup skk-server nil "SKK server related customization."
  :prefix "skk-server-"
  :group 'skk )

;; user variables.
(defcustom skk-server-host (getenv "SKKSERVER")
  "*SKK 񥵡С餻Ƥۥ̾"
  :type 'string
  :group 'skk-server )

(defcustom skk-server-prog (getenv "SKKSERV")
  "*SKK 񥵡Сץ̾եѥǽ񤯡"
  :type 'file
  :group 'skk-server )

(defcustom skk-server-jisyo (getenv "SKK_JISYO")
  "*SKK 񥵡СץϤ̾եѥǽ񤯡"
  :type 'file
  :group 'skk-server )

(defcustom skk-server-portnum nil
  "*Non-nil ǤСͤ port number Ȥ skkserv  TCP ³롣
/etc/services ľܽ񤭴븢¤ʤ桼Τѿ"
  :type '(choice integer (const nil))
  :group 'skk-server )

;;(defvar skk-server-debug nil
;;  "*Non-nil ǤС񥵡СץǥХå⡼ɤǵư롣
;;ǥХå⡼ɤ skkserv 餻ȡΤޤ foreground ꡢå
;;Ϥ롣ܡɤꤳߤ򤫤뤳ȤǤ롣" )

(defcustom skk-servers-list nil
  "*񥵡Сξꥹȡ

ʣΥۥȤưƤ륵Ф˥ǤˤϡʲΤ褦˥ꥹȤ
Ǥ˽˥ۥ̾եѥǤ SKK С̾SKK СϤ̾
SKK СѤݡֹ񤭡򤹤뤳ȤǤ롣

   \(setq skk-servers-list
         '\(\(\"host1\" \"/path/to/skkserv\" \"/path/to/SKK-JISYO.L\" 1178\)
           \(\"host2\" \"/path/to/skkserv\"\) \)\)

ξ硢ǽ˻ꤷФ˥ǤʤʤȡưŪ˽缡ꥹȤˤ
ĤΥФ˥褦ˤʤ롣
СΥǥեȤμ񤪤ӥݡֹѤ nil ꤹ뤫
񤫤ʤɤ

ʤ桼Ȥ˼¹Ը¤ΤʤСꤹϡ

   \(setq skk-servers-list '\(\(\"host1\"\) \(\"host2\"\)\)\)

Τ褦ˡۥ̾񤯤ȤǤ롣嵭Ǥϡhost1, host2 ˤ
 skkserv ӥ TCP ³γϤΤ߻ߡСεưϻߤʤ"
  :type '(repeat
	  (list (string :tag "Hostname")
		(choice :tag "Server" file (const nil))
		(choice :tag "Dictionary" file (const nil))
		(choice :tag "Port number" integer (const nil)) ))
  :group 'skk-server )

(defcustom skk-server-report-response nil
  "*Non-nil ǤСѴСФʸޤǤ accept-process-output 򲿲¹Ԥ𤹤롣"
  :type 'boolean
  :group 'skk-server )

(defcustom skk-server-remote-shell-program
  (or (getenv "REMOTESHELL")
      (and (boundp 'remote-shell-program) remote-shell-program)
      (cond
       ((eq system-type 'berkeley-unix)
        (if (file-exists-p "/usr/ucb/rsh") "/usr/ucb/rsh" "/usr/bin/rsh") )
       ((eq system-type 'usg-unix-v)
        (if (file-exists-p "/usr/ucb/remsh") "/usr/ucb/remsh" "/bin/rsh"))
       ((eq system-type 'hpux) "/usr/bin/remsh")
       ((eq system-type 'EWS-UX/V) "/usr/ucb/remsh")
       ((eq system-type 'pcux) "/usr/bin/rcmd")
       (t "rsh") ))
  "*⡼ȥΥץ̾"
  :type 'file
  :group 'skk-server )

(defcustom skk-server-load-hook nil
  "*skk-server.el ɤ˥뤵եå"
  :type 'hook
  :group 'skk-server )

;; internal constants and variables.
(defconst skk-network-open-status 'open)
(defconst skkserv-working-buffer " *skkserv*")
(defvar skkserv-process nil)

(defun skk-server-version ()
  (interactive)
  (if (interactive-p)
      (message (skk-server-version))
    (let (status)
      (if (not (or skk-server-host skk-servers-list))
          (skk-error "Lack of host information of SKK server"
                     "SKK СΥۥȾ󤬤ޤ" ))
      (setq status (process-status "skkservd"))
      (or (eq status skk-network-open-status) (setq status (skk-open-server)))
      (if (eq status skk-network-open-status)
          (let (v)
            (save-match-data
              (with-current-buffer skkserv-working-buffer
                (erase-buffer)
                ;; СС롣
                (process-send-string "skkservd" "2")
                (while (eq (buffer-size) 0)
                  (accept-process-output) )
                (setq v (buffer-string))
                (erase-buffer)
                ;; ۥ̾롣
                (process-send-string "skkservd" "3")
                (while (eq (buffer-size) 0)
                  (accept-process-output) )
                (goto-char (point-min))
                (format
                 (concat "SKK SERVER version %s"
                         (if skk-japanese-message-and-error
                             "(ۥ̾ %s)"
                           "running on HOST %s" ))
                 v (prog1 (buffer-string) (erase-buffer)) ))))))))

(defun skk-search-server (file limit &optional nomsg)
  ;; SKK եޥåȤ FILE  SKK СѤ skk-henkan-key 򥭡
  ;; ˤƸԤ
  ;; SKK СѤǤʤȤϡFILE Хåեɤ߹ǥ
  ;; 
  ;; LIMIT  NOMSG  SKK СѤʤȤΤ߻Ȥ
  ;; ꡼ LIMIT ʲˤʤޤǥХʥꥵԤθ˥
  ;; Ԥ
  ;; LIMIT  0 ǤС˥ΤߤԤ
  ;; 񤬥ȤƤʤΤǤСLIMIT  0 ɬפ롣
  ;; ץʥ NOMSG  non-nil Ǥ skk-get-jisyo-buffer Υ
  ;; Ϥʤ褦ˤ롣
  (if (or skk-server-host skk-servers-list)
      (skk-search-server-subr file limit)
    (skk-search-jisyo-file file limit nomsg) ))

(defun skk-search-server-subr (file limit)
  ;; skk-search-server Υ֥롼
  (let ((key
	 (if skk-use-numeric-conversion
	     (skk-num-compute-henkan-key skk-henkan-key)
	   skk-henkan-key))
        ;; ХåեͤμϤΤᡢ̾ΰѿ˼롣
        (okurigana (or skk-henkan-okurigana skk-okuri-char))
;        (status (process-status "skkservd"))
	l item)
    (setq item (skkinput-search-server-subr key file limit))
    (setq l (skkinput-compute-henkan-lists item okurigana))
    (if l
	(cond ((and okurigana skk-henkan-okuri-strictly)
	       ;; 겾̾ƱΥȥΤߤ֤
	       (nth 2 l) )
	      ((and okurigana skk-henkan-strict-okuri-precedence)
	       (skk-nunion (nth 2 l) (car l)))
	      (t (car l))))))

;    (or (eq status skk-network-open-status) (setq status (skk-open-server)))
;    (if (eq status skk-network-open-status)
;        (with-current-buffer skkserv-working-buffer
;          (let ((cont t) (count 0)
;                l )
;            (erase-buffer)
;            (process-send-string "skkservd" (concat "1" key " "))
;            (while (and cont (eq (process-status "skkservd")
;                                 skk-network-open-status ))
;              (accept-process-output)
;              (setq count (1+ count))
;              (if (> (buffer-size) 0)
;                  (if (eq (char-after 1) ?1) ;?1
;                      ;; found key successfully, so check if a whole line
;                      ;; is received.
;                      (if (eq (char-after (1- (point-max))) ?\n) ;?\n
;                          (setq cont nil) )
;                    ;; not found or error, so exit
;                    (setq cont nil) )))
;            (goto-char (point-min))
;            (if skk-server-report-response
;                (skk-message "%d  SKK СαԤ򤷤ޤ"
;                             "Waited for server response %d times" count ))
;            (if (eq (following-char) ?1) ;?1
;                (progn
;                  (forward-char 2)
;                  (setq l (skk-compute-henkan-lists okurigana))
;                  (if l
;                      (cond ((and okurigana skk-henkan-okuri-strictly)
;			     ;; 겾̾ƱΥȥΤߤ֤
;			     (nth 2 l) )
;			    ((and okurigana skk-henkan-strict-okuri-precedence)
;			     (skk-nunion (nth 2 l) (car l)) )
;			    (t (car l)) ))))))
;      ;; server is not active, so search file instead
;      (skk-search-jisyo-file file limit) )))

(defun skk-open-server ()
  ;; SKK С³롣Сץ status ֤
  (let (status code proc)
    (if (or (skk-open-network-stream) (skk-open-server-1))
        (progn
          (setq status (process-status "skkservd"))
          (if (eq status skk-network-open-status)
              (progn
                (setq code (cdr (assoc "euc" skk-coding-system-alist))
		      proc (get-process "skkservd") )
		(cond ((eq skk-emacs-type 'xemacs)
		       (set-process-input-coding-system proc code)
		       (set-process-output-coding-system proc code) )
		      (t
		       (set-process-coding-system proc code code) ))))))
    status ))

(defun skk-open-server-1 ()
  ;; skk-open-server Υ֥롼
  ;; skkserv ӥ򥪡ץǤ t ֤
  ;; skkserv ϰ˼񤬻ꤵƤʤСDEFAULT_JISYO 򻲾Ȥ롣
  (if (null skk-servers-list)
      (progn
	;; Emacs ư˴Ķѿꤷ硣
	(if (not skk-server-host)
	    (setq skk-server-host (getenv "SKKSERVER")) )
	(if (not skk-server-prog)
	    (setq skk-server-prog (getenv "SKKSERV")) )
	(if (not skk-server-jisyo)
	    (setq skk-server-jisyo (getenv "SKK_JISYO")) )
	(if skk-server-host
	    (setq skk-servers-list (list (list skk-server-host
					       skk-server-prog
					       skk-server-jisyo
					       skk-server-portnum )))
	  (setq skk-server-prog nil) )))
  (while (and (not (eq (process-status "skkservd") skk-network-open-status))
	      skk-servers-list )
    (let ((elt (car skk-servers-list))
	  arg )
      (setq skk-server-host (car elt)
	    skk-server-prog (nth 1 elt)
	    skk-server-jisyo (nth 2 elt)
	    skk-server-portnum (nth 3 elt)
	    skk-servers-list (cdr skk-servers-list) )
      ;; skkserv εưץϲ̤ꡣ
      ;;     skkserv [-d] [-p NNNN] [JISHO]
      ;;     `-d'     ǥХå⡼
      ;;     `-p NNNN'     ̿ѤΥݡֹȤNNNNȤ.
      ;;     `~/JISYO'     ~/JISYO򼭽Ȥ.
      (if skk-server-jisyo
	  (setq arg (list skk-server-jisyo))
	;; skkserv ϰ˼񤬻ꤵƤʤСDEFAULT_JISYO 
	;; Ȥ롣
	)
      ;;(if skk-server-debug
      ;;    (setq arg (cons "-d" arg)) )
      (if (and skk-server-portnum (not (= skk-server-portnum 1178)))
	  (setq arg
		(nconc (list "-p" (number-to-string skk-server-portnum)) arg) ))
      (if (and skk-server-host (not (skk-open-network-stream))
	       skk-server-prog )
	  ;; skk-startup-server ǥСưˤϡskk-server-host 
	  ;; skk-server-prog ꤵƤ뤳Ȥɬס
	  (skk-startup-server arg) )))
  (if (not (eq (process-status "skkservd") skk-network-open-status))
      ;; reset SKK-SERVER-HOST so as not to use server in this session
      (setq skk-server-host nil
	    skk-server-prog nil
	    skk-servers-list nil )
    t ))

(defun skk-open-network-stream ()
  ;; skk-server-host ˤ skkserv ӥ TCP ³򥪡ץ󤷡ץ
  ;; ֤
  (condition-case nil
      (progn
	(setq skkserv-process
	      (open-network-stream "skkservd" skkserv-working-buffer
				   skk-server-host
				   (or skk-server-portnum "skkserv") ))
	(process-kill-without-query skkserv-process) )
    (error nil) ))

(defun skk-startup-server (arg)
  ;; skkserv ưǤ t ֤
  (let (
        ;;(msgbuff (get-buffer-create " *skkserv-msg*"))
        (count 7) )
    (while (> count 0)
      (skk-message
       "%s  SKK СưƤޤ󡣵ưޤ%s"
       "SKK SERVER on %s is not active, I will activate it%s"
       skk-server-host (make-string count ?.) )
      (if (or (string= skk-server-host (system-name))
              (string= skk-server-host "localhost"))
          ;; server host is local machine
          (apply 'call-process skk-server-prog nil
                 ;;msgbuff
                 0 nil arg)
        (apply 'call-process
               skk-server-remote-shell-program nil
               ;; 0 ˤƥ֥ץνλԤäƤϤʤͳ롩
               ;; ʤ msgbuf ˥顼ϤäŪǤϡ  ޤ
               ;; ξϤ while 롼׼Ȥʤ
               ;; msgbuff
               0 nil skk-server-host skk-server-prog arg ))
      (sit-for 3)
      (if (and (skk-open-network-stream)
               (eq (process-status "skkservd") skk-network-open-status) )
          (setq count 0)
        (setq count (1- count)) ))
    (if (eq (process-status "skkservd") skk-network-open-status)
        (progn
          (skk-message "ۥ %s  SKK Сưޤ"
                       "SKK SERVER on %s is active now"
                       skk-server-host )
          (sit-for 1) ; return t
          t ) ; ǤǰΤ
      (skk-message "%s  SKK Сư뤳ȤǤޤǤ"
                   "Could not activate SKK SERVER on %s"
                   skk-server-host )
      (sit-for 1)
      (ding) ;return nil
      nil ))) ; ǤǰΤ

;;;###autoload
(defun skk-adjust-search-prog-list-for-server-search (&optional non-del)
  ;; skk-server-host ⤷ skk-servers-list  nil ǤС
  ;; skk-search-prog-list  skk-search-server  car ˻ĥꥹȤä
  ;; non-nil ǤСä롣
  (if (or skk-server-host skk-servers-list)
      (if (null (assq 'skk-search-server skk-search-prog-list))
          ;; skk-search-prog-list  nil ȤȤϤޤʤǰΤ
          ;; ᡢsetq Ƥ
          (setq skk-search-prog-list
                ;; դ롣ˤ (skk-okuri-search) äƤ
                ;; ⤤뤫⡣ץդѹ褦ˤ
                ;; ɤ
                (nconc skk-search-prog-list
                       (list
                        '(skk-search-server skk-aux-large-jisyo 10000) ))))
    (if (not non-del)
	(remove-alist 'skk-search-prog-list 'skk-search-server) )))

(defun skk-disconnect-server ()
  ;; СڤΥ
  (if (and skk-server-host
           (eq (process-status "skkservd") skk-network-open-status) )
      (progn
        (process-send-string "skkservd" "0") ; disconnect server
        (accept-process-output (get-process "skkservd")) )))

;;(add-hook 'skk-mode-hook 'skk-adjust-search-prog-list-for-server-search)
(add-hook 'skk-before-kill-emacs-hook 'skk-disconnect-server)

(run-hooks 'skk-server-load-hook)

(provide 'skk-server)
;;; skk-server.el ends here
