/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMInputMethod_h)
#define	XIMInputMethod_h

struct tagXIMInputMethod ;
typedef struct tagXIMInputMethod	XIMInputMethod ;

#include "XIMProtocol.h"
#include "XIMInputContext.h"

typedef struct {
	unsigned long	m_uXIMStyle ;
	int				m_nWindowType ;
}	XIMInputStyle ;

XIMInputMethod*		XIMInputMethod_Create				(Widget, int) ;
int					XIMInputMethod_GetID				(XIMInputMethod*) ;
Widget				XIMInputMethod_GetClient			(XIMInputMethod*) ;
XIMInputContext*	XIMInputMethod_CreateInputContext	(XIMInputMethod*) ;
void				XIMInputMethod_DestroyInputContext	(XIMInputMethod*, XIMInputContext*) ;
XIMInputContext*	XIMInputMethod_FindInputContext		(XIMInputMethod*, int) ;
int					XIMInputMethod_GetQueryInputStyle	(XIMInputMethod*, const XIMInputStyle**) ;
CARD16				XIMInputMethod_GetExtMask			(XIMInputMethod*) ;
Boolean				XIMInputMethod_SetExtMask			(XIMInputMethod*, CARD16) ;
void				XIMInputMethod_Destroy				(XIMInputMethod*) ;
void				XIMInputMethod_SetNext				(XIMInputMethod*, XIMInputMethod*) ;
XIMInputMethod*		XIMInputMethod_GetNext				(XIMInputMethod*) ;
Boolean				XIMInputMethod_SetCodingSystem		(XIMInputMethod*, int) ;
int					XIMInputMethod_GetCodingSystem		(XIMInputMethod*) ;

#endif

