/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMInputContextP_h)
#define	XIMInputContextP_h

#include <X11/Xlib.h>
#include "XIMInputContext.h"
#include "TConvAttr.h"
#include "varbuffer.h"
#include "tqueue.h"
#include "TLispClient.h"

struct tagXIMInputContext {
	CARD16						m_woID ;
	XIMInputMethod*				m_pInputMethod ;
	unsigned long				m_ulAttributeMask ;
	XIMStyle					m_dwInputStyle ;
	Window						m_wndClient ;
	Window						m_wndFocus ;
	Window						m_wndKeyFocus ;
	CARD32						m_dwFilterEvents ;
	XIMResetState				m_ulResetState ;
	TConversionAttribute		m_ConvAttr ;
	Atom						m_atPStdColormap ;
	Atom						m_atSStdColormap ;
	Widget						m_wgTopFrame ;
	Widget						m_wgTopMinibufFrame ;
	XIMPreeditState				m_preeditState ;
	TQueue						m_quePacketSpool ;
	TVarbuffer					m_vbufPFontSetName ;
	TVarbuffer					m_vbufSFontSetName ;
	unsigned int				m_uSyncStatus ;
	Boolean						m_fDestroy ;
	Boolean						m_fFocus ;
	TLispClient					m_LispClient ;
	struct tagXIMInputContext*	m_pNext ;
} ;

#endif

