/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMData_h)
#define	XIMData_h

#include "XIMProtocol.h"

typedef struct {
	const CARD8*	m_pData ;
	const CARD8*	m_pHead ;
	Boolean			m_fBigEndian ;
}	XIMData ;

extern inline void
XIMData_Initialize (
	register XIMData*		pThis,
	register const CARD8*	pData,
	register Boolean		fEndian)
{
	assert (pThis != NULL) ;
	pThis->m_pData		= pData ;
	pThis->m_pHead		= pData ;
	pThis->m_fBigEndian	= fEndian ;
	return ;
}

extern inline void
XIMData_SetEndian (
	register XIMData*		pThis,
	register Boolean		fEndian)
{
	assert (pThis != NULL) ;
	pThis->m_fBigEndian	= fEndian ;
	return ;
}

extern inline const CARD8*
XIMData_GetHead (
	register XIMData*		pThis)
{
	assert (pThis != NULL) ;
	return	pThis->m_pHead ;
}

extern inline CARD8
XIMData_GetCard8 (
	register XIMData*		pThis)
{
	register CARD8	c8Value ;

	c8Value	= pThis->m_pHead [0] ;
	pThis->m_pHead	++ ;
	return	c8Value ;
}

extern inline CARD16
XIMData_GetCard16 (
	register XIMData*		pThis)
{
    register CARD16	c16Value ;

    if (pThis->m_fBigEndian){
		c16Value	= ((CARD16)pThis->m_pHead [0] << 8) | pThis->m_pHead [1] ;
    } else {
		c16Value	= ((CARD16)pThis->m_pHead [1] << 8) | pThis->m_pHead [0] ;
    }
    pThis->m_pHead	+= sizeof (CARD16) / sizeof (CARD8) ;
    return	c16Value ;
}

extern inline CARD32
XIMData_GetCard32 (
	register XIMData*		pThis)
{
    register CARD32	c32Value ;

    if (pThis->m_fBigEndian){
		c32Value	= (((CARD32)pThis->m_pHead [0] << 24) |
					   ((CARD32)pThis->m_pHead [1] << 16) | 
					   ((CARD32)pThis->m_pHead [2] <<  8) | 
					   ((CARD32)pThis->m_pHead [3] <<  0)) ;
    } else {
		c32Value	= (((CARD32)pThis->m_pHead [3] << 24) |
					   ((CARD32)pThis->m_pHead [2] << 16) | 
					   ((CARD32)pThis->m_pHead [1] <<  8) | 
					   ((CARD32)pThis->m_pHead [0] <<  0)) ;
    }
	pThis->m_pHead	+= sizeof (CARD32) / sizeof (CARD8) ;
    return	c32Value ;
}

extern inline void
XIMData_Forward8 (
	register XIMData*		pThis,
	register int			nCount)
{
    pThis->m_pHead	+= nCount ;
}

extern inline void
XIMData_Forward16 (
	register XIMData*		pThis,
	register int			nCount)
{
    pThis->m_pHead	+= nCount * sizeof (CARD16) / sizeof (CARD8) ;
}

extern inline void
XIMData_Forward32 (
	register XIMData*		pThis,
	register int			nCount)
{
    pThis->m_pHead	+= nCount * sizeof (CARD32) / sizeof (CARD8) ;
}

extern inline void
XIMData_Rewind (
	register XIMData*		pThis)
{
    pThis->m_pHead	= pThis->m_pData ;
}

#endif

