/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (kfile_h)
#define	kfile_h

#include "Char.h"
#include <stdio.h>
#include "kanji.h"

typedef struct tagKFILE {
	FILE*				m_pf ;
	KANJISTATEMACHINE	m_ksm ;
	int					m_iCodingSystem ;
}	KFILE ;

typedef struct tagKFILEPOS {
	long				m_lPosition ;	/* եƬΰ֡*/
	KANJISTATEMACHINE	m_ksm ;			/* ֵξ֡*/
}	KFILEPOS ;

#define	KFILEPOS_POSITION(pos)	((pos).m_lPosition)
#define	KFILEPOS_STATE(pos)		((pos).m_ksm)

/*	Prototypes */
Boolean	KFile_Init	(KFILE*) ;
Boolean	KFile_Open	(KFILE*, const char*, int) ;
Boolean	KFile_Close	(KFILE*) ;
Char	KFile_Getc	(KFILE*) ;
Boolean	KFile_FindsAtBeginningOfLine  (KFILE*, const Char*) ;
Boolean	KFile_FindsAtBeginningOfLineA (KFILE*, const char*) ;
Boolean	KFile_Cmps					(KFILE*, const Char*) ;
Boolean	KFile_Cmpsn					(KFILE*, const Char*, int) ;
Boolean	KFile_Nextline				(KFILE*) ;
Boolean	KFile_Tell					(KFILE*, KFILEPOS*) ;
Boolean	KFile_Seek					(KFILE*, KFILEPOS*) ;
Boolean	KFile_Seekn					(KFILE*, long, int) ;
Boolean	KFile_Rewind				(KFILE*) ;
int		KFile_GetCodingSystem		(KFILE*) ;
int		KFile_DetectCodingSystem	(KFILE*) ;

#endif

