#include "lmkeymap.h"

TLispEntity*
lispMachine_GetGlobalMap (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntGlobalMap ;
	TLispEntity*	pEntKeymap ;

	pEntGlobalMap	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_GLOBAL_MAP) ;
	if (pEntGlobalMap != NULL &&
		TSUCCEEDED (lispMachine_GetCurrentSymbolValue (pLM, pEntGlobalMap, &pEntKeymap)) &&
		TFAILED (lispEntity_Voidp (pLispMgr, pEntKeymap)))
		return	pEntKeymap ;

	return	lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_NIL) ;
}

Boolean
lispMachine_EnumMinorModeMaps (
	register TLispMachine*	pLM,
	register Boolean		(*pProc)(TLispMachine*, TLispEntity*, void*, Boolean*),
	register void*			pCaller)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntSymbol ;
	TLispEntity*			pEntKeylist ;
	Boolean					fContinue ;

	pEntSymbol	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_MINOR_MODE_MAP_ALIST) ;
	if (pEntSymbol == NULL ||
		TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntSymbol, &pEntKeylist)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pEntKeylist)))
		return	True ;

	fContinue	= True ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntKeylist))) {
		TLispEntity*			pEntEntry ;
		TLispEntity*			pEntNext ;
		TLispEntity*			pEntKeymap ;
		TLispEntity*			pEntSymEnable ;
		TLispEntity*			pEntEnablep ;

		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntKeylist, &pEntEntry)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntKeylist, &pEntNext)))
			return	False ;
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntEntry, &pEntSymEnable)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntEntry, &pEntKeymap)))
			return	False ;

		/*	mode-map-list $B$,I>2A$9$k$KCM$9$k$+$r%A%'%C%/$9$k!#(B*/
		if (TSUCCEEDED (lispEntity_Symbolp (pLispMgr, pEntSymEnable)) &&
			TSUCCEEDED (lispMachine_GetCurrentSymbolValue (pLM, pEntSymEnable, &pEntEnablep)) &&
			TFAILED (lispEntity_Voidp (pLispMgr, pEntEnablep)) &&
			TFAILED (lispEntity_Nullp (pLispMgr, pEntEnablep))) {
			/*	$B$=$N(B keymap $B$KBP$7$F(B function $B$r8F$S=P$9!#(B*/
			if (TFAILED ((pProc)(pLM, pEntKeymap, pCaller, &fContinue)))
				return	False ;
			if (TFAILED (fContinue))
				break ;
		}
		pEntKeylist	= pEntNext ;
	}
	return	True ;
}


