/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lmachine_inl_h)
#define	lmachine_inl_h

extern inline	Boolean
lispMachineCode_PushState (
	register TLispMachine*	pLM,
	register TLMRESULT		(*pState)(TLispMachine*))
{
	TNotLispValue	val ;

	assert (pLM != NULL) ;

	/*
	 *	NextState  Interactiveness  Stack Ѥ¸롣
	 */
	val.m_pState	= pState ;
	if (TFAILED (Vstack_Push (&pLM->m_vstNonLispObj, &val)))
		return	False ;
	val.m_lValue	= (((pLM->m_fInteractive) ? 1 : 0) |
					   ((pLM->m_fCalledInteractively)? 2 : 0)) ;
	if (TFAILED (Vstack_Push (&pLM->m_vstNonLispObj, &val))) {
		/*	ѤǤΤ̵롣*/
		(void) Vstack_Pop (&pLM->m_vstNonLispObj, &val) ;
		return	False ;
	}
	return	True ;
}

extern inline	Boolean
lispMachineCode_PopState (
	register TLispMachine* pLM)
{
	TNotLispValue	valState ;
	TNotLispValue	valInteractive ;

	assert (pLM != NULL) ;

	if (TFAILED (Vstack_Pop (&pLM->m_vstNonLispObj, &valInteractive)) ||
		TFAILED (Vstack_Pop (&pLM->m_vstNonLispObj, &valState)))
		return	False ;
	
	pLM->m_fInteractive			= (valInteractive.m_lValue & 1)? True : False ;
	pLM->m_fCalledInteractively	= (valInteractive.m_lValue & 2)? True : False ;
	pLM->m_pState				= valState.m_pState ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_PushLReg (
	register TLispMachine*	pLM,
	register int			nReg)
{
	assert (pLM != NULL) ;
	assert (0 <= nReg && nReg < MAX_LISPOBJ_REGS) ;

	if (pLM->m_apLREGS [nReg] != NULL &&
		TFAILED (lispEntity_AddRef (pLM->m_pLispMgr, pLM->m_apLREGS [nReg])))
		return	False ;
#if defined (DEBUG_LV99)
	fprintf (stderr, "Vstack = u=%d/s=%d\n", pLM->m_vstLispObj.m_nUsage, pLM->m_vstLispObj.m_nSize) ;
#endif
	return	Vstack_Push (&pLM->m_vstLispObj, &pLM->m_apLREGS [nReg]) ;

}

extern inline	Boolean
lispMachineCode_PopLReg (
	register TLispMachine*	pLM,
	register int			nReg)
{
	assert (pLM != NULL) ;
	assert (0 <= nReg && nReg < MAX_LISPOBJ_REGS) ;

	if (pLM->m_apLREGS [nReg] != NULL)
		lispEntity_Release (pLM->m_pLispMgr, pLM->m_apLREGS [nReg]) ;
#if defined (DEBUG_LV99)
	fprintf (stderr, "Vstack = u=%d/s=%d\n", pLM->m_vstLispObj.m_nUsage, pLM->m_vstLispObj.m_nSize) ;
#endif
	return	Vstack_Pop (&pLM->m_vstLispObj, &pLM->m_apLREGS [nReg]) ;
}

extern inline	Boolean
lispMachineCode_SetLReg (
	register TLispMachine*	pLM,
	register int			nReg,
	register TLispEntity*	pEntValue)
{
	assert (pLM != NULL) ;
	assert (0 <= nReg && nReg < MAX_LISPOBJ_REGS) ;

	if (pEntValue != NULL)
		lispEntity_AddRef (pLM->m_pLispMgr, pEntValue) ;
	if (pLM->m_apLREGS [nReg] != NULL)
		lispEntity_Release (pLM->m_pLispMgr, pLM->m_apLREGS [nReg]) ;
	pLM->m_apLREGS [nReg]	= pEntValue ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_GetLReg (
	register TLispMachine*	pLM,
	register int			nReg,
	register TLispEntity**	phValue)
{
	assert (pLM != NULL) ;
	assert (0 <= nReg && nReg < MAX_LISPOBJ_REGS) ;
	assert (phValue != NULL) ;

	*phValue	= pLM->m_apLREGS [nReg] ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_MoveLReg (
	register TLispMachine*	pLM,
	register int			nDestReg,
	register int			nSrcReg)
{
	assert (pLM != NULL) ;
	assert (0 <= nDestReg && nDestReg < MAX_LISPOBJ_REGS) ;
	assert (0 <= nSrcReg  && nSrcReg  < MAX_LISPOBJ_REGS) ;

	if (pLM->m_apLREGS [nDestReg] != NULL)
		lispEntity_Release (pLM->m_pLispMgr, pLM->m_apLREGS [nDestReg]) ;
	if (pLM->m_apLREGS [nSrcReg] != NULL)
		lispEntity_AddRef (pLM->m_pLispMgr, pLM->m_apLREGS [nSrcReg]) ;
	pLM->m_apLREGS [nDestReg]	= pLM->m_apLREGS [nSrcReg] ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_Cdr (
	register TLispMachine*	pLM,
	register int			nDestReg,
	register int			nSrcReg)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pCDR ;

	assert (pLM != NULL) ;
	assert (0 <= nDestReg && nDestReg < MAX_LISPOBJ_REGS) ;
	assert (0 <= nSrcReg  && nSrcReg  < MAX_LISPOBJ_REGS) ;

	pLispMgr	= pLM->m_pLispMgr ;
	if (TFAILED (lispEntity_GetCdr (pLispMgr, pLM->m_apLREGS [nSrcReg], &pCDR)) ||
		pCDR == NULL)
		return	False ;
	lispEntity_AddRef (pLispMgr, pCDR) ;
	if (pLM->m_apLREGS [nDestReg] != NULL)
		lispEntity_Release (pLispMgr, pLM->m_apLREGS [nDestReg]) ;
	pLM->m_apLREGS [nDestReg]	= pCDR ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_SetInteractive (
	register TLispMachine*	pLM,
	register Boolean			fInteractive)
{
	assert (pLM != NULL) ;
	assert (fInteractive == True || fInteractive == False) ;

	pLM->m_fInteractive			= pLM->m_fCalledInteractively ;
	pLM->m_fCalledInteractively	= fInteractive ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_GetInteractive (
	register TLispMachine*	pLM,
	register Boolean*			pfInteractive)
{
	assert (pLM != NULL) ;
	assert (pfInteractive != NULL) ;

	*pfInteractive	= pLM->m_fInteractive ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_UnsetInteractive (
	register TLispMachine*	pLM,
	register Boolean			fInteractive)
{
	assert (pLM != NULL) ;
	assert (fInteractive == True || fInteractive == False) ;

	pLM->m_fCalledInteractively	= pLM->m_fInteractive	;
	pLM->m_fInteractive			= fInteractive ;
	return	True ;
}

extern inline	Boolean
lispMachine_LocalVariablep (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntSymbol)
{
	TLispEntity*	pEntValue ;
	assert (pLM != NULL) ;
	assert (pEntSymbol != NULL) ;
	if (TFAILED (lispMachine_GetCurrentBufferLocalSymbolValue (pLM, pEntSymbol, &pEntValue)) ||
		TSUCCEEDED (lispEntity_Voidp (pLM->m_pLispMgr, pEntValue)))
		return	False ;
	return	True ;
}

extern inline	Boolean
lispMachine_LocalVariableIfSetp (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntSymbol)
{
	TLispEntity*	pEntValue	= NULL ;
	assert (pLM != NULL) ;
	assert (pEntSymbol != NULL) ;
	if (TFAILED (lispMachine_GetCurrentBufferLocalSymbolValue (pLM, pEntSymbol, &pEntValue)) ||
		pEntValue == NULL)
		return	False ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_SetTail (
	register TLispMachine*	pLM, 
	register int			nRegHead,
	register int			nRegTail,
	register TLispEntity*	pEntNewTail)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*			pEntTail ;

	lispMachineCode_GetLReg (pLM, nRegTail, &pEntTail) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntTail))) {
		lispMachineCode_SetLReg (pLM, nRegHead, pEntNewTail) ;
	} else {
		if (TFAILED (lispEntity_SetCdr (pLispMgr, pEntTail, pEntNewTail)))
			return	False ;
	}
	lispMachineCode_SetLReg (pLM, nRegTail, pEntNewTail) ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_SetState (
	register TLispMachine*	pLM,
	register TLMRESULT		(*pState)(TLispMachine*))
{
	assert (pLM    != NULL) ;
	assert (pState != NULL) ;
	pLM->m_pState	= pState ;
	return	True ;
}

extern inline	Boolean
lispMachineCode_SetMinibufferMessage (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntMessage)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntFrame ;
	TLispEntity*	pEntWindow ;

	/* current-frame  minibuffer-window  message ɽ
	 * 롣*/
	if (TFAILED (lispMachineCode_GetCurrentFrame (pLM, &pEntFrame)) ||
		TFAILED (lispFrame_GetMinibufferWindow (pEntFrame, &pEntWindow)) ||
		TFAILED (lispWindow_SetMessage (pLispMgr, pEntWindow, pEntMessage))) 
		return	False ;
	return	True ;
}

extern inline	void
lispMachineCode_ClearQuitFlag (
	register TLispMachine*		pLM)
{
	register TLispManager*		pLispMgr ;
	register TLispEntity*		pEntQuitFlag ;
	register TLispEntity*		pEntInhibitQuit ;
	register TLispEntity*		pEntNil ;

	assert (pLM != NULL) ;
	pLispMgr		= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	pEntQuitFlag	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_QUIT_FLAG) ;
	pEntInhibitQuit	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_INHIBIT_QUIT) ;
	pEntNil			= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_NIL) ;
	assert (pEntQuitFlag != NULL) ;
	assert (pEntInhibitQuit != NULL) ;
	assert (pEntNil != NULL) ;
	lispMachine_SetCurrentSymbolValue (pLM, pEntQuitFlag,    pEntNil) ;
	lispMachine_SetCurrentSymbolValue (pLM, pEntInhibitQuit, pEntNil) ;
	return ;
}

#endif
