/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lispbuffer_h)

#include "varbuffer.h"
#include "bufstring.h"

enum {
	MARKER_BTOP				= 0,
	MARKER_ETOP,
	MARKER_POINT,
	MARKER_ELAST,
	MARKER_BLAST,
	MARKER_MARK,		/* MARK ¸ߤƤʤ礬롣*/
	NUM_BUFFER_MUST_MARKERS,
} ;

enum {
	SIZE_LISP_BIND_TABLE	= 37,
	MAX_BUFFER_TEXT			= 256,
} ;

struct tagTLispBind ;
struct tagTLispEntity ;

/*
 *	m_pEntName:		Хåե̾
 *	m_pEntKeymap:	Хåե˳դƤ륭ޥåס
 */
struct tagTLispBuffer {
	struct tagTLispBind*	m_apVariableTable [SIZE_LISP_BIND_TABLE] ;
	TBufString				m_Text ;
	Boolean					m_fModified ;
	int						m_nTick ;
	struct tagTLispEntity*	m_pEntName ;
	struct tagTLispEntity*	m_pEntKeymap ;
	struct tagTLispEntity*	m_apMustMarkers [NUM_BUFFER_MUST_MARKERS] ;
	struct tagTLispEntity*	m_lstMarkers ;
	struct tagTLispEntity*	m_pNextBuffer ;
	struct tagTLispEntity*	m_pPrevBuffer ;
} ;

typedef struct tagTLispBuffer	TLispBuffer ;

#endif

