/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (tfontset_h)
#define	tfontset_h

#include <X11/Xlib.h>
#include "TFont.h"

#define	TFONTSET_MAX_NAMES	(64)

struct tagTFontSet {
	int			m_iAscent ;
	int			m_iHeight ;
	int			m_iAvgWidth ;
	TFont*		m_af [MAX_CHARSET] ;
} ;

typedef struct tagTFontSet TFontSet ;

void		TFontSet_Initialize	(TFontSet*) ;
Boolean		TFontSet_Load		(Display*, TFontSet*, const char*, Boolean) ;
Boolean		TFontSet_LoadAtom	(Display*, TFontSet*, int, Atom*, Boolean) ;
void		TFontSet_Clear		(TFontSet*) ;
void		TFontSet_Destroy	(TFontSet*) ;
void		TFontSet_Copy		(TFontSet*, const TFontSet*) ;
int			TFontSet_GetAscent	(TFontSet*) ;
int			TFontSet_GetHeight	(TFontSet*) ;
int			TFontSet_GetDescent	(TFontSet*) ;
TFont*		TFontSet_GetFont	(TFontSet*, int) ;
void		TFontSet_Show		(TFontSet*) ;
void		TFontSet_Adjust		(Display*, TFontSet*, int) ;

#endif

