/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <X11/Xproto.h>
#include "dispatch.h"

static	Widget		swgToplevel			= NULL ;

Boolean
AfxWinInitialize (
	register Widget		wgToplevel)
{
	swgToplevel	= wgToplevel ;
	return	True ;
}

Display*
AfxGetDisplay (void)
{
	return	XtDisplay (swgToplevel) ;
}

Widget
AfxGetToplevelWidget (void)
{
	return	swgToplevel ;
}

int
AfxHandleXError (
	register Display*		pDisplay,
	register XErrorEvent*	pErrorEvent)
{
#if defined (DEBUG)
	static	const char*	const rstrRequest []	= {
		"X_CreateWindow", 			"X_ChangeWindowAttributes",
		"X_GetWindowAttributes",	"X_DestroyWindow",
		"X_DestroySubwindows",		"X_ChangeSaveSet",
		"X_ReparentWindow",			"X_MapWindow",
		"X_MapSubwindows",			"X_UnmapWindow",
		"X_UnmapSubwindows",		"X_ConfigureWindow",
		"X_CirculateWindow",		"X_GetGeometry",
		"X_QueryTree",				"X_InternAtom",
		"X_GetAtomName",			"X_ChangeProperty",
		"X_DeleteProperty",			"X_GetProperty",
		"X_ListProperties",			"X_SetSelectionOwner",
		"X_GetSelectionOwner",		"X_ConvertSelection",
		"X_SendEvent",				"X_GrabPointer",
		"X_UngrabPointer",			"X_GrabButton",
		"X_UngrabButton",			"X_ChangeActivePointerGrab",
		"X_GrabKeyboard",			"X_UngrabKeyboard",
		"X_GrabKey",				"X_UngrabKey",
		"X_AllowEvents",			"X_GrabServer",
		"X_UngrabServer",			"X_QueryPointer",
		"X_GetMotionEvents",		"X_TranslateCoords",
		"X_WarpPointer",			"X_SetInputFocus",
		"X_GetInputFocus",			"X_QueryKeymap",
		"X_OpenFont",				"X_CloseFont",
		"X_QueryFont",				"X_QueryTextExtents",
		"X_ListFonts",				"X_ListFontsWithInfo",
		"X_SetFontPath",			"X_GetFontPath",
		"X_CreatePixmap",			"X_FreePixmap",
		"X_CreateGC",				"X_ChangeGC",
		"X_CopyGC",					"X_SetDashes",
		"X_SetClipRectangles",		"X_FreeGC",
		"X_ClearArea",				"X_CopyArea",
		"X_CopyPlane",				"X_PolyPoint",
		"X_PolyLine",				"X_PolySegment",
		"X_PolyRectangle",			"X_PolyArc",
		"X_FillPoly",				"X_PolyFillRectangle",
		"X_PolyFillArc",			"X_PutImage",
		"X_GetImage",				"X_PolyText8",
		"X_PolyText16",				"X_ImageText8",
		"X_ImageText16",			"X_CreateColormap",
		"X_FreeColormap",			"X_CopyColormapAndFree",
		"X_InstallColormap",		"X_UninstallColormap",
		"X_ListInstalledColormaps",	"X_AllocColor",
		"X_AllocNamedColor",		"X_AllocColorCells",
		"X_AllocColorPlanes",		"X_FreeColors",
		"X_StoreColors",			"X_StoreNamedColor",
		"X_QueryColors",			"X_LookupColor",
		"X_CreateCursor",			"X_CreateGlyphCursor",
		"X_FreeCursor",				"X_RecolorCursor",
		"X_QueryBestSize",			"X_QueryExtension",
		"X_ListExtensions",			"X_ChangeKeyboardMapping",
		"X_GetKeyboardMapping",		"X_ChangeKeyboardControl",
		"X_GetKeyboardControl",		"X_Bell",
		"X_ChangePointerControl",	"X_GetPointerControl",
		"X_SetScreenSaver",			"X_GetScreenSaver",
		"X_ChangeHosts",			"X_ListHosts",
		"X_SetAccessControl",		"X_SetCloseDownMode",
		"X_KillClient",				"X_RotateProperties",
		"X_ForceScreenSaver",		"X_SetPointerMapping",
		"X_GetPointerMapping",		"X_SetModifierMapping",
		"X_GetModifierMapping",		NULL, /* 120 */
		NULL,						NULL,
		NULL,						NULL,
		NULL,						NULL,
		"X_NoOperation",
	} ;
	char	rchBuffer [256] ;

	XGetErrorText (pDisplay, pErrorEvent->error_code, rchBuffer, NELEMENTS (rchBuffer) - 1) ;
	rchBuffer [NELEMENTS (rchBuffer) - 1]	= '\0' ;
	fprintf (stderr, "XErrorEvent: \"%s\"\n", rchBuffer) ;
	fprintf (stderr, "Display  (%p)\n",  pErrorEvent->display) ;
	fprintf (stderr, "Serial   (%ld)\n", pErrorEvent->serial) ;
	fprintf (stderr, "Request  (") ;
	if (X_CreateWindow <= pErrorEvent->request_code &&
		pErrorEvent->request_code <= X_NoOperation  &&
		rstrRequest [pErrorEvent->request_code - X_CreateWindow] != NULL) {
		fprintf (stderr, "%s", rstrRequest [pErrorEvent->request_code - X_CreateWindow]) ;
	} else {
		fprintf (stderr, "%d", pErrorEvent->request_code) ;
	}
	fprintf (stderr, ")\n") ;
	fprintf (stderr, "minor    (%d)\n",  pErrorEvent->minor_code) ;
	fprintf (stderr, "resource (%lx)\n", pErrorEvent->resourceid) ;
#endif
	return	0 ;
}


