/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include "local.h"
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <sys/time.h>
//#include "skkinput.h"
#include "XIMInputContextP.h"
#include "XIMClient.h"
#include "XIMData.h" 
#include "dispatch.h"
#include "lmachine.h"
#include "lispmgr.h"
#include "TFrame.h"
#include "TRootWindow.h"
#include "TOverTheSpotWindow.h"
#include "TOffTheSpotWindow.h"
#include "TOnTheSpotWindow.h"
#include "TNormalFrame.h"
#include "TSubWindowFrame.h"
#include "lispyevent.h"

#define	DEFAULT_XIM_PREEDIT_LINESPACING		(14)
#define	DEFAULT_XIM_STATUS_LINESPACING		(14)

static	Boolean	ximInputContext_createFrame			(XIMInputContext*) ;
static	Boolean	ximInputContext_initializeLispPart	(XIMInputContext*, Widget, Widget) ;
static	void	ximInputContext_onKeyPress			(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onFrameConfigure	(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onFrameDestroy		(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onPreeditStart		(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onPreeditDraw		(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onPreeditCaret		(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onPreeditDone		(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onStatusStart		(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onStatusDraw		(Widget, XtPointer, XtPointer) ;
static	void	ximInputContext_onStatusDone		(Widget, XtPointer, XtPointer) ;

static	void	ximInputContext_onKeyNotify			(void*, TXEvent*) ;
static	void	ximInputContext_onTextNotify		(void*, const Char*, int) ;
static	void	ximInputContext_onEndNotify			(void*) ;

static	Boolean	ximInputContext_packetToCombinep	(XIMPacket*) ;
static	XIMPacket*	ximInputContext_combineXimCommit(XIMInputContext*, XIMPacket*, XIMPacket*) ;
static	void	ximInputContext_addFrameCallbacks	(XIMInputContext*, Widget) ;
static	void	ximInputContext_removeFrameCallbacks(XIMInputContext*, Widget) ;

XIMInputContext*
XIMInputContext_Create (
	register XIMInputMethod*	pInputMethod,
	register int				nID)
{
	register XIMInputContext*	pInputContext ;

	pInputContext	= MALLOC (sizeof (XIMInputContext)) ;
	if (pInputContext == NULL)
		return	NULL ;

	pInputContext->m_pInputMethod		= pInputMethod ;
	pInputContext->m_pNext				= NULL ;
	pInputContext->m_woID				= nID ;
	pInputContext->m_ulAttributeMask	= 0L ;
	pInputContext->m_wgTopFrame			= NULL ;
	pInputContext->m_wgTopMinibufFrame	= NULL ;
	pInputContext->m_ulResetState		= XIMInitialState ;
	pInputContext->m_preeditState		= XIMPreeditDisable ;
	pInputContext->m_wndClient			= None ;
	pInputContext->m_wndFocus			= None ;
	pInputContext->m_dwFilterEvents		= 0 ;
	pInputContext->m_uSyncStatus		= 0 ;
	pInputContext->m_dwInputStyle		= XIMStatusNothing | XIMPreeditNothing ;
	pInputContext->m_pNext				= NULL ;
	pInputContext->m_fDestroy			= False ;
	pInputContext->m_fFocus				= False ;
	pInputContext->m_atPStdColormap		= None ;
	pInputContext->m_atSStdColormap		= None ;
	TQueue_Initialize     (&pInputContext->m_quePacketSpool,   sizeof (XIMPacket*)) ;
	TVarbuffer_Initialize (&pInputContext->m_vbufPFontSetName, sizeof (char)) ;
	TVarbuffer_Initialize (&pInputContext->m_vbufSFontSetName, sizeof (char)) ;
	TConvAttr_Initialize (&pInputContext->m_ConvAttr) ;
	TLispClient_PreInitialize (&pInputContext->m_LispClient) ;

	/*	֤褬İ Client ʤʬʤġ
	 *	Ū˥Ф饳ȥǤʤȤΤϡ
	 *	ˤʤäƤΤȤġ*/
	pInputContext->m_wndKeyFocus		= None ;
	return	pInputContext ;
}	

void
XIMInputContext_Destroy (
	register XIMInputContext*	pThis)
{
	register XIMPacket**	ppPacket ;
	register int			nPacket ;

	ppPacket	= TQueue_GetData  (&pThis->m_quePacketSpool) ;
	nPacket		= TQueue_GetUsage (&pThis->m_quePacketSpool) ;
	while (nPacket -- > 0) 
		XIMPacket_Release (*ppPacket ++) ;

	TQueue_Uninitialize     (&pThis->m_quePacketSpool) ;
	TVarbuffer_Uninitialize (&pThis->m_vbufPFontSetName) ;
	TVarbuffer_Uninitialize (&pThis->m_vbufSFontSetName) ;
	TConvAttr_Uninitialize  (&pThis->m_ConvAttr) ;

	if (pThis->m_wgTopFrame != NULL) 
		ximInputContext_removeFrameCallbacks (pThis, pThis->m_wgTopFrame) ;
	if (pThis->m_wgTopMinibufFrame != NULL &&
		pThis->m_wgTopMinibufFrame != pThis->m_wgTopFrame) 
		ximInputContext_removeFrameCallbacks (pThis, pThis->m_wgTopMinibufFrame) ;
	pThis->m_wgTopFrame			= NULL ;
	pThis->m_wgTopMinibufFrame	= NULL ;

	TLispClient_Uninitialize (&pThis->m_LispClient) ;
	FREE (pThis) ;
	return ;
}

void
XIMInputContext_SetNext (
	register XIMInputContext*	pThis,
	register XIMInputContext*	pNext)
{
	assert (pThis != NULL) ;
	pThis->m_pNext	= pNext ;
	return ;
}

XIMInputContext*
XIMInputContext_GetNext (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	pThis->m_pNext ;
}

int
XIMInputContext_GetID (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	pThis->m_woID ;
}

Boolean
XIMInputContext_Alivep (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	!pThis->m_fDestroy ;
}

Boolean
XIMInputContext_ForwardEvent (
	register XIMInputContext*	pThis,
	register XEvent*			pXEvent)
{
#if defined (DEBUG) || 0
	struct timeval				te, tl ;
	struct timezone				tz ;
	gettimeofday (&te, &tz) ;
#endif

	if (pXEvent->type != KeyPress) 
		return	True ;
	
	pThis->m_wndKeyFocus	= pXEvent->xkey.window ;
	TLispMachine_EventProc (pThis->m_LispClient.m_pLM, LMEVENT_KEYPRESS, pXEvent, 0) ;
	TLispClient_SetModificationFlag (&pThis->m_LispClient, True) ;
#if !defined (USE_ASYNC_XIM)
	TLispClient_Tick (&pThis->m_LispClient) ;
#endif
#if defined (DEBUG) || 0
	gettimeofday (&tl, &tz) ;
	fprintf (stderr, "forward-event: ellapsed time (%ld,%ld)\n", 
			 tl.tv_sec - te.tv_sec, tl.tv_usec - te.tv_usec) ;
#endif
	return	True ;
}

Boolean
XIMInputContext_StartConversion (
	register XIMInputContext*	pThis)
{
	register Widget	wgClient ;

#if defined (DEBUG)
	fprintf (stderr, "XIMInputContext_StartConversion (%p)\n", pThis) ;
#endif

	if (pThis->m_preeditState == XIMPreeditEnable)
		return	True ;

	/*	ֺǽѴưξˤ Widget ɬפ롣
	 */
	if (pThis->m_wgTopFrame == NULL) {
		if (!ximInputContext_createFrame (pThis))
			return	False ;
	} else {
		/*	ʤɤνԤ*/
		TLispClient_Reinitialize (&pThis->m_LispClient) ;
	}

	pThis->m_preeditState	= XIMPreeditEnable ;
	wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	//XIMClient_PreeditStateChange (wgClient, pThis->m_pInputMethod, pThis) ;
#if 0
	XIMInputContext_Activate (pThis, True) ;
#else
	XIMInputContext_Activate (pThis, True) ;
	pThis->m_fFocus	= True ;
#endif
	return	True ;
}

Boolean
XIMInputContext_EndConversion (
	register XIMInputContext*	pThis)
{
	register Widget	wgClient ;

	if (pThis->m_preeditState == XIMPreeditDisable)
		return	False ;

	pThis->m_preeditState	= XIMPreeditDisable ;
	XIMInputContext_Activate (pThis, False) ;

	wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	//XIMClient_PreeditStateChange (wgClient, pThis->m_pInputMethod, pThis) ;
	return	True ;
}

Boolean
XIMInputContext_ResetConversion (
	register XIMInputContext*	pThis)
{
	return	True ;
}

unsigned
XIMInputContext_GetSyncMode (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	pThis->m_uSyncStatus ;
}

void
XIMInputContext_SetSyncMode (
	register XIMInputContext*	pThis,
	register unsigned			uMode)
{
	assert (pThis != NULL) ;
	assert ((uMode & XIMClientSync) || !(pThis->m_uSyncStatus & ~XIMClientSync)) ;
	pThis->m_uSyncStatus	|= uMode ;
	return ;
}

void
XIMInputContext_UnsetSyncMode (
	register XIMInputContext*	pThis,
	register unsigned			uMode)
{
	assert (pThis != NULL) ;

	pThis->m_uSyncStatus	&= ~uMode ;
	return ;
}

Boolean
XIMInputContext_SpoolPacket (
	register XIMInputContext*	pThis,
	XIMPacket*					pPacket)
{
	/*	Spool Ƥľ packet  XIM_COMMIT ʤСϢ뤹롣*/
	if (ximInputContext_packetToCombinep (pPacket)) {
		register XIMPacket**	ppSpooledPacket ;
		register int			npSpooledPacket ;

		ppSpooledPacket	= TQueue_GetData  (&pThis->m_quePacketSpool) ;
		npSpooledPacket	= TQueue_GetUsage (&pThis->m_quePacketSpool) ;
		if (npSpooledPacket > 0) {
			register XIMPacket*		pLastPacket ;

			pLastPacket	= *(ppSpooledPacket + npSpooledPacket - 1) ;
			if (ximInputContext_packetToCombinep (pLastPacket)) {
				register XIMPacket*	pNewPacket ;
				pNewPacket	= ximInputContext_combineXimCommit (pThis, pLastPacket, pPacket) ;
				if (pNewPacket == NULL)
					return	False ;
				XIMPacket_Release (pLastPacket) ;
				*(ppSpooledPacket + npSpooledPacket - 1)	= pNewPacket ;
				return	True ;
			}
		}
	}

	if (TFAILED (TQueue_In (&pThis->m_quePacketSpool, &pPacket, 1)))
		return	False ;
	XIMPacket_AddRef (pPacket) ;
	return	True ;
}

XIMPacket*
XIMInputContext_GetSpooledPacket (
	register XIMInputContext*	pThis)
{
	XIMPacket*		pPacket ;
	register int	nOut ;

	nOut	= TQueue_Out (&pThis->m_quePacketSpool, &pPacket, 1) ;
	if (nOut <= 0)
		return	NULL ;
	return	pPacket ;
}

XIMPacket*
XIMInputContext_LookSpooledPacket (
	register XIMInputContext*	pThis)
{
	register TQueue*	pQueue ;

	assert (pThis != NULL) ;

	pQueue	= &pThis->m_quePacketSpool ;
	if (TQueue_GetUsage (pQueue) <= 0)
		return	NULL ;

	return	TQueue_GetData (pQueue) ;
}

int
XIMInputContext_GetNumberOfSpooledPacket (
	register XIMInputContext*	pThis)
{
	return	TQueue_GetUsage (&pThis->m_quePacketSpool) ;
}

Boolean
XIMInputContext_SetFocus (
	register XIMInputContext*	pThis)
{
	if (pThis->m_preeditState == XIMPreeditDisable)
		return	False ;

#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetFocus (%p, %d)\n",
			 pThis, pThis->m_woID) ;
#endif
	/*	setfocus */
	pThis->m_fFocus	= True ;
	if (pThis->m_wgTopFrame != NULL) 
		XIMInputContext_Activate (pThis, True) ;
	return	True ;
}

Boolean
XIMInputContext_UnsetFocus (
	register XIMInputContext*	pThis)
{
	if (pThis->m_preeditState == XIMPreeditDisable)
		return	False ;

#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_UnsetFocus (%p, %d)\n",
			 pThis, pThis->m_woID) ;
#endif
	/*	unsetfocus */
	pThis->m_fFocus	= False ;
	if (pThis->m_wgTopFrame != NULL) 
		XIMInputContext_Activate (pThis, False) ;
	return	True ;
}

Boolean
XIMInputContext_SetInputStyle (
	register XIMInputContext*	pThis,
	register XIMStyle			imstyle)
{
#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetInputStyle (%p, %ld)\n",
			 pThis, imstyle) ;
#endif
	pThis->m_dwInputStyle		= imstyle ;
	SET_CONVATTR_MASK (pThis->m_ConvAttr, CAInputStyle) ;
	return	True ;
}

Boolean
XIMInputContext_SetClientWindow (
	register XIMInputContext*	pThis,
	register Window				wndClient)
{
#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetClientWindow (%p, %lx)\n",
			 pThis, wndClient) ;
#endif
	/*	client window ϰ٤Ǥʤ*/
	if (pThis->m_wndClient != None)
		return	False ;
	pThis->m_wndClient	= wndClient ;
	return	True ;
}

Boolean
XIMInputContext_SetFocusWindow (
	register XIMInputContext*	pThis,
	register Window				wndFocus)
{
#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetFocusWindow (%p, %lx)\n",
			 pThis, wndFocus) ;
#endif
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAFocusWindow) ||
		pThis->m_ConvAttr.m_wndFocus != wndFocus) {
		pThis->m_ConvAttr.m_wndFocus	= wndFocus ;

		if (pThis->m_wgTopFrame != NULL) {
			TConversionAttribute	ca ;
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAFocusWindow) ;
			ca.m_wndFocus	= wndFocus ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	SET_CONVATTR_MASK (pThis->m_ConvAttr, CAFocusWindow) ;
	return	True ;
}

Boolean
XIMInputContext_SetResetState (
	register XIMInputContext*	pThis,
	register XIMResetState		ulResetState)
{
	if (ulResetState != XIMInitialState && ulResetState != XIMPreserveState)
		return	False ;
	pThis->m_ulResetState	= ulResetState ;
	return	True ;
}

Boolean
XIMInputContext_SetPreeditState (
	register XIMInputContext*	pThis,
	register XIMPreeditState	ulPreeditState)
{
	if (ulPreeditState != XIMPreeditEnable && ulPreeditState != XIMPreeditDisable)
		return	False ;
	if (ulPreeditState != pThis->m_preeditState) {
		Widget	wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
		if (ulPreeditState == XIMPreeditEnable) {
			XIMClient_ControlEventFlow (wgClient, pThis->m_pInputMethod, pThis, True) ;
			XIMInputContext_StartConversion (pThis) ;
		} else {
			XIMClient_ControlEventFlow (wgClient, pThis->m_pInputMethod, pThis, False) ;
			XIMInputContext_EndConversion (pThis) ;
		}
	}
	return	True ;
}

XIMStyle
XIMInputContext_GetInputStyle (
	register XIMInputContext*	pThis)
{
	return	pThis->m_dwInputStyle ;
}

Window
XIMInputContext_GetClientWindow (
	register XIMInputContext*	pThis)
{
	return	pThis->m_wndClient ;
}

Window
XIMInputContext_GetFocusWindow (
	register XIMInputContext*	pThis)
{
	return	pThis->m_wndFocus ;
}

CARD32
XIMInputContext_GetFilterEvents (
	register XIMInputContext*	pThis)
{
	return	pThis->m_dwFilterEvents ;
}

XIMResetState
XIMInputContext_GetResetState (
	register XIMInputContext*	pThis)
{
	return	pThis->m_ulResetState ;
}

XIMPreeditState
XIMInputContext_GetPreeditState (
	register XIMInputContext*	pThis)
{
	return	pThis->m_preeditState ;
}

Boolean
XIMInputContext_SetPreeditArea (
	register XIMInputContext*	pThis,
	register const XRectangle*	pRect)
{
	TConversionAttribute	ca ;

#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext[%d]: SetPreeditArea (%d, %d, %d, %d)\n",
			 pThis->m_woID,
			 pRect->x, pRect->y, pRect->width, pRect->height) ;
#endif
#if 1
	if (pRect->width <= 0 || pRect->height <= 0)
		return	False ;
#endif
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientArea) ||
		!IS_AREA_EQUAL (pThis->m_ConvAttr.m_Preedit.m_area, *pRect)) {

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientArea) ;
		pThis->m_ConvAttr.m_Preedit.m_area	=  *pRect ;

		if (pThis->m_wgTopFrame != NULL) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAClientArea) ;
			ca.m_Preedit.m_area		=  *pRect ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetPreeditAreaNeeded (
	register XIMInputContext*	pThis,
	register const XRectangle*	pRect)
{
#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetPreeditAreaNeeded (%p, %p)\n",
			 pThis, pRect) ;
#endif
	/*	ClientAreaNeeded ȡClientArea Υ
	 *	ˤҤäѤ롣
	 */
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientAreaNeeded) ||
		!IS_AREA_EQUAL (pThis->m_ConvAttr.m_Preedit.m_areaNeeded, *pRect)) {

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientAreaNeeded) ;
		pThis->m_ConvAttr.m_Preedit.m_areaNeeded	= *pRect ;
	}
	return	True ;
}

Boolean
XIMInputContext_SetSpotLocation (
	register XIMInputContext*	pThis,
	register const XPoint*		pPos)
{
	register XPoint*	pCurPos ;

#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetSpotLocation (%p, %d, %d)\n",
			 pThis, pPos->x, pPos->y) ;
#endif
	pCurPos	= &pThis->m_ConvAttr.m_Preedit.m_spot ;
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CASpotLocation) ||
		pPos->x != pCurPos->x || pPos->y != pCurPos->y) {
		if (pThis->m_wgTopFrame != NULL) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CASpotLocation) ;
			memcpy (&ca.m_Preedit.m_spot, pPos, sizeof (XPoint)) ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
		pCurPos->x	= pPos->x ;
		pCurPos->y	= pPos->y ;
		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CASpotLocation) ;
	}
	return	True ;
}

Boolean
XIMInputContext_SetPreeditColormap (
	register XIMInputContext*	pThis,
	register Colormap			colormap)
{
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAColormap) ||
		pThis->m_ConvAttr.m_Preedit.m_colormap != colormap) {

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAColormap) ;
		pThis->m_ConvAttr.m_Preedit.m_colormap	= colormap ;

		if (pThis->m_wgTopFrame) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAColormap) ;
			ca.m_Preedit.m_colormap	= colormap ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetPreeditStdColormap (
	register XIMInputContext*	pThis,
	register Atom				atStdColormap)
{
	register Widget		gw			= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	register Display*	pDisplay	= XtDisplay (gw) ;
	register Window		wndFocus ;
	XStandardColormap*	pStdColormap ;
	int					nCount ;

#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetPreeditStdColormap (%p, %lx)\n",
					 pThis, atStdColormap) ;
#endif

	if (atStdColormap == None) 
		return	False ;

	wndFocus	= pThis->m_wndClient ;
	if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAFocusWindow))
		wndFocus	= pThis->m_ConvAttr.m_wndFocus ;
	if (wndFocus == None)
		return	False ;

	if (!XGetRGBColormaps (pDisplay, wndFocus, &pStdColormap, &nCount, atStdColormap))
		return	False ;

	pThis->m_atPStdColormap	= atStdColormap ;

	/*	ɸǤʤ colormap ƤƤСǽʬ*/
	if ((!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		 !IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAColormap)) &&
		nCount > 0) {
		register Colormap	colormap	= pStdColormap->colormap ;
		pThis->m_ConvAttr.m_Preedit.m_colormap	= colormap ;
		
		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAColormap) ;

		if (pThis->m_wgTopFrame) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAColormap) ;
			ca.m_Preedit.m_colormap	= colormap ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ; 
}

Boolean
XIMInputContext_SetPreeditForeground (
	register XIMInputContext*	pThis,
	register unsigned long		ulForeground)
{
#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetPreeditForeground (%p, %lx)\n",
			 pThis, ulForeground) ;
#endif
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAForegroundPixel) ||
		pThis->m_ConvAttr.m_Preedit.m_foreground != ulForeground) {
		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAForegroundPixel) ;
		pThis->m_ConvAttr.m_Preedit.m_foreground	= ulForeground ;
		if (pThis->m_wgTopFrame != NULL) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAForegroundPixel) ;
			ca.m_Preedit.m_foreground	= ulForeground ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetPreeditBackground (
	register XIMInputContext*	pThis,
	register unsigned long		ulBackground)
{
#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetPreeditBackground (%p, %lx)\n",
			 pThis, ulBackground) ;
#endif
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CABackgroundPixel) ||
		pThis->m_ConvAttr.m_Preedit.m_background != ulBackground) {

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CABackgroundPixel) ;
		pThis->m_ConvAttr.m_Preedit.m_background	= ulBackground ;

		if (pThis->m_wgTopFrame != NULL) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CABackgroundPixel) ;
			ca.m_Preedit.m_background	= ulBackground ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetPreeditBackgroundPixmap (
	register XIMInputContext*	pThis,
	register Pixmap				pixmap)
{
	return	True ;
}

Boolean
XIMInputContext_SetPreeditFontSet (
	register XIMInputContext*	pThis,
	register const char*		pBaseName,
	register int				nBaseNameLength)
{
	register const char*	pPFontSetName ;
	register int			nPFontSetName ;

	pPFontSetName	= TVarbuffer_GetBuffer (&pThis->m_vbufPFontSetName) ;
	nPFontSetName	= TVarbuffer_GetUsage  (&pThis->m_vbufPFontSetName) - 1 ;

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAFont) ||
		nPFontSetName != nBaseNameLength ||
		strncmp (pPFontSetName, pBaseName, nPFontSetName) != 0) {
		register Display*		pDisplay ;
		register Widget			wgClient ;
		register const char*	pFontSetName ;
		register TConversionAttribute*	pCA ;

		/*	եȤѹɬפ롣*/
		TVarbuffer_Clear (&pThis->m_vbufPFontSetName) ;
		TVarbuffer_Add (&pThis->m_vbufPFontSetName, pBaseName, nBaseNameLength) ;
		TVarbuffer_Add (&pThis->m_vbufPFontSetName, "\0", 1) ;

		pFontSetName	= TVarbuffer_GetBuffer (&pThis->m_vbufPFontSetName) ;
		assert (pThis->m_pInputMethod != NULL) ;
		wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
		assert (wgClient != NULL) ;
		pDisplay		= XtDisplay (wgClient) ;
		pCA				= &pThis->m_ConvAttr ;
#if defined (DEBUG) || 0
		fprintf (stderr, "PreeditFontSet => \"%s\"\n", pFontSetName) ;
#endif
		TFontSet_Load (pDisplay, &pCA->m_Preedit.m_FontSet, pFontSetName, False) ;

		if (pThis->m_wgTopFrame != NULL) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAFont) ;
			TFontSet_Copy (&ca.m_Preedit.m_FontSet, &pCA->m_Preedit.m_FontSet) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAFont) ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAFont) ;

		/*	եȤѹ line-spacing ξ̵ˤʤ롣*/
		UNSET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CALineSpacing) ;
	}
	return	True ;
}

Boolean
XIMInputContext_SetPreeditLineSpacing (
	register XIMInputContext*	pThis,
	register int 				nLineSpacing)
{
#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetPreeditLineSpacing (%p, %d)\n",
			 pThis, nLineSpacing) ;
#endif
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CALineSpacing) ||
		pThis->m_ConvAttr.m_Preedit.m_nLineSpacing != nLineSpacing) {

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CALineSpacing) ;
		pThis->m_ConvAttr.m_Preedit.m_nLineSpacing	= nLineSpacing ;

		if (pThis->m_wgTopFrame != NULL) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CALineSpacing) ;
			ca.m_Preedit.m_nLineSpacing	= nLineSpacing ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

/*
 *(ؿ̾)
 *	virtual Boolean
XIMInputContext_SetPreeditCursor (Cursor cursor) ;
 *()
 *	Preedit Area Υꤹ롣
 */
Boolean
XIMInputContext_SetPreeditCursor (
	register XIMInputContext*	pThis,
	register Cursor				cursor)
{
	return	False ;
}

/*
 *(ؿ̾)
 *	virtual bool	GetPreeditArea (XRectangle* pArea) const ;
 *()
 *	Preedt Area 礭֤
 *	Client Window ꥵȯԤƤʤ Preedit Area
 *	θߤ礭ĤȤϤǤʤ
 *	Ĥɤ褹٤(⤽ꥵäñ
 *	ΰ򹭤ʤ⤢)
 */
Boolean
XIMInputContext_GetPreeditArea (
	register XIMInputContext*	pThis,
	register XRectangle*		pRect)
{
	assert (pThis != NULL) ;
	assert (pRect != NULL) ;

	/*
	 *	PreeditArea ʤΤǤСɬפΰ֤ɬפϤʤ
	 */
	if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditNothing)
		return	True ;

	if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientArea)) {
		/*	ɽΰ褬ꤵƤ롣*/
		memcpy (pRect, &pThis->m_ConvAttr.m_Preedit.m_area, sizeof (XRectangle)) ;
	} else {
		if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditPosition){
			register Display*	pDisplay ;
			register Window		wndFocus ;

			/*
			 *	ɽΰ褬ꤵ줿Ȥʤ
			 *		
			 *	ɽɬפΰ⤵줿Ȥʤ
			 *
			 *	ޤPreeditPosition Τ AreaNeeded ꤵƤ
			 *	櫓ǤϤʤ(PreeditArea ʤ AreaNeeded ꤵƤ
			 *	ɬפ)
			 *
			 *	ˤϡFocus Ƥ Window ΰȤ뤳Ȥˤ롣
			 */
			wndFocus	= (pThis->m_wndFocus == None)? pThis->m_wndClient : pThis->m_wndFocus ;
			if (wndFocus != None){
				register Widget	wgClient ;
				Window			wndRoot ;
				int				iX, iY ;
				unsigned int	iWidth, iHeight, iBorder, iDepth ;

				wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
				pDisplay	= XtDisplay (wgClient) ;
				XGetGeometry (pDisplay, wndFocus, &wndRoot, &iX, &iY, &iWidth, &iHeight, &iBorder, &iDepth) ;
				pRect->x		= 0 ;
				pRect->y		= 0 ;
				pRect->width	= iWidth ;
				pRect->height	= iHeight ;
			} else {
				/*	Focus, Client Window ʤ Area ҤͤƤޤäġ*/
				return	False ;
			}
		} else {
			/*
			 *	餯 PreeditArea (Ĥޤ Preedit ΰ Area ɬפ
			 *	)ʤΤǡAreaNeeded ꤵƤ롣
			 *	ξˤ AreaNeeded ʬݤ줿ΤȤΤȤ
			 *	֤ͤ
			 */
			if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) &&
				IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientAreaNeeded)) {
				memcpy (pRect, &pThis->m_ConvAttr.m_Preedit.m_areaNeeded, sizeof (XRectangle)) ;
			} else {
				XIMInputContext_GetPreeditAreaNeeded (pThis, pRect) ;
			}
		}
	}
	return	True ;
}

/*
 *(ؿ̾)
 *	virtual bool	GetPreeditAreaNeeded (XRectangle* pArea) const ;
 *()
 *	ɬפȤ Preedit Area 礭򤳤֤ʤФʤʤ
 *	ɤ٤οͤʤΤġ
 *	ޤͤƤޤ٤ʤΤĤȤ⤳ɬפ
 *	ǾͤƤޤ٤ʤΤġ
 */
Boolean
XIMInputContext_GetPreeditAreaNeeded (
	register XIMInputContext*	pThis,
	register XRectangle*		pRect)
{
	assert (pThis != NULL) ;
	assert (pRect != NULL) ;

	/*
	 *	RootWindowStyle ʤ PreeditArea ¸ߤʤΤǡAreaNeeded
	 *	֤ȤϤǤʤ
	 */
	if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditNothing)
		return	True ;

	/*
	 *	ɬפȤΰɤˤꤹ롣
	 */
	if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientAreaNeeded)) {
		/*
		 *	ɬפΰ褬׻Ƥ
		 *		뤤
		 *	ɬפΰ褬饤ȤꤵƤ
		 *	ˤϡοȤ
		 */
		memcpy (pRect, &pThis->m_ConvAttr.m_Preedit.m_areaNeeded, sizeof (XRectangle)) ;
	} else {
		/*
		 *	ɬפΰ襵Ϸ׻Ƥ餺οͤϥǤȤʤäƤ롣
		 */
		if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditArea){
			register int	nLineSpacing ;
			/*
			 *	PreeditArea 礭򤳤ǻꤹɬפ
			 *		⤷
			 *	ɬפ礭󥹤
			 *	ơɤ׵᤹٤ʤΤ
			 */
			nLineSpacing	= XIMInputContext_GetPreeditLineSpacing (pThis) ;
			if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusArea &&
				IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) &&
				IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAClientAreaNeeded)) {
				pRect->x		= 0 ;
				pRect->y		= 0 ;
				pRect->width	= pThis->m_ConvAttr.m_Status.m_areaNeeded.width ;
				pRect->height	= nLineSpacing ;
			} else {
				pRect->x		= 0 ;
				pRect->y		= 0 ;
				pRect->width	= nLineSpacing * 20 ;
				pRect->height	= nLineSpacing * 20 ;
			}
		} else {
			/*
			 *	OverTheSpot Style ξˤꤷʤġ
			 *	ɤ顢׵᤬뤳ȤϤʤ
			 */
			register Window		wndFocus ;
			wndFocus	= (pThis->m_wndFocus == None)? pThis->m_wndClient : pThis->m_wndFocus ;
			if (wndFocus != None){
				register Display*	pDisplay ;
				register Widget		wgClient ;
				Window			wndRoot ;
				int				iX, iY ;
				unsigned int	iWidth, iHeight, iBorder, iDepth ;

				wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
				pDisplay	= XtDisplay (wgClient) ;
				XGetGeometry (pDisplay, wndFocus, &wndRoot, &iX, &iY, &iWidth, &iHeight, &iBorder, &iDepth) ;
				pRect->x		= 0 ;
				pRect->y		= 0 ;
				pRect->width	= iWidth ;
				pRect->height	= iHeight ;
			} else {
				//	Focus, Client Window ʤ Area ҤͤƤޤäġ
				return	False ;
			}
		}
	}
	return	True ;
}

/*
 *(ؿ̾)
 *	virtual const XPoint	GetSpotLocation () const ;
 *()
 *	ߤ Composition Window ΰ֤֤
 *	 Attribute  Status ˤϤʤ
 */
Boolean
XIMInputContext_GetSpotLocation (
	register XIMInputContext*	pThis,
	register XPoint*			pPos)
{
	assert (pThis != NULL) ;
	assert (pPos  != NULL) ;
	/*
	 *	UIWindow  Text  Position 롣
	 *	RootWindowStyle ξˤ SpotLocation ϰ̣ʤ
	 *	XIMStyle & XIMPreeditPosition äˤϸ̤ȤȤ
	 */
	if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditPosition &&
		IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CASpotLocation)) {
		register XPoint*	pCurPos	= &pThis->m_ConvAttr.m_Preedit.m_spot ;
		pPos->x	= pCurPos->x ;
		pPos->y	= pCurPos->y ;
	} else {
		pPos->x	= 0 ;
		pPos->y	= 0 ;
	}
	return	True ;
} 

/*
 *(ؿ̾)
 *	virtual const Colormap&	GetPreeditColormap () const ;
 *()
 *	PreeditArea θߤ Colormap 롣
 *	ǥեȤΤȤʤ顢
 *		DefaultColormap (display, 0)
 *	ȤäƤ롣
 */
Colormap
XIMInputContext_GetPreeditColormap (
	register XIMInputContext*	pThis)
{
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAColormap))
		return	None ;
	return	pThis->m_ConvAttr.m_Preedit.m_colormap ;
}

/*
 *(ؿ̾)
 *	virtual const Colormap&	GetPreeditColormap () const ;
 *()
 *	PreeditArea  Standard Colormap 롣
 *	ǥեȤΤȤʤ顢
 *		DefaultColormap (display, 0)
 *	ȤäƤ롣
 */
Atom
XIMInputContext_GetPreeditStdColormap (
	register XIMInputContext*	pThis)
{
	return	pThis->m_atPStdColormap ;
}

unsigned long
XIMInputContext_GetPreeditForeground (
	register XIMInputContext*	pThis)
{
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAForegroundPixel)) {
		/* What to do? */
	}
	return	pThis->m_ConvAttr.m_Preedit.m_foreground ;
}

unsigned long
XIMInputContext_GetPreeditBackground (
	register XIMInputContext*	pThis)
{
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CABackgroundPixel)) {
		/* What to do? */
	}
	return	pThis->m_ConvAttr.m_Preedit.m_background ;
}

Pixmap
XIMInputContext_GetPreeditBackgroundPixmap (
	register XIMInputContext*	pThis)
{
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CABackgroundPixmap)) {
		/* What to do? */
	}
	return	pThis->m_ConvAttr.m_Preedit.m_pixBackground ;
}

const char*
XIMInputContext_GetPreeditFontSet (
	register XIMInputContext*	pThis)
{
	return	TVarbuffer_GetBuffer (&pThis->m_vbufPFontSetName) ;
}

int	
XIMInputContext_GetPreeditLineSpacing (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask))
		return	DEFAULT_XIM_PREEDIT_LINESPACING ;

	if (IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CALineSpacing)) 
		return	pThis->m_ConvAttr.m_Preedit.m_nLineSpacing ;

	if (!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAFont))
		return	DEFAULT_XIM_PREEDIT_LINESPACING ;

	return	TFontSet_GetHeight (&pThis->m_ConvAttr.m_Preedit.m_FontSet) ;
}

Cursor
XIMInputContext_GetPreeditCursor (
	register XIMInputContext*	pThis)
{
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CACursor)) {
	}
	return	pThis->m_ConvAttr.m_Preedit.m_cursor ;
}

/*
 *	Status ¦ Interface
 */
Boolean
XIMInputContext_SetStatusArea (
	register XIMInputContext*	pThis,
	register const XRectangle*	pRect)
{
	TConversionAttribute	ca ;

#if defined (DEBUG)
	fprintf (stderr, "XIMInputContext[%d]: SetStatusArea (%d, %d, %d, %d)\n",
			 pThis->m_woID,
			 pRect->x, pRect->y, pRect->width, pRect->height) ;
#endif

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAClientArea) ||
		!IS_AREA_EQUAL (pThis->m_ConvAttr.m_Status.m_area, *pRect)) {
		
		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAClientArea) ;
		pThis->m_ConvAttr.m_Status.m_area	=  *pRect ;

		if (pThis->m_wgTopFrame != NULL) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAStatusMask) ;
			SET_CONVATTR_STATUS_MASK (ca, CAClientArea) ;
			ca.m_Status.m_area		=  *pRect ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetStatusAreaNeeded (
	register XIMInputContext*	pThis,
	register const XRectangle*	pRect)
{
	/*	ClientAreaNeeded ȡClientArea Υ
	 *	ˤҤäѤ롣
	 */
#if defined (DEBUG)
	fprintf (stderr, "XIMInputContext[%d]: SetStatusAreaNeeded (%d, %d, %d, %d)\n",
			 pThis->m_woID,
			 pRect->x, pRect->y, pRect->width, pRect->height) ;
#endif
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAClientAreaNeeded) ||
		!IS_AREA_EQUAL (pThis->m_ConvAttr.m_Status.m_areaNeeded, *pRect)) {

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAClientAreaNeeded) ;
		pThis->m_ConvAttr.m_Status.m_areaNeeded	= *pRect ;
	}
	return	True ;
}

Boolean
XIMInputContext_SetStatusColormap (
	register XIMInputContext*	pThis,
	register Colormap			colormap)
{
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAColormap) ||
		pThis->m_ConvAttr.m_Status.m_colormap != colormap) {
		TConversionAttribute	ca ;

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAColormap) ;
		pThis->m_ConvAttr.m_Status.m_colormap	= colormap ;

		if (pThis->m_wgTopFrame) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAStatusMask) ;
			SET_CONVATTR_STATUS_MASK (ca, CAColormap) ;
			ca.m_Status.m_colormap	= colormap ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
		if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusArea &&
			pThis->m_wgTopMinibufFrame != NULL &&
			pThis->m_wgTopFrame != pThis->m_wgTopMinibufFrame) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAColormap) ;
			ca.m_Preedit.m_colormap	= colormap ;
			TFrame_SetAttribute (pThis->m_wgTopMinibufFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetStatusStdColormap (
	register XIMInputContext*	pThis,
	register Atom				atStdColormap)
{
	register Widget		gw			= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	register Display*	pDisplay	= XtDisplay (gw) ;
	register Window		wndFocus ;
	XStandardColormap*	pStdColormap ;
	int					nCount ;

#if defined (DEBUG) || 0
	fprintf (stderr, "XIMInputContext_SetStatusStdColormap (%p, %lx)\n",
					 pThis, atStdColormap) ;
#endif

	if (atStdColormap == None) 
		return	False ;

	wndFocus	= pThis->m_wndClient ;
	if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAFocusWindow))
		wndFocus	= pThis->m_ConvAttr.m_wndFocus ;
	if (wndFocus == None)
		return	False ;

	if (!XGetRGBColormaps (pDisplay, wndFocus, &pStdColormap, &nCount, atStdColormap))
		return	False ;

	pThis->m_atSStdColormap	= atStdColormap ;

	/*	ɸǤʤ colormap ƤƤСǽʬ*/
	if ((!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		 !IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAColormap)) &&
		nCount > 0) {
		register Colormap	colormap	= pStdColormap->colormap ;
		pThis->m_ConvAttr.m_Status.m_colormap	= colormap ;

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAColormap) ;

		if (pThis->m_wgTopFrame) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAStatusMask) ;
			SET_CONVATTR_STATUS_MASK (ca, CAColormap) ;
			ca.m_Status.m_colormap	= colormap ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ; 
}

Boolean
XIMInputContext_SetStatusForeground (
	register XIMInputContext*	pThis,
	register unsigned long		ulForeground)
{
	assert (pThis != NULL) ;

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAForegroundPixel) ||
		pThis->m_ConvAttr.m_Status.m_foreground != ulForeground) {
		TConversionAttribute	ca ;

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAForegroundPixel) ;
		pThis->m_ConvAttr.m_Status.m_foreground	= ulForeground ;

		if (pThis->m_wgTopFrame != NULL) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAStatusMask) ;
			SET_CONVATTR_STATUS_MASK (ca, CAForegroundPixel) ;
			ca.m_Status.m_foreground	= ulForeground ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
		if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusArea &&
			pThis->m_wgTopMinibufFrame != NULL &&
			pThis->m_wgTopFrame != pThis->m_wgTopMinibufFrame) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAForegroundPixel) ;
			ca.m_Preedit.m_foreground	= ulForeground ;
			TFrame_SetAttribute (pThis->m_wgTopMinibufFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetStatusBackground (
	register XIMInputContext*	pThis,
	register unsigned long		ulBackground)
{
	assert (pThis != NULL) ;

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CABackgroundPixel) ||
		pThis->m_ConvAttr.m_Status.m_background != ulBackground) {
		TConversionAttribute	ca ;

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CABackgroundPixel) ;
		pThis->m_ConvAttr.m_Status.m_background	= ulBackground ;

		if (pThis->m_wgTopFrame != NULL) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAStatusMask) ;
			SET_CONVATTR_STATUS_MASK (ca, CABackgroundPixel) ;
			ca.m_Status.m_background	= ulBackground ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
		if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusArea &&
			pThis->m_wgTopMinibufFrame != NULL &&
			pThis->m_wgTopFrame != pThis->m_wgTopMinibufFrame) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CABackgroundPixel) ;
			ca.m_Preedit.m_background	= ulBackground ;
			TFrame_SetAttribute (pThis->m_wgTopMinibufFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetStatusBackgroundPixmap (
	register XIMInputContext*	pThis,
	register Pixmap				pixmap)
{
	assert (pThis != NULL) ;
	return	True ;
}

/*	Status ΰϺϲ⤷ƤʤΤԲǽ
 */
Boolean
XIMInputContext_SetStatusFontSet (
	register XIMInputContext*	pThis,
	register const char*		pBaseName,
	register int				nBaseNameLength)
{
	register const char*	pSFontSetName ;
	register int			nSFontSetName ;

	pSFontSetName	= TVarbuffer_GetBuffer (&pThis->m_vbufSFontSetName) ;
	nSFontSetName	= TVarbuffer_GetUsage  (&pThis->m_vbufSFontSetName) - 1 ;

	assert (pThis != NULL) ;

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAFont) ||
		nSFontSetName != nBaseNameLength ||
		strncmp (pSFontSetName, pBaseName, nSFontSetName) != 0) {
		register Display*		pDisplay ;
		register Widget			wgClient ;
		register const char*	pFontSetName ;
		register TConversionAttribute*	pCA ;
		TConversionAttribute	ca ;

		/*	եȤѹɬפ롣*/
		TVarbuffer_Clear (&pThis->m_vbufSFontSetName) ;
		TVarbuffer_Add (&pThis->m_vbufSFontSetName, pBaseName, nBaseNameLength) ;
		TVarbuffer_Add (&pThis->m_vbufSFontSetName, "\0", 1) ;

		pFontSetName	= TVarbuffer_GetBuffer (&pThis->m_vbufSFontSetName) ;
		assert (pThis->m_pInputMethod != NULL) ;
		wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
		assert (wgClient != NULL) ;
		pDisplay		= XtDisplay (wgClient) ;
		pCA				= &pThis->m_ConvAttr ;
#if defined (DEBUG) || 0
		fprintf (stderr, "StatusFontSet => \"%s\"\n", pFontSetName) ;
#endif
		TFontSet_Load (pDisplay, &pCA->m_Status.m_FontSet, pFontSetName, False) ;

		if (pThis->m_wgTopFrame != NULL) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
			SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAFont) ;
			TFontSet_Copy (&ca.m_Status.m_FontSet, &pCA->m_Status.m_FontSet) ;
			TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
		if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusArea &&
			pThis->m_wgTopMinibufFrame != NULL &&
			pThis->m_wgTopFrame != pThis->m_wgTopMinibufFrame) {
			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAFont) ;
			TFontSet_Copy (&ca.m_Preedit.m_FontSet, &pCA->m_Status.m_FontSet) ;
			TFrame_SetAttribute (pThis->m_wgTopMinibufFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAFont) ;

		/*	եȤѹ line-spacing ξ̵ˤʤ롣*/
		UNSET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CALineSpacing) ;
	}
	return	True ;
}

Boolean
XIMInputContext_SetStatusLineSpacing (
	register XIMInputContext*	pThis,
	register int				nLineSpacing)
{
	assert (pThis != NULL) ;
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CALineSpacing) ||
		pThis->m_ConvAttr.m_Status.m_nLineSpacing != nLineSpacing) {

		SET_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CALineSpacing) ;
		pThis->m_ConvAttr.m_Status.m_nLineSpacing	= nLineSpacing ;

		if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusArea &&
			pThis->m_wgTopMinibufFrame != NULL &&
			pThis->m_wgTopFrame != pThis->m_wgTopMinibufFrame) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CALineSpacing) ;
			ca.m_Status.m_nLineSpacing	= nLineSpacing ;
			TFrame_SetAttribute (pThis->m_wgTopMinibufFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	return	True ;
}

Boolean
XIMInputContext_SetStatusCursor (
	register XIMInputContext*	pThis,
	register Cursor				cursor)
{
	assert (pThis != NULL) ;
	return	True ;
}

/*
 *(ؿ̾)
 *	virtual bool	GetStatusArea (XRectangle* pArea) const ;
 *()
 *	Preedt Area 礭֤
 *	Client Window ꥵȯԤƤʤ Status Area
 *	θߤ礭ĤȤϤǤʤ
 *	Ĥɤ褹٤(⤽ꥵäñ
 *	ΰ򹭤ʤ⤢)
 */
Boolean
XIMInputContext_GetStatusArea (
	register XIMInputContext*	pThis,
	register XRectangle*		pRect)
{
	assert (pThis != NULL) ;
	assert (pRect != NULL) ;
	if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusNothing)
		return	False ;

	if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) &&
		IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientArea)) {
		memcpy (pRect, &pThis->m_ConvAttr.m_Status.m_area, sizeof (XRectangle)) ;
	} else {
		if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusArea &&
			IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientAreaNeeded)) {
			memcpy (pRect, &pThis->m_ConvAttr.m_Status.m_areaNeeded, sizeof (XRectangle)) ;
		} else {
			register int	nLineSpacing ;

			pRect->x	= 0 ;
			pRect->y	= 0 ;
			nLineSpacing	= XIMInputContext_GetStatusLineSpacing (pThis) ;
			if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditPosition){
				/*	⤽ line spacing äꤵƤʤ顢Ͻ
				 *	ɬפ롣*/
				pRect->width	= nLineSpacing * 80 / 2 ;
			} else {
				pRect->width	= nLineSpacing * 7 / 2 ;
			}
			pRect->height	= nLineSpacing ;
		}
	}
	return	True ;
}

/*
 *(ؿ̾)
 *	virtual bool	GetStatusAreaNeeded (XRectangle* pArea) const ;
 *()
 *	ɬפȤ Status Area 礭򤳤֤ʤФʤʤ
 *	ɤ٤οͤʤΤġ
 *	ޤͤƤޤ٤ʤΤĤȤ⤳ɬפ
 *	ǾͤƤޤ٤ʤΤġ
 */
Boolean
XIMInputContext_GetStatusAreaNeeded (
	register XIMInputContext*	pThis,
	register XRectangle*		pRect)
{
	assert (pThis != NULL) ;
	if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusNothing)
		return	False ;
	if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) &&
		IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAClientAreaNeeded)) {
		memcpy (pRect, &pThis->m_ConvAttr.m_Status.m_areaNeeded, sizeof (XRectangle)) ;
	} else {
		register int	nLineSpacing ;
		pRect->x		= 0 ;
		pRect->y		= 0 ;
		nLineSpacing	= XIMInputContext_GetStatusLineSpacing (pThis) ;
		if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditPosition){
			pRect->width	= nLineSpacing * 80 / 2 ;
		} else {
			pRect->width	= nLineSpacing * 7 / 2 ;
		}
		pRect->height	= nLineSpacing ;
	}
	return	True ;
}

/*
 *(ؿ̾)
 *	virtual const Colormap&	GetStatusColormap () const ;
 *()
 *	StatusArea θߤ Colormap 롣
 *	ǥեȤΤȤʤ顢
 *		DefaultColormap (display, 0)
 *	ȤäƤ롣
 */
Colormap
XIMInputContext_GetStatusColormap (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask) ||
		!IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CAColormap))
		return	None ;
	return	pThis->m_ConvAttr.m_Status.m_colormap ;
}

/*
 *(ؿ̾)
 *	virtual const Colormap&	GetStatusColormap () const ;
 *()
 *	StatusArea  Standard Colormap 롣
 *	ǥեȤΤȤʤ顢
 *		DefaultColormap (display, 0)
 *	ȤäƤ롣
 */
Atom
XIMInputContext_GetStatusStdColormap (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	pThis->m_atSStdColormap ;
}

unsigned long
XIMInputContext_GetStatusForeground (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	pThis->m_ConvAttr.m_Status.m_foreground ;
}

unsigned long
XIMInputContext_GetStatusBackground (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	pThis->m_ConvAttr.m_Status.m_background ;
}

Pixmap
XIMInputContext_GetStatusBackgroundPixmap (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	pThis->m_ConvAttr.m_Status.m_pixBackground ;
}

const char*
XIMInputContext_GetStatusFontSet (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;
	return	TVarbuffer_GetBuffer (&pThis->m_vbufSFontSetName) ;
}

/*
 *
 */
int
XIMInputContext_GetStatusLineSpacing (
	register XIMInputContext*	pThis)
{
	assert (pThis != NULL) ;

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask))
		return	DEFAULT_XIM_STATUS_LINESPACING ;

	if (IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CALineSpacing)) 
		return	pThis->m_ConvAttr.m_Status.m_nLineSpacing ;

	if (!IS_CONVATTR_STATUS_MASK (pThis->m_ConvAttr, CAFont))
		return	DEFAULT_XIM_STATUS_LINESPACING ;

	return	TFontSet_GetHeight (&pThis->m_ConvAttr.m_Status.m_FontSet) ;
}

Cursor
XIMInputContext_GetStatusCursor (
	register XIMInputContext*	pThis)
{
	return	pThis->m_ConvAttr.m_Status.m_cursor ;
}

Boolean
XIMInputContext_SetPreeditAttributes (
	register XIMInputContext*	pThis)
{
	TConversionAttribute	ca ;

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask))
		return	True ;

	/*	ϾľɬפʡConversionAttribute 
	 *	 copy ؿѰդ٤*/
	TConvAttr_Initialize (&ca) ;
	TConvAttr_Copy (&ca, &pThis->m_ConvAttr) ;
	CLR_CONVATTR_MASK (ca) ;
	SET_CONVATTR_MASK (ca, CAPreeditMask) ;
	TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
	TConvAttr_Uninitialize (&ca) ;
	return	True ;
}

Boolean
XIMInputContext_SetStatusAttributes (
	register XIMInputContext*	pThis)
{
	TConversionAttribute	ca ;

	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAStatusMask))
		return	True ;

	/*	ϾľɬפʡConversionAttribute 
	 *	 copy ؿѰդ٤*/
	TConvAttr_Initialize (&ca) ;
	TConvAttr_Copy (&ca, &pThis->m_ConvAttr) ;
	CLR_CONVATTR_MASK (ca) ;
	SET_CONVATTR_MASK (ca, CAStatusMask) ;
	TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
	TConvAttr_Uninitialize (&ca) ;
	return	True ;
}

Boolean
XIMInputContext_Activate (
	register XIMInputContext*		pThis,
	register Boolean				fActive)
{
	assert (pThis != NULL) ;
	assert (pThis->m_wgTopFrame != NULL) ;

	TLispClient_Activate (&pThis->m_LispClient, fActive) ;
	if (fActive)
		TLispClient_SetModificationFlag (&pThis->m_LispClient, True) ;
	return	True ;
}

Boolean
ximInputContext_createFrame (
	register XIMInputContext*	pThis)
{
	register Widget	wgTop, wgFrame ;
	register Window	wndFocus ;
	Widget			wgMinibufFrame ;
	Arg				rArg [12] ;
	register int	nArg ;

	nArg		= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged,	False) ; nArg ++ ;
	XtSetArg (rArg [nArg], XtNclientWindow,			pThis->m_wndClient) ; nArg ++ ;
	if (!IS_CONVATTR_MASK (pThis->m_ConvAttr, CAFocusWindow)) {
		wndFocus	= pThis->m_wndClient ;
	} else {
		wndFocus	= pThis->m_ConvAttr.m_wndFocus ;
	}
	XtSetArg (rArg [nArg], XtNfocusWindow,	wndFocus) ; nArg ++ ;
	XtSetArg (rArg [nArg], XtNinput,		False) ;	nArg ++ ;

	wgTop	= AfxGetToplevelWidget () ;
	switch (pThis->m_dwInputStyle & XIMPreeditMask) {
	case	XIMPreeditPosition:
		wgFrame	= TOverTheSpotWindowFrame_Create (wgTop, rArg, nArg) ;
		break ;
	case	XIMPreeditArea:
		wgFrame	= TOffTheSpotWindowFrame_Create (wgTop, rArg, nArg) ;
		break ;
	case	XIMPreeditCallbacks:
		wgFrame	= TOnTheSpotWindowFrame_Create (wgTop, rArg, nArg) ;
		break ;
	case	XIMPreeditNothing:
	case	XIMPreeditNone:
	default:
		wgFrame	= TRootWindowFrame_Create (wgTop, rArg, nArg) ;
		break ;
	}
	if (wgFrame == NULL)
		return	False ;
	
	pThis->m_wgTopFrame	= wgFrame ;

	if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (pThis->m_ConvAttr, CASpotLocation)) {
		TConversionAttribute	ca ;

		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CASpotLocation) ;
		memcpy (&ca.m_Preedit.m_spot, &pThis->m_ConvAttr.m_Preedit.m_spot, sizeof (XPoint)) ;
		TFrame_SetAttribute (pThis->m_wgTopFrame, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	XIMInputContext_SetPreeditAttributes (pThis) ;
	XIMInputContext_SetStatusAttributes  (pThis) ;

	ximInputContext_addFrameCallbacks (pThis, wgFrame) ;
	XtRealizeWidget (wgFrame) ;

	wgMinibufFrame	= NULL ;
	XtVaGetValues (wgFrame, XtNminibufFrame, &wgMinibufFrame, NULL) ;
#if defined (DEBUG)
	fprintf (stderr, "Frame(%p), MinibufFrame(%p)\n", wgFrame, wgMinibufFrame) ;
#endif
	if (wgMinibufFrame != NULL && wgMinibufFrame != wgFrame) {
		ximInputContext_addFrameCallbacks (pThis, wgMinibufFrame) ;
#if defined (DEBUG)
		fprintf (stderr, "MinibufFrame(%p, %d)\n",
				 wgMinibufFrame, XtIsRealized (wgMinibufFrame)) ;
#endif
		XtRealizeWidget (wgMinibufFrame) ;
	}
	pThis->m_wgTopMinibufFrame	= wgMinibufFrame ;

	ximInputContext_initializeLispPart (pThis, wgFrame, wgMinibufFrame) ;
	XFlush (XtDisplay (wgFrame)) ;
	return	True ;
}

Boolean
ximInputContext_initializeLispPart (
	register XIMInputContext*	pThis,
	register Widget				wgFrame,
	register Widget				wgMinibufFrame)
{
	register TLispClient*	pLispClient ;
	register Widget			wgClient ;
	Widget					wgProtocol ;
	Arg						rArg [1] ;
	TLispMachine*			pTopLM ;
	TLispClientArg			arg ;

	wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	XtSetArg (rArg [0], XtNprotocolWidget, &wgProtocol) ;
	XtGetValues (wgClient, rArg, 1) ;
	assert (wgProtocol != NULL) ;
	
	XtSetArg (rArg [0], XtNlispMachine, &pTopLM) ;
	XtGetValues (wgProtocol, rArg, 1) ;
	assert (pTopLM != NULL) ;
	
	pLispClient				= &pThis->m_LispClient ;
	arg.m_pLispMgr			= TLispMachine_GetLispManager (pTopLM) ;
	arg.m_pLM				= pTopLM ;
	arg.m_wgFrame			= wgFrame ;
	arg.m_wgMinibufFrame	= wgMinibufFrame ;
	arg.m_pKeyNotify		= &ximInputContext_onKeyNotify ;
	arg.m_pTextNotify		= &ximInputContext_onTextNotify ;
	arg.m_pEndNotify		= &ximInputContext_onEndNotify ;
	arg.m_pvClient			= pThis ;
	return	TLispClient_Initialize (pLispClient, &arg) ;
}

/*	XIM_COMMIT ΥѥåƱΤϢ뤹ΤԤΥѥåȤ
 *	ĤʤǤϤʤĤʤȡֲԡפʤʤΤǡ
 *	Spool ʳǡֲԡפΤߤΥѥåȤ虜虜Ƥ롣
 */
Boolean
ximInputContext_packetToCombinep (
	register XIMPacket*			pPacket)
{
	XIMData					imData ;
	int						nMajor ;
	register unsigned int	uBitMask ;

	assert (pPacket != NULL) ;

	XIMPacket_GetHeader (pPacket, &nMajor, NULL) ;
	if (nMajor != XIM_COMMIT) 
		return	False ;
	XIMData_Initialize (&imData, XIMPacket_GetData (pPacket), XIMPacket_GetEndian (pPacket)) ;
	XIMData_Forward8  (&imData, XIM_HEADER_SIZE + 2 + 2) ;
	uBitMask	= XIMData_GetCard16 (&imData) ;
	return	(uBitMask & 4)? False : True ;
}

XIMPacket*
ximInputContext_combineXimCommit (
	register XIMInputContext*	pThis,
	register XIMPacket*			pSrcPacket1,
	register XIMPacket*			pSrcPacket2)
{
	register XIMPacket*	pPacket ;
	XIMData			imSrc ;
	register int	nctext, nctotal, nIndex ;
	CARD16			uMask ;

	assert (pThis != NULL) ;
	assert (pSrcPacket1 != NULL) ;
	assert (pSrcPacket2 != NULL) ;

	pPacket	= XIMPacket_Create (XIMPacket_GetEndian (pSrcPacket1)) ;
	if (pPacket == NULL)
		return	NULL ;
#if defined (DEBUG)
	fprintf (stderr, "Combine X_COMMIT\n") ;
	fprintf (stderr, "Packet1:\n") ;
	XIMPacket_Show (pSrcPacket1) ;
	fprintf (stderr, "Packet2:\n") ;
	XIMPacket_Show (pSrcPacket2) ;
#endif
	XIMPacket_SetHeader (pPacket, XIM_COMMIT, 0) ;
	XIMPacket_AddCard16 (pPacket, XIMInputMethod_GetID  (pThis->m_pInputMethod)) ;
	XIMPacket_AddCard16 (pPacket, XIMInputContext_GetID (pThis)) ;
	XIMPacket_SetInputContext (pPacket, pThis) ;
	XIMPacket_SetSyncMode  (pPacket, XIMPacket_GetSyncMode (pSrcPacket1)) ;
	XIMPacket_GetCard16    (pSrcPacket1, XIM_HEADER_SIZE + 2 + 2, &uMask) ;
	XIMPacket_AddBitmask16 (pPacket, uMask) ;
	nIndex	= XIMPacket_GetDataSize (pPacket) ;
	XIMPacket_AddCard16 (pPacket, 0 /* dummy */) ;

	XIMData_Initialize (&imSrc, XIMPacket_GetData (pSrcPacket1), XIMPacket_GetEndian (pSrcPacket1)) ;
	XIMData_Forward8  (&imSrc, XIM_HEADER_SIZE) ;
	XIMData_Forward16 (&imSrc, 3 /* IMID + IMIC + Bitmask16 */) ;
	nctext	= XIMData_GetCard16 (&imSrc) ;
	nctotal	= nctext ;
	XIMPacket_AddString8 (pPacket, XIMData_GetHead (&imSrc), nctext) ;

	XIMData_Initialize (&imSrc, XIMPacket_GetData (pSrcPacket2), XIMPacket_GetEndian (pSrcPacket2)) ;
	XIMData_Forward8  (&imSrc, XIM_HEADER_SIZE) ;
	XIMData_Forward16 (&imSrc, 3 /* IMID + IMIC + Bitmask16 */) ;
	nctext	= XIMData_GetCard16 (&imSrc) ;
	nctotal	+= nctext ;
	XIMPacket_AddString8 (pPacket, XIMData_GetHead (&imSrc), nctext) ;
	XIMPacket_AddPad (pPacket, nctotal) ;
	XIMPacket_SetCard16 (pPacket, nIndex, nctotal) ;
	XIMPacket_SetLength (pPacket) ;
#if defined (DEBUG)
	fprintf (stderr, "Result Packet:\n") ;
	XIMPacket_Show (pPacket) ;
#endif
	return	pPacket ;
}

void
ximInputContext_addFrameCallbacks (
	register XIMInputContext*	pThis,
	register Widget				wgFrame)
{
	assert (pThis != NULL) ;
	assert (wgFrame != NULL) ;

	XtAddCallback (wgFrame, XtNkeyPressCallback,	ximInputContext_onKeyPress,		(XtPointer)pThis) ;
	XtAddCallback (wgFrame, XtNconfigureCallback,	ximInputContext_onFrameConfigure,	(XtPointer)pThis) ;
	XtAddCallback (wgFrame, XtNdestroyCallback,		ximInputContext_onFrameDestroy,	(XtPointer)pThis) ;

	if (XtIsSubclass (wgFrame, tonTheSpotWindowWidgetClass)) {
		if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditCallbacks) {
			XtAddCallback (wgFrame, XtNpreeditStartCallback, ximInputContext_onPreeditStart, (XtPointer) pThis) ;
			XtAddCallback (wgFrame, XtNpreeditDrawCallback,  ximInputContext_onPreeditDraw,  (XtPointer) pThis) ;
			XtAddCallback (wgFrame, XtNpreeditCaretCallback, ximInputContext_onPreeditCaret, (XtPointer) pThis) ;
			XtAddCallback (wgFrame, XtNpreeditDoneCallback,  ximInputContext_onPreeditDone,  (XtPointer) pThis) ;
		}
		if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusCallbacks) {
			XtAddCallback (wgFrame, XtNstatusStartCallback, ximInputContext_onStatusStart, (XtPointer) pThis) ;
			XtAddCallback (wgFrame, XtNstatusDrawCallback,  ximInputContext_onStatusDraw,  (XtPointer) pThis) ;
			XtAddCallback (wgFrame, XtNstatusDoneCallback,  ximInputContext_onStatusDone,  (XtPointer) pThis) ;
		}
	}
	return ;
}

void
ximInputContext_removeFrameCallbacks (
	register XIMInputContext*	pThis,
	register Widget				wgFrame)
{
	XtRemoveAllCallbacks (wgFrame, XtNkeyPressCallback) ;
	XtRemoveAllCallbacks (wgFrame, XtNconfigureCallback) ;
	XtRemoveAllCallbacks (wgFrame, XtNdestroyCallback) ;

	if (XtIsSubclass (wgFrame, tonTheSpotWindowWidgetClass)) {
		if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditCallbacks) {
			XtRemoveAllCallbacks (wgFrame, XtNpreeditStartCallback) ;
			XtRemoveAllCallbacks (wgFrame, XtNpreeditDrawCallback) ;
			XtRemoveAllCallbacks (wgFrame, XtNpreeditCaretCallback) ;
			XtRemoveAllCallbacks (wgFrame, XtNpreeditDoneCallback) ;
		}
		if ((pThis->m_dwInputStyle & XIMStatusMask) == XIMStatusCallbacks) {
			XtRemoveAllCallbacks (wgFrame, XtNstatusStartCallback) ;
			XtRemoveAllCallbacks (wgFrame, XtNstatusDrawCallback) ;
			XtRemoveAllCallbacks (wgFrame, XtNstatusDoneCallback) ;
		}
	}
	return ;
}

void
ximInputContext_onKeyPress (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext *) closure ;
	
	TLispMachine_EventProc (pThis->m_LispClient.m_pLM, LMEVENT_KEYPRESS, call_data, 0) ;
	TLispClient_SetModificationFlag (&pThis->m_LispClient, True) ;
	return ;
}

void
ximInputContext_onFrameConfigure (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext *) closure ;
	TLispEntity*	pEntFrame	= NULL ;
	
#if defined (DEBUG)
	fprintf (stderr, "ximInputContext_onFrameConfigure(%p): destroyed.\n", wgFrame) ;
#endif
	pEntFrame	= TFrame_GetLispFrameObject (wgFrame) ;
	assert (pEntFrame != NULL) ;
	TLispMachine_EventProc (pThis->m_LispClient.m_pLM, LMEVENT_FRAMERESIZE, pEntFrame, call_data) ;
	TLispClient_SetModificationFlag (&pThis->m_LispClient, True) ;

#if 0
	/*	XIM_GEOMETRY 롣Υߥ󥰤ɤΤ*/
	if ((pThis->m_dwInputStyle) & XIMPreeditMask == XIMPreeditArea ||
		(pThis->m_dwInputStyle) & XIMStatusMask  == XIMStatusArea) {
		register Widget		wgClient ;
		register int		nMethodId ;

		wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
		nMethodId	= XIMInputMethod_GetID     (pThis->m_pInputMethod) ;
		XIMClient_WriteXimGeomtery (wgClient, nMethodId, pThis->m_woID) ;
	}
#endif
	return ;
}

void
ximInputContext_onFrameDestroy (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext *) closure ;
#if defined (DEBUG)
	fprintf (stderr, "ximInputContext_onFrameDestroy(%p): destroyed.\n", wgFrame) ;
#endif
	ximInputContext_removeFrameCallbacks (pThis, wgFrame) ;
	if (wgFrame == pThis->m_wgTopFrame) 
		pThis->m_wgTopFrame	= NULL ;
	if (wgFrame == pThis->m_wgTopMinibufFrame) 
		pThis->m_wgTopMinibufFrame	= NULL ;
	/*	ȤԲǽˤʤäƤ뤳ȤϿ롣*/
	pThis->m_fDestroy	= True ;
	return ;
}

void
ximInputContext_onPreeditStart (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext*) closure ;
	register Widget				wgClient ;
	register int				nInputMethodID ;

	assert (wgFrame != NULL) ;
	assert (pThis   != NULL) ;

#if defined (DEBUG) || 0
	fprintf (stderr, "ximInputContext_onPreeditStart (%p, %p, %p)\n",
			 wgFrame, closure, call_data) ;
#endif
	wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	nInputMethodID	= XIMInputMethod_GetID (pThis->m_pInputMethod) ;
	XIMClient_WritePreeditStart (wgClient, nInputMethodID, pThis) ;
	return ;
}

void
ximInputContext_onPreeditDraw (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext*) closure ;
	register Widget				wgClient ;
	register int				nInputMethodID ;
	register const TOnTheSpotDrawArg*	pArg ;

	assert (wgFrame != NULL) ;
	assert (pThis   != NULL) ;

#if defined (DEBUG) || 0
	fprintf (stderr, "ximInputContext_onPreeditDraw (%p, %p, %p)\n",
			 wgFrame, closure, call_data) ;
#endif

	wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	pArg			= (const TOnTheSpotDrawArg *)call_data ;
	assert (wgClient != NULL) ;
	assert (pArg     != NULL) ;
	nInputMethodID	= XIMInputMethod_GetID (pThis->m_pInputMethod) ;
	XIMClient_WritePreeditDraw (wgClient, nInputMethodID, pThis, pArg) ;
	return ;
}

void
ximInputContext_onPreeditCaret (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext*) closure ;
	register Widget				wgClient ;
	register int				nInputMethodID ;
	register const TOnTheSpotDrawArg*	pArg ;

	assert (wgFrame != NULL) ;
	assert (pThis   != NULL) ;

#if defined (DEBUG) || 0
	fprintf (stderr, "ximInputContext_onPreeditCaret (%p, %p, %p)\n",
			 wgFrame, closure, call_data) ;
#endif
	wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	pArg			= (const TOnTheSpotDrawArg *)call_data ;
	assert (wgClient != NULL) ;
	assert (pArg     != NULL) ;
	nInputMethodID	= XIMInputMethod_GetID (pThis->m_pInputMethod) ;
	XIMClient_WritePreeditCaret (wgClient, nInputMethodID, pThis, pArg) ;
	return ;
}

void
ximInputContext_onPreeditDone (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext*) closure ;
	register Widget				wgClient ;
	register int				nInputMethodID ;

	assert (wgFrame != NULL) ;
	assert (pThis   != NULL) ;

#if defined (DEBUG) || 0
	fprintf (stderr, "ximInputContext_onPreeditDone (%p, %p, %p)\n",
			 wgFrame, closure, call_data) ;
#endif
	wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	nInputMethodID	= XIMInputMethod_GetID (pThis->m_pInputMethod) ;
	XIMClient_WritePreeditDone (wgClient, nInputMethodID, pThis) ;
	return ;
}

void
ximInputContext_onStatusStart (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext*) closure ;
	register Widget				wgClient ;
	register int				nInputMethodID ;

	assert (wgFrame != NULL) ;
	assert (pThis   != NULL) ;

	wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	nInputMethodID	= XIMInputMethod_GetID (pThis->m_pInputMethod) ;
	XIMClient_WriteStatusStart (wgClient, nInputMethodID, pThis) ;
	return ;
}

void
ximInputContext_onStatusDraw (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext*) closure ;
	register Widget				wgClient ;
	register int				nInputMethodID ;
	register const TOnTheSpotDrawArg*	pArg ;

	assert (wgFrame != NULL) ;
	assert (pThis   != NULL) ;

	wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	pArg			= (const TOnTheSpotDrawArg *)call_data ;
	assert (wgClient != NULL) ;
	assert (pArg     != NULL) ;
	nInputMethodID	= XIMInputMethod_GetID (pThis->m_pInputMethod) ;
	XIMClient_WriteStatusDraw (wgClient, nInputMethodID, pThis, pArg) ;
	return ;
}

void
ximInputContext_onStatusDone (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register XIMInputContext*	pThis	= (XIMInputContext*) closure ;
	register Widget				wgClient ;
	register int				nInputMethodID ;

	assert (wgFrame != NULL) ;
	assert (pThis   != NULL) ;

	wgClient		= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	nInputMethodID	= XIMInputMethod_GetID (pThis->m_pInputMethod) ;
	XIMClient_WriteStatusDone (wgClient, nInputMethodID, pThis) ;
	return ;
}

void
ximInputContext_onKeyNotify (
	register void*			pvClient,
	register TXEvent*		pEv)
{
	register XIMInputContext*	pThis		= (XIMInputContext *)pvClient ;
	register Widget				wgClient ;
	register Display*			pDisplay ;
	register Window				wndFocus ;
	register Char				cc ;
	Window						wndRoot, wndChild ;
	int							nRootX, nRootY, nX, nY ;
	unsigned int				uKeyCode, uState, uMask ;
	XEvent						ev ;
	struct timeval				t ;
	struct timezone				tz ;

	wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	pDisplay	= XtDisplay (wgClient) ;

	if (!pEv->m_fChar) {
		XIMClient_ForwardEvent (wgClient, pThis->m_pInputMethod, pThis, (XEvent *)pEv->u.m_pEv) ;
		return ;
	}
	cc	= pEv->u.m_ch ;

	if (pThis->m_wndKeyFocus != None) {
		wndFocus	= pThis->m_wndKeyFocus ;
	} else {
		if (IS_CONVATTR_MASK (pThis->m_ConvAttr, CAFocusWindow)) {
			wndFocus	= pThis->m_ConvAttr.m_wndFocus ;
		} else {
			wndFocus	= pThis->m_wndClient ;
		}
	}
	/*	Ʊ Screen ̵ˤϸ㲽ġ*/
	if (!XQueryPointer (pDisplay, wndFocus, &wndRoot, &wndChild, &nRootX, &nRootY, &nX, &nY, &uMask))
		return ;
	
	if (TFAILED (cchar2keycode (pDisplay, cc, &uKeyCode, &uState))) {
		Char	ch	= cc ;
		/*	Guess ˼Ԥˤ key-event Ȥ뤳Ȥ
		 *	ǤʤƥȤȤФ롣*/
		ximInputContext_onTextNotify (pvClient, &ch, 1) ;
		return ;
	}
	gettimeofday (&t, &tz) ;
	ev.xkey.type		= KeyPress ;
	ev.xkey.serial		= 0 ;
	ev.xkey.send_event	= False ;
	ev.xkey.display		= pDisplay ;
	ev.xkey.window		= wndFocus ;
	ev.xkey.root		= wndRoot ;
	ev.xkey.subwindow	= wndChild ;
	ev.xkey.time		= (t.tv_sec * 1000) + t.tv_usec ;
	ev.xkey.x			= nX ;
	ev.xkey.y			= nY ;
	ev.xkey.x_root		= nRootX ;
	ev.xkey.y_root		= nRootY ;
	ev.xkey.state		= uState ;
	ev.xkey.keycode		= uKeyCode ;
	ev.xkey.same_screen	= True ;
	XIMClient_ForwardEvent (wgClient, pThis->m_pInputMethod, pThis, (XEvent *)&ev) ;
	return ;
}

/*
 * Kinput Protocol Ѵ׵ԤؤʸԤδؿ
 *-----
 * ʸ SkkInputWidget ƽФ뤿ᡢcallbackηˤʤ
 * Ƥ롣Ͻ;ϤäѤ뤱ɡĤޤ괺ư
 * ˤʤäƤľޤ
 */
void
ximInputContext_onTextNotify (
	register void*			pvClient,
	register const Char*	pText,
	register int			nText)
{
	register XIMInputContext*	pThis		= (XIMInputContext *)pvClient ;
	register Widget				wgClient ;

#if defined (DEBUG) || 0
	fprintf (stderr, "ximInputMethod_onTextNotify (%p, %p, %d)\n", pvClient, pText, nText) ;
#endif
	wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	if ((pThis->m_dwInputStyle & XIMPreeditMask) == XIMPreeditCallbacks &&
		pThis->m_wgTopFrame != NULL) {
		TFrame_Clear (pThis->m_wgTopFrame) ;
		TFrame_Flush (pThis->m_wgTopFrame) ;
	}
	XIMClient_CommitString (wgClient, pThis->m_pInputMethod, pThis, pText, nText) ;
	return ;
}					

void
ximInputContext_onEndNotify (
	register void*			pvClient)
{
	register XIMInputContext*	pThis		= (XIMInputContext *)pvClient ;
	register Widget				wgClient ;

#if defined (DEBUG) || 0
	fprintf (stderr, "ximInputMethod_onEndNotify (%p)\n", pvClient) ;
#endif
	wgClient	= XIMInputMethod_GetClient (pThis->m_pInputMethod) ;
	XIMClient_ControlEventFlow (wgClient, pThis->m_pInputMethod, pThis, False) ;

	XIMInputContext_EndConversion (pThis) ;
	return ;
}

