/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (TOnTheSpotWindowP_h)
#define	TOnTheSpotWindowP_h

#include "TFrameP.h"
#include "TOnTheSpotWindow.h"
#include "varbuffer.h"
#include "kanji.h"

typedef struct tagTOnTheSpotWindowPart {
	/*	for Popup Window 
	 */
	Window					m_wndClient ;

	/*	OnTheSpotWindow ͭ Callback 
	 */
	XtCallbackList			m_lstCbkPreeditStart ;
	XtCallbackList			m_lstCbkPreeditDraw ;
	XtCallbackList			m_lstCbkPreeditCaret ;
	XtCallbackList			m_lstCbkPreeditDone ;
	XtCallbackList			m_lstCbkStatusStart ;
	XtCallbackList			m_lstCbkStatusDone ;
	XtCallbackList			m_lstCbkStatusDraw ;

	/*	PreeditDraw Callback ֤ƥȤ caret ξ
	 */
	TVarbuffer				m_rvbufText [2] ;
	int						m_rnCaret [2] ;
	int						m_nTextPlane ;
	TVarbuffer				m_vbufModeline ;
	TVarbuffer				m_vbufAttribute ;

	/*	Minibuffer Terminal ϡOnTheSpotWindow ȰβƤ
	 *	ˤϡ Widget 뤳Ȥˤʤ뤬ǤʤʬΥ
	 *	ˤϡRootWindowWidget Ǻ뤳Ȥˤʤ롣
	 *	ξˤϡ̥ե졼Ȥƴ٤LispObject 
	 *	¸ʤ顢ǺäƤ⤤ɡġ
	 *
	 *	ޤΥե졼ʸɽƤʤä顢ä
	 *	褦ưʤȤʤδǤΤϡ
	 *	Lisp_Tick (ȤΤǡ
	 *	Minibuffer ξ֤ƻ뤹Ф)
	 */
	Widget					m_wgMinibuf ;

	Boolean					m_fActive ;
	Boolean					m_fPreeditActive ;

}	TOnTheSpotWindowPart ;

typedef struct tagTOnTheSpotWindowRec {
	CorePart				core ;
	CompositePart			composite ;
	ShellPart				shell ;
	TFramePart				tframe ;
	TOnTheSpotWindowPart	tonwin ;
}	TOnTheSpotWindowRec ;

typedef struct {
	int						dummy ;
}	TOnTheSpotWindowClassPart ;

typedef struct tagTOnTheSpotWindowClassRec {
	CoreClassPart				core_class ;
	CompositeClassPart			composite_class ;
	ShellClassPart				shell_class ;
	TFrameClassPart				tframe_class ;
	TOnTheSpotWindowClassPart	tonwin_class ;
}	TOnTheSpotWindowClassRec ;

extern TOnTheSpotWindowClassRec	tonTheSpotWindowClassRec ;

#endif

