/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (TOffTheSpotWindowP_h)
#define	TOffTheSpotWindowP_h

#include "TFrameP.h"
#include "TOffTheSpotWindow.h"
#include "varbuffer.h"
#include "TFontSet.h"

typedef struct tagTOffTheSpotWindowPart {
	Window					m_wndFocus ;
	Window					m_wndClient ;
	Pixel					m_pxlForeground ;
	String					m_strFontSet ;

	/*	Ѵȥӥ塼Ȥν͵ڤӸ͡
	 *
	 *	ͤѤʤʤˤϡͤͤ򥳥ԡ
	 *	Ѥ롣
	 */
	TConversionAttribute	m_caInitial ;
	TConversionAttribute	m_caCurrent ;

	/*	¾Ѵȥӥ塼ȡ
	 */
	XPoint					m_ptSpot ;
	XPoint					m_ptClient ;
	XPoint					m_ptFocus ;
	Boolean					m_fActive ;

	Widget					m_wgTerminal ;
	TFontSet				m_fsTerminal ;

	/*	Modeshell ꡣ
	 */
	TVarbuffer				m_vbufModeshellText ;
	Window					m_wndModeshell ;
	GC						m_gcModeshell ;
	TSize					m_szModeshell ;

	Widget					m_wgMinibuf ;
	TFontSet				m_fsMinibuf ;

	Boolean					m_fDestroy ;
}	TOffTheSpotWindowPart ;

typedef struct tagTOffTheSpotWindowRec {
	CorePart				core ;
	CompositePart			composite ;
	ShellPart				shell ;
	TFramePart				tframe ;
	TOffTheSpotWindowPart	toffwin ;
}	TOffTheSpotWindowRec ;

typedef struct {
	int						dummy ;
}	TOffTheSpotWindowClassPart ;

typedef struct tagTOffTheSpotWindowClassRec {
	CoreClassPart				core_class ;
	CompositeClassPart			composite_class ;
	ShellClassPart				shell_class ;
	TFrameClassPart				tframe_class ;
	TOffTheSpotWindowClassPart	toffwin_class ;
}	TOffTheSpotWindowClassRec ;

extern TOffTheSpotWindowClassRec	toffTheSpotWindowClassRec ;

#endif

