/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include "TNormalFrameP.h"
#include "TTerminal.h"
#include "TConvAttr.h"

#define offset(field)	XtOffsetOf(TNormalFrameRec, tnormalframe.field)
#define goffset(field)	XtOffsetOf(WidgetRec, core.field )

static	XtResource	srNormalFrameResource []	= {
	{	XtNwidth,		XtCWidth,		XtRDimension,	sizeof (Dimension),
		goffset (width),			XtRImmediate,	(XtPointer) 640, },
	{	XtNheight,		XtCHeight,		XtRDimension,	sizeof (Dimension),
		goffset (height),			XtRImmediate,	(XtPointer) 48, },
	{	XtNbackground,	XtCBackground,	XtRPixel,		sizeof (Pixel),
		goffset (background_pixel),	XtRString,		XtDefaultBackground, },
#if 0
	{	XtNforeground,	XtCForeground,	XtRPixel,		sizeof (Pixel),
		offset (m_pxlForeground),	XtRString,		XtDefaultForeground, },
#endif
	{	XtNkeyPressCallback,	XtCCallback,	XtRCallback,	sizeof (XtCallbackList),
		offset (m_lstCbkKeyPress),	XtRCallback,	(XtPointer) NULL, },
	{	XtNconfigureCallback,	XtCCallback,	XtRCallback,	sizeof (XtCallbackList),
		offset (m_lstCbkConfigure),	XtRCallback,	(XtPointer) NULL, },
} ;

#undef	offset
#undef	goffset

static	void	tnormalFrame_onInitialize	(Widget, Widget, ArgList, Cardinal*) ;
static	void	tnormalFrame_onRealize		(Widget, XtValueMask*, XSetWindowAttributes*) ;
static	Boolean	tnormalFrame_onSetValues	(Widget, Widget, Widget, ArgList, Cardinal*) ;
static	void	tnormalFrame_onDestroy		(Widget) ;

static	void*	tnormalFrame_getclient		(Widget) ;
static	int		tnormalFrame_getrect		(Widget, XRectangle*) ;
static	void	tnormalFrame_activate		(Widget, Boolean) ;
static	void*	tnormalFrame_getfontset		(Widget) ;
static	Boolean	tnormalFrame_getlinespacing	(Widget, int*) ;
static	void*	tnormalFrame_getlispframeobject	(Widget) ;
static	void	tnormalFrame_setattribute	(Widget, const TConversionAttribute*) ;
static	Boolean	tnormalFrame_putchar		(Widget, const Char) ;
static	Boolean	tnormalFrame_puts			(Widget, const Char*, int) ;
static	void	tnormalFrame_rev			(Widget, Boolean) ;
static	void	tnormalFrame_clear			(Widget) ;
static	void	tnormalFrame_flush			(Widget) ;
static	Boolean	tnormalFrame_rectVariablep	(Widget) ;
static	Boolean	tnormalFrame_haveExternModelinep	(Widget) ;
static	Boolean	tnormalFrame_setModeline	(Widget, const Char*, int) ;
static	Boolean	tnormalFrame_autoPopupp		(Widget) ;

static	void	tnormalFrame_onTerminalKeyPress	(Widget, XtPointer, XEvent*, Boolean*) ;
static	void	tnormalFrame_onTerminalConfigure(Widget, XtPointer, XEvent*, Boolean*) ;

static	XtActionsRec	srNormalFrameAction []	= {
} ;

static	char			strNormalFrameTranslation []	= "" ;

TNormalFrameClassRec		tnormalFrameClassRec	= {
    {	/* core fields */
		/* superclass			*/	(WidgetClass) &tframeClassRec,
		/* class_name			*/	"TNormalFrame",
		/* size					*/	sizeof (TNormalFrameRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	tnormalFrame_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	tnormalFrame_onRealize,
		/* actions				*/	srNormalFrameAction,
		/* num_actions			*/	XtNumber (srNormalFrameAction),
		/* resources			*/	srNormalFrameResource,
		/* num_resources		*/	XtNumber(srNormalFrameResource),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	tnormalFrame_onDestroy,
		/* resize				*/	NULL,
		/* expose				*/	NULL,
		/* set_values			*/	tnormalFrame_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table				*/	strNormalFrameTranslation,
		/* query_geometry		*/	XtInheritQueryGeometry,
		/* display_accelerator	*/	NULL,
		/* extension	  		*/	NULL,
    },
	{	/* Composite			*/
		/* geometry_manager		*/	XtInheritGeometryManager,
		/* change_managed		*/	XtInheritChangeManaged,
		/* insert_child			*/	XtInheritInsertChild,
		/* delete_child			*/	XtInheritDeleteChild,
		/* extension			*/	NULL,
	},
	{	/* Shell				*/
		/* extension			*/	NULL,
	},
	{	/* Frame				*/
		/* getclient			*/	tnormalFrame_getclient,
		/* getlispframeobject	*/	tnormalFrame_getlispframeobject,
		/* setattribute			*/	tnormalFrame_setattribute,
		/* getrect				*/	tnormalFrame_getrect,
		/* activate				*/	tnormalFrame_activate,
		/* getfontset			*/	tnormalFrame_getfontset,
		/* getlinespacing		*/	tnormalFrame_getlinespacing,
		/* putchar				*/	tnormalFrame_puts,
		/* putchar				*/	tnormalFrame_putchar,
		/* rev					*/	tnormalFrame_rev,
		/* clear				*/	tnormalFrame_clear,
		/* flush				*/	tnormalFrame_flush,
		/* rectvariablep		*/	tnormalFrame_rectVariablep,
		/* haveExternModelinep	*/	tnormalFrame_haveExternModelinep,
		/* setModeline			*/	tnormalFrame_setModeline,
		/* autopopup			*/	tnormalFrame_autoPopupp,
		/* setCaret				*/	NULL,
	},
	{
		/* dummy				*/
	},
} ;

WidgetClass	tnormalFrameWidgetClass	= (WidgetClass) &tnormalFrameClassRec ;

void
tnormalFrame_onInitialize (
	Widget		wgRequest,
	Widget		wgNew,
	ArgList		args,
	Cardinal*	num_args)
{
	TNormalFrameWidget	w = (TNormalFrameWidget) wgNew ;

	w->tnormalframe.m_wgPopup		= NULL ;
	w->tnormalframe.m_wgTerminal	= NULL ;
	return ;
}

void
tnormalFrame_onRealize (
	register Widget					gw,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;
	CoreWidgetClass		super	= (CoreWidgetClass) XtClass (gw)->core_class.superclass ;
	Widget				wgPopup ;
	Widget				wgTerminal ;
	Arg					rArg [8] ;
	int					nArg ;

	(*super->core_class.realize) (gw, pValueMask, pXSWA) ;

	/*	Popup Widget 롣 Popup Widget Τ RootWindowStyle
	 *	 Window ˤʤ롣
	 */
	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNwidth,	gw->core.width) ;		nArg ++ ;
	XtSetArg (rArg [nArg], XtNheight,	gw->core.height) ;		nArg ++ ;
	XtSetArg (rArg [nArg], XtNinput,	True) ;					nArg ++ ;
	/*XtSetArg (rArg [nArg], XtNmappedWhenManaged, False) ;		nArg ++ ;*/
	assert (nArg < (sizeof (rArg) / sizeof (rArg [0]))) ;
#if defined (DEBUG)
	fprintf (stderr, "TransientPopupShell: width x height = %d x %d\n", gw->core.width, gw->core.height) ;
#endif
	wgPopup	= XtCreatePopupShell ("NormalFrame", transientShellWidgetClass, gw, rArg, nArg) ;

	/*	Terminal Window 롣*/
	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNwidth,	gw->core.width) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNheight,	gw->core.height) ;	nArg ++ ;
	assert (nArg < (sizeof (rArg) / sizeof (rArg [0]))) ;
	wgTerminal	= XtCreateManagedWidget ("NormalFrameTerminal", tterminalWidgetClass, wgPopup, rArg, nArg) ;
	XtRealizeWidget (wgPopup) ;

	/*	Terminal Window  Event Handler Ͽ롣*/
	wgThis->tnormalframe.m_wgPopup		= wgPopup ;
	wgThis->tnormalframe.m_wgTerminal	= wgTerminal ;

	XtAddEventHandler (wgTerminal, KeyPressMask, False, tnormalFrame_onTerminalKeyPress, gw) ;
	XtAddEventHandler (wgTerminal, StructureNotifyMask, False, tnormalFrame_onTerminalConfigure, gw) ;
	return ;
}

Boolean
tnormalFrame_onSetValues (
	register Widget		curw,
	register Widget		reqw,
	register Widget		neww,
	register ArgList	args,
	register Cardinal*	num_args)
{
	return	False ;
}

void
tnormalFrame_onDestroy (
	register Widget	gw)
{
	TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;
	return ;
}

/*	ƤӽФ Method
 */

/*	ƥԽʬɽ롣
 */
void
TNormalFrame_Popup (
	register Widget	gw)
{
	TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	XtPopup (wgThis->tnormalframe.m_wgPopup, XtGrabNonexclusive) ;
	return ;
}

/*	ƥԽʬɽˤ롣
 */
void
TNormalFrame_Popdown (
	register Widget	gw)
{
	TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	XtPopdown (wgThis->tnormalframe.m_wgPopup) ;
	return ;
}

/*	private functions
 */
void*
tnormalFrame_getclient (
	register Widget	gw)
{
	TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	return	wgThis->tframe.m_pClient ;
}

int
tnormalFrame_getrect (
	register Widget			gw,
	register XRectangle*	pRect)
{
	TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	if (pRect != NULL) {
		pRect->width	= wgThis->tnormalframe.m_wgTerminal->core.width ;
		pRect->height	= wgThis->tnormalframe.m_wgTerminal->core.height ;
	}
	return	1 ;
}

void
tnormalFrame_activate (
	register Widget			gw,
	register Boolean		fActivate)
{
	if (fActivate) {
		TNormalFrame_Popup (gw) ;
	} else {
		TNormalFrame_Popdown (gw) ;
	}
	return ;
}

void*
tnormalFrame_getfontset (
	register Widget			gw)
{
	register TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	return	TTerminal_GetFontSet (wgThis->tnormalframe.m_wgTerminal) ;
}

Boolean
tnormalFrame_getlinespacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	register TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;
	register TFontSet*			pFontSet ;

	pFontSet		= TTerminal_GetFontSet (wgThis->tnormalframe.m_wgTerminal) ;
	assert (pFontSet != NULL) ;
	*pnLineSpacing	= TFontSet_GetHeight (pFontSet) ;
	return	False ;
}

void*
tnormalFrame_getlispframeobject (
	register Widget			gw)
{
	TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	return	wgThis->tframe.m_pLispFrameObject ;
}

void
tnormalFrame_setattribute	(
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	/*	nothing to do */
	return ;
}

Boolean
tnormalFrame_putchar (
	register Widget			gw,
	register const Char		cc)
{
	register TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	return	TTerminal_Putchar (wgThis->tnormalframe.m_wgTerminal, cc) ;
}

Boolean
tnormalFrame_puts (
	register Widget			gw,
	register const Char*	pText,
	register int			nText)
{
	register TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;
	register Widget				wgTerminal ;

	wgTerminal	= wgThis->tnormalframe.m_wgTerminal ;
	while (nText -- > 0) 
		TTerminal_Putchar (wgTerminal, *pText ++) ;
	return	True ;
}

void
tnormalFrame_rev (
	register Widget			gw,
	register Boolean		fRev)
{
	register TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	TTerminal_Rev (wgThis->tnormalframe.m_wgTerminal, fRev) ;
	return ;
}

void
tnormalFrame_clear (
	register Widget			gw)
{
	register TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	TTerminal_Clear (wgThis->tnormalframe.m_wgTerminal) ;
	return ;
}

void
tnormalFrame_flush (
	register Widget			gw)
{
	register TNormalFrameWidget	wgThis	= (TNormalFrameWidget) gw ;

	TTerminal_Update (wgThis->tnormalframe.m_wgTerminal) ;
	return ;
}

Boolean
tnormalFrame_rectVariablep (
	register Widget			gw)
{
	return	False ;
}

Boolean
tnormalFrame_haveExternModelinep (
	register Widget			gw)
{
	return	False ;
}

Boolean
tnormalFrame_setModeline (
	register Widget			gw,
	register const Char*	pString,
	register int			nString)
{
	return	False ;
}

Boolean
tnormalFrame_autoPopupp (
	register Widget			gw)
{
	return	False ;
}

/*	Terminal ؤ key Ϥ򽦤ä client ˽뤿 wrapper callback ؿ
 *	 callback  callback Ťͤơߤΰ¸٤򸺤餷ƤΤɡä
 *	ɤˤʤäΤ⤷ʤ(;_;)
 */
void
tnormalFrame_onTerminalKeyPress (
	register Widget			gwTerinal,
	register XtPointer		closure,
	register XEvent*		pEvent,
	register Boolean*		pContinueToDispatch)
{
	register TNormalFrameWidget	wgThis		= (TNormalFrameWidget) closure ;

	XtCallCallbacks ((Widget) wgThis, XtNkeyPressCallback, (XtPointer) pEvent) ;
	return ;
}

void
tnormalFrame_onTerminalConfigure (
	register Widget			gwTerminal,
	register XtPointer		closure,
	register XEvent*		pXEvent,
	register Boolean*		pContinueToDispatch)
{
	register TNormalFrameWidget	wgThis		= (TNormalFrameWidget) closure ;
	XRectangle	rect ;

	/*	ꥵ XConfigureEvent Ȼפ 
	 */
	rect.x		= pXEvent->xconfigure.x ;
	rect.y		= pXEvent->xconfigure.y ;
	rect.width	= pXEvent->xconfigure.width ;
	rect.height	= pXEvent->xconfigure.height ;
	XtCallCallbacks ((Widget) wgThis, XtNconfigureCallback, (XtPointer) &rect) ;
	return ;
}

Widget
TNormalFrame_Create (
	register Widget		wgParent,
	register ArgList	arglist,
	register Cardinal	nArglist)
{
	assert (wgParent != NULL) ;
	return	XtCreateWidget ("frame", tnormalFrameWidgetClass, wgParent, arglist, nArglist) ;
}

