/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include "TFrameP.h"
#include "TConvAttr.h"

#define offset(field)	XtOffsetOf(TFrameRec, tframe.field)
#define goffset(field)	XtOffsetOf(WidgetRec, core.field )

static	XtResource	srTFrameResource []	= {
	{	XtNlispClient,				XtCLispClient,
		XtRPointer,					sizeof (XtPointer),
		offset (m_pClient),			XtRImmediate,		(XtPointer) NULL, },
	{	XtNlispFrameObject,			XtCLispFrameObject,
		XtRPointer,					sizeof (XtPointer),
		offset (m_pLispFrameObject),XtRImmediate,		(XtPointer) NULL, },
	{	XtNforeground,				XtCForeground,
		XtRPixel,					sizeof (Pixel),
		offset (m_pxlForeground),	XtRString,			XtDefaultForeground, },
	{	XtNkeyPressCallback,		XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkKeyPress),	XtRCallback,		(XtPointer) NULL, },
	{	XtNconfigureCallback,		XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkConfigure),	XtRCallback,		(XtPointer) NULL, },
	{	XtNdestroyCallback,			XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkDestroy),	XtRCallback,		(XtPointer) NULL, },
} ;

#undef	offset
#undef	goffset

static	void	tframe_onInitialize	(Widget, Widget, ArgList, Cardinal*) ;
static	void	tframe_onRealize	(Widget, XtValueMask*, XSetWindowAttributes*) ;
static	Boolean	tframe_onSetValues	(Widget, Widget, Widget, ArgList, Cardinal*) ;
static	void	tframe_onDestroy	(Widget) ;

static	void*		tframe_getclientDummy			(Widget) ;
static	int			tframe_getrectDummy 			(Widget, XRectangle*) ;
static	void		tframe_activateDummy			(Widget, Boolean) ;
static	void*		tframe_getfontsetDummy			(Widget) ;
static	Boolean		tframe_getlinespacingDummy		(Widget, int*) ;
static	void*		tframe_getlispframeobjectDummy	(Widget) ;
static	void		tframe_setattributeDummy		(Widget, const TConversionAttribute*) ;
static	Boolean		tframe_putsDummy				(Widget, const Char*, int) ;
static	Boolean		tframe_putcharDummy				(Widget, const Char) ;
static	void		tframe_revDummy					(Widget, Boolean) ;
static	void		tframe_clearDummy				(Widget) ;
static	void		tframe_flushDummy				(Widget) ;
static	Boolean		tframe_rectVariablepDummy		(Widget) ;
static	Boolean		tframe_haveExternModelinepDummy	(Widget) ;
static	Boolean		tframe_setModelineDummy			(Widget, const Char*, int) ;
static	Boolean		tframe_autoPopuppDummy			(Widget) ;
static	void		tframe_setCaretDummy			(Widget) ;


/* Хѿ
 */

/*	ɤΤ褦 X Event ɤΤޤͻ档
 */
static XtActionsRec		srTFrameAction [] = {
} ;

static char				sstrTFrameTranslation [] = "" ;

TFrameClassRec		tframeClassRec	= {
    {	/* core fields */
		/* superclass			*/	(WidgetClass) &shellClassRec,
		/* class_name			*/	"TFrame",
		/* size					*/	sizeof (TFrameRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	tframe_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	tframe_onRealize,
		/* actions				*/	srTFrameAction,
		/* num_actions			*/	XtNumber (srTFrameAction),
		/* resources			*/	srTFrameResource,
		/* num_resources		*/	XtNumber(srTFrameResource),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	tframe_onDestroy,
		/* resize				*/	NULL,
		/* expose				*/	NULL,
		/* set_values			*/	tframe_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_offsets		*/	NULL,
		/* tm_table				*/	sstrTFrameTranslation,
		/* query_geometry		*/	XtInheritQueryGeometry,
		/* display_accelerator	*/	NULL,
		/* extension	  		*/	NULL,
    },
	{	/* Composite			*/
		/* geometry_manager		*/	XtInheritGeometryManager,
		/* change_managed		*/	XtInheritChangeManaged,
		/* insert_child			*/	XtInheritInsertChild,
		/* delete_child			*/	XtInheritDeleteChild,
		/* extension			*/	NULL,
	},
	{	/* Shell				*/
		/* extension			*/	NULL,
	},
	{	/* Frame				*/
		/* getclient			*/	tframe_getclientDummy,
		/* getlispframeobject	*/	tframe_getlispframeobjectDummy,
		/* setattribute			*/	tframe_setattributeDummy,
		/* getrect				*/	tframe_getrectDummy,
		/* activate				*/	tframe_activateDummy,
		/* getfontset			*/	tframe_getfontsetDummy,
		/* getlinespacing		*/	tframe_getlinespacingDummy,
		/* puts					*/	tframe_putsDummy,
		/* putchar				*/	tframe_putcharDummy,
		/* rev					*/	tframe_revDummy,
		/* clear				*/	tframe_clearDummy,
		/* flush				*/	tframe_flushDummy,
		/* rectvariablep		*/	tframe_rectVariablepDummy,
		/* haveExternModelinep	*/	tframe_haveExternModelinepDummy,
		/* setModeline			*/	tframe_setModelineDummy,
		/* autoPopupp			*/	tframe_autoPopuppDummy,
		/* setcaret				*/	tframe_setCaretDummy,
	}
} ;

WidgetClass	tframeWidgetClass	= (WidgetClass) &tframeClassRec ;

void
tframe_onInitialize (
	Widget		wgRequest,
	Widget		wgNew,
	ArgList		args,
	Cardinal*	num_args)
{
	register TFrameWidget		wgThis	= (TFrameWidget) wgNew ;
	return ;
}

void
tframe_onRealize (
	register Widget					wgThis,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	(*tframeWidgetClass->core_class.superclass->core_class.realize) (wgThis, pValueMask, pXSWA) ;
	return ;
}

Boolean
tframe_onSetValues (
	register Widget		curw,
	register Widget		reqw,
	register Widget		neww,
	register ArgList	args,
	register Cardinal*	num_args)
{
	return	False ;
}

void
tframe_onDestroy (
	register Widget	wgThis)
{
	return ;
}


/*	ե졼«ͤ륯饤Ȥ롣饤ȤϥϤ椵
 *	Ǥ⤢롣
 *
 *	쥯饹ʤ̴쥦åȤʤΤǲ⤷ʤ
 */
void*
TFrame_GetClient (
	register Widget		gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pGetClient)(gw) ;
}

/*	ե졼ΰ롣
 *
 *	쥯饹ʤ̴쥦åȤʤΤǲ⤷ʤ
 */
int
TFrame_GetRect (
	register Widget			gw,
	register XRectangle*	pRect)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pGetRect)(gw, pRect) ;
}

void
TFrame_Activate (
	register Widget			gw,
	register Boolean		fActivate)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	(*wgClass->tframe_class.m_pActivate)(gw, fActivate) ;
	return ;
}

void*
TFrame_GetFontSet (
	register Widget			gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pGetFontSet)(gw) ;
}

Boolean
TFrame_GetLineSpacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	assert (gw != NULL) ;
	assert (pnLineSpacing != NULL);

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pGetLineSpacing)(gw, pnLineSpacing) ;
}

void*
TFrame_GetLispFrameObject (
	register Widget			gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pGetLispFrameObject)(gw) ;
}

void
TFrame_SetAttribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	(*wgClass->tframe_class.m_pSetAttribute)(gw, pAttribute) ;
	return ;
}

Boolean
TFrame_Putchar (
	register Widget			gw,
	register const Char		cc)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pPutchar)(gw, cc) ;
}

Boolean
TFrame_Puts (
	register Widget			gw,
	register const Char*	pText,
	register int			nText)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pPuts)(gw, pText, nText) ;
}

void
TFrame_Rev (
	register Widget			gw,
	register Boolean		fRev)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pRev)(gw, fRev) ;
}

void
TFrame_Clear (
	register Widget			gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pClear)(gw) ;
}

void
TFrame_Flush (
	register Widget			gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pFlush)(gw) ;
}

Boolean
TFrame_RectVariablep (
	register Widget			gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pRectVariablep)(gw) ;
}

Boolean
TFrame_HaveExternModeline (
	register Widget			gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pHaveExternModeline)(gw) ;
}

Boolean
TFrame_SetModeline (
	register Widget			gw,
	register const Char*	pString,
	register int			nString)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pSetModeline)(gw, pString, nString) ;
}

Boolean
TFrame_AutoPopupp (
	register Widget			gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	return	(*wgClass->tframe_class.m_pAutoPopupp)(gw) ;
}

void
TFrame_SetCaret (
	register Widget			gw)
{
	register TFrameWidget		wgThis ;
	register TFrameWidgetClass	wgClass ;

	wgThis	= (TFrameWidget) gw ;
	wgClass	= (TFrameWidgetClass) gw->core.widget_class ;
	if (!wgClass->tframe_class.m_pSetCaret)
		return ;
	return	(*wgClass->tframe_class.m_pSetCaret)(gw) ;
}

/*	private functions
 */

void*
tframe_getclientDummy (
	register Widget		gw)
{
	TFrameWidget		wgThis	= (TFrameWidget) gw ;
	return	wgThis->tframe.m_pClient ;
}

int
tframe_getrectDummy (
	register Widget			gw,
	register XRectangle*	pRect)
{
	return	0 ;
}

void
tframe_activateDummy (
	register Widget			gw,
	register Boolean		fActivate)
{
	return ;
}

void*
tframe_getfontsetDummy (
	register Widget			gw)
{
	return	NULL ;
}

Boolean
tframe_getlinespacingDummy (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	assert (gw != NULL) ;
	assert (pnLineSpacing != NULL) ;
	return	False ;
}

void*
tframe_getlispframeobjectDummy (
	register Widget			gw)
{
	return	NULL ;
}

void
tframe_setattributeDummy (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	return ;
}

Boolean
tframe_putsDummy (
	register Widget			gw,
	register const Char*	pText,
	register int			nText)
{
	return	False ;
}

Boolean
tframe_putcharDummy (
	register Widget			gw,
	register const Char		cc)
{
	return	False ;
}

void
tframe_revDummy (
	register Widget			gw,
	register Boolean		fRev)
{
	return ;
}

void
tframe_clearDummy (
	register Widget			gw)
{
	return ;
}

void
tframe_flushDummy (
	register Widget			gw)
{
	return ;
}

Boolean
tframe_rectVariablepDummy (
	register Widget			gw)
{
	return	False ;
}

Boolean
tframe_haveExternModelinepDummy (
	register Widget			gw)
{
	return	False ;
}

Boolean
tframe_setModelineDummy (
	register Widget			gw,
	register const Char*	pString,
	register int			nString)
{
	return	False ;
}

Boolean
tframe_autoPopuppDummy (
	register Widget			gw)
{
	return	False ;
}

void
tframe_setCaretDummy (
	register Widget			gw)
{
	return ;
}

