/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (TConvAttr_h)
#define	TConvAttr_h

#include "TFontSet.h"

enum {
	CONVERSION_EVENTSELECT_INPUTONLY,
	CONVERSION_EVENTSELECT_FOCUS,
	CONVERSION_EVENTSELECT_NONE,
} ;

enum {
	CONVERSION_INPUTSTYLE_ROOTWINDOW,
	CONVERSION_INPUTSTYLE_OFFTHESPOT,
	CONVERSION_INPUTSTYLE_OVERTHESPOT,
	CONVERSION_INPUTSTYLE_ONTHESPOT,
} ;

enum {
	CAEventSelectBit		= 0,
	CAInputStyleBit			= 1,
	CAFocusWindowBit		= 2,
	CAPreeditMaskBit		= 3,
	CAStatusMaskBit			= 4,
} ;

enum {
	CASpotLocationBit		= 0,
	CAClientAreaBit			= 1,
	/* font  linespacing ˤϽ¸롣
	 *	CAFontBit < CALineSpacingBit Ǥ뤳ȡ
	 */
	CAFontBit				= 2,
	CALineSpacingBit		= 3,
	CAColormapBit			= 4,
	CAForegroundPixelBit	= 5,
	CABackgroundPixelBit	= 6,
	CABackgroundPixmapBit	= 7,
	CACursorBit				= 8,
	CAClientAreaNeededBit	= 9,
} ;

#define	CAEventSelect		((unsigned long)1L << CAEventSelectBit)
#define	CAInputStyle		((unsigned long)1L << CAInputStyleBit)
#define	CAFocusWindow		((unsigned long)1L << CAFocusWindowBit)
#define	CAPreeditMask		((unsigned long)1L << CAPreeditMaskBit)
#define	CAStatusMask		((unsigned long)1L << CAStatusMaskBit)

#define	CASpotLocation		((unsigned long)1L << CASpotLocationBit)
#define	CAClientArea		((unsigned long)1L << CAClientAreaBit)
#define	CAFont				((unsigned long)1L << CAFontBit)
#define	CALineSpacing		((unsigned long)1L << CALineSpacingBit)
#define	CAColormap			((unsigned long)1L << CAColormapBit)
#define	CAForegroundPixel	((unsigned long)1L << CAForegroundPixelBit)
#define	CABackgroundPixel	((unsigned long)1L << CABackgroundPixelBit)
#define	CABackgroundPixmap	((unsigned long)1L << CABackgroundPixmapBit)
#define	CACursor			((unsigned long)1L << CACursorBit)
#define	CAClientAreaNeeded	((unsigned long)1L << CAClientAreaNeededBit)

typedef struct {
	unsigned int		m_uMask ;
	Pixel				m_foreground ;
	Pixel				m_background ;
	XPoint				m_spot ;
	XRectangle			m_area ;
	XRectangle			m_areaNeeded ;
	Colormap			m_colormap ;
	int					m_nLineSpacing ;
	TFontSet			m_FontSet ;
	Pixmap				m_pixBackground ;
	Cursor				m_cursor ;
}	PreeditAttribute ;

typedef struct {
	unsigned int		m_uMask ;
	Pixel				m_foreground ;
	Pixel				m_background ;
	XRectangle			m_area ;
	XRectangle			m_areaNeeded ;
	int					m_nLineSpacing ;
	Colormap			m_colormap ;
	TFontSet			m_FontSet ;
	Pixmap				m_pixBackground ;
	Cursor				m_cursor ;
}	StatusAttribute ;

struct tagTConversionAttribute {
	unsigned int		m_uMask ;
	int					m_nEventSelect ;
	int					m_nInputStyle ;
	Window				m_wndFocus ;
	PreeditAttribute	m_Preedit ;
	StatusAttribute		m_Status ;
} ;

typedef struct tagTConversionAttribute	TConversionAttribute ;

#define	IS_CONVATTR_MASK(ca,mask)			(((ca).m_uMask) & (mask))
#define	IS_CONVATTR_PREEDIT_MASK(ca,mask)	(((ca).m_Preedit.m_uMask) & (mask))
#define	IS_CONVATTR_STATUS_MASK(ca,mask)	(((ca).m_Status.m_uMask) & (mask))
#define	SET_CONVATTR_MASK(ca,mask)			{((ca).m_uMask) |= (mask) ;}
#define	SET_CONVATTR_PREEDIT_MASK(ca,mask)	{((ca).m_Preedit.m_uMask) |= (mask) ;}
#define	SET_CONVATTR_STATUS_MASK(ca,mask)	{((ca).m_Status.m_uMask) |= (mask) ;}
#define	UNSET_CONVATTR_MASK(ca,mask)			{((ca).m_uMask) &= ~(mask) ;}
#define	UNSET_CONVATTR_PREEDIT_MASK(ca,mask)	{((ca).m_Preedit.m_uMask) &= ~(mask) ;}
#define	UNSET_CONVATTR_STATUS_MASK(ca,mask)	{((ca).m_Status.m_uMask) &= ~(mask) ;}
#define	CLR_CONVATTR_MASK(ca)				{((ca).m_uMask) = 0 ;}
#define	CLR_CONVATTR_PREEDIT_MASK(ca)		{((ca).m_Preedit.m_uMask) = 0 ;}
#define	CLR_CONVATTR_STATUS_MASK(ca)		{((ca).m_Status.m_uMask) = 0 ;}

#define	CONVATTR_FOCUSWINDOW(ca)			((ca).m_wndFocus)
#define	CONVATTR_PREEDIT_SPOT(ca)			((ca).m_Preedit.m_spot)
#define	CONVATTR_PREEDIT_CLIENTAREA(ca)		((ca).m_Preedit.m_area)
#define	CONVATTR_PREEDIT_FOREGROUND(ca)		((ca).m_Preedit.m_foreground)
#define	CONVATTR_PREEDIT_BACKGROUND(ca)		((ca).m_Preedit.m_background)
#define	CONVATTR_PREEDIT_FONTSET(ca)		((ca).m_Preedit.m_FontSet)
#define	CONVATTR_PREEDIT_COLORMAP(ca)		((ca).m_Preedit.m_colormap)
#define	CONVATTR_STATUS_FOREGROUND(ca)		((ca).m_Status.m_foreground)
#define	CONVATTR_STATUS_BACKGROUND(ca)		((ca).m_Status.m_background)
#define	CONVATTR_STATUS_CLIENTAREA(ca)		((ca).m_Status.m_area)
#define	CONVATTR_STATUS_FONTSET(ca)			((ca).m_Status.m_FontSet)
#define	CONVATTR_STATUS_COLORMAP(ca)		((ca).m_Status.m_colormap)

#define	IS_AREA_EQUAL(area1,area2)			((area1).x == (area2).x && (area1).y == (area2).y && (area1).width == (area2).width && (area1).height == (area2).height)

#define	TConvAttr_Initialize(pConvAttr)	\
{	\
	register TConversionAttribute*	ptr	= (pConvAttr) ;	\
	ptr->m_uMask	= ptr->m_Preedit.m_uMask	= ptr->m_Status.m_uMask	= 0 ;	\
	TFontSet_Initialize (&ptr->m_Preedit.m_FontSet) ;	\
	TFontSet_Initialize (&ptr->m_Status.m_FontSet) ;	\
}

#define	TConvAttr_Uninitialize(pConvAttr)	\
{	\
	register TConversionAttribute*	ptr	= (pConvAttr) ;	\
	TFontSet_Destroy (&ptr->m_Preedit.m_FontSet) ;	\
	TFontSet_Destroy (&ptr->m_Status.m_FontSet) ;	\
}

#define	TConvAttr_Copy(pDestOrg,pSrcOrg)	\
{	\
	register TConversionAttribute*	pDest	= (pDestOrg) ;	\
	register TConversionAttribute*	pSrc	= (pSrcOrg) ;	\
	if ((pSrc->m_uMask & CAPreeditMask) && (pSrc->m_Preedit.m_uMask & CAFont))	\
		TFontSet_Copy (&pDest->m_Preedit.m_FontSet, &pSrc->m_Preedit.m_FontSet) ;	\
	if ((pSrc->m_uMask & CAStatusMask)  && (pSrc->m_Status.m_uMask & CAFont))	\
		TFontSet_Copy (&pDest->m_Status.m_FontSet, &pSrc->m_Status.m_FontSet) ;	\
	memcpy (pDest, pSrc, sizeof (TConversionAttribute)) ;	\
}

#endif

