/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lispyevent_h)
#define	lispyevent_h

#include "local.h"
#include "Char.h"

typedef struct tagTXEvent {
	Boolean	m_fChar ;
	union {
		Char			m_ch ;
		XEvent*			m_pEv ; 
	}	u ;
}	TXEvent ;

Boolean		keysym2string	(char*, int, KeySym, unsigned int) ;
Boolean		string2keysym	(const char*, KeySym*, unsigned int*) ;
Boolean		keysym2Cstring	(Char*, int, KeySym, unsigned int) ;
Boolean		cstring2keysym	(const Char*, int, KeySym*, unsigned int*) ;
Boolean		cchar2keycode	(Display*, Char, unsigned int*, unsigned int*) ;
int			string2keysymlist	(Display*, const char**, int*, KeySym*, unsigned int*, int) ;

#endif

