/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"
#include "lmkeymap.h"

typedef struct {
	TLispEntity*		m_pEntKey ;
	TLispEntity*		m_pEntFunc ;
	int					m_nMatch ;
	Boolean				m_fNearMatch ;
	Boolean				m_fAcceptDefault ;
}	TWindowProcLookupKeymapArg ;

static	TLMRESULT	lispMachineState_postPreCommandHook (TLispMachine*) ;
static	TLMRESULT	lispMachineState_windowProcAfterCall(TLispMachine*) ;
static	TLMRESULT	lispMachineState_windowProcFinalize (TLispMachine*) ;
static	TLMRESULT	lispMachineState_runCommandHook (TLispMachine*, TLispEntity*, TLMRESULT (*)(TLispMachine*)) ;
static	TLMRESULT	lispMachineState_returnWithSignal (TLispMachine*) ;
static	Boolean		lispMachine_windowProcLookupKeymap	(TLispMachine*, TLispEntity*, int*, TLispEntity**) ;
static	Boolean		lispMachine_handleMinorModeMap	(TLispMachine*, TLispEntity*, void*, Boolean*) ;

/*
 *	Lisp Machine ˤơCall-Interactively ƤӽФ Event Ԥ Loop
 *	 State 1ĤǤ롣ǤʤȡC-q ʤɤʤʤäƤޤ
 */
TLMRESULT
lispMachineState_WindowProc (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntUnreadCmdEvents ;
	TLispEntity*	pEntKey ;
	TLispEntity*	pEntFunc ;
	TLispEntity*	pEntLastKey ;
	TLispEntity*	pEntArg ;
	int				nMatch	= 0 ;
	long			lValue ;

	/*	̤ѥ unread-command-events ίޤäƤ롣*/
	pEntUnreadCmdEvents	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_UNREAD_COMMAND_EVENTS) ;
	assert (pEntUnreadCmdEvents != NULL) ;
	lispMachine_GetCurrentSymbolValue (pLM, pEntUnreadCmdEvents, &pEntKey) ;

#if defined (DEBUG)
	{
		TLispEntity*	pTemp ;
		fprintf (stderr, "(wndproc) unread-command-events = ") ;
		lispEntity_Print (pLispMgr, pEntKey) ;
		fprintf (stderr, "\n") ;
		lispMachine_GetCurrentSymbolValue (pLM, lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_UNREAD_COMMAND_CHAR), &pTemp) ;
		fprintf (stderr, "(wndproc) unread-command-char   = ") ;
		lispEntity_Print (pLispMgr, pTemp) ;
		fprintf (stderr, "\n") ;
	}
#endif
	/*	̤ѥ1Ĥʤв⤷ʤ*/
	if (TFAILED (lispMachine_windowProcLookupKeymap (pLM, pEntKey, &nMatch, &pEntFunc)))
		return	LMR_SUSPEND ;

#if defined (DEBUG)
	fprintf (stderr, "nmatch = %d\n", nMatch) ;
#endif

	/*	ҥåȤϤοӤơҥåȤϤοʤ
	 *	С󥻥뤹롣*/
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntFunc))) {
		while (nMatch -- > 0) 
			lispEntity_GetCdr (pLispMgr, pEntKey, &pEntKey) ;
		lispMachine_SetCurrentSymbolValue (pLM, pEntUnreadCmdEvents, pEntKey) ;
		/*	ˤ⤳ξ֤äߤΤǡSuspend ˤʤ롣*/
		return	LMR_SUSPEND ;
	}
	assert (nMatch > 0) ;
	while (nMatch -- > 0) {
		lispEntity_GetCar (pLispMgr, pEntKey, &pEntLastKey) ;
		if (TSUCCEEDED (lispEntity_GetIntegerValue (pLispMgr, pEntLastKey, &lValue))) 
			lispMachineCode_PushThisCommandKeys (pLM, (Char) lValue) ;
		lispEntity_GetCdr (pLispMgr, pEntKey, &pEntKey) ;
	}

	/*
	 *	this-command 򤳤줫餻褦ȤƤ륳ޥɤˡ
	 *	last-command Ȥ this-command λäƤͤˡ
	 *	롣
	 */
	lispMachine_SetCurrentSymbolValue (pLM, lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_THIS_COMMAND), pEntFunc) ;
	lispMachine_SetCurrentSymbolValue (pLM, lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_LAST_COMMAND_EVENT), pEntLastKey) ;
	lispMachine_SetCurrentSymbolValue (pLM, pEntUnreadCmdEvents, pEntKey) ;

#if defined (DEBUG)
	fprintf (stderr, "this-command = ") ;
	lispEntity_Print (pLispMgr, pEntFunc) ;
	fprintf (stderr, "\nlast-command-event = ") ;
	lispEntity_Print (pLispMgr, pEntLastKey) ;
	fprintf (stderr, "\n") ;
#endif
	/*	call-interactively ƤӽФ*/
	if (TFAILED (lispMgr_CreateList (pLispMgr, &pEntFunc, 1, &pEntArg)))
		return	LMR_ERROR ;

	lispMachineCode_SetMessage (pLM, NULL) ;
	lispMachineCode_SetLReg    (pLM, LM_LREG_ACC, pEntArg) ;
	lispMachineCode_PushLReg   (pLM, LM_LREG_ACC) ;

	/*
	 *	pre-command-hook 롣ʳǤ this-command Ϥ줫Ȥ
	 *	Ƥ륳ޥɤlast-command ԤäޥɤݻƤ롣
	 */
	return	lispMachineState_runCommandHook (pLM, lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_PRE_COMMAND_HOOK), &lispMachineState_postPreCommandHook) ;
}

TLMRESULT
lispMachineState_postPreCommandHook (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;

	/*	顼ȯˤ pre-command-hook ϼΤƤ롣*/
	if (LISPMACHINE_EXCEPTIONP (pLM)) {
		TLispEntity*	pEntNil ;
		lispMgr_CreateNil (pLM->m_pLispMgr, &pEntNil) ;
		lispMachine_SetCurrentSymbolValue (pLM, lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_PRE_COMMAND_HOOK), pEntNil) ;
	}
	lispMachineCode_ResetSignal    (pLM) ;
	lispMachineCode_ResetException (pLM) ;

	lispMachineCode_PopLReg    (pLM, LM_LREG_ACC) ;
	lispMachineCode_PushState  (pLM, &lispMachineState_windowProcAfterCall) ;
	lispMachineCode_SetState   (pLM, &lispMachineState_CallInteractively) ;
	return	LMR_CONTINUE ;
}

/*
 *	post-command-hook äƤ last-command-char ʤɤν롣
 */
TLMRESULT
lispMachineState_windowProcAfterCall (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntPostCmdHook ;
	TLMRESULT		(*pNextState)(TLispMachine*) ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	/*	exception ȯˤ post-command-hook ư
	 *	ʤȤ롣*/
	pNextState	= &lispMachineState_WindowProc ;
	if (LISPMACHINE_EXCEPTIONP (pLM)) {
		TLispEntity*	pEntException ;
		TLispEntity*	pEntValue ;
		register TLispEntity*	pEntExit ;

		/*	exit exception ʤȴ롣read-string 
		 *	*/
		lispMachineCode_GetException (pLM, &pEntException, &pEntValue) ;
		pEntExit	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_EXIT) ;
		if (TSUCCEEDED (lispEntity_Eq (pLispMgr, pEntException, pEntExit))) {
			if (TFAILED (lispEntity_Nullp (pLispMgr, pEntValue))) {
				register TLispEntity*	pEntSignal ;
				pEntSignal	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_QUIT) ;
				lispMachineCode_PushLReg (pLM, LM_LREG_1) ;
				lispMachineCode_PushLReg (pLM, LM_LREG_2) ;
				lispMachineCode_SetLReg  (pLM, LM_LREG_1, pEntSignal) ;
				lispMachineCode_SetLReg  (pLM, LM_LREG_2, pEntValue) ;
				pNextState	= &lispMachineState_returnWithSignal ;
			} else {
				pNextState	= &lispMachineState_ReturnOnly ;
			}
		} else {
			register TLispEntity*	pEntError ;
			/*	error ä顢Message Фʡ*/
			pEntError	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_ERROR) ;
			if (TSUCCEEDED (lispEntity_Eq (pLispMgr, pEntException, pEntError)) &&
				TSUCCEEDED (lispEntity_Stringp (pLispMgr, pEntValue))) 
				lispMachineCode_SetMessage (pLM, pEntValue) ;
		}
		/*
		 *	signal  quit ˤä᡹˥ޥɤλƤ post-command-hook 
		 *	ϼ¹Ԥ롣exit ʤġ
		 */
		lispMachineCode_ClearQuitFlag  (pLM) ;
		lispMachineCode_ResetSignal    (pLM) ;
		lispMachineCode_ResetException (pLM) ;
	}

	pEntPostCmdHook	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_POST_COMMAND_HOOK) ;
	lispMachineCode_PushState (pLM, pNextState) ;
	return	lispMachineState_runCommandHook (pLM, pEntPostCmdHook, &lispMachineState_windowProcFinalize) ;
}

TLMRESULT
lispMachineState_windowProcFinalize (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntFunc ;
	TLispEntity*	pEntThisCmd ;
	TLispEntity*	pEntLastCmd ;
	TLispEntity*	pEntUnreadCmdEvent ;
	TLispEntity*	pEntUnreadChar ;
	TLispEntity*	pWindow ;
	TLispEntity*	pCurBuffer ;
	TLispEntity*	pWindowBuffer ;

	/*	顼ȯˤ post-command-hook ϼΤƤ롣*/
	if (LISPMACHINE_EXCEPTIONP (pLM)) {
		TLispEntity*	pEntNil ;
		lispMgr_CreateNil (pLispMgr, &pEntNil) ;
		lispMachine_SetCurrentSymbolValue (pLM, lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_POST_COMMAND_HOOK), pEntNil) ;
	}
	lispMachineCode_ResetSignal    (pLM) ;
	lispMachineCode_ResetException (pLM) ;

	lispMachineCode_GetCurrentWindow (pLM, &pWindow) ;
	lispMachineCode_GetCurrentBuffer (pLM, &pCurBuffer) ;
	lispWindow_GetBuffer (pWindow, &pWindowBuffer) ;

	assert (pWindow != NULL) ;
	assert (pCurBuffer != NULL) ;
	assert (pWindowBuffer != NULL) ;

	if (pCurBuffer != pWindowBuffer) 
		lispMachineCode_SetCurrentBuffer (pLM, pWindowBuffer) ;

	/*	last-command ꡣ*/
	pEntThisCmd		= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_THIS_COMMAND) ;
	pEntLastCmd		= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_LAST_COMMAND) ;
	if (TSUCCEEDED (lispMachine_GetCurrentSymbolValue (pLM, pEntThisCmd, &pEntFunc)))
		lispMachine_SetCurrentSymbolValue (pLM, pEntLastCmd, pEntFunc) ;

	/*	unread-command-char μ갷ĤɤΤ*/
	pEntUnreadCmdEvent	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_UNREAD_COMMAND_CHAR) ;
	if (TSUCCEEDED (lispMachine_GetCurrentSymbolValue (pLM, pEntUnreadCmdEvent, &pEntUnreadChar))) {
		TLispEntity*	pEntNextValue ;
		long			lValue ;
		if (TSUCCEEDED (lispEntity_GetIntegerValue (pLispMgr, pEntUnreadChar, &lValue)) &&
			lValue >= 0) {
#if defined (DEBUG)
			fprintf (stderr, "unread-command-char (%ld) --> unread-command-events\n", lValue) ;
#endif
			lispMachine_QueueInEvent (pLM, lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_UNREAD_COMMAND_EVENTS), pEntUnreadChar) ;
		}
		/*	ɤ߼줿 unread-command-char  -1 ˤʤ롣*/
		if (TFAILED (lispMgr_CreateInteger (pLispMgr, -1, &pEntNextValue)))
			return	LMR_ERROR ;
		lispMachine_SetCurrentSymbolValue (pLM, pEntUnreadCmdEvent, pEntNextValue) ;
	}
	/*	this-command-chars 򥯥ꥢ롣*/
	lispMachineCode_ClearThisCommandKeys (pLM) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_runCommandHook (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntHook,
	register TLMRESULT		(*pReturnState)(TLispMachine*))
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntValue ;
	TLispEntity*	pEntNil ;

	pLispMgr	= pLM->m_pLispMgr ;
	lispMgr_CreateNil    (pLispMgr, &pEntNil) ;
	lispEntity_AddRef    (pLispMgr, pEntHook) ;
	if (TFAILED (lispMgr_CreateConscell (pLispMgr, pEntHook, pEntNil, &pEntValue)))
		return	LMR_ERROR ;
	lispEntity_Release   (pLispMgr, pEntHook) ;
	lispMachineCode_SetLReg   (pLM, LM_LREG_ACC, pEntValue) ;
	lispMachineCode_PushState (pLM, pReturnState) ;
	lispMachineCode_SetState  (pLM, &lispMachineState_RunHooks) ;
	return	LMR_CONTINUE ;
}

/*
 *	signal ᤷ return 롣
 */
TLMRESULT
lispMachineState_returnWithSignal (
	register TLispMachine*	pLM)
{
	TLispEntity*	pEntSignal ;
	TLispEntity*	pEntValue ;
	lispMachineCode_GetLReg   (pLM, LM_LREG_1, &pEntSignal) ;
	lispMachineCode_GetLReg   (pLM, LM_LREG_2, &pEntValue) ;
	lispMachineCode_SetSignal (pLM, pEntSignal, pEntValue) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_1) ;
	return	LMR_RETURN ;
}

Boolean
lispMachine_windowProcLookupKeymap (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntKey,
	register int*			pnMatch,
	register TLispEntity**	ppEntFunc)
{
	register TLispManager*		pLispMgr ;
	TWindowProcLookupKeymapArg	arg ;
	TLispEntity*		pCurBuffer ;
	TLispEntity*		pEntKeymap ;
	TLispEntity*		pEntFunc ;
	int					nMatch ;
	TLispEntity*		rEntKeymaps [2] ;
	register int		i ;
	register Boolean	fRetval ;
	register Boolean	fNearMatch ;
	register Boolean	fAcceptDefault ;

	/*	ν֤ǥޥåפ򸫤롣
	 *	local -> global -> local (near-match)  -> global (near-match, accept-default) 
	 *	-> local (near-match, accept-default)
	 *	ºݤ emacs Τ褦ˤƤ뤫ɤˤϼȤʤɡ
	 */
	static const Boolean	srfLookGlobal []	= { False, True,  False, True, False, } ;
	static const Boolean	srAcceptDefault []	= { False, False, False, True, True, } ;
	static const Boolean	srNearMatch []		= { False, False, True,  True, True, } ;

	pLispMgr	= pLM->m_pLispMgr ;

	/*	̤ѥ1Ĥʤв⤷ʤ*/
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntKey)))
		return	False ;

	lispMachineCode_GetCurrentBuffer (pLM, &pCurBuffer) ;
	if (TSUCCEEDED (lispBuffer_GetKeymap (pCurBuffer, &pEntKeymap))) {
		rEntKeymaps [0]	= pEntKeymap ;
	} else {
		rEntKeymaps [0]	= NULL ;
	}
	rEntKeymaps [1]	= lispMachine_GetGlobalMap (pLM) ;
	arg.m_pEntKey	= pEntKey ;

	for (i = 0 ; i < NELEMENTS (srfLookGlobal) ; i ++) {
		if (TFAILED (srfLookGlobal [i])) {
			arg.m_pEntFunc			= NULL ;
			arg.m_nMatch			= 0 ;
			arg.m_fAcceptDefault	= srAcceptDefault [i] ;
			arg.m_fNearMatch		= srNearMatch     [i] ;
			if (TFAILED (lispMachine_EnumMinorModeMaps (pLM, lispMachine_handleMinorModeMap, &arg)))
				return	False ;
			if (arg.m_pEntFunc != NULL &&
				TFAILED (lispEntity_Nullp (pLispMgr, arg.m_pEntFunc)) &&
				arg.m_nMatch > 0) {
				pEntFunc	= arg.m_pEntFunc ;
				nMatch		= arg.m_nMatch ;
				goto	key_hit ;
			}
			pEntKeymap	= rEntKeymaps [0] ;
		} else {
			pEntKeymap	= rEntKeymaps [1] ;
		}
		if (pEntKeymap == NULL)
			continue ;

		nMatch			= 0 ;
		fAcceptDefault	= srAcceptDefault [i] ;
		fNearMatch		= srNearMatch     [i] ;
		fRetval			= lispKeymap_Lookup (pLispMgr, pEntKeymap, pEntKey, fAcceptDefault, fNearMatch, &nMatch, &pEntFunc) ;
		if (fRetval && 
			TFAILED (lispEntity_Nullp (pLispMgr, pEntFunc)) &&
			nMatch > 0) 
			goto	key_hit ;
	}

	/*	ˤҥåȤʤС undefined Ǥ롣*/
	lispMgr_CreateNil (pLispMgr, &pEntFunc) ;
	nMatch	= 1 ;

  key_hit:
	*pnMatch	= nMatch ;
	*ppEntFunc	= pEntFunc ;
	return	True ;
}

Boolean
lispMachine_handleMinorModeMap (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntKeymap,
	register void*			pCaller,
	register Boolean*		pfContinue)
{
	register TWindowProcLookupKeymapArg*	pArg	= (TWindowProcLookupKeymapArg*) pCaller ;
	register TLispManager*	pLispMgr				= pLM->m_pLispMgr ;
	register TLispEntity*	pEntKey ;
	register Boolean		fNearMatch ;
	register Boolean		fAcceptDefault ;
	register Boolean		fRetval ;

	pEntKey			= pArg->m_pEntKey ;
	fAcceptDefault	= pArg->m_fAcceptDefault ;
	fNearMatch		= pArg->m_fNearMatch ;
	fRetval			= lispKeymap_Lookup (pLispMgr, pEntKeymap, pEntKey, fAcceptDefault, fNearMatch, &pArg->m_nMatch, &pArg->m_pEntFunc) ;
	if (fRetval && 
		TFAILED (lispEntity_Nullp (pLispMgr, pArg->m_pEntFunc)) &&
		pArg->m_nMatch > 0) 
		*pfContinue	= False ;
	return	True ;
}

