/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"
#include "TFontSet.h"
#include "TTerminal.h"
#include "TFrame.h"
#include "ttext.h"

/*
 *	(window-frame WINDOW)
 *
 *	window WINDOW ¸ߤե졼४֥Ȥ֤
 */
TLMRESULT
lispMachineState_WindowFrame (
	register TLispMachine*		pLM)
{
	TLispEntity*	pArglist ;
	TLispEntity*	pWindowEntity ;
	TLispEntity*	pFrameEntity ;

	assert (pLM != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar (pLM->m_pLispMgr, pArglist, &pWindowEntity)) ||
		TFAILED (lispWindow_GetFrame (pWindowEntity, &pFrameEntity))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pFrameEntity) ;
	}
	return	LMR_RETURN ;
}

/*
 *	(window-buffer &optional WINDOW)
 *
 *	WINDOW ɽƤ buffer ֤
 */
TLMRESULT
lispMachineState_WindowBuffer (register TLispMachine* pLM)
{
	TLispEntity*	pArglist ;
	TLispEntity*	pWindowEntity ;
	TLispEntity*	pBufferEntity ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar (pLM->m_pLispMgr, pArglist, &pWindowEntity))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TSUCCEEDED (lispEntity_Nullp (pLM->m_pLispMgr, pWindowEntity))) 
		lispMachineCode_GetCurrentWindow (pLM, &pWindowEntity) ;
	assert (pWindowEntity != NULL) ;
	lispWindow_GetBuffer (pWindowEntity, &pBufferEntity) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pBufferEntity) ;
	return	LMR_RETURN ;
}

/*
 *	(selected-window)
 */
TLMRESULT
lispMachineState_SelectedWindow (register TLispMachine* pLM)
{
	TLispEntity*	pEntWindow ;

	lispMachineCode_GetCurrentWindow (pLM, &pEntWindow) ;
	if (pEntWindow != NULL) {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntWindow) ;
	} else {
		lispMachineCode_SetError (pLM) ;
	}
	return	LMR_RETURN ;
}

/*	(window-width &optional WINDOW)
 *
 *	Return the number of display columns in WINDOW.
 *	This is the width that is usable columns available for text in WINDOW.
 *	If you want to find out how many columns WINDOW takes up,
 *	use  (let ((edges (window-edges))) (- (nth 2 edges) (nth 0 edges))).
 */
TLMRESULT
lispMachineState_WindowWidth (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*			pEntArglist ;
	TLispEntity*			pEntWindow ;
	TLispEntity*			pEntFrame ;
	TLispEntity*			pEntRetval ;
	XRectangle				rc ;
	Widget					wgTerminal ;
	register TFontSet*		pFontSet ;
	static const Char		chSPC	= 0x20 ;
	TSize					szSPC ;
	register int			nColumn ;
	int						nType ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntWindow) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntWindow))) 
		lispMachineCode_GetCurrentWindow (pLM, &pEntWindow) ;

	if (TFAILED (lispEntity_GetType (pLispMgr, pEntWindow, &nType)) ||
		nType != LISPENTITY_WINDOW) 
		goto	error ;
	lispWindow_GetArea  (pEntWindow, &rc) ;
	if (TFAILED (lispWindow_GetFrame (pEntWindow, &pEntFrame)) || 
		pEntFrame == NULL ) 
		goto	error ;
	(void) lispFrame_GetTerminal (pEntFrame, &wgTerminal) ;
	pFontSet	= TFrame_GetFontSet (wgTerminal) ;
	if (pFontSet == NULL) 
		goto	error ;

	/*	ࡢǤʤեȤȤϤޤꤽ...
	 */
	TGetTextExtents (pFontSet, &chSPC, 1, &szSPC) ;
	nColumn	= rc.width / szSPC.cx ;
	if (TFAILED (lispMgr_CreateInteger (pLispMgr, (long) nColumn, &pEntRetval)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;

  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_WindowMinibufferp (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*			pEntArglist ;
	TLispEntity*			pEntWindow ;
	register TLispEntity*	pEntRetval ;
	int						nType ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntWindow) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntWindow))) 
		lispMachineCode_GetCurrentWindow (pLM, &pEntWindow) ;

	if (TFAILED (lispEntity_GetType (pLispMgr, pEntWindow, &nType)) ||
		nType != LISPENTITY_WINDOW) {
		lispMachineCode_SetError (pLM) ;
		goto	error ;
	}
	if (TSUCCEEDED (lispWindow_Minibufferp (pEntWindow))) {
		pEntRetval	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_T) ;
	} else {
		pEntRetval	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_NIL) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
  error:
	return	LMR_RETURN ;
}

