/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 *	¾μ¸Υʬ¾椹ɬפ롣
 *	⤷ι˥֤׵᤬褿顩
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

static	TLMRESULT	lispMachineState_mutualEvalTryLock	(TLispMachine*) ;
static	TLMRESULT	lispMachineState_mutualEvalFinalize	(TLispMachine*) ;

TLMRESULT
lispMachineState_Mutexp (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMutex ;
	TLispEntity*	pEntRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntMutex))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TSUCCEEDED (lispEntity_Mutexp (pLispMgr, pEntMutex))) {
		lispMgr_CreateT (pLispMgr, &pEntRetval) ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

/*	(get-mutex MUTEX-NAME)
 *
 *	դʤä nil ֤
 */
TLMRESULT
lispMachineState_GetMutex (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMutex ;
	TLispEntity*	pEntMutexName ;
	const Char*		strMutexName ;
	int				nMutexName ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntMutexName)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntMutexName, &strMutexName, &nMutexName))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMgr_SearchMutex (pLispMgr, strMutexName, nMutexName, &pEntMutex))) 
		lispMgr_CreateNil (pLispMgr, &pEntMutex) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntMutex) ;
	return	LMR_RETURN ;
}

/*	(get-mutex-create MUTEX-NAME INITIAL-LOCK)
 *
 *	MUTEX-NAME  nil ʤ̵̾ Mutex Object 뤳Ȥˤʤ롣
 */
TLMRESULT
lispMachineState_GetMutexCreate (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMutexName ;
	TLispEntity*	pEntInitialLock ;
	const Char*		strMutexName ;
	int				nMutexName ;
	TLispEntity*	pEntMutex ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntMutexName)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntInitialLock))) 
		goto	error ;

	if (TSUCCEEDED (lispEntity_GetStringValue (pLispMgr, pEntMutexName, &strMutexName, &nMutexName))) {
		if (TSUCCEEDED (lispMgr_SearchMutex (pLispMgr, strMutexName, nMutexName, &pEntMutex))) {
			lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntMutex) ;
			return	LMR_RETURN ;
		}
	} else {
		if (TFAILED (lispEntity_Nullp (pLispMgr, pEntMutexName))) 
			goto	error ;
		pEntMutexName	= NULL ;
		nMutexName		= 0 ;
	}
	/*	Mutex Object 롣̾դξˤϡȥ󥿤ʳ
	 *	1 ˤʤäƤơʤ*/
	if (TFAILED (lispMgr_CreateMutex (pLispMgr, strMutexName, nMutexName, &pEntMutex))) 
		return	LMR_ERROR ;
	if (TFAILED (lispEntity_Nullp (pLispMgr, pEntInitialLock)))
		(void) lispMgr_LockMutex (pLispMgr, pEntMutex, pLM) ;

	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntMutex) ;
	return	LMR_RETURN ;

  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

/*	(mutual-eval MUTEX BODYFORM)
 */
TLMRESULT
lispMachineState_MutualEval (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMutex ;
	TLispEntity*	pEntTarget ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntMutex)) ||
		TFAILED (lispEntity_Mutexp  (pLispMgr, pEntMutex)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntTarget))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}

	lispMachineCode_PushLReg (pLM, LM_LREG_1) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_2) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_1, pEntMutex) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_2, pEntTarget) ;
	return	lispMachineState_mutualEvalTryLock (pLM) ;
}

TLMRESULT
lispMachineState_mutualEvalTryLock (
	register TLispMachine*	pLM)
{
	TLispEntity*	pEntMutex ;
	TLispEntity*	pEntTarget ;

	assert (pLM != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pEntMutex) ;
	assert (pEntMutex != NULL) ;

	/*	lock ߤ롣Ʊ process ʤƱ LispMachine 
	 *	顢lock ̤ȴġTICK ʤΤˤġMutex β
	 *	 broadcast 뵡ʤΤǡ*/
	if (TFAILED (lispMgr_LockMutex (pLM->m_pLispMgr, pEntMutex, pLM))) 
		return	LMR_TICK ;

	lispMachineCode_GetLReg (pLM, LM_LREG_2, &pEntTarget) ;
	lispMachineCode_Evaln (pLM, pEntTarget, &lispMachineState_mutualEvalFinalize) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_mutualEvalFinalize (
	register TLispMachine*	pLM)
{
	TLispEntity*	pEntMutex ;

	/*	Mutex Object  unlock 롣*/
	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pEntMutex) ;
	lispMgr_UnlockMutex (pLM->m_pLispMgr, pEntMutex, pLM) ;
	
	lispMachineCode_PopLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_1) ;
	return	LMR_RETURN ;
}

