/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "lispmgrp.h"

static	Boolean	lispMgr_registerNoNameMutex	(TLispManager*, TLispEntity*) ;
static	Boolean	lispMgr_registerNamedMutex	(TLispManager*, TLispEntity*) ;
static	void	lispMgr_abondonMutexSub		(TLispManager*, TLispEntity*, const void*) ;

Boolean
lispMgr_CreateMutex (
	register TLispManager* 			pLispMgr,
	register const Char*			pMutexName,
	register int					nMutexName,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*	pEntity ;
	register TLispMutex*	pMutex ;
	register size_t			nSize ;

	assert (pLispMgr    != NULL) ;
	assert (pMutexName  != NULL || nMutexName == 0) ;
	assert (ppEntReturn != NULL) ;

#if defined (DEBUG_LV99)
	fprintf (stderr, "Garbage collecting ...") ;
	fflush (stderr) ;
	lispMgr_CollectGarbage (pLispMgr) ;
	fprintf (stderr, "done.\n") ;
#endif	
	nSize	= sizeof (TLispMutex) + sizeof (Char) * ((nMutexName > 1)? nMutexName - 1 : 0) ;
	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, nSize, &pEntity)))
		return	False ;
		
	pEntity->m_iType		= LISPENTITY_MUTEX ;
	pEntity->m_lReferCount	= (nMutexName > 0)? 1 : 0 ;
	
	pMutex					= lispEntity_GetMutexPtr (pEntity) ;
	pMutex->m_nLength		= nMutexName ;
	if (nMutexName > 0) 
		memcpy (pMutex->m_achString, pMutexName, sizeof (Char) * nMutexName) ;
	pMutex->m_uLockCount	= 0 ;
	pMutex->m_pOwner		= NULL ;

	if (nMutexName > 0) {
		lispMgr_registerNamedMutex  (pLispMgr, pEntity) ;
	} else {
		lispMgr_registerNoNameMutex (pLispMgr, pEntity) ;
	}
	*ppEntReturn	= pEntity ;
	return	True ;
}

Boolean
lispEntity_Mutexp (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMutex)
{
	assert (pLispMgr  != NULL) ;
	assert (pEntMutex != NULL) ;
	return	(pEntMutex->m_iType == LISPENTITY_MUTEX) ;
}

Boolean
lispMgr_LockMutex (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMutex,
	register void*			pOwner)
{
	register TLispMutex*	pMutex ;

	assert (pLispMgr  != NULL) ;
	assert (pEntMutex != NULL) ;
	assert (pOwner    != NULL) ;

	pMutex	= lispEntity_GetMutexPtr (pEntMutex) ;
	if (pMutex->m_uLockCount > 0 && pMutex->m_pOwner != pOwner)
		return	False ;

	/*	åǤ³Ķȥ顼*/
	if (pMutex->m_uLockCount == (unsigned int)-1)
		return	False ;

	pMutex->m_uLockCount	++ ;
	pMutex->m_pOwner	= pOwner ;
	return	True ;
}

Boolean
lispMgr_UnlockMutex (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMutex,
	register void*			pOwner)
{
	register TLispMutex*	pMutex ;

	assert (pLispMgr  != NULL) ;
	assert (pEntMutex != NULL) ;
	assert (pOwner    != NULL) ;

	pMutex	= lispEntity_GetMutexPtr (pEntMutex) ;
	if (pMutex->m_uLockCount == 0 || pMutex->m_pOwner != pOwner)
		return	False ;

	pMutex->m_uLockCount	-- ;
	if (pMutex->m_uLockCount == 0)
		pMutex->m_pOwner	= NULL ;
	return	True ;
}

Boolean
lispEntity_GetMutexInfo (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMutex,
	register const Char**	ppString,
	register int*			pnString,
	register unsigned int*	puLockCount,
	register const void**	ppOwner)
{
	register TLispMutex*	pMutex ;

	assert (pLispMgr  != NULL) ;
	assert (pEntMutex != NULL) ;

	if (pEntMutex->m_iType != LISPENTITY_MUTEX)
		return	False ;

	pMutex		= lispEntity_GetMutexPtr (pEntMutex) ;
	if (ppString != NULL)
		*ppString	= pMutex->m_achString ;
	if (pnString != NULL)
		*pnString	= pMutex->m_nLength ;
	if (puLockCount != NULL)
		*puLockCount	= pMutex->m_uLockCount ;
	if (ppOwner != NULL)
		*ppOwner	= pMutex->m_pOwner ;
	return	True ;
}

Boolean
lispMgr_SearchMutex (
	register TLispManager*			pLispMgr,
	register const Char*			pMutexName,
	register int					nMutexName,
	register TLispEntity**	const	ppEntReturn)
{
	register TLispEntity*	pNode ;
	register TLispMutex*	pNodeMutex ;
	register const Char*	pNodeMutexName ;
	register int			nNodeMutexName ;

	assert (pLispMgr    != NULL) ;
	assert (ppEntReturn != NULL) ;

	if (pMutexName == NULL || nMutexName <= 0)
		return	False ;

	pNode		= pLispMgr->m_pEntListNamedMutex ;
	while (pNode != NULL) {
		pNodeMutex		= lispEntity_GetMutexPtr (pNode) ;
		pNodeMutexName	= pNodeMutex->m_achString ;
		nNodeMutexName	= pNodeMutex->m_nLength ;
		/*	¤ǤΤȤƤ롣*/
		if (nNodeMutexName == nMutexName &&
			!Cstrncmp (pMutexName, pNodeMutexName, nMutexName)) {
			*ppEntReturn	= pNode ;
			return	True ;
		}
		pNode			= pNode->m_pRight ;
	}
	return	False ;
}

/*	Mutex ζ
 */
void
lispMgr_AbondonMutex (
	register TLispManager*	pLispMgr,
	register const void*	pOwner)
{
	lispMgr_abondonMutexSub (pLispMgr, pLispMgr->m_pEntListNamedMutex, pOwner) ;
	lispMgr_abondonMutexSub (pLispMgr, pLispMgr->m_pEntListNoNameMutex, pOwner) ;
	return ;
}

Boolean
lispMgr_registerNoNameMutex (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMutex)
{
	register TLispEntity*	pNode ;
	register TLispMutex*	pMutex ;
	/*register const Char*	pMutexName ;*/
	register int			nMutexName ;

	assert (pLispMgr != NULL) ;
	assert (pEntMutex  != NULL) ;
	assert (pEntMutex->m_iType == LISPENTITY_MUTEX) ;

	pMutex		= lispEntity_GetMutexPtr (pEntMutex) ;
	nMutexName	= pMutex->m_nLength ;
	assert (nMutexName == 0) ;

	pNode				= pLispMgr->m_pEntListNoNameMutex ;
	pEntMutex->m_pRight	= pNode ;
	pEntMutex->m_pLeft	= NULL ;
	if (pNode != NULL)
		pNode->m_pLeft	= pEntMutex ;
	return	True ;
}

Boolean
lispMgr_registerNamedMutex (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMutex)
{
	register TLispEntity*	pNode ;
	register TLispEntity*	pPrevNode ;
	register TLispMutex*	pMutex ;
	register TLispMutex*	pNodeMutex ;
	register const Char*	pMutexName ;
	register int			nMutexName ;
	register const Char*	pNodeMutexName ;
	register int			nNodeMutexName ;
	register int			nCompare, nDiff ;

	assert (pLispMgr != NULL) ;
	assert (pEntMutex  != NULL) ;
	assert (pEntMutex->m_iType == LISPENTITY_MUTEX) ;

	pMutex		= lispEntity_GetMutexPtr (pEntMutex) ;
	pMutexName	= pMutex->m_achString ;
	nMutexName	= pMutex->m_nLength ;
	assert (pMutexName != NULL && nMutexName > 0) ;

	pNode		= pLispMgr->m_pEntListNamedMutex ;
	pPrevNode	= NULL ;
	while (pNode != NULL) {
		pNodeMutex		= lispEntity_GetMutexPtr (pNode) ;
		pNodeMutexName	= pNodeMutex->m_achString ;
		nNodeMutexName	= pNodeMutex->m_nLength ;
		/*	¤ǤΤȤƤ롣*/
		nCompare		= (nMutexName < nNodeMutexName)? nMutexName : nNodeMutexName ;
		nDiff			= Cstrncmp (pMutexName, pNodeMutexName, nCompare) ;
		assert (!(nDiff == 0 && nMutexName == nNodeMutexName)) ;
		if (nDiff > 0 || (nDiff == 0 && nMutexName > nNodeMutexName))
			break ;
		pPrevNode		= pNode ;
		pNode			= pNode->m_pRight ;
	}
	if (pPrevNode == NULL) {
		pEntMutex->m_pRight	= pLispMgr->m_pEntListNamedMutex ;
		pLispMgr->m_pEntListNamedMutex	= pEntMutex ;
	} else {
		pPrevNode->m_pRight	= pEntMutex ;
	}
	pEntMutex->m_pLeft	= pPrevNode ;
	pEntMutex->m_pRight	= pNode ;
	if (pNode != NULL)
		pNode->m_pLeft	= pEntMutex ;
	return	True ;
}

void
lispMgr_abondonMutexSub (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntListTop,
	register const void*	pOwner)
{
	register TLispEntity*	pNode ;
	register TLispMutex*	pNodeMutex ;

	pNode		= pEntListTop ;
	while (pNode != NULL) {
		pNodeMutex		= lispEntity_GetMutexPtr (pNode) ;
		if (pNodeMutex->m_pOwner == pOwner) {
			pNodeMutex->m_pOwner		= NULL ;
			pNodeMutex->m_uLockCount	= 0; 
		}
		pNode			= pNode->m_pRight ;
	}
	return ;
}

