/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lispmachine_h)
#define	lispmachine_h

#include "lispmgrp.h"
#include "vstack.h"

typedef enum {
	LMR_ERROR,
	LMR_FATALERROR,
	LMR_SUSPEND,
	LMR_CONTINUE,
	LMR_RETURN,
	LMR_TICK,
	LMR_DONE,
	LMR_DESTROYED,	/* LispMachine ˴줿ʸ塢pLM λѤ϶ػߡ*/
}	TLMRESULT ;

typedef enum {
	LMEVENT_INVALID	= -1,
	LMEVENT_KEYPRESS,
	LMEVENT_FRAMERESIZE,
}	TLMEVENT ;

struct tagTLispMachine ;
struct tagTLispEntity ;
struct tagTLispBind ;

typedef struct tagTLispMachine	TLispMachine ;

/*	Prototypes */
Boolean			TLispMachine_Create				(TLispManager*, TLispMachine*, TLispMachine** const) ;
Boolean			TLispMachine_Destroy			(TLispMachine*) ;
TLMRESULT		TLispMachine_Test				(TLispMachine*, struct tagTLispEntity*) ;
Boolean			TLispMachine_EventProc			(TLispMachine*, int, void*, void*) ;
TLispManager*	TLispMachine_GetLispManager		(TLispMachine*) ;

#endif

