/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <stdio.h>
#include <locale.h>
#include <signal.h>
#include "skkinput.h"
#include "dispatch.h"
#if defined (SUPPORT_KINPUT)
#include "KinputServer.h"
#endif
#if defined (SUPPORT_XIM)
#include "XIMServer.h"
#endif
#include "kanji.h"

/*========================================================================*
 *	ץȥ
 *========================================================================*/
static	Boolean	skkinputApp_initApplication		(int*, char*[]) ;
static	Boolean	skkinputApp_exitApplication		(void) ;
static	Boolean	skkinputApp_initInstance		(void) ;
static	Boolean	skkinputApp_exitInstance		(void) ;
static	Boolean	skkinputApp_mainLoop			(void) ;
static	Boolean	skkinputApp_initLispMgr			(void) ;
static	int		skkinputApp_getExitFlag			(void) ;
static	void	skkinputApp_onProtocolDestroy	(Widget, XtPointer, XtPointer) ;
static	int		skkinputApp_onXIoError			(Display*) ;
static	void	skkinputApp_onSignal			(int) ;
static	void	skkinputApp_showUsage			(int*, char*[]) ;

/*========================================================================*
 *	Хѿ
 *========================================================================*/
static SkkinputApp	theApp ;

#if !defined (XtNlispMachine)
#define	XtNlispMachine			"lispMachine"
#endif

typedef struct {
#if defined (SUPPORT_KINPUT)
	Boolean		m_fUseKinputProtocol ;
#endif
#if defined (SUPPORT_XIM)
	Boolean		m_fUseXIMProtocol ;
#endif
	String		m_strServerHost ;
	int			m_nPortNum ;
	String		m_strConfigPath ;
}	SkkinputAppResRec ;

static SkkinputAppResRec	theAppRes ;

#define	offset(field)	XtOffsetOf(SkkinputAppResRec,field)

static XtResource		rresSkkinputApp []	= {
#if defined (SUPPORT_KINPUT)
	{ "useKinputProtocol",	"UseKinputProtocol",	XtRBoolean,
	  sizeof (Boolean),		offset (m_fUseKinputProtocol),
	  XtRImmediate,			(XtPointer) True, },
#endif
#if defined (SUPPORT_XIM)
	{ "useXIMProtocol",		"UseXIMProtocol",		XtRBoolean,
	  sizeof (Boolean),		offset (m_fUseXIMProtocol),
	  XtRImmediate,			(XtPointer) True, },
#endif
	{ "serverHost",			"SkkserverHost",		XtRString,
	  sizeof (String),		offset (m_strServerHost),
	  XtRImmediate,			(XtPointer)"", },
	{ "portnum",			"Portnum",				XtRInt,
	  sizeof (int),			offset (m_nPortNum),
	  XtRImmediate,			(XtPointer)-1, },
	{ "configPath",			"ConfigPath",			XtRString,
	  sizeof (String),		offset (m_strConfigPath),
	  XtRImmediate,			(XtPointer) ELISP_DIR, },
} ;

#undef	offset

static XrmOptionDescRec	roptDescSkkinputApp [] = {
#if defined (SUPPORT_KINPUT)
	{ "-kinput",	".useKinputProtocol",	XrmoptionNoArg,		"True", },
	{ "+kinput",	".useKinputProtocol",	XrmoptionNoArg,		"False", },
#endif
#if defined (SUPPORT_XIM)
	{ "-xim",		".useXIMProtocol",		XrmoptionNoArg,		"True", },
	{ "+xim",		".useXIMProtocol",		XrmoptionNoArg,		"False", },
#endif
	{ "-server",	".serverHost",			XrmoptionSepArg,	NULL, },
	{ "-portnum",	".portnum",				XrmoptionSepArg,	NULL, },
	{ "-config",	".configPath",			XrmoptionSepArg,	NULL, },
	{ "-fontset",	"*fontSet",				XrmoptionSepArg,	NULL, },
	{ "-rv",		"*reverseVideo",		XrmoptionNoArg,		"True", },
	{ "+rv",		"*reverseVideo",		XrmoptionNoArg,		"False", },
	{ "-fg",		"*foreground",			XrmoptionSepArg,	NULL, },
	{ "-bg",		"*background",			XrmoptionSepArg,	NULL, },
	{ "-bd",		"*borderColor",			XrmoptionSepArg,	NULL, },
} ;

int
main (int iArgc, char* rpArgv [])
{
	register void	(*pOrgSigHandler)(int) ;

	setlocale (LC_ALL, "japanese") ;

	if (! skkinputApp_initApplication (&iArgc, rpArgv))
		return	EXIT_FAILURE ;

	pOrgSigHandler		= signal (SIGHUP, SIG_IGN) ;
	theApp.m_pLispMgr	= NULL ;
	do {
		theApp.m_fContinue	= False ;
		theApp.m_fExitFlag	= False ;

		if (! skkinputApp_initInstance ())
			return	EXIT_FAILURE ;

		(void) signal (SIGHUP,  skkinputApp_onSignal) ;
		(void) signal (SIGINT,  skkinputApp_onSignal) ;
		(void) signal (SIGQUIT, skkinputApp_onSignal) ;
		if (theApp.m_nProtocol > 0)
			skkinputApp_mainLoop () ;
		(void) signal (SIGHUP,  SIG_IGN) ;
		(void) signal (SIGINT,  SIG_IGN) ;
		(void) signal (SIGQUIT, SIG_IGN) ;
		skkinputApp_exitInstance () ;
	}	while (theApp.m_fContinue) ;

	(void) signal (SIGHUP, pOrgSigHandler) ;
	skkinputApp_exitApplication () ;

	return	EXIT_SUCCESS ; ;
}

#if defined (DEBUG)
TLispManager*
skkinputApp_GetLispMgr (void)
{
	return	theApp.m_pLispMgr ;
}
#endif

/*========================================================================*
 *	ؿ
 *========================================================================*/
Boolean
skkinputApp_initApplication (
	register int*	pnArgc,
	register char*	pArgv [])
{
	/*register TEditorClient*	pClient ;*/
	register Widget		wgToplevel ;
	Arg					rArg [8] ;
	register int		nArg, nArgc ;

	wgToplevel	= XtAppInitialize (&theApp.m_appContext, "Skkinput", roptDescSkkinputApp, XtNumber (roptDescSkkinputApp), pnArgc, pArgv, NULL, NULL, (Cardinal) 0) ;
	nArgc	= *pnArgc ;
	if (nArgc > 1) {
		skkinputApp_showUsage (pnArgc, pArgv) ;
		return	False ;
	}
	if (wgToplevel == NULL)
		return	False ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged,	False) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNwidth,				1) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNheight,				1) ;	nArg ++ ;
	XtSetValues (wgToplevel, rArg, nArg) ;

	XtGetApplicationResources (wgToplevel, &theAppRes, rresSkkinputApp, XtNumber (rresSkkinputApp), NULL, 0) ;
	AfxWinInitialize (wgToplevel) ;
	XtRealizeWidget (wgToplevel) ;
	theApp.m_wgToplevel	= wgToplevel ;
	return	True ;
}

Boolean
skkinputApp_initInstance (void)
{
	/*register TEditorClient*	pClient ;*/
	register Widget		wgToplevel ;
#if defined (SUPPORT_KINPUT)
	register Widget		wgKinputProtocol ;
#endif
#if defined (SUPPORT_XIM)
	register Widget		wgXIMProtocol ;
#endif
	Arg					rArg [8] ;
	register int		nArg ;

	theApp.m_nProtocol	= 0 ;
	wgToplevel	= theApp.m_wgToplevel ;

	/*	lisp manager ν*/
	if (TFAILED (skkinputApp_initLispMgr ()))
		return	False ;

	nArg		= 0 ;
	XtSetArg (rArg [nArg], XtNlispMachine,			theApp.m_pLM) ;	nArg ++ ;

#if defined (SUPPORT_KINPUT)
    /* Kinput Protocol Ѥ뤿νԤ*/
	if (theAppRes.m_fUseKinputProtocol) {
		wgKinputProtocol	= XtCreateManagedWidget ("kinput2", kinputServerWidgetClass, wgToplevel, rArg, nArg) ;
		if (wgKinputProtocol != NULL) {
			XtAddCallback (wgKinputProtocol, XtNdestroyCallback, skkinputApp_onProtocolDestroy, 0) ;
			XtRealizeWidget (wgKinputProtocol) ;
			theApp.m_nProtocol	++ ;
		}
	} else {
		wgKinputProtocol		= NULL ;
	}
	theApp.m_wgKinputProtocol	= wgKinputProtocol ;
#endif
#if defined (SUPPORT_XIM)
	/*	XIMProtocol ¦ν*/
	if (theAppRes.m_fUseXIMProtocol) {
		wgXIMProtocol		= XtCreateManagedWidget ("xim", ximServerWidgetClass, wgToplevel, rArg, nArg) ;
		if (wgXIMProtocol != NULL) {
			XtAddCallback (wgXIMProtocol, XtNdestroyCallback, skkinputApp_onProtocolDestroy, 0) ;
			XtRealizeWidget (wgXIMProtocol) ;
			theApp.m_nProtocol	++ ;
		}
	} else {
		wgXIMProtocol		= NULL ;
	}
	theApp.m_wgXIMProtocol		= wgXIMProtocol ;
#endif
	if (theApp.m_nProtocol <= 0) {
		fprintf (stderr, "No protocol server is available.\n") ;
		return	False ;
	}
	return	True ;
}

Boolean
skkinputApp_exitInstance (void)
{
#if defined (SUPPORT_KINPUT)
	if (theApp.m_wgKinputProtocol != NULL) {
		XtDestroyWidget (theApp.m_wgKinputProtocol) ;
		theApp.m_wgKinputProtocol	= NULL ;
	}
#endif
#if defined (SUPPORT_XIM)
	if (theApp.m_wgXIMProtocol != NULL) {
		XtDestroyWidget (theApp.m_wgXIMProtocol) ;
		theApp.m_wgXIMProtocol	= NULL ;
	}
#endif
	theApp.m_nProtocol	= 0 ;
	TLispClient_ClassFinalize (theApp.m_pLM) ;
	theApp.m_pLM		= NULL ;
	return	True ;
}

Boolean
skkinputApp_exitApplication (void)
{
	register Display*	pDisplay ;

	pDisplay			= XtDisplay (theApp.m_wgToplevel) ;
	XtDestroyWidget (theApp.m_wgToplevel) ;
    XtDestroyApplicationContext (theApp.m_appContext) ;
	return	True ;
}

Boolean
skkinputApp_mainLoop (void)
{
	register int	(*pOrgHandler)(Display*, XErrorEvent*) ;
	register int	(*pOrgIOHandler)(Display*) ;

#if defined (DEBUG)
	fprintf (stderr, "skkinputApp_mainLoop(): enter\n") ;
#endif
	pOrgHandler		= XSetErrorHandler   (AfxHandleXError) ;
	pOrgIOHandler	= XSetIOErrorHandler (skkinputApp_onXIoError) ;
	TLispClient_MainLoop (theApp.m_appContext, theApp.m_pLM, &skkinputApp_getExitFlag) ;
	(void) XSetIOErrorHandler (pOrgIOHandler) ;
	(void) XSetErrorHandler (pOrgHandler) ;
#if defined (DEBUG)
	fprintf (stderr, "skkinputApp_mainLoop(): leave\n") ;
#endif
	return	True ;
}

Boolean
skkinputApp_initLispMgr (void)
{
	register Boolean		fCreate	;
	register const char*	strConfigPath ;	
	register const char*	strServerHost ;
	register int			nPortNum ;

	fCreate			= (theApp.m_pLispMgr == NULL) ;
	strConfigPath	= theAppRes.m_strConfigPath ;
	strServerHost	= theAppRes.m_strServerHost ;
	nPortNum		= theAppRes.m_nPortNum ;
	if (TFAILED (TLispClient_ClassInitialize (&theApp.m_pLispMgr, &theApp.m_pLM, strConfigPath, strServerHost, nPortNum, fCreate))) {
		fprintf (stderr, "skkinput: failed: initialize lisp manager.\n") ;
		return	False ;
	}
	return	True ;
}

int
skkinputApp_getExitFlag (void)
{
	return	theApp.m_fExitFlag ;
}

void
skkinputApp_onSignal (
	register int		nSignal)
{
	register Display*	pDisplay ;
	XEvent				xev ;

#if defined (DEBUG)
	fprintf (stderr, "Catch SIGHUP (%d)\n", nSignal) ;
#endif
	theApp.m_fContinue			= (nSignal == SIGHUP)? True : False ;
	theApp.m_fExitFlag			= True ;

	pDisplay					= XtDisplay (theApp.m_wgToplevel) ;
	memset (&xev, 0, sizeof (xev)) ;
	xev.xclient.type			= ClientMessage ;
	xev.xclient.serial			= 0UL ;
	xev.xclient.window			= XtWindow (theApp.m_wgToplevel) ;
	xev.xclient.display			= pDisplay ;
	xev.xclient.message_type	= None ;
	xev.xclient.format			= 8 ;
	XSendEvent (pDisplay, XtWindow (theApp.m_wgToplevel), True, NoEventMask, &xev) ;
	XFlush (pDisplay) ;
	return ;
}

void
skkinputApp_onProtocolDestroy (
	register Widget		gw,
	register XtPointer	closure,
	register XtPointer	call_data)
{
#if defined (SUPPORT_KINPUT)
	if (gw == theApp.m_wgKinputProtocol) {
		theApp.m_nProtocol	-- ;
		theApp.m_wgKinputProtocol	= NULL ;
	}
#endif
#if defined (SUPPORT_XIM)
	if (gw == theApp.m_wgXIMProtocol) {
		theApp.m_nProtocol	-- ;
		theApp.m_wgXIMProtocol		= NULL ;
	}
#endif
#if defined (DEBUG)
	fprintf (stderr, "theApp.m_nProtocol = %d\n", theApp.m_nProtocol) ;
#endif
	if (theApp.m_nProtocol <= 0)
		theApp.m_fExitFlag	= True ;
	return ;
}

/*	X IO Error Υϥɥ顣
 */
int
skkinputApp_onXIoError (
	register Display*	pDisplay)
{
#if defined (DEBUG)
	fprintf (stderr, "skkinputApp_onXIoError (%p)\n", pDisplay) ;
#endif
	if (theApp.m_pLispMgr != NULL &&
		theApp.m_pLM != NULL) {
		TLispClient_ClassFinalize (theApp.m_pLM) ;
	}
	exit (0) ;
}

void
skkinputApp_showUsage (
	register int*		pnArgc,
	register char*		pArgv [])
{
	register int	i, nArgc ;

	nArgc	= *pnArgc ;
	for (i = 1 ; i < nArgc ; i ++) {
		if (strcmp (pArgv [i], "-v") && strcmp (pArgv [i], "-version")) 
			fprintf (stderr, "Unknown option: %s\n", pArgv [i]) ;
	}
	fprintf (stderr, "skkinput version 3.0_3\n") ;
	fprintf (stderr, "[usage]\n") ;
	fprintf (stderr, " -v, -version:  show version\n") ;
#if defined (SUPPORT_KINPUT)
	fprintf (stderr, " -/+kinput:     enable/disable kinput protocol server\n") ;
#endif
#if defined (SUPPORT_XIM)
	fprintf (stderr, " -/+xim:        enable/disable XIM protocol server\n") ;
#endif
	fprintf (stderr, " -server:       specify skk-server-host\n") ;
	fprintf (stderr, " -portnum:      specify skk-portnum\n") ;
	fprintf (stderr, " -config:       specify load-path (default:%s)\n", ELISP_DIR) ;
	fprintf (stderr, " -fontset:      specify default fontset\n") ;
	fprintf (stderr, " -fg:           specify default foreground pixel\n") ;
	fprintf (stderr, " -bg:           specify default background pixel\n") ;
	fprintf (stderr, " -bd:           specify default border pixel\n") ;
	fprintf (stderr, " -/+rv:         enable/disable reverse video\n") ;
	return ;
}

