/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (TSubWindowFrameP_h)
#define	TSubWindowFrameP_h

#include "TFrameP.h"
#include "TSubWindowFrame.h"
#include "varbuffer.h"
#include "TFontSet.h"

typedef struct tagTSubWindowFrameTerminalTextControl {
	int						m_nTextPos ;
	int						m_nText ;
	Boolean					m_fRev ;
	Boolean					m_fFinish ;
}	TSubWindowFrameTerminalTextControl ;

typedef struct tagTSubWindowFrameTerminal {
	TVarbuffer				m_vbufText ;	/* ʸ*/
	TVarbuffer				m_vbufControl ;	/* 楳ɡ*/
	int						m_nCursor ;		/* ߤΥ֡*/
	Boolean					m_fRev ;		/* ReverseVideo ݤ*/
	int						m_nLine ;
}	TSubWindowFrameTerminal ;

typedef struct tagTSubWindowFramePart {
	Window					m_wndClient ;
	Window					m_wndFocus ;
	Pixel					m_pxlForeground ;
	XtCallbackList			m_lstCbkConfigure ;
	XtCallbackList			m_lstCbkDestroy ;
	Boolean					m_fDestroy ;

	Window					m_wndTerminal ;
	GC						m_gcTerminal ;
	TFontSet				m_fsTerminal ;
	int						m_nLineSpacing ;
	TSubWindowFrameTerminal	m_Terminal ;
}	TSubWindowFramePart ;

typedef struct tagTSubWindowFrameRec {
	CorePart				core ;
	CompositePart			composite ;
	ShellPart				shell ;
	TFramePart				tframe ;
	TSubWindowFramePart		tsubwin ;
}	TSubWindowFrameRec ;

typedef struct {
	int						dummy ;
}	TSubWindowFrameClassPart ;

typedef struct tagTSubWindowFrameClassRec {
	CoreClassPart			core_class ;
	CompositeClassPart		composite_class ;
	ShellClassPart			shell_class ;
	TFrameClassPart			tframe_class ;
	TSubWindowFrameClassPart	tsubframe_class ;
}	TSubWindowFrameClassRec ;

extern TSubWindowFrameClassRec	tsubWindowFrameClassRec ;

#endif
