/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (TRootWindowP_h)
#define	TRootWindowP_h

#include "TFrameP.h"
#include "TRootWindow.h"

/*
 *
 */
typedef struct tagTRootWindowPart {
	Window					m_wndFocus ;
	Window					m_wndClient ;

	Widget					m_wgPopup ;			/* Terminal οƤˤʤ ShellWidget */
	Widget					m_wgTerminal ;		/* Terminal Widget */
	Boolean					m_fAutoPopup ; 
	Boolean					m_fActive ;
	Boolean					m_fHaveText ;
}	TRootWindowPart ;

typedef struct tagTRootWindowRec {
	CorePart				core ;
	CompositePart			composite ;
	ShellPart				shell ;
	TFramePart				tframe ;
	TRootWindowPart			trootwin ;
}	TRootWindowRec ;

typedef struct {
	int						dummy ;
}	TRootWindowClassPart ;

typedef struct tagTRootWindowClassRec {
	CoreClassPart			core_class ;
	CompositeClassPart		composite_class ;
	ShellClassPart			shell_class ;
	TFrameClassPart			tframe_class ;
	TRootWindowClassPart	trootwin_class ;
}	TRootWindowClassRec ;

extern TRootWindowClassRec	trootWindowClassRec ;

#endif

