/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include "TRootWindowP.h"
#include "TTerminal.h"
#include "TConvAttr.h"

#define offset(field)	XtOffsetOf(TRootWindowRec, trootwin.field)
#define goffset(field)	XtOffsetOf(WidgetRec, core.field )

static	XtResource	srRootWindowResource []	= {
	{	XtNwidth,					XtCWidth,
		XtRDimension,				sizeof (Dimension),
		goffset (width),			XtRImmediate,		(XtPointer) 640, },
	{	XtNheight,					XtCHeight,
		XtRDimension,				sizeof (Dimension),
		goffset (height),			XtRImmediate,		(XtPointer) 3, },
	{	XtNbackground,				XtCBackground,
		XtRPixel,					sizeof (Pixel),
		goffset (background_pixel),	XtRString,			XtDefaultBackground, },
#if 0
	{	XtNreverseVideo,			XtCReverseVideo,
		XtRBoolean,					sizeof (Boolean),
		offset (m_fReverseVideo),	XtRImmediate,		(XtPointer) False, },
#endif
	{	XtNclientWindow,			XtCClientWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndClient),		XtRImmediate,		(XtPointer) None, },
	{	XtNfocusWindow,				XtCFocusWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndFocus),		XtRImmediate,		(XtPointer) None, },
	{	XtNautoPopup,				XtCAutoPopup,
		XtRBoolean,					sizeof (Boolean),
		offset (m_fAutoPopup),		XtRImmediate,		(XtPointer) False, },
} ;

#undef	offset
#undef	goffset

static	void	trootWindow_onInitialize	(Widget, Widget, ArgList, Cardinal*) ;
static	void	trootWindow_onRealize		(Widget, XtValueMask*, XSetWindowAttributes*) ;
static	Boolean	trootWindow_onSetValues		(Widget, Widget, Widget, ArgList, Cardinal*) ;
static	void	trootWindow_onDestroy		(Widget) ;
static	void	trootWindow_onKeyPress		(Widget, XEvent*, String*, Cardinal*) ;
static	void	trootWindow_onKeyRelease	(Widget, XEvent*, String*, Cardinal*) ;

static	void*	trootWindow_getclient		(Widget) ;
static	int		trootWindow_getrect			(Widget, XRectangle*) ;
static	void	trootWindow_activate		(Widget, Boolean) ;
static	void*	trootWindow_getfontset		(Widget) ;
static	Boolean	trootWindow_getlinespacing	(Widget, int*) ;
static	void*	trootWindow_getlispframeobject	(Widget) ;
static	void	trootWindow_setattribute		(Widget, const TConversionAttribute*) ;
static	Boolean	trootWindow_putchar			(Widget, const Char) ;
static	Boolean	trootWindow_puts			(Widget, const Char*, int) ;
static	void	trootWindow_rev				(Widget, Boolean) ;
static	void	trootWindow_clear			(Widget) ;
static	void	trootWindow_flush			(Widget) ;
static	Boolean	trootWindow_rectVariablep	(Widget) ;
static	Boolean	trootWindow_haveExternModelinep	(Widget) ;
static	Boolean	trootWindow_setModeline		(Widget, const Char*, int) ;
static	Boolean	trootWindow_autoPopupp		(Widget) ;
static	void	trootWindow_popup			(Widget) ;
static	void	trootWindow_popdown			(Widget) ;

static	void	trootWindow_onTerminalKeyPress	(Widget, XtPointer, XEvent*, Boolean*) ;
static	void	trootWindow_onTerminalConfigure	(Widget, XtPointer, XEvent*, Boolean*) ;

static	void	trootWindow_adjustPopupWindow	(Widget) ;


static	XtActionsRec	srRootWindowAction []	= {
	{ "onKeyPress",		trootWindow_onKeyPress, },
	{ "onKeyRelease",	trootWindow_onKeyRelease, },
} ;

static	char			strRootWindowTranslation []	= 
"<Key>:                 onKeyPress()\n\
 <KeyRelease>:          onKeyRelease()\n" ;

TRootWindowClassRec		trootWindowClassRec	= {
    {	/* core fields */
		/* superclass			*/	(WidgetClass) &tframeClassRec,
		/* class_name			*/	"TRootWindow",
		/* size					*/	sizeof (TRootWindowRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	trootWindow_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	trootWindow_onRealize,
		/* actions				*/	srRootWindowAction,
		/* num_actions			*/	XtNumber (srRootWindowAction),
		/* resources			*/	srRootWindowResource,
		/* num_resources		*/	XtNumber(srRootWindowResource),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	trootWindow_onDestroy,
		/* resize				*/	NULL,
		/* expose				*/	NULL,
		/* set_values			*/	trootWindow_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table				*/	strRootWindowTranslation,
		/* query_geometry		*/	XtInheritQueryGeometry,
		/* display_accelerator	*/	NULL,
		/* extension	  		*/	NULL,
    },
	{	/* Composite			*/
		/* geometry_manager		*/	XtInheritGeometryManager,
		/* change_managed		*/	XtInheritChangeManaged,
		/* insert_child			*/	XtInheritInsertChild,
		/* delete_child			*/	XtInheritDeleteChild,
		/* extension			*/	NULL,
	},
	{	/* Shell				*/
		/* extension			*/	NULL,
	},
	{
		/* getclient			*/	trootWindow_getclient,
		/* getlispframeobject	*/	trootWindow_getlispframeobject,
		/* setattribute			*/	trootWindow_setattribute,
		/* getrect				*/	trootWindow_getrect,
		/* activate				*/	trootWindow_activate,
		/* getfontset			*/	trootWindow_getfontset,
		/* getlinespacing		*/	trootWindow_getlinespacing,
		/* puts					*/	trootWindow_puts,
		/* putchar				*/	trootWindow_putchar,
		/* rev					*/	trootWindow_rev,
		/* clear				*/	trootWindow_clear,
		/* flush				*/	trootWindow_flush,
		/* rectvariablep		*/	trootWindow_rectVariablep,
		/* haveExternModelinep	*/	trootWindow_haveExternModelinep,
		/* setModeline			*/	trootWindow_setModeline,
		/* autoPopupp			*/	trootWindow_autoPopupp,
		/* setCaret				*/	NULL,
	},
	{
		/* dummy				*/	0,
	},
} ;

WidgetClass	trootWindowWidgetClass	= (WidgetClass) &trootWindowClassRec ;

void
trootWindow_onInitialize (
	Widget		wgRequest,
	Widget		wgNew,
	ArgList		args,
	Cardinal*	num_args)
{
	TRootWindowWidget	w = (TRootWindowWidget) wgNew ;

	w->trootwin.m_wgPopup		= 0 ;
	w->trootwin.m_wgTerminal	= 0 ;
	w->trootwin.m_fHaveText		= False ;
	w->trootwin.m_fActive		= False ;
	return ;
}

void
trootWindow_onRealize (
	register Widget					gw,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;
	CoreWidgetClass		super	= (CoreWidgetClass) XtClass (gw)->core_class.superclass ;
	Widget				wgPopup ;
	Widget				wgTerminal ;
	Arg					rArg [8] ;
	int					nArg ;

	(*super->core_class.realize) (gw, pValueMask, pXSWA) ;

	/*	Popup Widget 롣 Popup Widget Τ RootWindowStyle
	 *	 Window ˤʤ롣
	 */
	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNwidth,	gw->core.width) ;			nArg ++ ;
	XtSetArg (rArg [nArg], XtNheight,	gw->core.height) ;			nArg ++ ;
	XtSetArg (rArg [nArg], XtNinput,	wgThis->tframe.m_fInput) ;	nArg ++ ;
#if 0
	XtSetArg (rArg [nArg], XtNinput,	True) ;						nArg ++ ;
#endif
	/*XtSetArg (rArg [nArg], XtNmappedWhenManaged,	False) ;		nArg ++ ;*/
	assert (nArg < (sizeof (rArg) / sizeof (rArg [0]))) ;
	wgPopup	= XtCreatePopupShell ("RootWindowStyleFrame", transientShellWidgetClass, gw, rArg, nArg) ;

	/*	Terminal Window 롣*/
	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNinput, True) ; nArg ++ ;
	assert (nArg < (sizeof (rArg) / sizeof (rArg [0]))) ;
	wgTerminal	= XtCreateManagedWidget ("RootWindowTerminal", tterminalWidgetClass, wgPopup, rArg, nArg) ;

	/*	Terminal Window  Event Handler Ͽ롣*/
	wgThis->trootwin.m_wgPopup		= wgPopup ;
	wgThis->trootwin.m_wgTerminal	= wgTerminal ;
	XtRealizeWidget (wgPopup) ;

	trootWindow_adjustPopupWindow (gw) ;

	XtAddEventHandler (wgTerminal, KeyPressMask, False, trootWindow_onTerminalKeyPress, gw) ;
	XtAddEventHandler (wgPopup,    StructureNotifyMask, False, trootWindow_onTerminalConfigure, gw) ;
	return ;
}

Boolean
trootWindow_onSetValues (
	register Widget		curw,
	register Widget		reqw,
	register Widget		neww,
	register ArgList	args,
	register Cardinal*	num_args)
{
	return	False ;
}

void
trootWindow_onDestroy (
	register Widget	gw)
{
	TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;

	if (wgThis->trootwin.m_wgPopup != NULL) {
		XtDestroyWidget (wgThis->trootwin.m_wgPopup) ;
		wgThis->trootwin.m_wgPopup	= NULL ;
	}
	/*	Manage ƤΤǡפ */
	if (wgThis->trootwin.m_wgTerminal != NULL) {
		XtDestroyWidget (wgThis->trootwin.m_wgTerminal) ;
		wgThis->trootwin.m_wgTerminal	= NULL ;
	}
	return ;
}

void
trootWindow_onKeyPress (
	register Widget		gw,
	register XEvent*	pEvent,
	register String*	pString,
	register Cardinal*	num_args)
{
	if (!XtIsRealized (gw))
		return ;
	/*	Event Select: None ȡ˸ä KeyEvent ꤲǽ
	 *	롣*/
	XtCallCallbacks (gw, XtNkeyPressCallback, (XtPointer) pEvent) ;
	return ;
 }

void
trootWindow_onKeyRelease (
	register Widget		gw,
	register XEvent*	pEvent,
	register String*	pString,
	register Cardinal*	num_args)
{
	return ;
}

/*	Terminal ؤ key Ϥ򽦤ä client ˽뤿 wrapper callback ؿ
 *	 callback  callback Ťͤơߤΰ¸٤򸺤餷ƤΤɡä
 *	ɤˤʤäΤ⤷ʤ(;_;)
 */
void
trootWindow_onTerminalKeyPress (
	register Widget			gwTerinal,
	register XtPointer		closure,
	register XEvent*		pEvent,
	register Boolean*		pContinueToDispatch)
{
	register TRootWindowWidget	wgThis		= (TRootWindowWidget) closure ;

	XtCallCallbacks ((Widget) wgThis, XtNkeyPressCallback, (XtPointer) pEvent) ;
	return ;
}

void
trootWindow_onTerminalConfigure (
	register Widget			gwTerminal,
	register XtPointer		closure,
	register XEvent*		pEvent,
	register Boolean*		pContinueToDispatch)
{
	register TRootWindowWidget	wgThis		= (TRootWindowWidget) closure ;
	XRectangle	rc ;

#if defined (DEBUG)
	fprintf (stderr, "Event: Type(%d), Window(%lx)\n", 
			 pEvent->type, pEvent->xany.window) ;
#endif
	if (pEvent->type != ConfigureNotify)
		return ;
#if defined (DEBUG)
	if (pEvent->type == ConfigureNotify) {
		fprintf (stderr, "Configure: %d, %d, %d, %d\n", 
				 pEvent->xconfigure.x, pEvent->xconfigure.y, 
				 pEvent->xconfigure.width, pEvent->xconfigure.height) ; 
	}
#endif
	rc.x		= 0 ;
	rc.y		= 0 ;
	rc.width	= pEvent->xconfigure.width ;
	rc.height	= pEvent->xconfigure.height ;
#if defined (DEBUG)
	if (wgThis->trootwin.m_wgTerminal != NULL) {
		XWindowAttributes	xwa ;
		XGetWindowAttributes (XtDisplay (wgThis), XtWindow (wgThis->trootwin.m_wgTerminal), &xwa) ;
		fprintf (stderr, "Terminal: core(%d, %d, %d, %d), window(%d, %d)\n",
				 wgThis->trootwin.m_wgTerminal->core.x,
				 wgThis->trootwin.m_wgTerminal->core.y,
				 wgThis->trootwin.m_wgTerminal->core.width,
				 wgThis->trootwin.m_wgTerminal->core.height,
				 xwa.width,
				 xwa.height) ;
	}
#endif
	XtCallCallbacks ((Widget) wgThis, XtNconfigureCallback, (XtPointer) &rc) ;
	return ;
}

/*	private functions
 */
void*
trootWindow_getclient (
	register Widget	gw)
{
	TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;

	return	wgThis->tframe.m_pClient ;
}

int
trootWindow_getrect (
	register Widget			gw,
	register XRectangle*	pRect)
{
	TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;

	if (pRect != NULL) {
		pRect->x		= 0 ;
		pRect->y		= 0 ;
		pRect->width	= wgThis->trootwin.m_wgTerminal->core.width ;
		pRect->height	= wgThis->trootwin.m_wgTerminal->core.height ;
	}
	return	1 ;
}

void
trootWindow_activate (
	register Widget			gw,
	register Boolean		fActivate)
{
	if (fActivate) {
		trootWindow_popup (gw) ;
	} else {
		trootWindow_popdown (gw) ;
	}
	return ;
}

void*
trootWindow_getfontset (
	register Widget			gw)
{
	TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;

	return	TTerminal_GetFontSet (wgThis->trootwin.m_wgTerminal) ;
}

Boolean
trootWindow_getlinespacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	register TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;
	register TFontSet*			pFontSet ;
	
	pFontSet		= TTerminal_GetFontSet (wgThis->trootwin.m_wgTerminal) ;
	assert (pFontSet != NULL) ;
	*pnLineSpacing	= TFontSet_GetHeight (pFontSet) ;
	return	False ;
}

void*
trootWindow_getlispframeobject (
	register Widget			gw)
{
	TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;

	return	wgThis->tframe.m_pLispFrameObject ;
}

void
trootWindow_setattribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	/*	RootWindow Style ä ConversionAttribute 򸫤ʤ
	 */
	return ;
}

Boolean
trootWindow_putchar (
	register Widget			gw,
	register const Char		cc)
{
	register TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;
	
	TTerminal_Putchar (wgThis->trootwin.m_wgTerminal, cc) ;
	wgThis->trootwin.m_fHaveText	= True ;
	return	True ;
}

Boolean
trootWindow_puts (
	register Widget			gw,
	register const Char*	pText,
	register int			nText)
{
	register TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;
	register Widget				wgTerminal ;
	
	wgTerminal	= wgThis->trootwin.m_wgTerminal ;
	while (nText -- > 0) 
		TTerminal_Putchar (wgTerminal, *pText ++) ;
	wgThis->trootwin.m_fHaveText	= True ;
	return	True ;
}

void
trootWindow_rev (
	register Widget			gw,
	register Boolean		fRev)
{
	register TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;
	
	TTerminal_Rev (wgThis->trootwin.m_wgTerminal, fRev) ;
	return ;
}

void
trootWindow_clear (
	register Widget			gw)
{
	register TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;
	
	TTerminal_Clear (wgThis->trootwin.m_wgTerminal) ;
	wgThis->trootwin.m_fHaveText	= False ;
	return ;
}

void
trootWindow_flush (
	register Widget			gw)
{
	register TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;
	
	if (wgThis->trootwin.m_fAutoPopup &&
		wgThis->trootwin.m_fActive) {
		if (wgThis->trootwin.m_fHaveText) {
#if defined (DEBUG)
			fprintf (stderr, "HaveText...\n") ;
#endif
			XtPopup (wgThis->trootwin.m_wgPopup, XtGrabNonexclusive) ;
		} else {
#if defined (DEBUG)
			fprintf (stderr, "No Text...\n") ;
#endif
			XtPopdown (wgThis->trootwin.m_wgPopup) ;
			return ;
		}
	}
	TTerminal_Update (wgThis->trootwin.m_wgTerminal) ;
	return ;
}

Boolean
trootWindow_rectVariablep (
	register Widget			gw)
{
	return	False ;
}

Boolean
trootWindow_haveExternModelinep (
	register Widget			gw)
{
	return	False ;
}

Boolean
trootWindow_setModeline (
	register Widget			gw,
	register const Char*	pString,
	register int			nString)
{
	return	False ;
}

Boolean
trootWindow_autoPopupp (
	register Widget			gw)
{
	register TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;

	return	wgThis->trootwin.m_fAutoPopup ;
}

void
trootWindow_adjustPopupWindow (
	register Widget		gw)
{
	register TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;
	register Display*	pDisplay 	= XtDisplay (gw) ;
	register Widget		wgPopup ;
	register Window		wndFocus, wndRoot ;
	Window	wndDummy ;
	int		nFocusX, nFocusY ;
	int		nX, nY, nFocusWidth, nFocusHeight, nRootWidth, nRootHeight, nDummy ;
	register int		nPosX, nPosY, nCanvasWidth, nCanvasHeight, nCanvasBorder ;
	register TFontSet*	pFS ;
	
	wgPopup			= wgThis->trootwin.m_wgPopup ;
	assert (wgPopup != NULL) ;
	assert (wgThis->trootwin.m_wgTerminal != NULL) ;
	assert (XtIsRealized (wgThis->trootwin.m_wgTerminal)) ;

	pFS				= TTerminal_GetFontSet (wgThis->trootwin.m_wgTerminal) ;
	nCanvasHeight	= TFontSet_GetHeight (pFS) * wgThis->core.height ;
	nCanvasWidth	= wgThis->trootwin.m_wgTerminal->core.width ;
	nCanvasBorder	= wgThis->trootwin.m_wgTerminal->core.border_width ;

	if (wgThis->trootwin.m_wndFocus != None) {
		wndFocus	= wgThis->trootwin.m_wndFocus ;
	} else {
		wndFocus	= wgThis->trootwin.m_wndClient ;
	}
	assert (wndFocus != None) ;

	XGetGeometry (pDisplay, wndFocus, &wndDummy, &nFocusX, &nFocusY, &nFocusWidth, &nFocusHeight, &nDummy, &nDummy) ;
#if defined (DEBUG)
	fprintf (stderr, "Focus:(%lx) => (%d, %d, %d, %d)\n", wndFocus, nFocusX, nFocusY, nFocusWidth, nFocusHeight) ;
#endif
	wndRoot	= RootWindowOfScreen (XtScreen (gw)) ;
	XGetGeometry (pDisplay, wndRoot, &wndDummy, &nDummy, &nDummy, &nRootWidth, &nRootHeight, &nDummy, &nDummy) ;
	XTranslateCoordinates (pDisplay, wndFocus, wndRoot, 0, 0, &nX, &nY, &wndDummy) ;

	nPosX	= nX ;
	nPosY	= nY ;
	nPosY	= nY + nFocusHeight ;
	if ((nPosY + nCanvasHeight) > nRootHeight) {
		XSizeHints	sizehints ;
		long		supplied ;

		if (nPosY < 0) 
			nPosY	= nRootHeight - nCanvasHeight - nCanvasBorder ;

		/* Window Manager ˥ҥȤäƤ롣XSetWMNormalHints * 
		 * ʬ񴹤ʤ褦ʤΤǡ hints ɤߤȤäƤ麹*
		 * ؤȤˡȤʤФʤʤ*/
		XGetWMNormalHints (pDisplay, XtWindow (wgPopup), &sizehints, &supplied) ;
		sizehints.flags			|= PWinGravity ;
		sizehints.win_gravity	= SouthWestGravity ;
		XSetWMNormalHints (pDisplay, XtWindow (wgPopup), &sizehints) ;
	}
	if ((nPosX + nCanvasWidth) > nRootWidth) 
		nPosX	= nRootWidth - nCanvasWidth - nCanvasBorder ;
	if (nPosX < 0)
		nPosX	= 0 ;
#if defined (DEBUG)
	fprintf (stderr, "Focus Window (%d, %d, %d, %d)\n", nX, nY, nFocusWidth, nFocusHeight) ;
	fprintf (stderr, "Adjust Popup Window => (%d, %d, %d, %d)\n", nPosX, nPosY, nCanvasWidth, nCanvasHeight) ;
#endif
	XtConfigureWidget (wgPopup, nPosX, nPosY, nCanvasWidth + nCanvasBorder * 2, nCanvasHeight + nCanvasBorder * 2, wgPopup->core.border_width) ;
	/*XtMoveWidget (wgPopup, nPosX, nPosY) ;*/
	return ;
}

/*	ƥԽʬɽ롣
 */
void
trootWindow_popup (
	register Widget	gw)
{
	TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;

	if (!wgThis->trootwin.m_fAutoPopup ||
		wgThis->trootwin.m_fHaveText)
		XtPopup (wgThis->trootwin.m_wgPopup, XtGrabNonexclusive) ;
	wgThis->trootwin.m_fActive	= True ;
	return ;
}

/*	ƥԽʬɽˤ롣
 */
void
trootWindow_popdown (
	register Widget	gw)
{
	TRootWindowWidget	wgThis	= (TRootWindowWidget) gw ;

	XtPopdown (wgThis->trootwin.m_wgPopup) ;
	wgThis->trootwin.m_fActive	= False ;
	return ;
}

/*	ƤӽФ Method
 */
Widget
TRootWindowFrame_Create (
	Widget			wgParent,
	ArgList			arglist,
	Cardinal		nArglist)
{
	return	XtCreateWidget ("RootWindow", trootWindowWidgetClass, wgParent, arglist, nArglist) ;
}

