/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include "TOverTheSpotWindowP.h"
#include "TRootWindow.h"
#include "TSubWindowFrame.h"
#include "TTerminal.h"
#include "TConvAttr.h"
#include "dispatch.h"
#include "ttext.h"

#if !defined (DEFAULT_FONTSET)
#define	DEFAULT_FONTSET	"-*--12-*"
#endif
#if !defined (DEFAULT_FONTHEIGHT)
#define	DEFAULT_FONTHEIGHT	12
#endif

#define offset(field)	XtOffsetOf(TOverTheSpotWindowRec, toverwin.field)
#define soffset(field)	XtOffsetOf(ShellWidgetRec, shell.field)
#define goffset(field)	XtOffsetOf(WidgetRec, core.field )

static	XtResource	srOverTheSpotWindowResource []	= {
	{	XtNwidth,					XtCWidth,
		XtRDimension,				sizeof (Dimension),
		goffset (width),			XtRImmediate,		(XtPointer) 640, },
	{	XtNheight,					XtCHeight,
		XtRDimension,				sizeof (Dimension),
		goffset (height),			XtRImmediate,		(XtPointer) 48, },
	{	XtNbackground,				XtCBackground,
		XtRPixel,					sizeof (Pixel),
		goffset (background_pixel),	XtRString,			XtDefaultBackground, },
	{	XtNforeground,				XtCForeground,
		XtRPixel,					sizeof (Pixel),
		offset (m_pxlForeground),	XtRString,			XtDefaultForeground, },
#if 0
	{	XtNreverseVideo,			XtCReverseVideo,
		XtRBoolean,					sizeof (Boolean),
		offset (m_fReverseVideo),	XtRImmediate,		(XtPointer) False, },
#endif
	/*	ͤȤƤΤѤ default  fontset ̾*/
	{	XtNfontSet,					XtCFontSet,
		XtRString,					sizeof (String),
		offset (m_strFontSet),		XtRImmediate,		(XtPointer) DEFAULT_FONTSET, },
	{	XtNclientWindow,			XtCClientWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndClient),		XtRImmediate,		(XtPointer) None, },
	{	XtNfocusWindow,				XtCFocusWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndFocus),		XtRImmediate,		(XtPointer) None, },
	{	XtNminibufFrame,			XtCMinibufFrame,
		XtRWidget,					sizeof (Widget),
		offset (m_wgMinibuf),		XtRWidget,			NULL, },
} ;

#undef	offset
#undef	goffset

static	void	toverTheSpotWindow_onInitialize	(Widget, Widget, ArgList, Cardinal*) ;
static	void	toverTheSpotWindow_onRealize	(Widget, XtValueMask*, XSetWindowAttributes*) ;
static	Boolean	toverTheSpotWindow_onSetValues	(Widget, Widget, Widget, ArgList, Cardinal*) ;
static	void	toverTheSpotWindow_onDestroy	(Widget) ;
static	void	toverTheSpotWindow_onKeyPress	(Widget, XEvent*, String*, Cardinal*) ;
static	void	toverTheSpotWindow_onKeyRelease	(Widget, XEvent*, String*, Cardinal*) ;

static	int		toverTheSpotWindow_onFocusResize			(void*, XEvent*) ;
static	int		toverTheSpotWindow_onTopTerminalExpose		(void*, XEvent*) ;
static	int		toverTheSpotWindow_onMiddleTerminalExpose	(void*, XEvent*) ;
static	int		toverTheSpotWindow_onBottomTerminalExpose	(void*, XEvent*) ;
static	int		toverTheSpotWindow_onTerminalDestroy		(void*, XEvent*) ;
static	int		toverTheSpotWindow_onModeshellExpose		(void*, XEvent*) ;
static	int		toverTheSpotWindow_onModeshellDestroy		(void*, XEvent*) ;
static	int		toverTheSpotWindow_onSubwindowKeyPress		(void*, XEvent*) ;
static	int		toverTheSpotWindow_onSubwindowKeyRelease	(void*, XEvent*) ;

static	Boolean	toverTheSpotWindow_putchar		(Widget, const Char) ;
static	Boolean	toverTheSpotWindow_puts			(Widget, const Char*, int) ;
static	void	toverTheSpotWindow_flush		(Widget) ;
static	void	toverTheSpotWindow_clear		(Widget) ;
static	void	toverTheSpotWindow_rev			(Widget, Boolean) ;
static	Boolean	toverTheSpotWindow_rectVariablep(Widget) ;
static	Boolean	toverTheSpotWindow_haveExternModelinep (Widget) ;
static	Boolean	toverTheSpotWindow_setModeline	(Widget, const Char*, int) ;
static	Boolean	toverTheSpotWindow_autoPopupp	(Widget) ;

static	void*	toverTheSpotWindow_getclient	(Widget) ;
static	int		toverTheSpotWindow_getrect		(Widget, XRectangle*) ;
static	void	toverTheSpotWindow_activate		(Widget, Boolean) ;
static	void*	toverTheSpotWindow_getfontset	(Widget) ;
static	Boolean	toverTheSpotWindow_getlinespacing	(Widget, int*) ;
static	void*	toverTheSpotWindow_getlispframeobject	(Widget) ;
static	void	toverTheSpotWindow_setattribute	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetAttributeFocusWindow	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetPreeditAttribute		(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetPAttributeSpotLocation	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetPAttributeClientArea	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetPAttributeFont			(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetPAttributeLineSpacing	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetPAttributeColormap		(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetPAttributeBackground	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetPAttributeForeground	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetStatusAttribute			(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetSAttributeClientArea	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetSAttributeFont			(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetSAttributeLineSpacing	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetSAttributeColormap		(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetSAttributeBackground	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_onSetSAttributeForeground	(Widget, const TConversionAttribute*) ;
static	Boolean	toverTheSpotWindow_getPreeditLineSpacing	(Widget, int*) ;
static	void	toverTheSpotWindow_setMinibufferFrameSize	(Widget, int, int, int, int) ;
static	unsigned long	toverTheSpotWindow_getPreeditWindowAttribute	(Widget, XSetWindowAttributes*) ;
static	unsigned long	toverTheSpotWindow_getStatusWindowAttribute	(Widget, XSetWindowAttributes*) ;
static	Boolean	toverTheSpotWindow_createTerminalWindow		(Widget) ;
static	Boolean	toverTheSpotWindow_createModeshellWindow	(Widget) ;
static	Boolean	toverTheSpotWindow_createMinibufferFrame	(Widget) ;

static	void	toverTheSpotWindow_configureTerminalWindow	(Widget) ;
static	void	toverTheSpotWindow_displayTerminal		(Widget, Window, GC, TOverTheSpotTerminalTextControl*, int, int) ;
static	int		toverTheSpotWindow_configureFocusOffset	(Widget) ;
static	void	toverTheSpotWindow_resizeModeshellWindow	(Widget) ;
static	void	toverTheSpotWindow_popup				(Widget) ;
static	void	toverTheSpotWindow_popdown				(Widget) ;
static	void	toverTheSpotWindow_convertStatus2Preedit	(TConversionAttribute*, const TConversionAttribute*) ;

void	XGetRectangleOfWindow	(Display*, Window, XRectangle*) ;


static	XtActionsRec	srOverTheSpotWindowAction []	= {
	{ "onKeyPress",			toverTheSpotWindow_onKeyPress, },
	{ "onKeyRelease",		toverTheSpotWindow_onKeyRelease, },
} ;

static	char			strOverTheSpotWindowTranslation []	= 
"<Key>:                 onKeyPress()\n\
 <KeyRelease>:          onKeyRelease()\n" ;

static	int				(*srOverTheSpotTerminalExposeProc [])(void*, XEvent*) = {
	toverTheSpotWindow_onTopTerminalExpose,
	toverTheSpotWindow_onMiddleTerminalExpose,
	toverTheSpotWindow_onBottomTerminalExpose,
} ;

TOverTheSpotWindowClassRec		toverTheSpotWindowClassRec	= {
    {	/* core fields */
		/* superclass			*/	(WidgetClass) &tframeClassRec,
		/* class_name			*/	"TOverTheSpotWindow",
		/* size					*/	sizeof (TOverTheSpotWindowRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	toverTheSpotWindow_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	toverTheSpotWindow_onRealize,
		/* actions				*/	srOverTheSpotWindowAction,
		/* num_actions			*/	XtNumber (srOverTheSpotWindowAction),
		/* resources			*/	srOverTheSpotWindowResource,
		/* num_resources		*/	XtNumber(srOverTheSpotWindowResource),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	toverTheSpotWindow_onDestroy,
		/* resize				*/	NULL,
		/* expose				*/	NULL,
		/* set_values			*/	toverTheSpotWindow_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table				*/	strOverTheSpotWindowTranslation,
		/* query_geometry		*/	XtInheritQueryGeometry,
		/* display_accelerator	*/	NULL,
		/* extension	  		*/	NULL,
    },
	{	/* Composite			*/
		/* geometry_manager		*/	XtInheritGeometryManager,
		/* change_managed		*/	XtInheritChangeManaged,
		/* insert_child			*/	XtInheritInsertChild,
		/* delete_child			*/	XtInheritDeleteChild,
		/* extension			*/	NULL,
	},
	{	/* Shell				*/
		/* extension			*/	NULL,
	},
	{
		/* getclient			*/	toverTheSpotWindow_getclient,
		/* getlispframeobject	*/	toverTheSpotWindow_getlispframeobject,
		/* setattribute			*/	toverTheSpotWindow_setattribute,
		/* getrect				*/	toverTheSpotWindow_getrect,
		/* activate				*/	toverTheSpotWindow_activate,
		/* getfontset			*/	toverTheSpotWindow_getfontset,
		/* getlinespacing		*/	toverTheSpotWindow_getlinespacing,
		/* puts					*/	toverTheSpotWindow_puts,
		/* putchar				*/	toverTheSpotWindow_putchar,
		/* rev					*/	toverTheSpotWindow_rev,
		/* clear				*/	toverTheSpotWindow_clear,
		/* flush				*/	toverTheSpotWindow_flush,
		/* rectVariablep		*/	toverTheSpotWindow_rectVariablep,
		/* haveExternModelinep	*/	toverTheSpotWindow_haveExternModelinep,
		/* setModeline			*/	toverTheSpotWindow_setModeline,
		/* autoPopupp			*/	toverTheSpotWindow_autoPopupp,
		/* setCaret				*/	NULL,
	},
	{
		/* dummy				*/	0,
	},
} ;

WidgetClass	toverTheSpotWindowWidgetClass	= (WidgetClass) &toverTheSpotWindowClassRec ;

void
toverTheSpotWindow_onInitialize (
	Widget		wgRequest,
	Widget		wgNew,
	ArgList		args,
	Cardinal*	num_args)
{
	register TOverTheSpotWindowWidget	w = (TOverTheSpotWindowWidget) wgNew ;
	register TOverTheSpotTerminal*		pTerminal ;
	register int						i ;
	register const char*				strFontSet ;

	TConvAttr_Initialize (&w->toverwin.m_caInitial) ;
	TConvAttr_Initialize (&w->toverwin.m_caCurrent) ;

	w->toverwin.m_ptFocus.x		= w->toverwin.m_ptFocus.y	= 0 ;
	w->toverwin.m_ptClient.x	= w->toverwin.m_ptClient.y	= 0 ;

	/*	default  fontset ǽ롣ݤʤΤ -*--12-* Ǥ䡣*/
	TFontSet_Initialize (&w->toverwin.m_fsTerminal) ;
	TFontSet_Initialize (&w->toverwin.m_fsMinibuf) ;
	strFontSet	= w->toverwin.m_strFontSet ;
	TFontSet_Load (XtDisplay (wgNew), &w->toverwin.m_fsTerminal, strFontSet, False) ;
	TFontSet_Load (XtDisplay (wgNew), &w->toverwin.m_fsMinibuf,  strFontSet, False) ;

	pTerminal	= &w->toverwin.m_Terminal ;
	for (i = 0 ; i < 3 ; i ++) {
		pTerminal->m_wndTerminal [i]		= None ;
		pTerminal->m_rGC [i]				= None ;
		pTerminal->m_rnControlOffset [i]	= -1 ;
	}
	TVarbuffer_Initialize (&pTerminal->m_vbufText,    sizeof (Char)) ;
	TVarbuffer_Initialize (&pTerminal->m_vbufControl, sizeof (TOverTheSpotTerminalTextControl)) ;
	pTerminal->m_fRev		= False ;
	pTerminal->m_nCursor	= -1 ;
	pTerminal->m_nLine		= 0 ;

	w->toverwin.m_wgMinibuf			= 0 ;
	TVarbuffer_Initialize (&w->toverwin.m_vbufModeshellText, sizeof (Char)) ;
	w->toverwin.m_wndModeshell			= None ;
	w->toverwin.m_gcModeshell			= None ;
	w->toverwin.m_fActive				= False ;
	w->toverwin.m_ptSpot.x				= 0 ;
	w->toverwin.m_ptSpot.y				= 0 ;
	w->toverwin.m_fFloatingModeshell	= True ;
	w->toverwin.m_szModeshell.cx		= 0 ;
	w->toverwin.m_szModeshell.cy		= 0 ;

	/*	 m_fDestroy ϼʬȤ XtDestroyWidget ǤϤʤ
	 *	̤γŪװˤäԲǽˤʤäƤ뤳Ȥ̣롣
	 */
	w->toverwin.m_fDestroy			= False ;
	return ;
}

void
toverTheSpotWindow_onRealize (
	register Widget					gw,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register CoreWidgetClass			super ;
	register Display*					pDisplay	= XtDisplay (gw) ;

	super	= (CoreWidgetClass) XtClass (gw)->core_class.superclass ;
	(*super->core_class.realize) (gw, pValueMask, pXSWA) ;

	if (wgThis->toverwin.m_wndClient == None) {
		XtDestroyWidget (gw) ;
		return ;
	}
	/*	ʳޤǤͤȤ¸롣ʹߤ current Τѹ롣*/
	TConvAttr_Copy (&wgThis->toverwin.m_caInitial, &wgThis->toverwin.m_caCurrent) ;

	/*	Focus Window ꤵƤ뤫ɤǧ롣ƤʤСClient Window
	 *	 Focus Window ȤѤ롣*/
	if (wgThis->toverwin.m_wndFocus == None) 
		wgThis->toverwin.m_wndFocus	= wgThis->toverwin.m_wndClient ;
	if (!IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caCurrent, CAClientArea)) {
		XRectangle	rect ;

		SET_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caCurrent, CAClientArea) ;
		XGetRectangleOfWindow (pDisplay, wgThis->toverwin.m_wndFocus, &rect) ;
		CONVATTR_PREEDIT_CLIENTAREA (wgThis->toverwin.m_caCurrent)	= rect ;
	}
	/*	FocusWindow  Resize ƻ뤹롣 Preedit  CAClientArea 
	 *	ꤷʤ Client кǤ롣*/
	AfxRegisterWindow (pDisplay, wgThis->toverwin.m_wndFocus, ConfigureNotify, StructureNotifyMask, gw, toverTheSpotWindow_onFocusResize) ;

	if (!toverTheSpotWindow_createTerminalWindow (gw) ||
		!toverTheSpotWindow_createModeshellWindow (gw)) {
		XtDestroyWidget (gw) ;
		return ;
	}

	/*	Modeshell 礭ɽʸԤ
	 */
	toverTheSpotWindow_configureFocusOffset (gw) ;
	toverTheSpotWindow_resizeModeshellWindow (gw) ;
	toverTheSpotWindow_configureTerminalWindow (gw) ;

	/*	Minibuffer  Realize ˤĤƤϤޤȤ⡣󤷤ˤ롣
	 *	˺Τʤ顢 lisp object ˤɬפ
	 *	ޤ lisp machine Ȥ߹ǡʤ뤫
	 *	
	 */
	toverTheSpotWindow_createMinibufferFrame (gw) ;
	return ;
}

Boolean
toverTheSpotWindow_onSetValues (
	register Widget		curw,
	register Widget		reqw,
	register Widget		neww,
	register ArgList	args,
	register Cardinal*	num_args)
{
	register TOverTheSpotWindowWidget	wgCur	= (TOverTheSpotWindowWidget) curw ;
	register TOverTheSpotWindowWidget	wgReq	= (TOverTheSpotWindowWidget) reqw ;
	register TOverTheSpotWindowWidget	wgNew	= (TOverTheSpotWindowWidget) neww ;

	if (wgReq->toverwin.m_wgMinibuf != wgCur->toverwin.m_wgMinibuf) {
		/*	Minibuffer Frame ѹ뤳ȤϤǤʤ
		 *	Ĥ get only Ǥ롣*/
#if defined (DEBUG)
		fprintf (stderr, "minibuffer frame can't change from (%p) to (%p).\n",
				 wgCur->toverwin.m_wgMinibuf, wgReq->toverwin.m_wgMinibuf) ;
#endif
		wgNew->toverwin.m_wgMinibuf	= wgCur->toverwin.m_wgMinibuf ;
	}
	return	False ;
}

void
toverTheSpotWindow_onDestroy (
	register Widget	gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*		pTerminal ;
	register Display*	pDisplay ;
	register Window		wndTerminal, wndModeshell, wndFocus ;
	register int		i ;

	pDisplay	= XtDisplay (gw) ;
	pTerminal	= &wgThis->toverwin.m_Terminal ;
	for (i = 0 ; i < 3 ; i ++) {
		wndTerminal	= pTerminal->m_wndTerminal [i] ;
		if (wndTerminal != None) {
			AfxUnregisterWindow (wndTerminal, Expose, ExposureMask, gw, srOverTheSpotTerminalExposeProc [i]) ;
			AfxUnregisterWindow (wndTerminal, DestroyNotify, StructureNotifyMask, gw, toverTheSpotWindow_onTerminalDestroy) ;
			AfxUnregisterWindow (wndTerminal, KeyPress, KeyPressMask, gw, toverTheSpotWindow_onSubwindowKeyPress) ;
			AfxUnregisterWindow (wndTerminal, KeyRelease, KeyReleaseMask, gw, toverTheSpotWindow_onSubwindowKeyRelease) ;
			/*	 destroy  XErrorEvent ǽ⤤*/
			if (!wgThis->toverwin.m_fDestroy)
				XDestroyWindow (pDisplay, wndTerminal) ;
		}
		XFreeGC (pDisplay, pTerminal->m_rGC [i]) ;
		pTerminal->m_rGC [i]	= None ;
	}
	XFreeGC (pDisplay, wgThis->toverwin.m_gcModeshell) ;
	wgThis->toverwin.m_gcModeshell	= None ;

	wndModeshell	= wgThis->toverwin.m_wndModeshell ;
	if (wndModeshell != None) {
		AfxUnregisterWindow (wndModeshell, Expose, ExposureMask, gw, toverTheSpotWindow_onModeshellExpose) ;
		AfxUnregisterWindow (wndModeshell, DestroyNotify, StructureNotifyMask, gw, toverTheSpotWindow_onModeshellDestroy) ;
		AfxUnregisterWindow (wndModeshell, KeyPress, KeyPressMask, gw, toverTheSpotWindow_onSubwindowKeyPress) ;
		AfxUnregisterWindow (wndModeshell, KeyRelease, KeyReleaseMask, gw, toverTheSpotWindow_onSubwindowKeyRelease) ;
		/*	 destroy  XErrorEvent ǽ⤤*/
		if (!wgThis->toverwin.m_fDestroy)
			XDestroyWindow (pDisplay, wndModeshell) ;
		wgThis->toverwin.m_wndModeshell	= None ;
	}
	wndFocus		= wgThis->toverwin.m_wndFocus ;
	if (wndFocus != None) {
		AfxUnregisterWindow (wndFocus, ConfigureNotify, StructureNotifyMask, wgThis, toverTheSpotWindow_onFocusResize) ;
		wgThis->toverwin.m_wndFocus	= None ;
	}

	TFontSet_Destroy (&wgThis->toverwin.m_fsTerminal) ;
	TFontSet_Destroy (&wgThis->toverwin.m_fsMinibuf) ;
	TVarbuffer_Uninitialize (&pTerminal->m_vbufText) ;
	TVarbuffer_Uninitialize (&pTerminal->m_vbufControl) ;
	TVarbuffer_Uninitialize (&wgThis->toverwin.m_vbufModeshellText) ;

	TConvAttr_Uninitialize (&wgThis->toverwin.m_caInitial) ;
	TConvAttr_Uninitialize (&wgThis->toverwin.m_caCurrent) ;
	return ;
}

void
toverTheSpotWindow_onKeyPress (
	register Widget		gw,
	register XEvent*	pEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	if (!XtIsRealized (gw))
		return ;
	/*	Event Select: None ȡ˸ä KeyEvent ꤲǽ
	 *	롣*/
	XtCallCallbacks (gw, XtNkeyPressCallback, (XtPointer) pEvent) ;
	return ;
 }

void
toverTheSpotWindow_onKeyRelease (
	register Widget		gw,
	register XEvent*	pEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	return ;
}

/*	Focus Ƥ Window  Resize Event 򽦤⤷Client Area 
 *	󤬡Ѵ client ˤäͿ줿ΤǤʤС resize ξ
 *	äƺľ
 */
int
toverTheSpotWindow_onFocusResize (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) pClosure ;
	register TConversionAttribute*	pCurAttr ;

	assert (pClosure != NULL) ;
	assert (pEvent   != NULL) ;

	if (!XtIsRealized ((Widget)wgThis))
		return	0 ;
	if (IS_CONVATTR_MASK (wgThis->toverwin.m_caInitial, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caInitial, CAClientArea))
		return	0 ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pCurAttr->m_Preedit.m_area.x		= pEvent->xconfigure.x ;
	pCurAttr->m_Preedit.m_area.y		= pEvent->xconfigure.y ;
	pCurAttr->m_Preedit.m_area.width	= pEvent->xconfigure.width ;
	pCurAttr->m_Preedit.m_area.height	= pEvent->xconfigure.height ;
	SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
	SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea) ;
	return	0 ;
}

int
toverTheSpotWindow_onTopTerminalExpose (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) pClosure ;
	register TOverTheSpotTerminal*		pTerminal ;
	register TOverTheSpotTerminalTextControl*	pControl ;
	register Window	window ;
	register GC		gc ;
	register int	nControl, nOffset ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	nControl	= TVarbuffer_GetUsage  (&pTerminal->m_vbufControl) ;
	nOffset		= pTerminal->m_rnControlOffset [0] ;
	if (nControl <= nOffset || nOffset < 0)
		return	0 ;
	pControl	= TVarbuffer_GetBuffer (&pTerminal->m_vbufControl) ;
	pControl	+= nOffset ;
	nControl	-= nOffset ;
	window		= pTerminal->m_wndTerminal [0] ;
	gc			= pTerminal->m_rGC [0] ;
	toverTheSpotWindow_displayTerminal ((Widget)wgThis, window, gc, pControl, nControl, 1) ;
	return	0 ;
}

int
toverTheSpotWindow_onMiddleTerminalExpose (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) pClosure ;
	register TOverTheSpotTerminal*				pTerminal ;
	register TOverTheSpotTerminalTextControl*	pControl ;
	register Window	window ;
	register GC		gc ;
	register int	nControl, nOffset, nLine ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	nControl	= TVarbuffer_GetUsage  (&pTerminal->m_vbufControl) ;
	nOffset		= pTerminal->m_rnControlOffset [1] ;
#if defined (DEBUG)
	fprintf (stderr, "onMiddleTerminalExpose (%d, %d, %d)\n", 
			 nControl, nOffset, pTerminal->m_nLine) ;
#endif
	if (nControl <= nOffset || nOffset < 0 || pTerminal->m_nLine < 1)
		return	0 ;
	pControl	= TVarbuffer_GetBuffer (&pTerminal->m_vbufControl) ;
	pControl	+= nOffset ;
	nControl	-= nOffset ;
	window		= pTerminal->m_wndTerminal [1] ;
	gc			= pTerminal->m_rGC [1] ;
	nLine		= (pTerminal->m_nLine >= 2)? pTerminal->m_nLine - 1 : 1 ;
	toverTheSpotWindow_displayTerminal ((Widget)wgThis, window, gc, pControl, nControl, nLine) ;
	return	0 ;
}

int
toverTheSpotWindow_onBottomTerminalExpose (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) pClosure ;
	register TOverTheSpotTerminal*				pTerminal ;
	register TOverTheSpotTerminalTextControl*	pControl ;
	register Window	window ;
	register GC		gc ;
	register int	nControl, nOffset ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	nControl	= TVarbuffer_GetUsage  (&pTerminal->m_vbufControl) ;
	nOffset		= pTerminal->m_rnControlOffset [2] ;
	if (nControl <= nOffset || nOffset < 0 || pTerminal->m_nLine < 2)
		return	0 ;
#if defined (DEBUG)
	fprintf (stderr, "onBottomTerminalExpose (%d, %d, %d)\n", 
			 nControl, nOffset, pTerminal->m_nLine) ;
#endif
	pControl	= TVarbuffer_GetBuffer (&pTerminal->m_vbufControl) ;
	pControl	+= nOffset ;
	nControl	-= nOffset ;
	window		= pTerminal->m_wndTerminal [2] ;
	gc			= pTerminal->m_rGC [2] ;
	toverTheSpotWindow_displayTerminal ((Widget)wgThis, window, gc, pControl, nControl, 1) ;
	return	0 ;
}

int
toverTheSpotWindow_onTerminalDestroy (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) pClosure ;
	register TOverTheSpotTerminal*	pTerminal ;
	register Window					window ;
	register int	n ;
	
	pTerminal	= &wgThis->toverwin.m_Terminal ;
	window		= pEvent->xany.window ;
	for (n = 0 ; n < 3 ; n ++) {
		if (pTerminal->m_wndTerminal [n] == window) {
			AfxUnregisterWindow (window, Expose, ExposureMask, pClosure, srOverTheSpotTerminalExposeProc [n]) ;
			AfxUnregisterWindow (window, DestroyNotify, StructureNotifyMask, pClosure, toverTheSpotWindow_onTerminalDestroy) ;
			AfxUnregisterWindow (window, KeyPress, KeyPressMask, pClosure, toverTheSpotWindow_onSubwindowKeyPress) ;
			AfxUnregisterWindow (window, KeyRelease, KeyReleaseMask, pClosure, toverTheSpotWindow_onSubwindowKeyRelease) ;
			pTerminal->m_wndTerminal [n]	= None ;
			break ;
		}
	}
	if (!wgThis->toverwin.m_fDestroy) {
		XtCallCallbacks ((Widget)wgThis, XtNdestroyCallback, (XtPointer) 0) ;
		wgThis->toverwin.m_fDestroy	= True ;
	}
	return	0 ;
}

int
toverTheSpotWindow_onModeshellExpose (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) pClosure ;
	register Display*		pDisplay ;
	register Window			window ;
	register GC				gc ;
	register TFontSet*		pFontSet ;
	register int			y ;
	register Pixel			pxlForeground, pxlBackground ;
	register const Char*	pString ;
	register int			nString ;

	pString		= TVarbuffer_GetBuffer (&wgThis->toverwin.m_vbufModeshellText) ;
	nString		= TVarbuffer_GetUsage  (&wgThis->toverwin.m_vbufModeshellText) ;
	window		= wgThis->toverwin.m_wndModeshell ;
	if (window == None || nString <= 0)
		return	0 ;

	pDisplay	= XtDisplay ((Widget)wgThis) ;

	pxlForeground	= wgThis->toverwin.m_pxlForeground ;
	pxlBackground	= wgThis->core.background_pixel ;
	if (wgThis->toverwin.m_fFloatingModeshell) {
		if (IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAPreeditMask)) { 
			if (IS_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caCurrent, CAForegroundPixel)) 
				pxlForeground	= CONVATTR_PREEDIT_FOREGROUND (wgThis->toverwin.m_caCurrent) ;
			if (IS_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caCurrent, CABackgroundPixel)) 
				pxlBackground	= CONVATTR_PREEDIT_BACKGROUND (wgThis->toverwin.m_caCurrent) ;
		}
		pFontSet	= &wgThis->toverwin.m_fsTerminal ;
	} else {
		if (IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAStatusMask)) { 
			if (IS_CONVATTR_STATUS_MASK (wgThis->toverwin.m_caCurrent, CAForegroundPixel)) 
				pxlForeground	= CONVATTR_STATUS_FOREGROUND (wgThis->toverwin.m_caCurrent) ;
			if (IS_CONVATTR_STATUS_MASK (wgThis->toverwin.m_caCurrent, CABackgroundPixel)) 
				pxlBackground	= CONVATTR_STATUS_BACKGROUND (wgThis->toverwin.m_caCurrent) ;
		}
		pFontSet	= &wgThis->toverwin.m_fsMinibuf ;
	}
	gc			= wgThis->toverwin.m_gcModeshell ;
	y			= TFontSet_GetAscent (pFontSet) ;
	XSetBackground (pDisplay, gc, pxlBackground) ;
	XSetForeground (pDisplay, gc, pxlForeground) ;

	TTextOut (pDisplay, window, gc, pFontSet, 0, y, pString, nString, NULL) ;
	return	0 ;
}

int
toverTheSpotWindow_onModeshellDestroy (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) pClosure ;
	register Window	window ;

	/*	Destroy Фִ֤ KinputClient  entry 
	 *	Ƥ Window 줿ʳ Widget ϾäʤФ
	 *	ʤ
	 */
	window	= pEvent->xany.window ;
	if (wgThis->toverwin.m_wndModeshell != window)
		return	0 ;
	AfxUnregisterWindow (window, Expose, ExposureMask, pClosure, toverTheSpotWindow_onModeshellExpose) ;
	AfxUnregisterWindow (window, DestroyNotify, StructureNotifyMask, pClosure, toverTheSpotWindow_onModeshellDestroy) ;
	AfxUnregisterWindow (window, KeyPress, KeyPressMask, pClosure, toverTheSpotWindow_onSubwindowKeyPress) ;
	AfxUnregisterWindow (window, KeyRelease, KeyReleaseMask, pClosure, toverTheSpotWindow_onSubwindowKeyRelease) ;
	wgThis->toverwin.m_wndModeshell	= None ;

	if (!wgThis->toverwin.m_fDestroy) {
		XtCallCallbacks ((Widget)wgThis, XtNdestroyCallback, (XtPointer) 0) ;
		wgThis->toverwin.m_fDestroy	= True ;
	}
	return	0 ;
}

int
toverTheSpotWindow_onSubwindowKeyPress (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register Widget	gw	= (Widget) pClosure ;

	XtCallCallbacks (gw, XtNkeyPressCallback, (XtPointer) pEvent) ;
	return	0 ;
}

int
toverTheSpotWindow_onSubwindowKeyRelease (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	return	0 ;
}

/*	private functions
 */
void*
toverTheSpotWindow_getclient (
	register Widget	gw)
{
	TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;

	return	wgThis->tframe.m_pClient ;
}

int
toverTheSpotWindow_getrect (
	register Widget			gw,
	register XRectangle*	pRect)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register XRectangle*	pCurRect ;

	if (pRect == NULL)
		return	1 ;

	pCurRect		= &CONVATTR_PREEDIT_CLIENTAREA (wgThis->toverwin.m_caCurrent) ;
	pRect->x		= wgThis->toverwin.m_ptSpot.x ; /*pCurRect->x ;*/
	pRect->y		= wgThis->toverwin.m_ptSpot.y ; /*pCurRect->y ;*/
	pRect->width	= pCurRect->width ;
	pRect->height	= pCurRect->height ;
	return	1 ;
}

void
toverTheSpotWindow_activate (
	register Widget			gw,
	register Boolean		fActivate)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;

	if (!XtIsRealized (gw) || wgThis->toverwin.m_fDestroy)
		return ;

	if (fActivate) {
		toverTheSpotWindow_popup (gw) ;
	} else {
		toverTheSpotWindow_popdown (gw) ;
	}
	return ;
}

void*
toverTheSpotWindow_getfontset (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;

	return	&wgThis->toverwin.m_fsTerminal ;
}

Boolean
toverTheSpotWindow_getlinespacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	return	toverTheSpotWindow_getPreeditLineSpacing (gw, pnLineSpacing) ;
}

void*
toverTheSpotWindow_getlispframeobject (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;

	return	wgThis->tframe.m_pLispFrameObject ;
}

void
toverTheSpotWindow_setattribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	static Boolean	(*rpSetAttrProcTbl[])(Widget, const TConversionAttribute*) = {
		toverTheSpotWindow_onSetAttributeFocusWindow,
		toverTheSpotWindow_onSetPreeditAttribute,
		toverTheSpotWindow_onSetStatusAttribute,
	} ;
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register int			i ;
	register unsigned int	uMask ;
	register Boolean		fReconf ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	if (wgThis->toverwin.m_fDestroy)
		return ;

	uMask	= 1 << CAFocusWindowBit ;
	fReconf	= False ;
	for (i = 0 ; i <= (CAStatusMaskBit - CAFocusWindowBit) ; i ++) {
		if (IS_CONVATTR_MASK (*pAttribute, uMask)) {
			fReconf	= (rpSetAttrProcTbl [i])(gw, pAttribute)? True : fReconf ;
		}
		uMask	= uMask << 1 ;
	}
	if (XtIsRealized (gw) && fReconf && wgThis->toverwin.m_fActive) {
		register TOverTheSpotTerminal*	pTerminal ;
		register int	nControl, nText ;

		pTerminal	= &wgThis->toverwin.m_Terminal ;
		nControl	= TVarbuffer_GetUsage (&pTerminal->m_vbufControl) ;
		nText		= TVarbuffer_GetUsage (&pTerminal->m_vbufText) ;
#if defined (DEBUG)
		fprintf (stderr, "toverTheSpotWindow_setattribute (%d)\n", fReconf) ;
#endif
		/*	ľ*/
		toverTheSpotWindow_configureFocusOffset (gw) ;
		toverTheSpotWindow_resizeModeshellWindow (gw) ;
		if (nControl > 0 && nText > 0) 
			XtCallCallbacks (gw, XtNconfigureCallback, (XtPointer) 0) ;
		//toverTheSpotWindow_configureTerminalWindow (gw) ;
	}
	return ;
}

Boolean
toverTheSpotWindow_onSetAttributeFocusWindow (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*		pTerminal ;
	register Display*				pDisplay ;
	register TConversionAttribute*	pCurAttr ;
	register Window					wndNewFocus, wndOldFocus ;
	register int					i ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;
	assert ((pAttribute->m_uMask & CAFocusWindow) != 0) ;

	wndNewFocus	= CONVATTR_FOCUSWINDOW (*pAttribute) ; 
	pDisplay	= XtDisplay (gw) ;
#if defined (DEBUG)
	fprintf (stderr, "FocusWindow: (%lx)\n", wndNewFocus) ;
#endif
	if (!XtIsRealized (gw)) {
		SET_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caCurrent, CAFocusWindow) ;
		CONVATTR_FOCUSWINDOW (wgThis->toverwin.m_caCurrent) = wndNewFocus ;
		return	False ;
	}
	if (IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAFocusWindow))
		return	False ;
	wndOldFocus	= CONVATTR_FOCUSWINDOW (wgThis->toverwin.m_caCurrent) ;
	if (wndOldFocus == wndNewFocus) 
		return	False ;

	CONVATTR_FOCUSWINDOW (wgThis->toverwin.m_caCurrent) = wndNewFocus ;
	wgThis->toverwin.m_wndFocus	= wndNewFocus ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	for (i = 0 ; i < 3 ; i ++) {
		if (pTerminal->m_wndTerminal [i] != None)
			XReparentWindow (pDisplay, pTerminal->m_wndTerminal [i], wndNewFocus, 0, 0) ;
	}
	if (wgThis->toverwin.m_wndModeshell != None)
		XReparentWindow (pDisplay, wgThis->toverwin.m_wndModeshell, wndNewFocus, 0, 0) ;

	/*	Realize Ƥ֤Ǥ Focus Window ѹ CAClientArea 
	 *	ǤȽǤ롣
	 */
	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
	SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea) ;
	XGetRectangleOfWindow (pDisplay, wndNewFocus, &CONVATTR_PREEDIT_CLIENTAREA (*pCurAttr)) ;

	/*	Focus Window  Resize δƻ³롣*/
	if (wndOldFocus != None)
		AfxUnregisterWindow (wndOldFocus, ConfigureNotify, StructureNotifyMask, wgThis, toverTheSpotWindow_onFocusResize) ;
	if (wndNewFocus != None)
		AfxRegisterWindow (pDisplay, wndNewFocus, ConfigureNotify, StructureNotifyMask, wgThis, toverTheSpotWindow_onFocusResize) ;
	return	True ;
}

Boolean
toverTheSpotWindow_onSetPreeditAttribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register unsigned int	uMask ;
	register int			i ;
	register Boolean		fRetval ;
	static Boolean	(*rpSetPAttrProcTbl[])(Widget, const TConversionAttribute*) = {
		toverTheSpotWindow_onSetPAttributeSpotLocation,
		toverTheSpotWindow_onSetPAttributeClientArea,
		toverTheSpotWindow_onSetPAttributeFont,
		toverTheSpotWindow_onSetPAttributeLineSpacing,
		toverTheSpotWindow_onSetPAttributeColormap,
		toverTheSpotWindow_onSetPAttributeForeground,
		toverTheSpotWindow_onSetPAttributeBackground,
	} ;

#if defined (DEBUG)
	fprintf (stderr, "PreeditMask: %x\n", pAttribute->m_Preedit.m_uMask) ;
#endif
	uMask	= 1 << CASpotLocationBit ;
	i		= 0 ;
	fRetval	= False ;
	while (i <= (CABackgroundPixelBit - CASpotLocationBit)) {
		if (IS_CONVATTR_PREEDIT_MASK (*pAttribute, uMask)) {
			fRetval	= (rpSetPAttrProcTbl [i])(gw, pAttribute)? True : fRetval ;
		}
		uMask	= uMask << 1 ;
		i	++ ;
	}
	return	fRetval ;
}

Boolean
toverTheSpotWindow_onSetPAttributeSpotLocation (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register Boolean				fMove ;
	register TOverTheSpotTerminal*	pTerminal ;
	register int					x, y, nControl, nText ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	x		= CONVATTR_PREEDIT_SPOT(*pAttribute).x ;
	y		= CONVATTR_PREEDIT_SPOT(*pAttribute).y ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	nControl	= TVarbuffer_GetUsage (&pTerminal->m_vbufControl) ;
	nText		= TVarbuffer_GetUsage (&pTerminal->m_vbufText) ;
	/* Spot ѹ ReConfigure ɬפˤĤʤ롣*/
	fMove	= (wgThis->toverwin.m_ptSpot.x != x || wgThis->toverwin.m_ptSpot.y != y) ;
	wgThis->toverwin.m_ptSpot.x	= x ;
	wgThis->toverwin.m_ptSpot.y	= y ;

	if (wgThis->toverwin.m_wndModeshell != None && fMove &&
		wgThis->toverwin.m_fFloatingModeshell) {
		register TFontSet*	pFontSet	= &wgThis->toverwin.m_fsTerminal ;
		register int		nAscent, nDescent, nFontHeight ;
		register Boolean	fLineSpacing ;
		int					nLineSpacing ;

		fLineSpacing	= toverTheSpotWindow_getPreeditLineSpacing (gw, &nLineSpacing) ;
		nDescent		= TFontSet_GetDescent (pFontSet) ;
		nAscent			= TFontSet_GetAscent  (pFontSet) ;
		nFontHeight		= TFontSet_GetHeight  (pFontSet) ;
		y	+= (fLineSpacing && nFontHeight < nLineSpacing)? (nLineSpacing - nAscent) : nDescent ;
		XMoveWindow (XtDisplay (gw), wgThis->toverwin.m_wndModeshell, x, y) ;
	}
	return	fMove && (nControl > 0 && nText > 0) ;
}

Boolean
toverTheSpotWindow_onSetPAttributeClientArea (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Boolean				fRetval	= False ;
	register XRectangle*			pCurArea ;
	register const XRectangle*		pNewArea ;
	register int					nWidth, nHeight ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pNewArea	= &CONVATTR_PREEDIT_CLIENTAREA (*pAttribute) ;
	pCurArea	= &CONVATTR_PREEDIT_CLIENTAREA (*pCurAttr) ;

	if (pNewArea->width == 0 || pNewArea->height == 0) {
		register Window	wndFocus ;
		XRectangle		rc ;

		wndFocus	= wgThis->toverwin.m_wndClient ;
		if (IS_CONVATTR_MASK (*pCurAttr, CAFocusWindow))
			wndFocus	= CONVATTR_FOCUSWINDOW (*pCurAttr) ;
		if (wndFocus != None) {
			XGetRectangleOfWindow (XtDisplay (gw), wndFocus, &rc) ;
		} else {
			rc.width	= 65535 ;
			rc.height	= 65535 ;
		}
		nWidth	= (pNewArea->width  <= 0)? rc.width  : pNewArea->width ;
		nHeight	= (pNewArea->height <= 0)? rc.height : pNewArea->height ;
	} else {
		nWidth	= pNewArea->width ;
		nHeight	= pNewArea->height ;
	}
#if defined (DEBUG) || 0
	fprintf (stderr, "ClientArea: (%d, %d, %d(%d), %d(%d))\n", 
			 pAttribute->m_Preedit.m_area.x,
			 pAttribute->m_Preedit.m_area.y,
			 nWidth,
			 pAttribute->m_Preedit.m_area.width,
			 nHeight,
			 pAttribute->m_Preedit.m_area.height) ;
#endif

	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea)) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea) ;
		pCurArea->x			= pNewArea->x ;
		pCurArea->y			= pNewArea->y ;
		pCurArea->width		= nWidth ;
		pCurArea->height	= nHeight ;
		fRetval	= True ;
	} else {
		if (pCurArea->x      != pNewArea->x     ||
			pCurArea->y      != pNewArea->y     ||
			pCurArea->width  != nWidth			||
			pCurArea->height != nHeight)
			fRetval	= True ;
		pCurArea->x			= pNewArea->x ;
		pCurArea->y			= pNewArea->y ;
		pCurArea->width		= nWidth ;
		pCurArea->height	= nHeight ;
	}
	return	fRetval ;
}

Boolean
toverTheSpotWindow_onSetPAttributeFont (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

#if defined (DEBUG)
	fprintf (stderr, "toverTheSpotWindow_onSetPAttributeFont (%p)\n", gw) ;
#endif
	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAFont)) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAFont) ;
	}
	TFontSet_Copy  (&wgThis->toverwin.m_fsTerminal, &CONVATTR_PREEDIT_FONTSET (*pAttribute)) ;
	UNSET_CONVATTR_PREEDIT_MASK (*pCurAttr, CALineSpacing) ;

	/*	礱Ƥ charset  font СѰդ롣
	 */
	TFontSet_Adjust (XtDisplay (gw), &wgThis->toverwin.m_fsTerminal, DEFAULT_FONTHEIGHT) ;
#if defined (DEBUG)
	TFontSet_Show (&wgThis->toverwin.m_fsTerminal) ;
#endif
	return	True ;
}

Boolean
toverTheSpotWindow_onSetPAttributeLineSpacing (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CALineSpacing) ||
		pCurAttr->m_Preedit.m_nLineSpacing != pAttribute->m_Preedit.m_nLineSpacing) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CALineSpacing) ;
		pCurAttr->m_Preedit.m_nLineSpacing	= pAttribute->m_Preedit.m_nLineSpacing ;
		return	True ;
	}
	return	False ;
}

Boolean
toverTheSpotWindow_onSetPAttributeColormap (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register TOverTheSpotTerminal*		pTerminal ;
	register Window		window ;
	register Colormap	colNew ;
	register int		i ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	colNew		= pAttribute->m_Preedit.m_colormap ;
	if (IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAColormap) &&
		pCurAttr->m_Preedit.m_colormap == colNew) 
		return	False ;

	SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
	SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAColormap) ;
	pCurAttr->m_Preedit.m_colormap	= colNew ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	for (i = 0 ; i < 3 ; i ++) {
		window	= pTerminal->m_wndTerminal [i] ;
		if (window != None)
			XSetWindowColormap (XtDisplay (gw), window, colNew) ;
	}
	window	= wgThis->toverwin.m_wndModeshell ;
	if (window != None)
		XSetWindowColormap (XtDisplay (gw), window, colNew) ;
	return	False ;
}

Boolean
toverTheSpotWindow_onSetPAttributeBackground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register TOverTheSpotTerminal*	pTerminal ;
	register Window	window ;
	register int	i ;
	register Pixel	pxlBack ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pxlBack		= CONVATTR_PREEDIT_BACKGROUND (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CABackgroundPixel)) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CABackgroundPixel) ;
	} else {
		if (CONVATTR_PREEDIT_BACKGROUND (*pCurAttr) == pxlBack)
			return	False ;
	}
	CONVATTR_PREEDIT_BACKGROUND (*pCurAttr)	= pxlBack ;
#if defined (DEBUG)
	fprintf (stderr, "toverTheSpotWindow_onSetPAttributeBackground (%p, %lx)\n",
			 gw, pxlBack) ;
#endif

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	for (i = 0 ; i < 3 ; i ++) {
		window	= pTerminal->m_wndTerminal [i] ;
		if (window != None)
			XSetWindowBackground (XtDisplay (gw), window, pxlBack) ;
	}
	window	= wgThis->toverwin.m_wndModeshell ;
	if (window != None)
		XSetWindowBackground (XtDisplay (gw), window, pxlBack) ;
	return	False ;
}

Boolean
toverTheSpotWindow_onSetPAttributeForeground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Pixel	pxlFore ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pxlFore		= CONVATTR_PREEDIT_FOREGROUND (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAForegroundPixel)) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAForegroundPixel) ;
	} else {
		if (CONVATTR_PREEDIT_FOREGROUND (*pCurAttr) == pxlFore)
			return	False ;
	}
#if defined (DEBUG)
	fprintf (stderr, "toverTheSpotWindow_onSetPAttributeForeground (%p, %lx)\n",
			 gw, pxlFore) ;
#endif
	CONVATTR_PREEDIT_FOREGROUND (*pCurAttr)	= pxlFore ;
	return	True ;
}

/*	Status Attribute:	Status Attribute ¦ϲޤǤμɬפ
 */
Boolean
toverTheSpotWindow_onSetStatusAttribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register unsigned int	uMask ;
	register int			i ;
	register Boolean		fRetval ;
	static Boolean	(*rpSetSAttrProcTbl[])(Widget, const TConversionAttribute*) = {
		NULL,
		toverTheSpotWindow_onSetSAttributeClientArea,
		toverTheSpotWindow_onSetSAttributeFont,
		toverTheSpotWindow_onSetSAttributeLineSpacing,
		toverTheSpotWindow_onSetSAttributeColormap,
		toverTheSpotWindow_onSetSAttributeForeground,
		toverTheSpotWindow_onSetSAttributeBackground,
	} ;

	uMask	= 1 << CASpotLocationBit ;
	i		= 0 ;
	fRetval	= False ;
	while (i <= (CABackgroundPixelBit - CASpotLocationBit)) {
		if (IS_CONVATTR_STATUS_MASK (*pAttribute, uMask) && 
			rpSetSAttrProcTbl [i] != NULL)
			fRetval	= (rpSetSAttrProcTbl [i])(gw, pAttribute) || fRetval ;
		uMask	= uMask << 1 ;
		i	++ ;
	}
	return	False ;
}

/*	Status Attribute:	ɽΰꡣ
 */
Boolean
toverTheSpotWindow_onSetSAttributeClientArea (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Boolean			fRetval	= False ;
	register const XRectangle*	pNewArea ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

#if defined (DEBUG)
	fprintf (stderr, "Status: ClientArea: (%d, %d, %d, %d)\n", 
			 pAttribute->m_Status.m_area.x,
			 pAttribute->m_Status.m_area.y,
			 pAttribute->m_Status.m_area.width,
			 pAttribute->m_Status.m_area.height) ;
#endif
	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pNewArea	= &CONVATTR_STATUS_CLIENTAREA (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea)) {
		SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (*pCurAttr, CAClientArea) ;
		CONVATTR_STATUS_CLIENTAREA (*pCurAttr)	= *pNewArea ;
		fRetval	= True ;
	} else {
		register XRectangle*	pCurArea ;

		pCurArea	= &CONVATTR_STATUS_CLIENTAREA (*pCurAttr) ;
		if (pCurArea->x      != pNewArea->x     ||
			pCurArea->y      != pNewArea->y     ||
			pCurArea->width  != pNewArea->width ||
			pCurArea->height != pNewArea->height)
			fRetval	= True ;
		*pCurArea	= *pNewArea ;
	}
	if (fRetval) {
		register int	nDX	= 0 ;
		if (wgThis->toverwin.m_wndModeshell != None &&
			!wgThis->toverwin.m_fFloatingModeshell) {
			XMoveWindow (XtDisplay (gw), wgThis->toverwin.m_wndModeshell, pNewArea->x, pNewArea->y) ;
			nDX	= wgThis->toverwin.m_szModeshell.cx ;
		}
		toverTheSpotWindow_setMinibufferFrameSize (gw, pNewArea->x + nDX, pNewArea->y, pNewArea->width - nDX, pNewArea->height) ;
	}
	return	fRetval ;
}

Boolean
toverTheSpotWindow_onSetSAttributeFont (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	/*	modeshell 񤯤Τɬפ */
	TFontSet_Copy  (&wgThis->toverwin.m_fsMinibuf, &CONVATTR_STATUS_FONTSET (*pAttribute)) ;

	if (wgThis->toverwin.m_wgMinibuf != NULL &&
		XtClass (wgThis->toverwin.m_wgMinibuf) == tsubWindowFrameWidgetClass) {
		TConversionAttribute	ca ;

		/*	modeshell ΰ֤餵ʤȤʤΤǡΰ֤Ǥ
		 *	ޤ */
		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CAFont) ;
		TFontSet_Copy  (&CONVATTR_PREEDIT_FONTSET (ca), &CONVATTR_STATUS_FONTSET (*pAttribute)) ;
		TFrame_SetAttribute (wgThis->toverwin.m_wgMinibuf, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	SET_CONVATTR_STATUS_MASK (*pCurAttr, CAFont) ;
	UNSET_CONVATTR_STATUS_MASK (*pCurAttr, CALineSpacing) ;
	return	True ;
}

Boolean
toverTheSpotWindow_onSetSAttributeLineSpacing (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (*pCurAttr, CALineSpacing) ||
		pCurAttr->m_Status.m_nLineSpacing != pAttribute->m_Status.m_nLineSpacing) {
		SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (*pCurAttr, CALineSpacing) ;
		pCurAttr->m_Status.m_nLineSpacing	= pAttribute->m_Status.m_nLineSpacing ;

		if (wgThis->toverwin.m_wgMinibuf != NULL &&
			XtClass (wgThis->toverwin.m_wgMinibuf) == tsubWindowFrameWidgetClass) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			SET_CONVATTR_MASK (ca, CAPreeditMask) ;
			SET_CONVATTR_PREEDIT_MASK (ca, CALineSpacing) ;
			ca.m_Preedit.m_nLineSpacing	= pAttribute->m_Status.m_nLineSpacing ;
			TFrame_SetAttribute (wgThis->toverwin.m_wgMinibuf, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
		return	True ;
	}
	return	False ;
}

Boolean
toverTheSpotWindow_onSetSAttributeColormap (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register Colormap	colNew ;
	TConversionAttribute	ca ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	colNew		= pAttribute->m_Preedit.m_colormap ;
	if (IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) &&
		IS_CONVATTR_STATUS_MASK (*pCurAttr, CAColormap) &&
		pCurAttr->m_Status.m_colormap == colNew) 
		return	False ;

	SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
	SET_CONVATTR_STATUS_MASK (*pCurAttr, CAColormap) ;
	pCurAttr->m_Status.m_colormap	= colNew ;

	if (!wgThis->toverwin.m_fFloatingModeshell &&
		wgThis->toverwin.m_wndModeshell != None) 
		XSetWindowColormap (XtDisplay (gw), wgThis->toverwin.m_wndModeshell, colNew) ;

	if (wgThis->toverwin.m_wgMinibuf != NULL &&
		XtClass (wgThis->toverwin.m_wgMinibuf) == tsubWindowFrameWidgetClass) {
		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CAColormap) ;
		ca.m_Preedit.m_colormap	= colNew ;
		TFrame_SetAttribute (wgThis->toverwin.m_wgMinibuf, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	False ;
}

Boolean
toverTheSpotWindow_onSetSAttributeBackground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Pixel	pxlBack ;
	TConversionAttribute	ca ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pxlBack		= CONVATTR_STATUS_BACKGROUND (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (*pCurAttr, CABackgroundPixel)) {
		SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (*pCurAttr, CABackgroundPixel) ;
	} else {
		if (CONVATTR_STATUS_BACKGROUND (*pCurAttr) == pxlBack)
			return	False ;
	}
	CONVATTR_STATUS_BACKGROUND (*pCurAttr)	= pxlBack ;

	if (!wgThis->toverwin.m_fFloatingModeshell &&
		wgThis->toverwin.m_wndModeshell != None) 
		XSetWindowBackground (XtDisplay (gw), wgThis->toverwin.m_wndModeshell, pxlBack) ;

	if (wgThis->toverwin.m_wgMinibuf != NULL &&
		XtClass (wgThis->toverwin.m_wgMinibuf) == tsubWindowFrameWidgetClass) {
		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CABackgroundPixel) ;
		CONVATTR_PREEDIT_BACKGROUND (ca)	= pxlBack ;
		TFrame_SetAttribute (wgThis->toverwin.m_wgMinibuf, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	False ;
}

Boolean
toverTheSpotWindow_onSetSAttributeForeground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Pixel	pxlFore ;
	TConversionAttribute	ca ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pxlFore		= CONVATTR_STATUS_FOREGROUND (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (*pCurAttr, CAForegroundPixel)) {
		SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (*pCurAttr, CAForegroundPixel) ;
	} else {
		if (CONVATTR_STATUS_FOREGROUND (*pCurAttr) == pxlFore)
			return	False ;
	}
	CONVATTR_STATUS_FOREGROUND (*pCurAttr)	= pxlFore ;

	if (wgThis->toverwin.m_wgMinibuf != NULL &&
		XtClass (wgThis->toverwin.m_wgMinibuf) == tsubWindowFrameWidgetClass) {
		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CAForegroundPixel) ;
		CONVATTR_PREEDIT_FOREGROUND (ca)	= pxlFore ;
		TFrame_SetAttribute (wgThis->toverwin.m_wgMinibuf, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	True ;
}

/*	楳ɤϲԤƤʤʤ̤뤤ɤʤġ
 */
Boolean
toverTheSpotWindow_puts (
	register Widget			gw,
	register const Char*	pText,
	register int			nText)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*		pTerminal ;
	register TOverTheSpotTerminalTextControl*	pControl ;
	register const Char*			ptr ;
	register const Char*			pStrInput ;
	register int					nptr, nInput, nControl ;
	register Boolean				fNewControl	= False ;
	TOverTheSpotTerminalTextControl	localControl ;

	if (wgThis->toverwin.m_fDestroy)
		return	False ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	nControl	= TVarbuffer_GetUsage (&pTerminal->m_vbufControl) ;
	if (nControl > 0) {
		pControl	= TVarbuffer_GetBuffer (&pTerminal->m_vbufControl) ;
		pControl	= pControl + nControl - 1 ;
		if (TSUCCEEDED (pControl->m_fFinish) ||
			pControl->m_fRev != pTerminal->m_fRev) {
			/* ξˤϿȥ뤬ɬס*/
			pControl	= &localControl ;
			fNewControl	= True ;
		}
	} else {
		pControl	= &localControl ;
		fNewControl	= True ;
	}
	if (fNewControl) {
		pControl->m_fRev		= pTerminal->m_fRev ;
		pControl->m_nTextPos	= TVarbuffer_GetUsage (&pTerminal->m_vbufText) ;
		pControl->m_nText		= 0 ;
		pControl->m_fFinish		= False ;
	}

	ptr		= pStrInput	= pText ;
	nptr	= nText ;
	while (nptr > 0) {
		if (*ptr == '\n') {
			nInput					= ptr - pStrInput ;
			if (nInput > 0 &&
				TFAILED (TVarbuffer_Add (&pTerminal->m_vbufText, pStrInput, nInput)))
				return	False ;
			pControl->m_nText		+= nInput ;
#if defined (DEBUG) || 0
			fprintf (stderr, "TextPos(%d), Text(%d), %d, %d\n",
					 pControl->m_nTextPos, pControl->m_nText, nInput, nText) ;
#endif
			pControl->m_fFinish	= True ;
			if (fNewControl) {
				if (TFAILED (TVarbuffer_Add (&pTerminal->m_vbufControl, pControl, 1)))
					return	False ;
			}
			pControl				= &localControl ;
			fNewControl				= True ;
			pControl->m_fRev		= pTerminal->m_fRev ;
			pControl->m_nTextPos	= TVarbuffer_GetUsage (&pTerminal->m_vbufText) ;
			pControl->m_nText		= 0 ;
			pControl->m_fFinish		= False ;
			pTerminal->m_nLine		++ ;	/* Ԥ뤫ϥ쥤Ȥ˽פʤΤǵ롣*/
			pStrInput				= ptr + 1 ;
		}
		ptr		++ ;
		nptr	-- ;
	}
	if (ptr != pStrInput) {
		nInput					= ptr - pStrInput ;
		if (TFAILED (TVarbuffer_Add (&pTerminal->m_vbufText, pStrInput, nInput)))
			return	False ;
		pControl->m_nText		+= nInput ;
#if defined (DEBUG) || 0
		fprintf (stderr, "TextPos(%d), Text(%d), %d, %d\n",
				 pControl->m_nTextPos, pControl->m_nText, nInput, nText) ;
#endif
	}
	if (fNewControl) {
		if (TFAILED (TVarbuffer_Add (&pTerminal->m_vbufControl, pControl, 1)))
			return	False ;
	}
	return	True ;
}

Boolean
toverTheSpotWindow_putchar (
	register Widget			gw,
	const Char				cc)
{
	return	toverTheSpotWindow_puts (gw, &cc, 1) ;
}

void
toverTheSpotWindow_flush (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;

	if (wgThis->toverwin.m_fActive && !wgThis->toverwin.m_fDestroy)
		toverTheSpotWindow_configureTerminalWindow (gw) ;
	return ;
}

/*
 */
void
toverTheSpotWindow_clear (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*	pTerminal ;

	if (wgThis->toverwin.m_fDestroy)
		return ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	TVarbuffer_Clear (&pTerminal->m_vbufText) ;
	TVarbuffer_Clear (&pTerminal->m_vbufControl) ;
	pTerminal->m_nCursor	= 0 ;
	pTerminal->m_nLine		= 0 ;
	return ;
}

/*
 */
void
toverTheSpotWindow_rev (
	register Widget			gw,
	register Boolean			fRev)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*	pTerminal ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	pTerminal->m_fRev	= fRev ;
	return ;
}

Boolean
toverTheSpotWindow_rectVariablep (
	register Widget			gw)
{
	return	True ;
}

Boolean
toverTheSpotWindow_haveExternModelinep (
	register Widget			gw)
{
	return	True ;
}

Boolean
toverTheSpotWindow_setModeline (
	register Widget			gw,
	register const Char*	pString,
	register int			nString)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register const Char*	pPrevString ;
	register int			nPrevString ;
	register Boolean		fRedraw ;

	if (wgThis->toverwin.m_fDestroy)
		return	True ;

	pPrevString	= TVarbuffer_GetBuffer (&wgThis->toverwin.m_vbufModeshellText) ;
	nPrevString	= TVarbuffer_GetUsage  (&wgThis->toverwin.m_vbufModeshellText) ;
	fRedraw		= (nPrevString != nString || memcmp (pPrevString, pString, nString * sizeof (Char)) != 0) ;
	if (!fRedraw)
		return	True ;
	TVarbuffer_Clear (&wgThis->toverwin.m_vbufModeshellText) ;
	if (TFAILED (TVarbuffer_Add (&wgThis->toverwin.m_vbufModeshellText, pString, nString)))
		return	False ;
	toverTheSpotWindow_resizeModeshellWindow (gw) ;
	toverTheSpotWindow_onModeshellExpose (gw, 0) ;
	//XClearArea (XtDisplay (gw), wgThis->toverwin.m_wndModeshell, 0, 0, 0, 0, True) ;
	return	True ;
}

Boolean
toverTheSpotWindow_autoPopupp (
	register Widget		gw)
{
	return	False ;
}


/*	Terminal Window ΥĴԤ
 *
 *	3Ĥ Window ڤؤƻȤäƤΤ줾 Window ΰ֤ȥ
 *	ˤʤ롣
 */
void
toverTheSpotWindow_configureTerminalWindow (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*				pTerminal ;
	register TOverTheSpotTerminalTextControl*	pControl ;
	register TOverTheSpotTerminalTextControl*	pControlHead ;
	register Display*				pDisplay ;
	register const Char*			pText ;
	register int					nControl, nWindow, nMaxWindow, nClientAreaX, nClientAreaY ;
	register int					nX, nY, nMasterClientAreaWidth, nClientAreaWidth ;
	register TFontSet*				pFontSet ;
	int								rnLineCount [3], nLineSpacing ;
	TSize							sz ;
	register Boolean					fEmpty, fLineSpacing ;

	pDisplay		= XtDisplay (gw) ;
	pTerminal		= &wgThis->toverwin.m_Terminal ;
	pText			= TVarbuffer_GetBuffer (&pTerminal->m_vbufText) ;
	pControlHead	= TVarbuffer_GetBuffer (&pTerminal->m_vbufControl) ;
	pControl		= pControlHead ;
	nControl		= TVarbuffer_GetUsage  (&pTerminal->m_vbufControl) ;
	pFontSet		= &wgThis->toverwin.m_fsTerminal ;
	fEmpty			= (nControl <= 0) ;
	fLineSpacing	= toverTheSpotWindow_getPreeditLineSpacing (gw, &nLineSpacing) ;

	nWindow		= 0 ;
	rnLineCount	[nWindow ++]	= 1 ;
	if ((pTerminal->m_nLine - 2) >= 0) 
		rnLineCount [nWindow ++]	= pTerminal->m_nLine - 1 ;
	if (pTerminal->m_nLine >= 1) 
		rnLineCount [nWindow ++]	= 1 ;

	nMaxWindow	= nWindow ;
	nWindow		= 0 ;
	/*	֤ꡣ*/
	if (IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caCurrent, CAClientArea)) {
		nMasterClientAreaWidth	= wgThis->toverwin.m_caCurrent.m_Preedit.m_area.width ;
#if 0
		nClientAreaX			= wgThis->toverwin.m_caCurrent.m_Preedit.m_area.x ;
		nClientAreaY			= wgThis->toverwin.m_caCurrent.m_Preedit.m_area.y ;
#else
		nClientAreaX			= 0 ;
		nClientAreaY			= 0 ;
#endif
	} else {
		nClientAreaX			= 0 ;
		nClientAreaY			= 0 ;
		nMasterClientAreaWidth	= 65535 ;
	}
	nX					= wgThis->toverwin.m_ptSpot.x + nClientAreaX ;
	nY					= wgThis->toverwin.m_ptSpot.y + nClientAreaY - TFontSet_GetAscent (pFontSet) ;
#if defined (DEBUG) || 0
	fprintf (stderr, "Spot:(%d, %d) Client:(%d, %d, %d, %d), line=%d\n",
			 wgThis->toverwin.m_ptSpot.x,
			 wgThis->toverwin.m_ptSpot.y,
			 nClientAreaX,
			 nClientAreaY,
			 nMasterClientAreaWidth - wgThis->toverwin.m_ptSpot.x,
			 wgThis->toverwin.m_caCurrent.m_Preedit.m_area.height,
			 pTerminal->m_nLine) ;
#endif
	nClientAreaWidth	= nMasterClientAreaWidth - wgThis->toverwin.m_ptSpot.x ;

	while (nWindow < nMaxWindow) {
		register int	nCurLineWidth, nCurLineHeight, nWidth, nHeight, nLine ;
		register Boolean	fFinish ;

		pTerminal->m_rnControlOffset [nWindow]	= pControl - pControlHead ;

		nLine			= rnLineCount [nWindow] ;
		nCurLineWidth	= 0 ;
		nCurLineHeight	= 0 ;
		nWidth			= 0 ;
		nHeight			= 0 ;
		while (nControl > 0) {
			TGetTextExtents (pFontSet, pText + pControl->m_nTextPos, pControl->m_nText, &sz) ;
#if defined (DEBUG) || 0
			fprintf (stderr, "Control: TextPos(%d), Text(%d), Rev(%d), Fin(%d), %d x %d\n",
					 pControl->m_nTextPos, pControl->m_nText, 
					 pControl->m_fRev, pControl->m_fFinish,
					 sz.cx, sz.cy) ;
#endif
			nCurLineWidth	+= sz.cx ;
			nCurLineHeight	= (nCurLineHeight < sz.cy)? sz.cy : nCurLineHeight ;
			fFinish			=  pControl->m_fFinish ;
			pControl	++ ;
			nControl	-- ;
			
			if (fFinish || nControl <= 0) {
				nHeight		+= (fLineSpacing)? nLineSpacing : nCurLineHeight ;
				nWidth		= (nWidth < nCurLineWidth)? nCurLineWidth : nWidth ;
				nLine	-- ;
				if (nLine <= 0) 
					break ;
				nCurLineWidth	= 0 ;
				nCurLineHeight	= 0 ;
			}
		}
		nWidth	= (nWidth > nClientAreaWidth)? nClientAreaWidth : nWidth ;

#if defined (DEBUG) || 0
		fprintf (stderr, "Window(%d): (%d, %d, %d, %d)\n",
				 nWindow, nX, nY, nWidth, nHeight) ;
#endif
		if (pTerminal->m_wndTerminal [nWindow] != None) {
			if (nWidth > 0 && nHeight > 0) {
				XMoveResizeWindow (pDisplay, pTerminal->m_wndTerminal [nWindow], nX, nY, nWidth, nHeight) ;
				XMapRaised (pDisplay, pTerminal->m_wndTerminal [nWindow]) ;
				(srOverTheSpotTerminalExposeProc [nWindow])(gw, 0) ;
//				XClearArea (pDisplay, pTerminal->m_wndTerminal [nWindow], 0, 0, 0, 0, True) ;
			} else {
				XUnmapWindow (pDisplay, pTerminal->m_wndTerminal [nWindow]) ;
			}
		}
		nX					=  nClientAreaX ;
		nY					+= nHeight ;
		nClientAreaWidth	= nMasterClientAreaWidth ;
		nWindow	++ ;
	}
	while (nWindow < 3) {
		if (pTerminal->m_wndTerminal [nWindow] != None)
			XUnmapWindow (pDisplay, pTerminal->m_wndTerminal [nWindow]) ;
		pTerminal->m_rnControlOffset [nWindow]	= -1 ;
		nWindow	++ ;
	}
	
	/*	Modeshell ư롣̳˽Фʤ褦ˤåʤ*/
	if (wgThis->toverwin.m_wndModeshell != None &&
		wgThis->toverwin.m_fFloatingModeshell) {

		if (nMaxWindow <= 1) {
			nX	=  wgThis->toverwin.m_ptSpot.x + nClientAreaX ;
			if (fEmpty) {
				register int	nFontHeight	= TFontSet_GetHeight (pFontSet) ;
				nY	+= (fLineSpacing && nFontHeight < nLineSpacing)? nLineSpacing : nFontHeight ;
			}
		} else {
			nX	= nClientAreaX ;
		}
#if defined (DEBUG)
		fprintf (stderr, "spot(x,y,ls,empty)=(%d,%d,%d,%d)\n", nX, nY, nLineSpacing, fEmpty) ;
#endif
		XMoveWindow (pDisplay, wgThis->toverwin.m_wndModeshell, nX, nY) ;
	}
	return ;
}

void
toverTheSpotWindow_displayTerminal (
	register Widget								gw,
	register Window								wndTerminal,
	register GC									gc,
	register TOverTheSpotTerminalTextControl*	pControl,
	register int								nControl,
	register int								nLine)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*		pTerminal ;
	register Display*					pDisplay ;
	register const Char*				pText ;
	register TFontSet*					pFontSet ;
	register Pixel						pxlForeground, pxlBackground ;
	register int						x, y, nHeight, nAscent, nDescent ;
	register Boolean					fLineSpacing ;
	int									nLineSpacing ;
	TSize								sz ;

	if (nControl <= 0 || nLine <= 0)
		return ;

	pDisplay		= XtDisplay (wgThis) ;
	pTerminal		= &wgThis->toverwin.m_Terminal ;
	pFontSet		= &wgThis->toverwin.m_fsTerminal ;
	x				= 0 ;
	nAscent			= TFontSet_GetAscent (pFontSet) ;
	nDescent		= TFontSet_GetDescent (pFontSet) ;
	y				= nAscent ;
	nHeight			= 0 ;
	fLineSpacing	= toverTheSpotWindow_getPreeditLineSpacing (gw, &nLineSpacing) ;
	pxlForeground	= wgThis->toverwin.m_pxlForeground ;
	pxlBackground	= wgThis->core.background_pixel ;
	if (IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAPreeditMask)) { 
		if (IS_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caCurrent, CAForegroundPixel)) 
			pxlForeground	= CONVATTR_PREEDIT_FOREGROUND (wgThis->toverwin.m_caCurrent) ;
		if (IS_CONVATTR_PREEDIT_MASK (wgThis->toverwin.m_caCurrent, CABackgroundPixel)) 
			pxlBackground	= CONVATTR_PREEDIT_BACKGROUND (wgThis->toverwin.m_caCurrent) ;
	}
#if defined (DEBUG)
	fprintf (stderr, "displayTerminal (Fore:%lx, Back:%lx)\n",
			 pxlForeground, pxlBackground) ;
#endif

	pText			= TVarbuffer_GetBuffer (&pTerminal->m_vbufText) ;
	while (nControl > 0) {
#if defined (DEBUG)
		fprintf (stderr, "[%d(%d)]", pControl->m_nText, pControl->m_fRev) ;
#endif
		if (pControl->m_fRev) {
			XSetBackground (pDisplay, gc, pxlForeground) ;
			XSetForeground (pDisplay, gc, pxlBackground) ;
		} else {
			XSetForeground (pDisplay, gc, pxlForeground) ;
			XSetBackground (pDisplay, gc, pxlBackground) ;
		}
		if (pControl->m_nText > 0) {
			TTextOut (pDisplay, wndTerminal, gc, pFontSet, x, y, pText + pControl->m_nTextPos, pControl->m_nText, &sz) ;
			x		+= sz.cx ;
			nHeight	=  (nHeight < sz.cy)? sz.cy : nHeight ;
		}

		/*	ιԤޤ뤫ɤΥå*/
		if (pControl->m_fFinish) {
			XClearArea (pDisplay, wndTerminal, x, y - nAscent, 65535, y + nDescent, False) ;
			nLine	-- ;
			if (nLine <= 0)
				break ;
			x		= 0 ;
			y		+= (fLineSpacing)? nLineSpacing : nHeight ;
			nHeight	= 0 ;
		}
		pControl	++ ;
		nControl	-- ;
	}
#if defined (DEBUG)
	fprintf (stderr, "\n") ;
#endif
	return ;
}

/*	Spot ϤǤʤˤϡTerminal Window Ȥΰִطɬס
 */
void
toverTheSpotWindow_resizeModeshellWindow (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register Display*				pDisplay	= XtDisplay (gw) ;
	register const Char*			pString ;
	register int					nString ;	
	register Boolean				fFixedModeshell ;
	TSize	sz ;

	if (wgThis->toverwin.m_wndModeshell == None)
		return ;

	fFixedModeshell	= (IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAStatusMask) &&
					   IS_CONVATTR_STATUS_MASK (wgThis->toverwin.m_caCurrent, CAClientArea) &&
					   wgThis->toverwin.m_wndClient != wgThis->toverwin.m_wndFocus) ;

	pString		= TVarbuffer_GetBuffer (&wgThis->toverwin.m_vbufModeshellText) ;
	nString		= TVarbuffer_GetUsage  (&wgThis->toverwin.m_vbufModeshellText) ;
	if (nString <= 0) {
		XUnmapWindow (pDisplay, wgThis->toverwin.m_wndModeshell) ;
		sz.cx	= 0 ;
		sz.cy	= 0 ;
	} else {
		register TFontSet*	pFontSet ;

		if (wgThis->toverwin.m_fActive)
			XMapWindow (pDisplay, wgThis->toverwin.m_wndModeshell) ;
		if (fFixedModeshell) {
			pFontSet	= &wgThis->toverwin.m_fsMinibuf ;
		} else {
			pFontSet	= &wgThis->toverwin.m_fsTerminal ;
		}
		TGetTextExtents (pFontSet, pString, nString, &sz) ;
		XResizeWindow (pDisplay, wgThis->toverwin.m_wndModeshell, sz.cx, sz.cy) ;
	}
	wgThis->toverwin.m_szModeshell	= sz ;

	if (fFixedModeshell) {
		register const XRectangle*	pRC	= &CONVATTR_STATUS_CLIENTAREA (wgThis->toverwin.m_caCurrent) ;
		toverTheSpotWindow_setMinibufferFrameSize (gw, pRC->x + sz.cx, pRC->y, pRC->width - sz.cx, pRC->height) ;
	}
	return ;
}

int
toverTheSpotWindow_configureFocusOffset (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register Display*				pDisplay	= XtDisplay (gw) ;
	register Window					wndClient, wndFocus ;
	register Boolean				fRedraw		= False ;
	int		x, y, nFocusX, nFocusY ;
	Window	dummy ;

	wndClient	= wgThis->toverwin.m_wndClient ;
	wndFocus	= wgThis->toverwin.m_wndFocus ;
	XTranslateCoordinates (pDisplay, wndClient, RootWindowOfScreen (XtScreen (gw)), 0, 0, &x, &y, &dummy) ;
	if (wndClient != wndFocus) {
		/*	Client Window  Focus Window ɤ줿֤ˤ
		 *	Τ򵭲Ƥ
		 */
		XTranslateCoordinates (pDisplay, wndFocus, wndClient, 0, 0, &nFocusX, &nFocusY, &dummy) ;
	} else {
		nFocusX	= nFocusY	= 0 ;
	}
	if (wgThis->toverwin.m_ptClient.x != x || wgThis->toverwin.m_ptClient.y != y) {
		wgThis->toverwin.m_ptClient.x	= x ;
		wgThis->toverwin.m_ptClient.y	= y ;
		fRedraw	= True ;
	}
	if (wgThis->toverwin.m_ptFocus.x != nFocusX || wgThis->toverwin.m_ptFocus.y != nFocusY) {
		wgThis->toverwin.m_ptFocus.x	= x ;
		wgThis->toverwin.m_ptFocus.y	= y ;
		fRedraw	= True ;
	}
	return	fRedraw ;
}

/*
 *
 */
void
toverTheSpotWindow_popup (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*		pTerminal ;
	register int	i ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	for (i = 0 ; i < 3 ; i ++) {
		if (pTerminal->m_wndTerminal [i] != None)
			XMapWindow (XtDisplay (gw), pTerminal->m_wndTerminal [i]) ;
	}
	if (wgThis->toverwin.m_wndModeshell != None)
		XMapWindow (XtDisplay (gw), wgThis->toverwin.m_wndModeshell) ;

	if (!wgThis->toverwin.m_fActive) {
		toverTheSpotWindow_configureTerminalWindow (gw) ;
		wgThis->toverwin.m_fActive	= True ;
	}
	return ;
}

void
toverTheSpotWindow_popdown (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register TOverTheSpotTerminal*		pTerminal ;
	register int	i ;

	pTerminal	= &wgThis->toverwin.m_Terminal ;
	for (i = 0 ; i < 3 ; i ++) {
		if (pTerminal->m_wndTerminal [i] != None)
			XUnmapWindow (XtDisplay (gw), pTerminal->m_wndTerminal [i]) ;
	}
	if (wgThis->toverwin.m_wndModeshell != None)
		XUnmapWindow (XtDisplay (gw), wgThis->toverwin.m_wndModeshell) ;
	wgThis->toverwin.m_fActive	= False ;
	return ;
}

Boolean
toverTheSpotWindow_getPreeditLineSpacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;

	assert (gw != NULL) ;
	assert (pnLineSpacing != NULL) ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CALineSpacing)) {
		*pnLineSpacing	= TFontSet_GetHeight (&wgThis->toverwin.m_fsTerminal) ;
		return	False ;
	}
	*pnLineSpacing	= pCurAttr->m_Preedit.m_nLineSpacing ;
	return	True ;
}

void
toverTheSpotWindow_setMinibufferFrameSize (
	register Widget					gw,
	register int					nX,
	register int					nY,
	register int					nWidth,
	register int					nHeight)
{
	register TOverTheSpotWindowWidget	wgThis		= (TOverTheSpotWindowWidget) gw ;
	TConversionAttribute	ca ;

	if (wgThis->toverwin.m_fFloatingModeshell ||
		wgThis->toverwin.m_wgMinibuf == NULL  ||
		XtClass (wgThis->toverwin.m_wgMinibuf) != tsubWindowFrameWidgetClass) 
		return ;
	
	TConvAttr_Initialize (&ca) ;
	SET_CONVATTR_MASK (ca, CAPreeditMask) ;
	SET_CONVATTR_PREEDIT_MASK (ca, CAClientArea) ;
	ca.m_Preedit.m_area.x		= nX ;
	ca.m_Preedit.m_area.y		= nY ;
	ca.m_Preedit.m_area.width	= nWidth ;
	ca.m_Preedit.m_area.height	= nHeight ;
	TFrame_SetAttribute (wgThis->toverwin.m_wgMinibuf, &ca) ;
	TConvAttr_Uninitialize (&ca) ;
	return ;
}

unsigned long
toverTheSpotWindow_getPreeditWindowAttribute (
	register Widget					gw,
	register XSetWindowAttributes*	pSWA)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register unsigned long	lMask ;
	register Pixel			pxlBack ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pxlBack		= wgThis->core.background_pixel ;
	lMask		= CWOverrideRedirect | CWBackPixel | CWBorderPixel ;

	if (IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAPreeditMask)) {
		if (IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CABackgroundPixel))
			pxlBack		= CONVATTR_PREEDIT_BACKGROUND (*pCurAttr) ;
		if (IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAColormap)) {
			pSWA->colormap	= pCurAttr->m_Preedit.m_colormap ;
			lMask			|= CWColormap ;
		}
	}
	pSWA->override_redirect	= True ;
	pSWA->background_pixel	= pxlBack ;
	pSWA->border_pixel		= pxlBack ;
	return	lMask ;
}

unsigned long
toverTheSpotWindow_getStatusWindowAttribute (
	register Widget					gw,
	register XSetWindowAttributes*	pSWA)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register unsigned long	lMask ;
	register Pixel			pxlBack ;

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	pxlBack		= wgThis->core.background_pixel ;
	lMask		= CWOverrideRedirect | CWBackPixel | CWBorderPixel ;

	if (IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAStatusMask)) {
		if (IS_CONVATTR_STATUS_MASK (*pCurAttr, CABackgroundPixel))
			pxlBack		= CONVATTR_STATUS_BACKGROUND (*pCurAttr) ;
		if (IS_CONVATTR_STATUS_MASK (*pCurAttr, CAColormap)) {
			pSWA->colormap	= pCurAttr->m_Status.m_colormap ;
			lMask			|= CWColormap ;
		}
	}
	pSWA->override_redirect	= True ;
	pSWA->background_pixel	= pxlBack ;
	pSWA->border_pixel		= pxlBack ;
	return	lMask ;
}

Boolean
toverTheSpotWindow_createTerminalWindow (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register Display*				pDisplay	= XtDisplay (gw) ;
	register TOverTheSpotTerminal*	pTerminal ;
	register Window					wndFocus, wndTerminal ;
	register GC						gc ;
	register unsigned long			lMask ;
	register int					i ;
	XSetWindowAttributes			swa ;

	lMask		= toverTheSpotWindow_getPreeditWindowAttribute (gw, &swa) ;
	wndFocus	= wgThis->toverwin.m_wndFocus ;
	pTerminal	= &wgThis->toverwin.m_Terminal ;
	for (i = 0 ; i < 3 ; i ++) {
		wndTerminal	= XCreateWindow (pDisplay, wndFocus, 0, 0, 1, 1, 0, CopyFromParent, CopyFromParent, CopyFromParent, lMask, &swa) ;
		if (wndTerminal == None) 
			return	False ;
		pTerminal->m_wndTerminal [i]	= wndTerminal ;

		gc			= XCreateGC (pDisplay, wndTerminal, 0, NULL) ;
		if (gc == None) 
			return	False ;

		pTerminal->m_rGC [i]	= gc ;

		AfxRegisterWindow (pDisplay, wndTerminal, Expose, ExposureMask, gw, srOverTheSpotTerminalExposeProc [i]) ;
		AfxRegisterWindow (pDisplay, wndTerminal, DestroyNotify, StructureNotifyMask, gw, toverTheSpotWindow_onTerminalDestroy) ;
		AfxRegisterWindow (pDisplay, wndTerminal, KeyPress, KeyPressMask, gw, toverTheSpotWindow_onSubwindowKeyPress) ;
		AfxRegisterWindow (pDisplay, wndTerminal, KeyRelease, KeyReleaseMask, gw, toverTheSpotWindow_onSubwindowKeyRelease) ;
	}
	return	True ;
}

Boolean
toverTheSpotWindow_createModeshellWindow (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register Display*		pDisplay	= XtDisplay (gw) ;
	register Window			wndFocus, wndModeshell ;
	register GC				gc ;
	register int			x, y ;
	register unsigned long	lMask ;
	XSetWindowAttributes	swa ;

	if (!IS_CONVATTR_MASK (wgThis->toverwin.m_caCurrent, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (wgThis->toverwin.m_caCurrent, CAClientArea) ||
		wgThis->toverwin.m_wndClient == wgThis->toverwin.m_wndFocus) {
		/*	floating modeshell */
		wndFocus	= wgThis->toverwin.m_wndFocus ;
		wgThis->toverwin.m_fFloatingModeshell	= True ;
		x	=	y	= 0 ;
	} else {
		/*	fixed modeshell */
		wndFocus	= wgThis->toverwin.m_wndClient ;
		wgThis->toverwin.m_fFloatingModeshell	= False ;
		x	= wgThis->toverwin.m_caCurrent.m_Status.m_area.x ;
		y	= wgThis->toverwin.m_caCurrent.m_Status.m_area.y ;
	}

	if (wgThis->toverwin.m_fFloatingModeshell) {
		lMask	= toverTheSpotWindow_getPreeditWindowAttribute (gw, &swa) ;
#if 0
		lMask	|= CWSaveUnder | CWBackingStore ;
		swa.save_under		= True ;
		swa.backing_store	= Always ;
#endif
	} else {
		lMask	= toverTheSpotWindow_getStatusWindowAttribute (gw, &swa) ;
	}

	/*	Focus Window Žդ Modeshell 롣Ĥ terminal 
	 *	Ƥ뤬ɤΤ ʤ overspec ʵ뤬ġ
	 */
	wndModeshell	= XCreateWindow (pDisplay, wndFocus, x, y, 1, 1, 0, CopyFromParent, CopyFromParent, CopyFromParent, lMask, &swa) ;
	if (wndModeshell == None) 
		return	False ;
	wgThis->toverwin.m_wndModeshell	= wndModeshell ;

	gc	= XCreateGC (pDisplay, wndModeshell, 0, NULL) ;
	if (gc == None) 
		return	False ;
	wgThis->toverwin.m_gcModeshell	= gc ;

	AfxRegisterWindow (pDisplay, wndModeshell, Expose, ExposureMask, gw, toverTheSpotWindow_onModeshellExpose) ;
	AfxRegisterWindow (pDisplay, wndModeshell, DestroyNotify, StructureNotifyMask, gw, toverTheSpotWindow_onModeshellDestroy) ;
	AfxRegisterWindow (pDisplay, wndModeshell, KeyPress, KeyPressMask, gw, toverTheSpotWindow_onSubwindowKeyPress) ;
	AfxRegisterWindow (pDisplay, wndModeshell, KeyRelease, KeyReleaseMask, gw, toverTheSpotWindow_onSubwindowKeyRelease) ;
	return	True ;
}

Boolean
toverTheSpotWindow_createMinibufferFrame (
	register Widget			gw)
{
	register TOverTheSpotWindowWidget	wgThis	= (TOverTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register Widget	wgMinibufFrame ;
	Boolean			fInput ;
	Arg				rArg [12] ;
	register int	nArg ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg],	XtNinput,			&fInput) ;	nArg ++ ;
	XtGetValues (gw, rArg, nArg) ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged, False) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNclientWindow,		wgThis->toverwin.m_wndClient) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNfocusWindow,		wgThis->toverwin.m_wndFocus) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNinput,			fInput) ;	nArg ++ ;	

	pCurAttr	= &wgThis->toverwin.m_caCurrent ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (*pCurAttr, CAClientArea) ||
		wgThis->toverwin.m_wndClient == wgThis->toverwin.m_wndFocus) {
		XtSetArg (rArg [nArg], XtNautoPopup,	True) ;		nArg ++ ;	
		XtSetArg (rArg [nArg], XtNheight,		1) ;		nArg ++ ;
		wgMinibufFrame	= TRootWindowFrame_Create (XtParent (gw), rArg, nArg) ;
	} else {
		register const XRectangle*	pRect	= &pCurAttr->m_Status.m_area ;
		register int				nDX		= 0 ;
		
		if (!wgThis->toverwin.m_fFloatingModeshell &&
			wgThis->toverwin.m_wndModeshell != None) 
			nDX	= wgThis->toverwin.m_szModeshell.cx ;

		XtSetArg (rArg [nArg], XtNx,		pRect->x + nDX) ;		nArg ++ ;
		XtSetArg (rArg [nArg], XtNy,		pRect->y) ;				nArg ++ ;
		XtSetArg (rArg [nArg], XtNwidth,	pRect->width - nDX) ;	nArg ++ ;
		XtSetArg (rArg [nArg], XtNheight,	pRect->height) ;		nArg ++ ;
		if (IS_CONVATTR_STATUS_MASK (*pCurAttr, CAForegroundPixel)) {
			XtSetArg (rArg [nArg], XtNforeground,	pCurAttr->m_Status.m_foreground) ;
			nArg ++ ;
		}
		if (IS_CONVATTR_STATUS_MASK (*pCurAttr, CABackgroundPixel)) {
			XtSetArg (rArg [nArg], XtNbackground,	pCurAttr->m_Status.m_background) ;
			nArg ++ ;
		}
		wgMinibufFrame	= TSubWindowFrame_Create (XtParent (gw), rArg, nArg) ;
		if (wgMinibufFrame != NULL) {
			TConversionAttribute	ca ;

			TConvAttr_Initialize (&ca) ;
			toverTheSpotWindow_convertStatus2Preedit (&ca, pCurAttr) ;
			ca.m_wndFocus	=  wgThis->toverwin.m_wndClient ;
			ca.m_uMask		|= CAFocusWindow ;
			SET_CONVATTR_PREEDIT_MASK (ca, CAFont) ;
			TFontSet_Copy  (&ca.m_Preedit.m_FontSet, &wgThis->toverwin.m_fsMinibuf) ;
			TFrame_SetAttribute (wgMinibufFrame, &ca) ;
			TConvAttr_Uninitialize (&ca) ;
		}
	}
	if (wgMinibufFrame == NULL)
		return	False ;
	wgThis->toverwin.m_wgMinibuf	= wgMinibufFrame ;
	return	True ;
}

void
toverTheSpotWindow_convertStatus2Preedit (
	register TConversionAttribute*			pDest,
	register const TConversionAttribute*	pSrc)
{
	assert (pDest != NULL) ;
	assert (pSrc != NULL) ;

	pDest->m_wndFocus	= pSrc->m_wndFocus ;
	pDest->m_uMask		= pSrc->m_uMask & ~(CAPreeditMask | CAStatusMask) ;
	if (!IS_CONVATTR_MASK (*pSrc, CAStatusMask)) 
		return ;
	pDest->m_uMask		|= CAPreeditMask ;
	pDest->m_Preedit.m_uMask		= pSrc->m_Status.m_uMask & ~CASpotLocation ;
	pDest->m_Preedit.m_cursor		= pSrc->m_Status.m_cursor ;
	pDest->m_Preedit.m_foreground	= pSrc->m_Status.m_foreground ;
	pDest->m_Preedit.m_background	= pSrc->m_Status.m_background ;
	pDest->m_Preedit.m_nLineSpacing	= pSrc->m_Status.m_nLineSpacing ;
	pDest->m_Preedit.m_colormap		= pSrc->m_Status.m_colormap ;
	pDest->m_Preedit.m_cursor		= pSrc->m_Status.m_cursor ;
	pDest->m_Preedit.m_area			= pSrc->m_Status.m_area ;
	pDest->m_Preedit.m_areaNeeded	= pSrc->m_Status.m_areaNeeded ;
	return ;
}

/*
 * ꤵ줿礭֤ξ XRectangle ¤Τ֤ؿ
 */
void
XGetRectangleOfWindow (
	register Display*		pDisplay,
	register Window			win,
	register XRectangle*	pArea)
{
	Window			wndRoot ;
	int				x, y ;
	unsigned int	border_width, depth_size, height, width ;
  
	XGetGeometry (pDisplay, win, &wndRoot, &x, &y, &width, &height, &border_width, &depth_size) ;
	pArea->x		= (short) x ;
	pArea->y		= (short) y ;
	pArea->width	= (unsigned short)width ;
	pArea->height	= (unsigned short)height ;
	return ;
}

Widget
TOverTheSpotWindowFrame_Create (
	Widget			wgParent,
	ArgList			arglist,
	Cardinal		nArglist)
{
	return	XtCreateWidget ("TOverTheSpotWindow", toverTheSpotWindowWidgetClass, wgParent, arglist, nArglist) ;
}

