/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include "TOnTheSpotWindowP.h"
#include "TRootWindow.h"
#include "TTerminal.h"
#include "TConvAttr.h"
#include "dispatch.h"
#include "ttext.h"

#define offset(field)	XtOffsetOf(TOnTheSpotWindowRec, tonwin.field)
#define soffset(field)	XtOffsetOf(ShellWidgetRec, shell.field)
#define goffset(field)	XtOffsetOf(WidgetRec, core.field )

static	XtResource	srOnTheSpotWindowResource []	= {
	{	XtNwidth,					XtCWidth,
		XtRDimension,				sizeof (Dimension),
		goffset (width),			XtRImmediate,		(XtPointer) 1, },
	{	XtNheight,					XtCHeight,
		XtRDimension,				sizeof (Dimension),
		goffset (height),			XtRImmediate,		(XtPointer) 1, },
	{	XtNclientWindow,			XtCClientWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndClient),		XtRImmediate,		(XtPointer) None, },
	{	XtNpreeditStartCallback,	XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkPreeditStart),	XtRCallback,		(XtPointer) NULL, },
	{	XtNpreeditDrawCallback,	XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkPreeditDraw),	XtRCallback,		(XtPointer) NULL, },
	{	XtNpreeditCaretCallback,	XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkPreeditCaret),	XtRCallback,		(XtPointer) NULL, },
	{	XtNpreeditDoneCallback,	XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkPreeditDone),	XtRCallback,		(XtPointer) NULL, },
	{	XtNstatusStartCallback,	XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkStatusStart),	XtRCallback,		(XtPointer) NULL, },
	{	XtNstatusDrawCallback,	XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkStatusDraw),	XtRCallback,		(XtPointer) NULL, },
	{	XtNstatusDoneCallback,	XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkStatusDone),	XtRCallback,		(XtPointer) NULL, },
	{	XtNminibufFrame,			XtCMinibufFrame,
		XtRWidget,					sizeof (Widget),
		offset (m_wgMinibuf),		XtRWidget,			NULL, },
} ;

#undef	offset
#undef	goffset

static	void	tonTheSpotWindow_onInitialize	(Widget, Widget, ArgList, Cardinal*) ;
static	void	tonTheSpotWindow_onRealize		(Widget, XtValueMask*, XSetWindowAttributes*) ;
static	Boolean	tonTheSpotWindow_onSetValues	(Widget, Widget, Widget, ArgList, Cardinal*) ;
static	void	tonTheSpotWindow_onDestroy		(Widget) ;
static	void	tonTheSpotWindow_onKeyPress		(Widget, XEvent*, String*, Cardinal*) ;
static	void	tonTheSpotWindow_onKeyRelease	(Widget, XEvent*, String*, Cardinal*) ;

static	Boolean	tonTheSpotWindow_putchar		(Widget, const Char) ;
static	Boolean	tonTheSpotWindow_puts			(Widget, const Char*, int) ;
static	void	tonTheSpotWindow_flush			(Widget) ;
static	void	tonTheSpotWindow_clear			(Widget) ;
static	void	tonTheSpotWindow_rev			(Widget, Boolean) ;
static	Boolean	tonTheSpotWindow_rectVariablep	(Widget) ;
static	Boolean	tonTheSpotWindow_haveExternModelinep (Widget) ;
static	Boolean	tonTheSpotWindow_setModeline	(Widget, const Char*, int) ;
static	Boolean	tonTheSpotWindow_autoPopupp		(Widget) ;
static	void	tonTheSpotWindow_setCaret		(Widget) ;
static	void	tonTheSpotWindow_popup			(Widget) ;
static	void	tonTheSpotWindow_popdown		(Widget) ;
static	void	tonTheSpotWindow_updateText		(Widget) ;

static	void*	tonTheSpotWindow_getclient		(Widget) ;
static	int		tonTheSpotWindow_getrect		(Widget, XRectangle*) ;
static	void	tonTheSpotWindow_activate		(Widget, Boolean) ;
static	void*	tonTheSpotWindow_getfontset		(Widget) ;
static	Boolean	tonTheSpotWindow_getlinespacing	(Widget, int*) ;
static	void*	tonTheSpotWindow_getlispframeobject	(Widget) ;
static	void	tonTheSpotWindow_setattribute	(Widget, const TConversionAttribute*) ;
static	Boolean	tonTheSpotWindow_createMinibufferFrame	(Widget) ;

static	XtActionsRec	srOnTheSpotWindowAction []	= {
	{ "onKeyPress",			tonTheSpotWindow_onKeyPress, },
	{ "onKeyRelease",		tonTheSpotWindow_onKeyRelease, },
} ;

static	char			strOnTheSpotWindowTranslation []	= 
"<Key>:                 onKeyPress()\n\
 <KeyRelease>:          onKeyRelease()\n" ;

TOnTheSpotWindowClassRec		tonTheSpotWindowClassRec	= {
    {	/* core fields */
		/* superclass			*/	(WidgetClass) &tframeClassRec,
		/* class_name			*/	"TOnTheSpotWindow",
		/* size					*/	sizeof (TOnTheSpotWindowRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	tonTheSpotWindow_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	tonTheSpotWindow_onRealize,
		/* actions				*/	srOnTheSpotWindowAction,
		/* num_actions			*/	XtNumber (srOnTheSpotWindowAction),
		/* resources			*/	srOnTheSpotWindowResource,
		/* num_resources		*/	XtNumber(srOnTheSpotWindowResource),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	tonTheSpotWindow_onDestroy,
		/* resize				*/	NULL,
		/* expose				*/	NULL,
		/* set_values			*/	tonTheSpotWindow_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table				*/	strOnTheSpotWindowTranslation,
		/* query_geometry		*/	XtInheritQueryGeometry,
		/* display_accelerator	*/	NULL,
		/* extension	  		*/	NULL,
    },
	{	/* Composite			*/
		/* geometry_manager		*/	XtInheritGeometryManager,
		/* change_managed		*/	XtInheritChangeManaged,
		/* insert_child			*/	XtInheritInsertChild,
		/* delete_child			*/	XtInheritDeleteChild,
		/* extension			*/	NULL,
	},
	{	/* Shell				*/
		/* extension			*/	NULL,
	},
	{
		/* getclient			*/	tonTheSpotWindow_getclient,
		/* getlispframeobject	*/	tonTheSpotWindow_getlispframeobject,
		/* setattribute			*/	tonTheSpotWindow_setattribute,
		/* getrect				*/	tonTheSpotWindow_getrect,
		/* activate				*/	tonTheSpotWindow_activate,
		/* getfontset			*/	tonTheSpotWindow_getfontset,
		/* getlinespacing		*/	tonTheSpotWindow_getlinespacing,
		/* puts					*/	tonTheSpotWindow_puts,
		/* putchar				*/	tonTheSpotWindow_putchar,
		/* rev					*/	tonTheSpotWindow_rev,
		/* clear				*/	tonTheSpotWindow_clear,
		/* flush				*/	tonTheSpotWindow_flush,
		/* rectVariablep		*/	tonTheSpotWindow_rectVariablep,
		/* haveExternModelinep	*/	tonTheSpotWindow_haveExternModelinep,
		/* setModeline			*/	tonTheSpotWindow_setModeline,
		/* autoPopupp			*/	tonTheSpotWindow_autoPopupp,
		/* setCaret				*/	tonTheSpotWindow_setCaret,
	},
	{
		/* dummy				*/	0,
	},
} ;

WidgetClass	tonTheSpotWindowWidgetClass	= (WidgetClass) &tonTheSpotWindowClassRec ;

void
tonTheSpotWindow_onInitialize (
	register Widget		wgRequest,
	register Widget		wgNew,
	register ArgList	args,
	register Cardinal*	num_args)
{
	register TOnTheSpotWindowWidget		wgThis = (TOnTheSpotWindowWidget) wgNew ;

	TVarbuffer_Initialize (&wgThis->tonwin.m_rvbufText [0], sizeof (Char)) ;
	TVarbuffer_Initialize (&wgThis->tonwin.m_rvbufText [1], sizeof (Char)) ;
	TVarbuffer_Initialize (&wgThis->tonwin.m_vbufModeline,  sizeof (Char)) ;
	TVarbuffer_Initialize (&wgThis->tonwin.m_vbufAttribute, sizeof (XIMFeedback)) ;
	wgThis->tonwin.m_rnCaret [0]	= 0 ;
	wgThis->tonwin.m_rnCaret [1]	= 0 ;
	wgThis->tonwin.m_nTextPlane		= 0 ;
	wgThis->tonwin.m_fActive		= False ;
	wgThis->tonwin.m_fPreeditActive	= False ;
	wgThis->tonwin.m_wgMinibuf		= 0 ;
	return ;
}

void
tonTheSpotWindow_onRealize (
	register Widget					gw,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	register CoreWidgetClass			super ;

	super	= (CoreWidgetClass) XtClass (gw)->core_class.superclass ;
	(*super->core_class.realize) (gw, pValueMask, pXSWA) ;

	/*	Minibuffer  Realize ˤĤƤϤޤȤ⡣󤷤ˤ롣
	 *	˺Τʤ顢 lisp object ˤɬפ
	 *	ޤ lisp machine Ȥ߹ǡʤ뤫
	 *	
	 */
	tonTheSpotWindow_createMinibufferFrame (gw) ;
	return ;
}

Boolean
tonTheSpotWindow_onSetValues (
	register Widget		curw,
	register Widget		reqw,
	register Widget		neww,
	register ArgList	args,
	register Cardinal*	num_args)
{
	register TOnTheSpotWindowWidget	wgCur	= (TOnTheSpotWindowWidget) curw ;
	register TOnTheSpotWindowWidget	wgReq	= (TOnTheSpotWindowWidget) reqw ;
	register TOnTheSpotWindowWidget	wgNew	= (TOnTheSpotWindowWidget) neww ;

	if (wgReq->tonwin.m_wgMinibuf != wgCur->tonwin.m_wgMinibuf) {
		/*	Minibuffer Frame ѹ뤳ȤϤǤʤ
		 *	Ĥ get only Ǥ롣*/
#if defined (DEBUG)
		fprintf (stderr, "minibuffer frame can't change from (%p) to (%p).\n",
				 wgCur->tonwin.m_wgMinibuf, wgReq->tonwin.m_wgMinibuf) ;
#endif
		wgNew->tonwin.m_wgMinibuf	= wgCur->tonwin.m_wgMinibuf ;
	}
	return	False ;
}

void
tonTheSpotWindow_onDestroy (
	register Widget	gw)
{
	register TOnTheSpotWindowWidget		wgThis	= (TOnTheSpotWindowWidget) gw ;

#if 0
	/*	¿ʬ̤ηϩ˴Ȼפ롣*/
	if (wgThis->tonwin.m_wgMinibuf != NULL) {
		XtDestroyWidget (wgThis->tonwin.m_wgMinibuf) ;
		wgThis->tonwin.m_wgMinibuf	= NULL ;
	}
#endif
	TVarbuffer_Uninitialize (&wgThis->tonwin.m_rvbufText [0]) ;
	TVarbuffer_Uninitialize (&wgThis->tonwin.m_rvbufText [1]) ;
	TVarbuffer_Uninitialize (&wgThis->tonwin.m_vbufModeline) ;
	TVarbuffer_Uninitialize (&wgThis->tonwin.m_vbufAttribute) ;
	return ;
}

void
tonTheSpotWindow_onKeyPress (
	register Widget		gw,
	register XEvent*	pEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	if (!XtIsRealized (gw))
		return ;
	/*	Event Select: None ȡ˸ä KeyEvent ꤲǽ
	 *	롣*/
	XtCallCallbacks (gw, XtNkeyPressCallback, (XtPointer) pEvent) ;
	return ;
 }

void
tonTheSpotWindow_onKeyRelease (
	register Widget		gw,
	register XEvent*	pEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	return ;
}

/*	private functions
 */
void*
tonTheSpotWindow_getclient (
	register Widget	gw)
{
	register TOnTheSpotWindowWidget	wgThis	= (TOnTheSpotWindowWidget) gw ;

	return	wgThis->tframe.m_pClient ;
}

int
tonTheSpotWindow_getrect (
	register Widget			gw,
	register XRectangle*	pRect)
{
	/*	Client ΰ褬¸ߤΤǡ¦Ǥΰʤ
	 */
	return	0 ;
}

void
tonTheSpotWindow_activate (
	register Widget			gw,
	register Boolean		fActivate)
{
	if (!XtIsRealized (gw))
		return ;

	if (fActivate) {
		tonTheSpotWindow_popup (gw) ;
	} else {
		tonTheSpotWindow_popdown (gw) ;
	}
	return ;
}

void*
tonTheSpotWindow_getfontset (
	register Widget			gw)
{
	return	NULL ;
}

Boolean
tonTheSpotWindow_getlinespacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	return	False ;
}

void*
tonTheSpotWindow_getlispframeobject (
	register Widget			gw)
{
	register TOnTheSpotWindowWidget	wgThis	= (TOnTheSpotWindowWidget) gw ;

	return	wgThis->tframe.m_pLispFrameObject ;
}

void
tonTheSpotWindow_setattribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	return ;
}

/*	楳ɤϲԤƤʤʤ̤뤤ɤʤġ
 */
Boolean
tonTheSpotWindow_puts (
	register Widget			gw,
	register const Char*	pText,
	register int			nText)
{
	register TOnTheSpotWindowWidget	wgThis		= (TOnTheSpotWindowWidget) gw ;
	register TVarbuffer*			pvbuf ;

	if (pText == NULL || nText <= 0)
		return	True ;

	pvbuf	= &wgThis->tonwin.m_rvbufText [wgThis->tonwin.m_nTextPlane] ;
	return	TVarbuffer_Add (pvbuf, pText, nText) ;
}

Boolean
tonTheSpotWindow_putchar (
	register Widget			gw,
	const Char				cc)
{
	return	tonTheSpotWindow_puts (gw, &cc, 1) ;
}

void
tonTheSpotWindow_flush (
	register Widget			gw)
{
	register TOnTheSpotWindowWidget	wgThis		= (TOnTheSpotWindowWidget) gw ;

	if (!wgThis->tonwin.m_fActive)
		return ;

	tonTheSpotWindow_updateText (gw) ;
	return ;
}

/*
 */
void
tonTheSpotWindow_clear (
	register Widget			gw)
{
	register TOnTheSpotWindowWidget	wgThis		= (TOnTheSpotWindowWidget) gw ;
	register int					nPlane ;

	nPlane		= wgThis->tonwin.m_nTextPlane ;
	assert (0 <= nPlane && nPlane < 2) ;
	TVarbuffer_Clear (&wgThis->tonwin.m_rvbufText [nPlane]) ;
	wgThis->tonwin.m_rnCaret [nPlane]	= 0 ;
#if 0
	TVarbuffer_Clear (&wgThis->tonwin.m_vbufModeline) ;
#endif
	return ;
}

/*	sorry currently doesn't work well
 */
void
tonTheSpotWindow_rev (
	register Widget			gw,
	register Boolean		fRev)
{
	/*register TOnTheSpotWindowWidget	wgThis		= (TOnTheSpotWindowWidget) gw ;*/
	return ;
}

Boolean
tonTheSpotWindow_rectVariablep (
	register Widget			gw)
{
	return	True ;
}

Boolean
tonTheSpotWindow_haveExternModelinep (
	register Widget			gw)
{
	return	True ;
}

Boolean
tonTheSpotWindow_setModeline (
	register Widget			gw,
	register const Char*	pString,
	register int			nString)
{
	register TOnTheSpotWindowWidget	wgThis		= (TOnTheSpotWindowWidget) gw ;
	register TVarbuffer*			pvbufCur ;
	register const Char*			pCurText ;
	register int					nCurUsage ;

#if defined (DEBUG)
	fprintf (stderr, "tonTheSpotWindow_setModeline (%p, %p, %d)\n",
			 gw, pString, nString) ;
#endif
	if (!wgThis->tonwin.m_fActive)
		return	True ;

	if (wgThis->tonwin.m_lstCbkStatusDraw == NULL ||
		XtHasCallbacks (gw, XtNstatusDrawCallback) != XtCallbackHasSome) 
		return	True ;

	pvbufCur		= &wgThis->tonwin.m_vbufModeline ;
	pCurText		= TVarbuffer_GetBuffer (pvbufCur) ;
	nCurUsage		= TVarbuffer_GetUsage  (pvbufCur) ;
	if (nCurUsage != nString ||
		memcmp (pString, pCurText, sizeof (Char) * nString) != 0) {
		TOnTheSpotDrawArg		arg ;
		arg.m_pText	= pString ;
		arg.m_nText	= nString ;
		XtCallCallbacks (gw, XtNstatusDrawCallback, &arg) ;
	}
	TVarbuffer_Clear (pvbufCur) ;
	if (nString > 0)
		if (TFAILED (TVarbuffer_Add   (pvbufCur, pString, nString)))
			return	False ;
	return	True ;
}

Boolean
tonTheSpotWindow_autoPopupp (
	register Widget		gw)
{
	return	False ;
}

/*	ߤ襫֤ Caret ȤƵ롣
 */
void
tonTheSpotWindow_setCaret (
	register Widget		gw)
{
	register TOnTheSpotWindowWidget	wgThis		= (TOnTheSpotWindowWidget) gw ;
	register int					nPlane ;
	register int*					pnCaret ;
	register TVarbuffer*			pvbuf ;

	nPlane		=  wgThis->tonwin.m_nTextPlane ;
	assert (nPlane == 0 || nPlane == 1) ;
	pvbuf		= &wgThis->tonwin.m_rvbufText [nPlane] ;
	pnCaret		= &wgThis->tonwin.m_rnCaret [nPlane] ;
	*pnCaret	= TVarbuffer_GetUsage (pvbuf) ;
	return ;
}

/*
 *
 */
void
tonTheSpotWindow_popup (
	register Widget			gw)
{
	register TOnTheSpotWindowWidget	wgThis	= (TOnTheSpotWindowWidget) gw ;

	if (wgThis->tonwin.m_fActive) 
		return ;

#if defined (DEBUG) || 0
	fprintf (stderr, "tonTheSpotWindow_popup (%p)\n", gw) ;
#endif

	if (wgThis->tonwin.m_lstCbkPreeditStart != NULL &&
		XtHasCallbacks (gw, XtNpreeditStartCallback) == XtCallbackHasSome &&
		!wgThis->tonwin.m_fPreeditActive) {
		XtCallCallbacks (gw, XtNpreeditStartCallback, 0) ;
		wgThis->tonwin.m_fPreeditActive	= True ;
	}
	if (wgThis->tonwin.m_lstCbkStatusStart != NULL &&
		XtHasCallbacks (gw, XtNstatusStartCallback) == XtCallbackHasSome)
		XtCallCallbacks (gw, XtNstatusStartCallback, 0) ;

	wgThis->tonwin.m_fActive	= True ;
	return ;
}

void
tonTheSpotWindow_popdown (
	register Widget			gw)
{
	register TOnTheSpotWindowWidget	wgThis	= (TOnTheSpotWindowWidget) gw ;
	register TVarbuffer*	pvbuf ;

	if (!wgThis->tonwin.m_fActive) 
		return ;

#if defined (DEBUG) || 0
	fprintf (stderr, "tonTheSpotWindow_popdown (%p)\n", gw) ;
#endif

	tonTheSpotWindow_clear (gw) ;
	tonTheSpotWindow_updateText (gw) ;
	if (wgThis->tonwin.m_lstCbkPreeditDone != NULL &&
		XtHasCallbacks (gw, XtNpreeditDoneCallback) == XtCallbackHasSome &&
		wgThis->tonwin.m_fPreeditActive) {
		XtCallCallbacks (gw, XtNpreeditDoneCallback, 0) ;
		wgThis->tonwin.m_fPreeditActive	= False ;
	}
	if (wgThis->tonwin.m_lstCbkStatusDone != NULL &&
		XtHasCallbacks (gw, XtNstatusDoneCallback) == XtCallbackHasSome) {
		tonTheSpotWindow_setModeline (gw, NULL, 0) ;
		XtCallCallbacks (gw, XtNstatusDoneCallback, 0) ;
	}
	pvbuf		= &wgThis->tonwin.m_vbufModeline ;
	TVarbuffer_Clear (pvbuf) ;

	wgThis->tonwin.m_fActive	= False ;
	return ;
}

void
tonTheSpotWindow_updateText (
	register Widget			gw)
{
	register TOnTheSpotWindowWidget	wgThis		= (TOnTheSpotWindowWidget) gw ;
	register TVarbuffer*	pvbufPrev ;
	register TVarbuffer*	pvbufCur ;
	register const Char*	pPrevText ;
	register const Char*	pCurText ;
	register int	nPrevText, nCurText, nCount, nLast ;
	register int	nModifyStart, nModifyEnd, nCaretCur, nCaretPrev ;
	register const Char*	pPrevPtr ;
	register const Char*	pCurPtr ;
	TOnTheSpotDrawArg		arg ;

	pvbufCur	= &wgThis->tonwin.m_rvbufText [wgThis->tonwin.m_nTextPlane] ;
	pvbufPrev	= &wgThis->tonwin.m_rvbufText [wgThis->tonwin.m_nTextPlane ^ 1] ;
	pCurText	= TVarbuffer_GetBuffer (pvbufCur) ;
	nCurText	= TVarbuffer_GetUsage  (pvbufCur) ;
	pPrevText	= TVarbuffer_GetBuffer (pvbufPrev) ;
	nPrevText	= TVarbuffer_GetUsage  (pvbufPrev) ;

	if (!wgThis->tonwin.m_fPreeditActive) {
		if (nCurText <= 0) {
			wgThis->tonwin.m_nTextPlane	^= 1 ;
			return ;
		}
		if (wgThis->tonwin.m_lstCbkPreeditStart != NULL &&
			XtHasCallbacks (gw, XtNpreeditStartCallback) == XtCallbackHasSome)
			XtCallCallbacks (gw, XtNpreeditStartCallback, 0) ;

		wgThis->tonwin.m_fPreeditActive	= True ;
	}

	/*	ɤǤä O(n) ꤽ顢Ǥ롣()
	 */
	if (nCurText < nPrevText) {
		nLast		= nCurText ;
		nModifyEnd	= nPrevText ;
	} else if (nCurText > nPrevText) {
		nLast		= nPrevText ;
		nModifyEnd	= nPrevText ;
	} else {
		nLast		= nCurText ;
		nModifyEnd	= nCurText ;
	}
	pCurPtr		= pCurText ;
	pPrevPtr	= pPrevText ;
	nCount		= nLast ;
	while (nCount -- > 0 && *pCurPtr == *pPrevPtr) {
		pCurPtr		++ ;
		pPrevPtr	++ ;
	}
	nModifyStart	= pCurPtr - pCurText ;

	nCaretCur		= wgThis->tonwin.m_rnCaret [wgThis->tonwin.m_nTextPlane] ;
	nCaretPrev		= wgThis->tonwin.m_rnCaret [wgThis->tonwin.m_nTextPlane ^ 1] ;
	if (nCaretCur != nCaretPrev) {
		register int	nCaretModify ;

		nCaretModify	= (nCaretCur < nCaretPrev)? nCaretCur : nCaretPrev ;
		if (nModifyStart > nCaretModify)
			nModifyStart	= nCaretModify ;
	}

	if (wgThis->tonwin.m_lstCbkPreeditDraw != NULL &&
		XtHasCallbacks (gw, XtNpreeditDrawCallback) == XtCallbackHasSome) {
		static	XIMFeedback	rFeedbacks [2]	= { XIMUnderline, XIMReverse, } ;
		register int	i ;

		TVarbuffer_Clear (&wgThis->tonwin.m_vbufAttribute) ;
		for (i = nModifyStart ; i < nCurText ; i ++) {
			if (nCaretCur == i) {
				TVarbuffer_Add (&wgThis->tonwin.m_vbufAttribute, rFeedbacks + 1, 1) ;
			} else {
				TVarbuffer_Add (&wgThis->tonwin.m_vbufAttribute, rFeedbacks, 1) ;
			}
		}
		TVarbuffer_Add (&wgThis->tonwin.m_vbufAttribute, rFeedbacks, 1) ;

		arg.m_nCaret		= nCurText ;
		
		/*	PreeditDraw Callback λϤ String  ChgFirst 
		 *	ChgLength ʬΡѹ줿 display  stringפ
		 *	ΤȤѹƤʤʬޤ᤿ display 
		 *	stringפʤΤʬʤ
		 *
		 *	򤹤ˡϡľפȡ
		 *()
		 *	KDE3.0 Ǥϡѹ줿ʬפ Text 褦
		 *	Ƥ롣
		 */
		arg.m_nChgFirst		= nModifyStart ;
		arg.m_nChgLength	= nModifyEnd - nModifyStart ;
		arg.m_pText			= pCurText + nModifyStart ;
		arg.m_nText			= nCurText - nModifyStart ;

		arg.m_pAttribute	= TVarbuffer_GetBuffer (&wgThis->tonwin.m_vbufAttribute) ;
		arg.m_nAttribute	= TVarbuffer_GetUsage  (&wgThis->tonwin.m_vbufAttribute) ;
#if defined (DEBUG) || 0
		fprintf (stderr, "Caret(%d/%d), Modify(%d), Length(%d), Text(%d)\n",
				 nCaretCur, nCaretPrev, nModifyStart, nModifyEnd - nModifyStart, nCurText) ;
#endif
		XtCallCallbacks (gw, XtNpreeditDrawCallback, &arg) ;
	}
	/*	ԽƥȤ̵ʤä顢 Done ɤ*/
	if (nCurText <= 0) {
		if (wgThis->tonwin.m_lstCbkPreeditDone != NULL &&
			XtHasCallbacks (gw, XtNpreeditDoneCallback) == XtCallbackHasSome)
			XtCallCallbacks (gw, XtNpreeditDoneCallback, 0) ;

		wgThis->tonwin.m_fPreeditActive	= False ;
	}
	wgThis->tonwin.m_nTextPlane	^= 1 ;
	return ;
}

Boolean
tonTheSpotWindow_createMinibufferFrame (
	register Widget			gw)
{
	register TOnTheSpotWindowWidget	wgThis	= (TOnTheSpotWindowWidget) gw ;
	register Widget	wgMinibufFrame ;
	Boolean			fInput ;
	Window			wndClient ;
	Arg				rArg [12] ;
	register int	nArg ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg],	XtNinput,			&fInput) ;	nArg ++ ;
	XtSetArg (rArg [nArg],	XtNclientWindow,	&wndClient) ;	nArg ++ ;
	XtGetValues (gw, rArg, nArg) ;

	/*	Ϥø RootWindowStyle Ǥä Minibuffer  Emulation
	 *	Ԥ
	 */
	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged,	False) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNinput,				fInput) ;	nArg ++ ;	
	XtSetArg (rArg [nArg], XtNautoPopup,	True) ;		nArg ++ ;	
	XtSetArg (rArg [nArg], XtNheight,		1) ;		nArg ++ ;
	XtSetArg (rArg [nArg], XtNclientWindow,	wndClient) ;	nArg ++ ;
	wgMinibufFrame	= TRootWindowFrame_Create (XtParent (gw), rArg, nArg) ;
	if (wgMinibufFrame == NULL)
		return	False ;
	wgThis->tonwin.m_wgMinibuf	= wgMinibufFrame ;
	return	True ;
}

Widget
TOnTheSpotWindowFrame_Create (
	register Widget			wgParent,
	register ArgList		arglist,
	register Cardinal		nArglist)
{
	return	XtCreateWidget ("TOnTheSpotWindow", tonTheSpotWindowWidgetClass, wgParent, arglist, nArglist) ;
}

