/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include "TOffTheSpotWindowP.h"
#include "TRootWindow.h"
#include "TSubWindowFrame.h"
#include "TTerminal.h"
#include "TConvAttr.h"
#include "dispatch.h"
#include "ttext.h"

#if !defined (DEFAULT_FONTSET)
#define	DEFAULT_FONTSET	"-*--12-*"
#endif
#if !defined (DEFAULT_FONTHEIGHT)
#define	DEFAULT_FONTHEIGHT	12
#endif

#define offset(field)	XtOffsetOf(TOffTheSpotWindowRec, toffwin.field)
#define soffset(field)	XtOffsetOf(ShellWidgetRec, shell.field)
#define goffset(field)	XtOffsetOf(WidgetRec, core.field )

static	XtResource	srOffTheSpotWindowResource []	= {
	{	XtNwidth,					XtCWidth,
		XtRDimension,				sizeof (Dimension),
		goffset (width),			XtRImmediate,		(XtPointer) 640, },
	{	XtNheight,					XtCHeight,
		XtRDimension,				sizeof (Dimension),
		goffset (height),			XtRImmediate,		(XtPointer) 48, },
	{	XtNbackground,				XtCBackground,
		XtRPixel,					sizeof (Pixel),
		goffset (background_pixel),	XtRString,			XtDefaultBackground, },
	{	XtNforeground,				XtCForeground,
		XtRPixel,					sizeof (Pixel),
		offset (m_pxlForeground),	XtRString,			XtDefaultForeground, },
#if 0
	{	XtNreverseVideo,			XtCReverseVideo,
		XtRBoolean,					sizeof (Boolean),
		offset (m_fReverseVideo),	XtRImmediate,		(XtPointer) False, },
#endif
	/*	ͤȤƤΤѤ default  fontset ̾*/
	{	XtNfontSet,					XtCFontSet,
		XtRString,					sizeof (String),
		offset (m_strFontSet),		XtRImmediate,		(XtPointer) DEFAULT_FONTSET, },
	{	XtNclientWindow,			XtCClientWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndClient),		XtRImmediate,		(XtPointer) None, },
	{	XtNfocusWindow,				XtCFocusWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndFocus),		XtRImmediate,		(XtPointer) None, },
	{	XtNminibufFrame,			XtCMinibufFrame,
		XtRWidget,					sizeof (Widget),
		offset (m_wgMinibuf),		XtRWidget,			NULL, },
} ;

#undef	offset
#undef	goffset

static	void	toffTheSpotWindow_onInitialize	(Widget, Widget, ArgList, Cardinal*) ;
static	void	toffTheSpotWindow_onRealize		(Widget, XtValueMask*, XSetWindowAttributes*) ;
static	Boolean	toffTheSpotWindow_onSetValues	(Widget, Widget, Widget, ArgList, Cardinal*) ;
static	void	toffTheSpotWindow_onDestroy		(Widget) ;
static	void	toffTheSpotWindow_onKeyPress	(Widget, XEvent*, String*, Cardinal*) ;
static	void	toffTheSpotWindow_onKeyRelease	(Widget, XEvent*, String*, Cardinal*) ;
static	int		toffTheSpotWindow_onFocusResize	(void*, XEvent*) ;

static	int		toffTheSpotWindow_onModeshellExpose		(void*, XEvent*) ;
static	int		toffTheSpotWindow_onModeshellDestroy	(void*, XEvent*) ;
static	int		toffTheSpotWindow_onSubwindowKeyPress	(void*, XEvent*) ;
static	int		toffTheSpotWindow_onSubwindowKeyRelease	(void*, XEvent*) ;

static	Boolean	toffTheSpotWindow_putchar		(Widget, const Char) ;
static	Boolean	toffTheSpotWindow_puts			(Widget, const Char*, int) ;
static	void	toffTheSpotWindow_flush			(Widget) ;
static	void	toffTheSpotWindow_clear			(Widget) ;
static	void	toffTheSpotWindow_rev			(Widget, Boolean) ;
static	Boolean	toffTheSpotWindow_rectVariablep	(Widget) ;
static	Boolean	toffTheSpotWindow_haveExternModelinep (Widget) ;
static	Boolean	toffTheSpotWindow_setModeline	(Widget, const Char*, int) ;
static	Boolean	toffTheSpotWindow_autoPopupp	(Widget) ;

static	void*	toffTheSpotWindow_getclient	(Widget) ;
static	int		toffTheSpotWindow_getrect		(Widget, XRectangle*) ;
static	void	toffTheSpotWindow_activate		(Widget, Boolean) ;
static	void*	toffTheSpotWindow_getfontset	(Widget) ;
static	Boolean	toffTheSpotWindow_getlinespacing	(Widget, int*) ;
static	void*	toffTheSpotWindow_getlispframeobject	(Widget) ;
static	void	toffTheSpotWindow_setattribute	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetAttributeFocusWindow	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetPreeditAttribute		(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetPAttributeSpotLocation	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetPAttributeClientArea	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetPAttributeFont			(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetPAttributeLineSpacing	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetPAttributeColormap		(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetPAttributeBackground	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetPAttributeForeground	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetStatusAttribute			(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetSAttributeClientArea	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetSAttributeFont			(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetSAttributeLineSpacing	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetSAttributeColormap		(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetSAttributeBackground	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_onSetSAttributeForeground	(Widget, const TConversionAttribute*) ;
static	Boolean	toffTheSpotWindow_getPreeditLineSpacing	(Widget, int*) ;

static	unsigned long	toffTheSpotWindow_getStatusWindowAttribute	(Widget, XSetWindowAttributes*) ;
static	Boolean	toffTheSpotWindow_createTerminalWindow	(Widget) ;
static	Boolean	toffTheSpotWindow_createModeshellWindow	(Widget) ;
static	Boolean	toffTheSpotWindow_createMinibufferFrame	(Widget) ;

static	int		toffTheSpotWindow_configureFocusOffset	(Widget) ;
static	void	toffTheSpotWindow_resizeModeshellWindow	(Widget) ;
static	void	toffTheSpotWindow_popup				(Widget) ;
static	void	toffTheSpotWindow_popdown				(Widget) ;

extern void	XGetRectangleOfWindow	(Display*, Window, XRectangle*) ;

static	XtActionsRec	srOffTheSpotWindowAction []	= {
	{ "onKeyPress",			toffTheSpotWindow_onKeyPress, },
	{ "onKeyRelease",		toffTheSpotWindow_onKeyRelease, },
} ;

static	char			strOffTheSpotWindowTranslation []	= 
"<Key>:                 onKeyPress()\n\
 <KeyRelease>:          onKeyRelease()\n" ;

TOffTheSpotWindowClassRec		toffTheSpotWindowClassRec	= {
    {	/* core fields */
		/* superclass			*/	(WidgetClass) &tframeClassRec,
		/* class_name			*/	"TOffTheSpotWindow",
		/* size					*/	sizeof (TOffTheSpotWindowRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	toffTheSpotWindow_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	toffTheSpotWindow_onRealize,
		/* actions				*/	srOffTheSpotWindowAction,
		/* num_actions			*/	XtNumber (srOffTheSpotWindowAction),
		/* resources			*/	srOffTheSpotWindowResource,
		/* num_resources		*/	XtNumber(srOffTheSpotWindowResource),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	toffTheSpotWindow_onDestroy,
		/* resize				*/	NULL,
		/* expose				*/	NULL,
		/* set_values			*/	toffTheSpotWindow_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table				*/	strOffTheSpotWindowTranslation,
		/* query_geometry		*/	XtInheritQueryGeometry,
		/* display_accelerator	*/	NULL,
		/* extension	  		*/	NULL,
    },
	{	/* Composite			*/
		/* geometry_manager		*/	XtInheritGeometryManager,
		/* change_managed		*/	XtInheritChangeManaged,
		/* insert_child			*/	XtInheritInsertChild,
		/* delete_child			*/	XtInheritDeleteChild,
		/* extension			*/	NULL,
	},
	{	/* Shell				*/
		/* extension			*/	NULL,
	},
	{
		/* getclient			*/	toffTheSpotWindow_getclient,
		/* getlispframeobject	*/	toffTheSpotWindow_getlispframeobject,
		/* setattribute			*/	toffTheSpotWindow_setattribute,
		/* getrect				*/	toffTheSpotWindow_getrect,
		/* activate				*/	toffTheSpotWindow_activate,
		/* getfontset			*/	toffTheSpotWindow_getfontset,
		/* getlinespacing		*/	toffTheSpotWindow_getlinespacing,
		/* puts					*/	toffTheSpotWindow_puts,
		/* putchar				*/	toffTheSpotWindow_putchar,
		/* rev					*/	toffTheSpotWindow_rev,
		/* clear				*/	toffTheSpotWindow_clear,
		/* flush				*/	toffTheSpotWindow_flush,
		/* rectVariablep		*/	toffTheSpotWindow_rectVariablep,
		/* haveExternModelinep	*/	toffTheSpotWindow_haveExternModelinep,
		/* setModeline			*/	toffTheSpotWindow_setModeline,
		/* autoPopupp			*/	toffTheSpotWindow_autoPopupp,
		/* setCaret				*/	NULL,
	},
	{
		/* dummy				*/	0,
	},
} ;

WidgetClass	toffTheSpotWindowWidgetClass	= (WidgetClass) &toffTheSpotWindowClassRec ;

void
toffTheSpotWindow_onInitialize (
	register Widget		wgRequest,
	register Widget		wgNew,
	register ArgList	args,
	register Cardinal*	num_args)
{
	register TOffTheSpotWindowWidget	wgThis = (TOffTheSpotWindowWidget) wgNew ;
	register const char*	strFontSet ;

	TConvAttr_Initialize (&wgThis->toffwin.m_caInitial) ;
	TConvAttr_Initialize (&wgThis->toffwin.m_caCurrent) ;

	wgThis->toffwin.m_ptFocus.x		= wgThis->toffwin.m_ptFocus.y	= 0 ;
	wgThis->toffwin.m_ptClient.x	= wgThis->toffwin.m_ptClient.y	= 0 ;

	/*	default  fontset ǽ롣ݤʤΤ -*--12-* Ǥ䡣*/
	TFontSet_Initialize (&wgThis->toffwin.m_fsTerminal) ;
	TFontSet_Initialize (&wgThis->toffwin.m_fsMinibuf) ;
	strFontSet	= wgThis->toffwin.m_strFontSet ;
	TFontSet_Load (XtDisplay (wgNew), &wgThis->toffwin.m_fsTerminal, strFontSet, False) ;
	TFontSet_Load (XtDisplay (wgNew), &wgThis->toffwin.m_fsMinibuf,  strFontSet, False) ;

	wgThis->toffwin.m_wgTerminal		= 0 ;
	wgThis->toffwin.m_wgMinibuf			= 0 ;
	TVarbuffer_Initialize (&wgThis->toffwin.m_vbufModeshellText, sizeof (Char)) ;
	wgThis->toffwin.m_wndModeshell		= None ;
	wgThis->toffwin.m_gcModeshell		= None ;
	wgThis->toffwin.m_fActive			= False ;
	wgThis->toffwin.m_szModeshell.cx	= 0 ;
	wgThis->toffwin.m_szModeshell.cy	= 0 ;

	/*	 m_fDestroy ϼʬȤ XtDestroyWidget ǤϤʤ
	 *	̤γŪװˤäԲǽˤʤäƤ뤳Ȥ̣롣
	 */
	wgThis->toffwin.m_fDestroy			= False ;
	return ;
}

void
toffTheSpotWindow_onRealize (
	register Widget					gw,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register CoreWidgetClass			super ;
	register Display*					pDisplay	= XtDisplay (gw) ;

	super	= (CoreWidgetClass) XtClass (gw)->core_class.superclass ;
	(*super->core_class.realize) (gw, pValueMask, pXSWA) ;

	if (wgThis->toffwin.m_wndClient == None) {
		XtDestroyWidget (gw) ;
		return ;
	}
	/*	ʳޤǤͤȤ¸롣ʹߤ current Τѹ롣*/
	TConvAttr_Copy (&wgThis->toffwin.m_caInitial, &wgThis->toffwin.m_caCurrent) ;

	/*	Focus Window ꤵƤ뤫ɤǧ롣ƤʤСClient Window
	 *	 Focus Window ȤѤ롣*/
	if (wgThis->toffwin.m_wndFocus == None) 
		wgThis->toffwin.m_wndFocus	= wgThis->toffwin.m_wndClient ;
	if (!IS_CONVATTR_MASK (wgThis->toffwin.m_caCurrent, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (wgThis->toffwin.m_caCurrent, CAClientArea)) {
		XRectangle	rect ;

		SET_CONVATTR_MASK (wgThis->toffwin.m_caCurrent, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (wgThis->toffwin.m_caCurrent, CAClientArea) ;
		XGetRectangleOfWindow (pDisplay, wgThis->toffwin.m_wndFocus, &rect) ;
		CONVATTR_PREEDIT_CLIENTAREA (wgThis->toffwin.m_caCurrent)	= rect ;
	}
	/*	FocusWindow  Resize ƻ뤹롣 Preedit  CAClientArea 
	 *	ꤷʤ Client кǤ롣*/
	AfxRegisterWindow (pDisplay, wgThis->toffwin.m_wndFocus, ConfigureNotify, StructureNotifyMask, gw, toffTheSpotWindow_onFocusResize) ;

	if (!toffTheSpotWindow_createTerminalWindow (gw) ||
		!toffTheSpotWindow_createModeshellWindow (gw)) {
		XtDestroyWidget (gw) ;
		return ;
	}

	/*	Modeshell 礭ɽʸԤ
	 */
	toffTheSpotWindow_configureFocusOffset (gw) ;
	toffTheSpotWindow_resizeModeshellWindow (gw) ;

	/*	Minibuffer  Realize ˤĤƤϤޤȤ⡣󤷤ˤ롣
	 *	˺Τʤ顢 lisp object ˤɬפ
	 *	ޤ lisp machine Ȥ߹ǡʤ뤫
	 *	
	 */
	toffTheSpotWindow_createMinibufferFrame (gw) ;

	if (!XtIsRealized (wgThis->toffwin.m_wgTerminal))
		XtRealizeWidget (wgThis->toffwin.m_wgTerminal) ;
	return ;
}

Boolean
toffTheSpotWindow_onSetValues (
	register Widget		curw,
	register Widget		reqw,
	register Widget		neww,
	register ArgList	args,
	register Cardinal*	num_args)
{
	register TOffTheSpotWindowWidget	wgCur	= (TOffTheSpotWindowWidget) curw ;
	register TOffTheSpotWindowWidget	wgReq	= (TOffTheSpotWindowWidget) reqw ;
	register TOffTheSpotWindowWidget	wgNew	= (TOffTheSpotWindowWidget) neww ;

	if (wgReq->toffwin.m_wgMinibuf != wgCur->toffwin.m_wgMinibuf) {
		/*	Minibuffer Frame ѹ뤳ȤϤǤʤ
		 *	Ĥ get only Ǥ롣*/
#if defined (DEBUG)
		fprintf (stderr, "minibuffer frame can't change from (%p) to (%p).\n",
				 wgCur->toffwin.m_wgMinibuf, wgReq->toffwin.m_wgMinibuf) ;
#endif
		wgNew->toffwin.m_wgMinibuf	= wgCur->toffwin.m_wgMinibuf ;
	}
	return	False ;
}

void
toffTheSpotWindow_onDestroy (
	register Widget	gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register Display*	pDisplay ;
	register Window		wndModeshell, wndFocus ;

	pDisplay	= XtDisplay (gw) ;
	XFreeGC (pDisplay, wgThis->toffwin.m_gcModeshell) ;
	wgThis->toffwin.m_gcModeshell	= None ;

	wndModeshell	= wgThis->toffwin.m_wndModeshell ;
	if (wndModeshell != None) {
		AfxUnregisterWindow (wndModeshell, Expose, ExposureMask, gw, toffTheSpotWindow_onModeshellExpose) ;
		AfxUnregisterWindow (wndModeshell, DestroyNotify, StructureNotifyMask, gw, toffTheSpotWindow_onModeshellDestroy) ;
		AfxUnregisterWindow (wndModeshell, KeyPress, KeyPressMask, gw, toffTheSpotWindow_onSubwindowKeyPress) ;
		AfxUnregisterWindow (wndModeshell, KeyRelease, KeyReleaseMask, gw, toffTheSpotWindow_onSubwindowKeyRelease) ;
		/*	 destroy  XErrorEvent ǽ⤤*/
		if (!wgThis->toffwin.m_fDestroy)
			XDestroyWindow (pDisplay, wndModeshell) ;
		wgThis->toffwin.m_wndModeshell	= None ;
	}
	wndFocus		= wgThis->toffwin.m_wndFocus ;
	if (wndFocus != None) {
		AfxUnregisterWindow (wndFocus, ConfigureNotify, StructureNotifyMask, wgThis, toffTheSpotWindow_onFocusResize) ;
		wgThis->toffwin.m_wndFocus	= None ;
	}

	TFontSet_Destroy (&wgThis->toffwin.m_fsTerminal) ;
	TFontSet_Destroy (&wgThis->toffwin.m_fsMinibuf) ;
	TVarbuffer_Uninitialize (&wgThis->toffwin.m_vbufModeshellText) ;

	TConvAttr_Uninitialize (&wgThis->toffwin.m_caInitial) ;
	TConvAttr_Uninitialize (&wgThis->toffwin.m_caCurrent) ;
	return ;
}

void
toffTheSpotWindow_onKeyPress (
	register Widget		gw,
	register XEvent*	pEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	if (!XtIsRealized (gw))
		return ;
	/*	Event Select: None ȡ˸ä KeyEvent ꤲǽ
	 *	롣*/
	XtCallCallbacks (gw, XtNkeyPressCallback, (XtPointer) pEvent) ;
	return ;
 }

void
toffTheSpotWindow_onKeyRelease (
	register Widget		gw,
	register XEvent*	pEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	return ;
}

/*	Focus Ƥ Window  Resize Event 򽦤⤷Client Area 
 *	󤬡Ѵ client ˤäͿ줿ΤǤʤС resize ξ
 *	äƺľ
 */
int
toffTheSpotWindow_onFocusResize (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) pClosure ;
	register TConversionAttribute*		pCurAttr ;

	assert (pClosure != NULL) ;
	assert (pEvent   != NULL) ;

	if (!XtIsRealized ((Widget)wgThis))
		return	0 ;
	if (IS_CONVATTR_MASK (wgThis->toffwin.m_caInitial, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (wgThis->toffwin.m_caInitial, CAClientArea))
		return	0 ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	pCurAttr->m_Preedit.m_area.x		= pEvent->xconfigure.x ;
	pCurAttr->m_Preedit.m_area.y		= pEvent->xconfigure.y ;
	pCurAttr->m_Preedit.m_area.width	= pEvent->xconfigure.width ;
	pCurAttr->m_Preedit.m_area.height	= pEvent->xconfigure.height ;
	SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
	SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea) ;
	return	0 ;
}

int
toffTheSpotWindow_onModeshellExpose (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) pClosure ;
	register Display*		pDisplay ;
	register Window			window ;
	register GC				gc ;
	register TFontSet*		pFontSet ;
	register int			y ;
	register Pixel			pxlForeground, pxlBackground ;
	register const Char*	pString ;
	register int			nString ;

	pString		= TVarbuffer_GetBuffer (&wgThis->toffwin.m_vbufModeshellText) ;
	nString		= TVarbuffer_GetUsage  (&wgThis->toffwin.m_vbufModeshellText) ;
	window		= wgThis->toffwin.m_wndModeshell ;
	if (window == None || nString <= 0)
		return	0 ;

	pDisplay	= XtDisplay ((Widget)wgThis) ;
	pFontSet	= &wgThis->toffwin.m_fsMinibuf ;
	gc			= wgThis->toffwin.m_gcModeshell ;
	y			= TFontSet_GetAscent (pFontSet) ;

	pxlForeground	= wgThis->toffwin.m_pxlForeground ;
	pxlBackground	= wgThis->core.background_pixel ;
	if (IS_CONVATTR_MASK (wgThis->toffwin.m_caCurrent, CAStatusMask)) { 
		if (IS_CONVATTR_STATUS_MASK (wgThis->toffwin.m_caCurrent, CAForegroundPixel)) 
			pxlForeground	= CONVATTR_STATUS_FOREGROUND (wgThis->toffwin.m_caCurrent) ;
		if (IS_CONVATTR_STATUS_MASK (wgThis->toffwin.m_caCurrent, CABackgroundPixel)) 
			pxlBackground	= CONVATTR_STATUS_BACKGROUND (wgThis->toffwin.m_caCurrent) ;
	}
	XSetBackground (pDisplay, gc, pxlBackground) ;
	XSetForeground (pDisplay, gc, pxlForeground) ;
	TTextOut (pDisplay, window, gc, pFontSet, 0, y, pString, nString, NULL) ;
	return	0 ;
}

int
toffTheSpotWindow_onModeshellDestroy (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) pClosure ;
	register Window	window ;

	/*	Destroy Фִ֤ KinputClient  entry 
	 *	Ƥ Window 줿ʳ Widget ϾäʤФ
	 *	ʤ
	 */
	window	= pEvent->xany.window ;
	if (wgThis->toffwin.m_wndModeshell != window)
		return	0 ;
	AfxUnregisterWindow (window, Expose, ExposureMask, pClosure, toffTheSpotWindow_onModeshellExpose) ;
	AfxUnregisterWindow (window, DestroyNotify, StructureNotifyMask, pClosure, toffTheSpotWindow_onModeshellDestroy) ;
	AfxUnregisterWindow (window, KeyPress, KeyPressMask, pClosure, toffTheSpotWindow_onSubwindowKeyPress) ;
	AfxUnregisterWindow (window, KeyRelease, KeyReleaseMask, pClosure, toffTheSpotWindow_onSubwindowKeyRelease) ;
	wgThis->toffwin.m_wndModeshell	= None ;

	if (!wgThis->toffwin.m_fDestroy) {
		XtCallCallbacks ((Widget)wgThis, XtNdestroyCallback, (XtPointer) 0) ;
		wgThis->toffwin.m_fDestroy	= True ;
	}
	return	0 ;
}

int
toffTheSpotWindow_onSubwindowKeyPress (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register Widget	gw	= (Widget) pClosure ;

	XtCallCallbacks (gw, XtNkeyPressCallback, (XtPointer) pEvent) ;
	return	0 ;
}

int
toffTheSpotWindow_onSubwindowKeyRelease (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	return	0 ;
}

/*	private functions
 */
void*
toffTheSpotWindow_getclient (
	register Widget	gw)
{
	TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	
	return	wgThis->tframe.m_pClient ;
}

int
toffTheSpotWindow_getrect (
	register Widget			gw,
	register XRectangle*	pRect)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register XRectangle*	pCurRect ;

	if (pRect == NULL)
		return	1 ;

	pCurRect		= &CONVATTR_PREEDIT_CLIENTAREA (wgThis->toffwin.m_caCurrent) ;
	pRect->x		= 0 ;
	pRect->y		= 0 ;
	pRect->width	= pCurRect->width ;
	pRect->height	= pCurRect->height ;
	return	1 ;
}

void
toffTheSpotWindow_activate (
	register Widget			gw,
	register Boolean		fActivate)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;

	if (!XtIsRealized (gw) || wgThis->toffwin.m_fDestroy)
		return ;

	if (fActivate) {
		toffTheSpotWindow_popup (gw) ;
	} else {
		toffTheSpotWindow_popdown (gw) ;
	}
	return ;
}

void*
toffTheSpotWindow_getfontset (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register Widget						wgTerminal ;

	wgTerminal	= wgThis->toffwin.m_wgTerminal ;
	assert (wgTerminal != NULL) ;
	return	TFrame_GetFontSet (wgTerminal) ;
}

Boolean
toffTheSpotWindow_getlinespacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register Widget						wgTerminal ;

	wgTerminal	= wgThis->toffwin.m_wgTerminal ;
	if (wgTerminal != NULL)
		return	TFrame_GetLineSpacing (wgTerminal, pnLineSpacing) ;

	return	toffTheSpotWindow_getPreeditLineSpacing (gw, pnLineSpacing) ;
}

void*
toffTheSpotWindow_getlispframeobject (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;

	return	wgThis->tframe.m_pLispFrameObject ;
}

void
toffTheSpotWindow_setattribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	static Boolean	(*rpSetAttrProcTbl[])(Widget, const TConversionAttribute*) = {
		toffTheSpotWindow_onSetAttributeFocusWindow,
		toffTheSpotWindow_onSetPreeditAttribute,
		toffTheSpotWindow_onSetStatusAttribute,
	} ;
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register int			i ;
	register unsigned int	uMask ;
	register Boolean		fReconf ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	if (wgThis->toffwin.m_fDestroy)
		return ;

	uMask	= 1 << CAFocusWindowBit ;
	fReconf	= False ;
	for (i = 0 ; i <= (CAStatusMaskBit - CAFocusWindowBit) ; i ++) {
		if (IS_CONVATTR_MASK (*pAttribute, uMask)) 
			fReconf	= (rpSetAttrProcTbl [i])(gw, pAttribute) | fReconf ;
		uMask	= uMask << 1 ;
	}
	if (XtIsRealized (gw) && fReconf) {
		/*	ľ*/
		toffTheSpotWindow_configureFocusOffset (gw) ;
	}
	return ;
}

Boolean
toffTheSpotWindow_onSetAttributeFocusWindow (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register Display*				pDisplay ;
	register TConversionAttribute*	pCurAttr ;
	register Window					wndNewFocus, wndOldFocus ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;
	assert ((pAttribute->m_uMask & CAFocusWindow) != 0) ;

	wndNewFocus	= CONVATTR_FOCUSWINDOW (*pAttribute) ; 
	pDisplay	= XtDisplay (gw) ;
#if defined (DEBUG)
	fprintf (stderr, "FocusWindow: (%lx)\n", wndNewFocus) ;
#endif
	if (!XtIsRealized (gw)) {
		SET_CONVATTR_PREEDIT_MASK (wgThis->toffwin.m_caCurrent, CAFocusWindow) ;
		CONVATTR_FOCUSWINDOW (wgThis->toffwin.m_caCurrent) = wndNewFocus ;
		return	False ;
	}
	if (IS_CONVATTR_MASK (wgThis->toffwin.m_caCurrent, CAFocusWindow))
		return	False ;
	wndOldFocus	= CONVATTR_FOCUSWINDOW (wgThis->toffwin.m_caCurrent) ;
	if (wndOldFocus == wndNewFocus) 
		return	False ;

	CONVATTR_FOCUSWINDOW (wgThis->toffwin.m_caCurrent) = wndNewFocus ;
	wgThis->toffwin.m_wndFocus	= wndNewFocus ;

	/*	Realize Ƥ֤Ǥ Focus Window ѹ CAClientArea 
	 *	ǤȽǤ롣
	 */
	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
	SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea) ;
	XGetRectangleOfWindow (pDisplay, wndNewFocus, &CONVATTR_PREEDIT_CLIENTAREA (*pCurAttr)) ;

	/*	Focus Window  Resize δƻ³롣*/
	if (wndOldFocus != None)
		AfxUnregisterWindow (wndOldFocus, ConfigureNotify, StructureNotifyMask, wgThis, toffTheSpotWindow_onFocusResize) ;
	if (wndNewFocus != None)
		AfxRegisterWindow (pDisplay, wndNewFocus, ConfigureNotify, StructureNotifyMask, wgThis, toffTheSpotWindow_onFocusResize) ;
	return	True ;
}

Boolean
toffTheSpotWindow_onSetPreeditAttribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register unsigned int	uMask ;
	register int			i ;
	register Boolean		fRetval ;
	static Boolean	(*rpSetPAttrProcTbl[])(Widget, const TConversionAttribute*) = {
		toffTheSpotWindow_onSetPAttributeSpotLocation,
		toffTheSpotWindow_onSetPAttributeClientArea,
		toffTheSpotWindow_onSetPAttributeFont,
		toffTheSpotWindow_onSetPAttributeLineSpacing,
		toffTheSpotWindow_onSetPAttributeColormap,
		toffTheSpotWindow_onSetPAttributeForeground,
		toffTheSpotWindow_onSetPAttributeBackground,
	} ;

	uMask	= 1 << CASpotLocationBit ;
	i		= 0 ;
	fRetval	= False ;
	while (i <= (CABackgroundPixelBit - CASpotLocationBit)) {
		if (IS_CONVATTR_PREEDIT_MASK (*pAttribute, uMask))
			fRetval	= (rpSetPAttrProcTbl [i])(gw, pAttribute) || fRetval ;
		uMask	= uMask << 1 ;
		i	++ ;
	}
	return	fRetval ;
}

Boolean
toffTheSpotWindow_onSetPAttributeSpotLocation (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	/*	OffTheSpot Window Style  SpotLocation Ϥʤ*/
	return	False ;
}

Boolean
toffTheSpotWindow_onSetPAttributeClientArea (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Boolean				fRetval	= False ;
	register XRectangle*			pCurArea ;
	register const XRectangle*		pNewArea ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

#if defined (DEBUG)
	fprintf (stderr, "ClientArea: (%d, %d, %d, %d)\n", 
			 pAttribute->m_Preedit.m_area.x,
			 pAttribute->m_Preedit.m_area.y,
			 pAttribute->m_Preedit.m_area.width,
			 pAttribute->m_Preedit.m_area.height) ;
#endif
	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	pCurArea	= &CONVATTR_PREEDIT_CLIENTAREA (*pCurAttr) ;
	pNewArea	= &CONVATTR_PREEDIT_CLIENTAREA (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea)) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea) ;
		memcpy (pCurArea, pNewArea, sizeof (XRectangle)) ;
		fRetval	= True ;
	} else {
		if (pCurArea->x      != pNewArea->x     ||
			pCurArea->y      != pNewArea->y     ||
			pCurArea->width  != pNewArea->width ||
			pCurArea->height != pNewArea->height) {
			memcpy (pCurArea, pNewArea, sizeof (XRectangle)) ;
			fRetval	= True ;
		}
	}
	/*	SubFrame  Resize ɬפˤʤ롣*/
	if (fRetval && wgThis->toffwin.m_wgTerminal != NULL) {
		TConversionAttribute				ca ;

		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CAClientArea) ;
		memcpy (&CONVATTR_PREEDIT_CLIENTAREA(ca), pNewArea, sizeof (XRectangle)) ;
		TFrame_SetAttribute (wgThis->toffwin.m_wgTerminal, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	fRetval ;
}

Boolean
toffTheSpotWindow_onSetPAttributeFont (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register const TFontSet*			pNewFontSet ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

#if defined (DEBUG)
	fprintf (stderr, "toffTheSpotWindow_onSetPAttributeFont ()\n") ;
#endif
	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAFont)) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAFont) ;
	}
	pNewFontSet	= &CONVATTR_PREEDIT_FONTSET(*pAttribute) ;
	TFontSet_Copy  (&CONVATTR_PREEDIT_FONTSET (*pCurAttr), pNewFontSet) ;
	UNSET_CONVATTR_PREEDIT_MASK (*pCurAttr, CALineSpacing) ;
	TFontSet_Adjust (XtDisplay (gw), &wgThis->toffwin.m_fsTerminal, DEFAULT_FONTHEIGHT) ;

	if (wgThis->toffwin.m_wgTerminal != NULL) {
		TConversionAttribute				ca ;

		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CAFont) ;
		TFontSet_Copy  (&CONVATTR_PREEDIT_FONTSET(ca), pNewFontSet) ;
		TFrame_SetAttribute (wgThis->toffwin.m_wgTerminal, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	False ;
}

Boolean
toffTheSpotWindow_onSetPAttributeLineSpacing (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register int						nLineSpacing ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr		= &wgThis->toffwin.m_caCurrent ;
	nLineSpacing	= pAttribute->m_Preedit.m_nLineSpacing ;
	if (IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CALineSpacing) &&
		pCurAttr->m_Preedit.m_nLineSpacing == nLineSpacing)
		return	False ;

	SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
	SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CALineSpacing) ;
	pCurAttr->m_Preedit.m_nLineSpacing	= nLineSpacing ;

	/*	SubFrame  LineSpacing ѹ롣*/
	if (wgThis->toffwin.m_wgTerminal != NULL) {
		TConversionAttribute				ca ;

		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CALineSpacing) ;
		ca.m_Preedit.m_nLineSpacing	= nLineSpacing ;
		TFrame_SetAttribute (wgThis->toffwin.m_wgTerminal, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	False ;
}

Boolean
toffTheSpotWindow_onSetPAttributeColormap (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register Colormap	colNew ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	colNew		= pAttribute->m_Preedit.m_colormap ;
	if (IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) &&
		IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAColormap) &&
		pCurAttr->m_Preedit.m_colormap == colNew) 
		return	False ;

	SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
	SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAColormap) ;
	CONVATTR_PREEDIT_COLORMAP(*pCurAttr)	= colNew ;

	/*	SubFrame  Colormap ѹ롣*/
	if (wgThis->toffwin.m_wgTerminal != NULL) {
		TConversionAttribute				ca ;

		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CAColormap) ;
		CONVATTR_PREEDIT_COLORMAP(ca)	= colNew ;
		TFrame_SetAttribute (wgThis->toffwin.m_wgTerminal, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	False ;
}

Boolean
toffTheSpotWindow_onSetPAttributeBackground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register Pixel						pxlBack ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	pxlBack		= CONVATTR_PREEDIT_BACKGROUND (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CABackgroundPixel)) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CABackgroundPixel) ;
	} else {
		if (CONVATTR_PREEDIT_BACKGROUND (*pCurAttr) == pxlBack)
			return	False ;
	}
	CONVATTR_PREEDIT_BACKGROUND (*pCurAttr)	= pxlBack ;

	/*	SubFrame  background pixel ѹ롣*/
	if (wgThis->toffwin.m_wgTerminal != NULL) {
		TConversionAttribute				ca ;

		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CABackgroundPixel) ;
		CONVATTR_PREEDIT_BACKGROUND(ca)	= pxlBack ;
		TFrame_SetAttribute (wgThis->toffwin.m_wgTerminal, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	False ;
}

Boolean
toffTheSpotWindow_onSetPAttributeForeground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Pixel	pxlFore ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	pxlFore		= CONVATTR_PREEDIT_FOREGROUND (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAForegroundPixel)) {
		SET_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (*pCurAttr, CAForegroundPixel) ;
	} else {
		if (CONVATTR_PREEDIT_FOREGROUND (*pCurAttr) == pxlFore)
			return	False ;
	}
	CONVATTR_PREEDIT_FOREGROUND (*pCurAttr)	= pxlFore ;

	/*	SubFrame  foreground pixel ѹ롣*/
	if (wgThis->toffwin.m_wgTerminal != NULL) {
		TConversionAttribute				ca ;

		TConvAttr_Initialize (&ca) ;
		SET_CONVATTR_MASK (ca, CAPreeditMask) ;
		SET_CONVATTR_PREEDIT_MASK (ca, CAForegroundPixel) ;
		CONVATTR_PREEDIT_FOREGROUND(ca)	= pxlFore ;
		TFrame_SetAttribute (wgThis->toffwin.m_wgTerminal, &ca) ;
		TConvAttr_Uninitialize (&ca) ;
	}
	return	False ;
}

/*	Status Attribute:	Status Attribute ¦ϲޤǤμɬפ
 */
Boolean
toffTheSpotWindow_onSetStatusAttribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register unsigned int	uMask ;
	register int			i ;
	register Boolean		fRetval ;
	static Boolean	(*rpSetSAttrProcTbl[])(Widget, const TConversionAttribute*) = {
		NULL,
		toffTheSpotWindow_onSetSAttributeClientArea,
		toffTheSpotWindow_onSetSAttributeFont,
		toffTheSpotWindow_onSetSAttributeLineSpacing,
		toffTheSpotWindow_onSetSAttributeColormap,
		toffTheSpotWindow_onSetSAttributeForeground,
		toffTheSpotWindow_onSetSAttributeBackground,
	} ;

	uMask	= 1 << CASpotLocationBit ;
	i		= 0 ;
	fRetval	= False ;
	while (i <= (CABackgroundPixelBit - CASpotLocationBit)) {
		if (IS_CONVATTR_STATUS_MASK (*pAttribute, uMask) && 
			rpSetSAttrProcTbl [i] != NULL)
			fRetval	= (rpSetSAttrProcTbl [i])(gw, pAttribute) || fRetval ;
		uMask	= uMask << 1 ;
		i	++ ;
	}
	return	False ;
}

/*	Status Attribute:	ɽΰꡣ
 */
Boolean
toffTheSpotWindow_onSetSAttributeClientArea (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Boolean			fRetval	= False ;
	register const XRectangle*	pNewArea ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

#if defined (DEBUG)
	fprintf (stderr, "Status: ClientArea: (%d, %d, %d, %d)\n", 
			 pAttribute->m_Status.m_area.x,
			 pAttribute->m_Status.m_area.y,
			 pAttribute->m_Status.m_area.width,
			 pAttribute->m_Status.m_area.height) ;
#endif
	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	pNewArea	= &CONVATTR_STATUS_CLIENTAREA (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CAClientArea)) {
		SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (*pCurAttr, CAClientArea) ;
		CONVATTR_STATUS_CLIENTAREA (*pCurAttr)	= *pNewArea ;
		fRetval	= True ;
	} else {
		register XRectangle*	pCurArea ;

		pCurArea	= &CONVATTR_STATUS_CLIENTAREA (*pCurAttr) ;
		if (pCurArea->x      != pNewArea->x     ||
			pCurArea->y      != pNewArea->y     ||
			pCurArea->width  != pNewArea->width ||
			pCurArea->height != pNewArea->height)
			fRetval	= True ;
		*pCurArea	= *pNewArea ;
	}
	if (fRetval && wgThis->toffwin.m_wndModeshell != None) 
		XMoveWindow (XtDisplay (gw), wgThis->toffwin.m_wndModeshell, pNewArea->x, pNewArea->y) ;
	return	fRetval ;
}

Boolean
toffTheSpotWindow_onSetSAttributeFont (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	/*	modeshell 񤯤Τɬ */
	TFontSet_Copy  (&wgThis->toffwin.m_fsMinibuf, &CONVATTR_STATUS_FONTSET (*pAttribute)) ;
	SET_CONVATTR_STATUS_MASK (*pCurAttr, CAFont) ;
	UNSET_CONVATTR_STATUS_MASK (*pCurAttr, CALineSpacing) ;
	return	True ;
}

Boolean
toffTheSpotWindow_onSetSAttributeLineSpacing (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	/*	Modeshell 񤯤Τ LineSpacing פʵ롣*/
	return	False ;
}

Boolean
toffTheSpotWindow_onSetSAttributeColormap (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register Window		window ;
	register Colormap	colNew ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	colNew		= pAttribute->m_Preedit.m_colormap ;
	if (IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) &&
		IS_CONVATTR_STATUS_MASK (*pCurAttr, CAColormap) &&
		pCurAttr->m_Status.m_colormap == colNew) 
		return	False ;

	SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
	SET_CONVATTR_STATUS_MASK (*pCurAttr, CAColormap) ;
	CONVATTR_STATUS_COLORMAP(*pCurAttr)	= colNew ;

	window	= wgThis->toffwin.m_wndModeshell ;
	if (window != None)
		XSetWindowColormap (XtDisplay (gw), window, colNew) ;
	return	False ;
}

Boolean
toffTheSpotWindow_onSetSAttributeBackground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register Window	window ;
	register Pixel	pxlBack ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	pxlBack		= CONVATTR_STATUS_BACKGROUND (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (*pCurAttr, CABackgroundPixel)) {
		SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (*pCurAttr, CABackgroundPixel) ;
	} else {
		if (CONVATTR_STATUS_BACKGROUND (*pCurAttr) == pxlBack)
			return	False ;
	}
	CONVATTR_STATUS_BACKGROUND (*pCurAttr)	= pxlBack ;

	window	= wgThis->toffwin.m_wndModeshell ;
	if (window != None)
		XSetWindowBackground (XtDisplay (gw), window, pxlBack) ;
	return	False ;
}

Boolean
toffTheSpotWindow_onSetSAttributeForeground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register Pixel	pxlFore ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	pxlFore		= CONVATTR_STATUS_FOREGROUND (*pAttribute) ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAStatusMask) ||
		!IS_CONVATTR_STATUS_MASK (*pCurAttr, CAForegroundPixel)) {
		SET_CONVATTR_MASK (*pCurAttr, CAStatusMask) ;
		SET_CONVATTR_STATUS_MASK (*pCurAttr, CAForegroundPixel) ;
	} else {
		if (CONVATTR_STATUS_FOREGROUND (*pCurAttr) == pxlFore)
			return	False ;
	}
	CONVATTR_STATUS_FOREGROUND (*pCurAttr)	= pxlFore ;
	return	True ;
}

/*	楳ɤϲԤƤʤʤ̤뤤ɤʤġ
 */
Boolean
toffTheSpotWindow_puts (
	register Widget			gw,
	register const Char*	pText,
	register int			nText)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;

	if (wgThis->toffwin.m_fDestroy || wgThis->toffwin.m_wgTerminal == NULL)
		return	False ;

	return	TFrame_Puts (wgThis->toffwin.m_wgTerminal, pText, nText) ;
}

Boolean
toffTheSpotWindow_putchar (
	register Widget			gw,
	register const Char		cc)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;

	if (wgThis->toffwin.m_fDestroy || wgThis->toffwin.m_wgTerminal == NULL)
		return	False ;

	return	TFrame_Putchar (wgThis->toffwin.m_wgTerminal, cc) ;
}

void
toffTheSpotWindow_flush (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;

	if (!wgThis->toffwin.m_fActive ||
		wgThis->toffwin.m_fDestroy ||
		wgThis->toffwin.m_wgTerminal == NULL)
		return ;
	
	TFrame_Flush (wgThis->toffwin.m_wgTerminal) ;
	return ;
}

/*
 */
void
toffTheSpotWindow_clear (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;

	if (wgThis->toffwin.m_fDestroy || wgThis->toffwin.m_wgTerminal == NULL)
		return ;

	TFrame_Clear (wgThis->toffwin.m_wgTerminal) ;
	return ;
}

/*
 */
void
toffTheSpotWindow_rev (
	register Widget			gw,
	register Boolean		fRev)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;

	if (wgThis->toffwin.m_fDestroy || wgThis->toffwin.m_wgTerminal == NULL)
		return ;

	TFrame_Rev (wgThis->toffwin.m_wgTerminal, fRev) ;
	return ;
}

Boolean
toffTheSpotWindow_rectVariablep (
	register Widget			gw)
{
	return	True ;
}

Boolean
toffTheSpotWindow_haveExternModelinep (
	register Widget			gw)
{
	return	True ;
}

Boolean
toffTheSpotWindow_setModeline (
	register Widget			gw,
	register const Char*	pString,
	register int			nString)
{
	register TOffTheSpotWindowWidget	wgThis		= (TOffTheSpotWindowWidget) gw ;
	register const Char*	pPrevString ;
	register int			nPrevString ;
	register Boolean		fRedraw ;

	if (wgThis->toffwin.m_fDestroy)
		return	True ;

	pPrevString	= TVarbuffer_GetBuffer (&wgThis->toffwin.m_vbufModeshellText) ;
	nPrevString	= TVarbuffer_GetUsage  (&wgThis->toffwin.m_vbufModeshellText) ;
	fRedraw		= (nPrevString != nString || memcmp (pPrevString, pString, nString * sizeof (Char)) != 0) ;
	if (!fRedraw)
		return	True ;
	TVarbuffer_Clear (&wgThis->toffwin.m_vbufModeshellText) ;
	if (TFAILED (TVarbuffer_Add (&wgThis->toffwin.m_vbufModeshellText, pString, nString)))
		return	False ;
	toffTheSpotWindow_resizeModeshellWindow (gw) ;
	toffTheSpotWindow_onModeshellExpose (gw, 0) ;
	//XClearArea (XtDisplay (gw), wgThis->toffwin.m_wndModeshell, 0, 0, 0, 0, True) ;
	return	True ;
}

Boolean
toffTheSpotWindow_autoPopupp (
	register Widget		gw)
{
	return	False ;
}

void
toffTheSpotWindow_resizeModeshellWindow (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register Display*				pDisplay	= XtDisplay (gw) ;
	register const Char*			pString ;
	register int					nString ;	
	TSize	sz ;

	if (wgThis->toffwin.m_wndModeshell == None)
		return ;

	pString		= TVarbuffer_GetBuffer (&wgThis->toffwin.m_vbufModeshellText) ;
	nString		= TVarbuffer_GetUsage  (&wgThis->toffwin.m_vbufModeshellText) ;
	if (nString <= 0) {
		XUnmapWindow (pDisplay, wgThis->toffwin.m_wndModeshell) ;
		wgThis->toffwin.m_szModeshell.cx	= 0 ;
		wgThis->toffwin.m_szModeshell.cy	= 0 ;
	} else {
		register TFontSet*	pFontSet ;
		register Boolean	fFixedModeshell ;

		fFixedModeshell	= (IS_CONVATTR_MASK (wgThis->toffwin.m_caCurrent, CAStatusMask) &&
						   IS_CONVATTR_STATUS_MASK (wgThis->toffwin.m_caCurrent, CAClientArea)) ;

		XMapWindow (pDisplay, wgThis->toffwin.m_wndModeshell) ;
		pFontSet	= &wgThis->toffwin.m_fsMinibuf ;
		TGetTextExtents (pFontSet, pString, nString, &sz) ;
		XResizeWindow (pDisplay, wgThis->toffwin.m_wndModeshell, sz.cx, sz.cy) ;
		wgThis->toffwin.m_szModeshell	= sz ;
	}
	return ;
}

int
toffTheSpotWindow_configureFocusOffset (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register Display*				pDisplay	= XtDisplay (gw) ;
	register Window					wndClient, wndFocus ;
	register Boolean				fRedraw		= False ;
	int		x, y, nFocusX, nFocusY ;
	Window	dummy ;

	wndClient	= wgThis->toffwin.m_wndClient ;
	wndFocus	= wgThis->toffwin.m_wndFocus ;
	XTranslateCoordinates (pDisplay, wndClient, RootWindowOfScreen (XtScreen (gw)), 0, 0, &x, &y, &dummy) ;
	if (wndClient != wndFocus) {
		/*	Client Window  Focus Window ɤ줿֤ˤ
		 *	Τ򵭲Ƥ
		 */
		XTranslateCoordinates (pDisplay, wndFocus, wndClient, 0, 0, &nFocusX, &nFocusY, &dummy) ;
	} else {
		nFocusX	= nFocusY	= 0 ;
	}
	if (wgThis->toffwin.m_ptClient.x != x || wgThis->toffwin.m_ptClient.y != y) {
		wgThis->toffwin.m_ptClient.x	= x ;
		wgThis->toffwin.m_ptClient.y	= y ;
		fRedraw	= True ;
	}
	if (wgThis->toffwin.m_ptFocus.x != nFocusX || wgThis->toffwin.m_ptFocus.y != nFocusY) {
		wgThis->toffwin.m_ptFocus.x	= x ;
		wgThis->toffwin.m_ptFocus.y	= y ;
		fRedraw	= True ;
	}
	return	fRedraw ;
}

/*
 *
 */
void
toffTheSpotWindow_popup (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;

	if (wgThis->toffwin.m_wgTerminal != NULL) 
		TFrame_Activate (wgThis->toffwin.m_wgTerminal, True) ;
		
	if (wgThis->toffwin.m_wndModeshell != None)
		XMapWindow (XtDisplay (gw), wgThis->toffwin.m_wndModeshell) ;

	if (!wgThis->toffwin.m_fActive) 
		wgThis->toffwin.m_fActive	= True ;
	return ;
}

void
toffTheSpotWindow_popdown (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;

	if (wgThis->toffwin.m_wgTerminal != NULL) 
		TFrame_Activate (wgThis->toffwin.m_wgTerminal, False) ;
		
	if (wgThis->toffwin.m_wndModeshell != None)
		XUnmapWindow (XtDisplay (gw), wgThis->toffwin.m_wndModeshell) ;
	wgThis->toffwin.m_fActive	= False ;
	return ;
}

Boolean
toffTheSpotWindow_getPreeditLineSpacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;

	assert (gw != NULL) ;
	assert (pnLineSpacing != NULL) ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_PREEDIT_MASK (*pCurAttr, CALineSpacing)) {
		*pnLineSpacing	= TFontSet_GetHeight (&wgThis->toffwin.m_fsTerminal) ;
		return	False ;
	}
	*pnLineSpacing	= pCurAttr->m_Preedit.m_nLineSpacing ;
	return	True ;
}

unsigned long
toffTheSpotWindow_getStatusWindowAttribute (
	register Widget					gw,
	register XSetWindowAttributes*	pSWA)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*	pCurAttr ;
	register unsigned long	lMask ;
	register Pixel			pxlBack ;

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	pxlBack		= wgThis->core.background_pixel ;
	lMask		= CWOverrideRedirect | CWBackPixel | CWBorderPixel ;

	if (IS_CONVATTR_MASK (wgThis->toffwin.m_caCurrent, CAStatusMask)) {
		if (IS_CONVATTR_STATUS_MASK (*pCurAttr, CABackgroundPixel))
			pxlBack		= CONVATTR_STATUS_BACKGROUND (*pCurAttr) ;
		if (IS_CONVATTR_STATUS_MASK (*pCurAttr, CAColormap)) {
			pSWA->colormap	= pCurAttr->m_Status.m_colormap ;
			lMask			|= CWColormap ;
		}
	}
	pSWA->override_redirect	= True ;
	pSWA->background_pixel	= pxlBack ;
	pSWA->border_pixel		= pxlBack ;
	return	lMask ;
}

Boolean
toffTheSpotWindow_createTerminalWindow (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register Widget						wgTerminalFrame ;
	register const XRectangle*			pRect ;
	TConversionAttribute				ca ;
	Boolean								fInput ;
	Arg									rArg [12] ;
	register int						nArg ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg],	XtNinput,			&fInput) ;	nArg ++ ;
	XtGetValues (gw, rArg, nArg) ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged, False) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNclientWindow,		wgThis->toffwin.m_wndClient) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNfocusWindow,		wgThis->toffwin.m_wndFocus) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNinput,			fInput) ;	nArg ++ ;	

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	if (!IS_CONVATTR_MASK (*pCurAttr, CAPreeditMask) ||
		!IS_CONVATTR_STATUS_MASK (*pCurAttr, CAClientArea))
		return	False ;
	//wgThis->toffwin.m_wndClient == wgThis->toffwin.m_wndFocus

	pRect	= &pCurAttr->m_Preedit.m_area ;
	XtSetArg (rArg [nArg], XtNx,		pRect->x) ;			nArg ++ ;
	XtSetArg (rArg [nArg], XtNy,		pRect->y) ;			nArg ++ ;
	XtSetArg (rArg [nArg], XtNwidth,	pRect->width) ;		nArg ++ ;
	XtSetArg (rArg [nArg], XtNheight,	pRect->height) ;	nArg ++ ;
	if (IS_CONVATTR_STATUS_MASK (*pCurAttr, CAForegroundPixel)) {
		XtSetArg (rArg [nArg], XtNforeground,	pCurAttr->m_Status.m_foreground) ;
		nArg ++ ;
	}
	if (IS_CONVATTR_STATUS_MASK (*pCurAttr, CABackgroundPixel)) {
		XtSetArg (rArg [nArg], XtNbackground,	pCurAttr->m_Status.m_background) ;
		nArg ++ ;
	}
	wgTerminalFrame	= TSubWindowFrame_Create (XtParent (gw), rArg, nArg) ;
	if (wgTerminalFrame == NULL)
		return	False ;

	TConvAttr_Initialize (&ca) ;
	/**/
	TConvAttr_Copy (&ca, pCurAttr) ;
	ca.m_wndFocus	=  wgThis->toffwin.m_wndClient ;
	ca.m_uMask		|= CAFocusWindow ;
	TFrame_SetAttribute (wgTerminalFrame, &ca) ;
	TConvAttr_Uninitialize (&ca) ;

	wgThis->toffwin.m_wgTerminal	= wgTerminalFrame ;
	return	True ;
}

Boolean
toffTheSpotWindow_createModeshellWindow (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register Display*		pDisplay	= XtDisplay (gw) ;
	register Window			wndFocus, wndModeshell ;
	register GC				gc ;
	register int			x, y ;
	register unsigned long	lMask ;
	XSetWindowAttributes	swa ;

	/*	fixed modeshell */
	wndFocus	= wgThis->toffwin.m_wndClient ;
	x		= wgThis->toffwin.m_caCurrent.m_Status.m_area.x ;
	y		= wgThis->toffwin.m_caCurrent.m_Status.m_area.y ;
	lMask	= toffTheSpotWindow_getStatusWindowAttribute (gw, &swa) ;

	/*	Focus Window Žդ Modeshell 롣Ĥ terminal 
	 *	Ƥ뤬ɤΤ ʤ overspec ʵ뤬ġ
	 */
	wndModeshell	= XCreateWindow (pDisplay, wndFocus, x, y, 1, 1, 0, CopyFromParent, CopyFromParent, CopyFromParent, lMask, &swa) ;
	if (wndModeshell == None) 
		return	False ;
	wgThis->toffwin.m_wndModeshell	= wndModeshell ;

	gc	= XCreateGC (pDisplay, wndModeshell, 0, NULL) ;
	if (gc == None) 
		return	False ;
	wgThis->toffwin.m_gcModeshell	= gc ;

	AfxRegisterWindow (pDisplay, wndModeshell, Expose, ExposureMask, gw, toffTheSpotWindow_onModeshellExpose) ;
	AfxRegisterWindow (pDisplay, wndModeshell, DestroyNotify, StructureNotifyMask, gw, toffTheSpotWindow_onModeshellDestroy) ;
	AfxRegisterWindow (pDisplay, wndModeshell, KeyPress, KeyPressMask, gw, toffTheSpotWindow_onSubwindowKeyPress) ;
	AfxRegisterWindow (pDisplay, wndModeshell, KeyRelease, KeyReleaseMask, gw, toffTheSpotWindow_onSubwindowKeyRelease) ;
	return	True ;
}

Boolean
toffTheSpotWindow_createMinibufferFrame (
	register Widget			gw)
{
	register TOffTheSpotWindowWidget	wgThis	= (TOffTheSpotWindowWidget) gw ;
	register TConversionAttribute*		pCurAttr ;
	register Widget	wgMinibufFrame ;
	Boolean			fInput ;
	Arg				rArg [12] ;
	register int	nArg ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg],	XtNinput,			&fInput) ;	nArg ++ ;
	XtGetValues (gw, rArg, nArg) ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged, False) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNclientWindow,		wgThis->toffwin.m_wndClient) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNfocusWindow,		wgThis->toffwin.m_wndFocus) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNinput,			fInput) ;	nArg ++ ;	

	pCurAttr	= &wgThis->toffwin.m_caCurrent ;
	XtSetArg (rArg [nArg], XtNautoPopup,	True) ;		nArg ++ ;	
	XtSetArg (rArg [nArg], XtNheight,		1) ;		nArg ++ ;
	wgMinibufFrame	= TRootWindowFrame_Create (XtParent (gw), rArg, nArg) ;
	if (wgMinibufFrame == NULL)
		return	False ;
	wgThis->toffwin.m_wgMinibuf	= wgMinibufFrame ;
	return	True ;
}

Widget
TOffTheSpotWindowFrame_Create (
	register Widget			wgParent,
	register ArgList		arglist,
	register Cardinal		nArglist)
{
	return	XtCreateWidget ("TOffTheSpotWindow", toffTheSpotWindowWidgetClass, wgParent, arglist, nArglist) ;
}

