/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (TFrameP_h)
#define	TFrameP_h

/*	Ƥ Window Style ˶̤Υ١Ȥʤ Widget
 */
#include "Char.h"
#include <X11/IntrinsicP.h>
#include <X11/ShellP.h>
#include <X11/StringDefs.h>
#include "TFrame.h"
#include "TConvAttr.h"

typedef struct tagTFramePart {
	XtPointer			m_pClient ;	/*  client ɬפʤΤ ȤäƤʤɡ*/
	XtPointer			m_pLispFrameObject ;
	Pixel				m_pxlForeground ;
	Boolean				m_fInput ;
	XtCallbackList		m_lstCbkKeyPress ;
	XtCallbackList		m_lstCbkConfigure ;
	XtCallbackList		m_lstCbkDestroy ;
}	TFramePart ;

typedef struct tagTFrameRec {
	CorePart			core ;
	CompositePart		composite ;
	ShellPart			shell ;
	TFramePart			tframe ;
}	TFrameRec ;

typedef struct tagTFrameClassPart {
	void*			(*m_pGetClient)(Widget) ;
	void*			(*m_pGetLispFrameObject)(Widget) ;
	void			(*m_pSetAttribute)(Widget, const struct tagTConversionAttribute*) ;
	int				(*m_pGetRect)(Widget, XRectangle*) ;
	void			(*m_pActivate)(Widget, Boolean) ;
	void*			(*m_pGetFontSet)(Widget) ;
	Boolean			(*m_pGetLineSpacing)(Widget, int*) ;
	Boolean			(*m_pPuts)(Widget, const Char*, int) ;
	Boolean			(*m_pPutchar)(Widget, Char) ;
	void			(*m_pRev)(Widget, Boolean) ;
	void			(*m_pClear)(Widget) ;
	void			(*m_pFlush)(Widget) ;
	Boolean			(*m_pRectVariablep)(Widget) ;
	Boolean			(*m_pHaveExternModeline)(Widget) ;
	Boolean			(*m_pSetModeline)(Widget, const Char*, int) ;
	Boolean			(*m_pAutoPopupp)(Widget) ;
	void			(*m_pSetCaret)(Widget) ;
}	TFrameClassPart ;

typedef struct tagTFrameClassRec {
	CoreClassPart		core_class ;
	CompositeClassPart	composite_class ;
	ShellClassPart		shell_class ;
	TFrameClassPart		tframe_class ;
}	TFrameClassRec ;

extern TFrameClassRec	tframeClassRec ;

#endif



