/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include <assert.h>
#include "TTerminal.h"
#include "TNormalFrame.h"
#include "TEditorClientP.h"

static	void	tEditorClient_onKeyPress		(Widget, XtPointer, XtPointer) ;
static	void	tEditorClient_onFrameConfigure	(Widget, XtPointer, XtPointer) ;

TEditorClient*
TEditorClient_New (void)
{
	register TEditorClient*	pClient ;

	pClient	= MALLOC (sizeof (TEditorClient)) ;
	if (pClient == NULL)
		return	NULL ;

	TLispClient_PreInitialize (&pClient->m_LispClient) ;
	return	pClient ;
}

Boolean
TEditorClient_Initialize (
	register TEditorClient*	pClient,
	register TLispManager*	pLispMgr,
	register TLispMachine*	pLM)
{
	register Widget	wgParent, wgFrame ;
	Arg				rArg [4] ;
	register int	nArg ;
	TLispClientArg	arg ;

	wgParent	= AfxGetToplevelWidget () ;
	nArg		= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged,	False) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNlispClient,			pClient) ;	nArg ++ ;
	wgFrame			= TNormalFrame_Create (wgParent, rArg, nArg) ;
	XtAddCallback (wgFrame, XtNkeyPressCallback,  tEditorClient_onKeyPress, (XtPointer)pClient) ;
	XtAddCallback (wgFrame, XtNconfigureCallback, tEditorClient_onFrameConfigure, (XtPointer)pClient) ;
	XtRealizeWidget (wgFrame) ;

	arg.m_pLispMgr			= pLispMgr ;
	arg.m_pLM				= pLM ;
	arg.m_wgFrame			= wgFrame ;
	arg.m_wgMinibufFrame	= NULL ;
	arg.m_pvClient			= NULL ;
	arg.m_pTextNotify		= NULL ;
	arg.m_pKeyNotify		= NULL ;
	arg.m_pEndNotify		= NULL ;
	TLispClient_Initialize (&pClient->m_LispClient, &arg) ;

	/*	ɤΤϵ Active */
	TLispClient_Activate (&pClient->m_LispClient, True) ;
	return	True ;
}

void
TEditorClient_Destroy (
	register TEditorClient*	pClient)
{
	assert (pClient != NULL) ;
	TLispClient_Uninitialize (&pClient->m_LispClient) ;
	return ;
}

void
tEditorClient_onKeyPress (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register TEditorClient*		pClient	= (TEditorClient *) closure ;

	/*	LispMachine, Event, LPARAM, RPARAM ν֤Ϥ롣
	 */
	TLispMachine_EventProc (pClient->m_LispClient.m_pLM, LMEVENT_KEYPRESS, call_data, 0) ;
	return ;
}

void
tEditorClient_onFrameConfigure (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register TEditorClient*		pClient	= (TEditorClient *) closure ;
	TLispEntity*	pEntFrame	= NULL ;
	
	pEntFrame	= TFrame_GetLispFrameObject (wgFrame) ;
	assert (pEntFrame != NULL) ;
	TLispMachine_EventProc (pClient->m_LispClient.m_pLM, LMEVENT_FRAMERESIZE, pEntFrame, call_data) ;
	return ;
}

