/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (KinputClientP_h)
#define	KinputClientP_h

#include "KinputClient.h"
#include "TLispClient.h"

enum {
	KINPUT2_ATTRIBUTE_NONE			= 0,
	KINPUT2_ATTRIBUTE_INDIRECT,
	KINPUT2_ATTRIBUTE_FOCUS_WINDOW,
	KINPUT2_ATTRIBUTE_SPOTLOCATION,
	KINPUT2_ATTRIBUTE_CLIENTAREA,
	KINPUT2_ATTRIBUTE_STATUSAREA,
	KINPUT2_ATTRIBUTE_COLORMAP,
	KINPUT2_ATTRIBUTE_COLOR,
	KINPUT2_ATTRIBUTE_BACKGROUND_PIXMAP,
	KINPUT2_ATTRIBUTE_LINESPACING,
	KINPUT2_ATTRIBUTE_FONT,
	KINPUT2_ATTRIBUTE_CURSOR,
	KINPUT2_ATTRIBUTE_INPUTSTYLE	= 128,
	KINPUT2_ATTRIBUTE_EVENTSELECT	= 129,
	KINPUT2_ATTRIBUTE_EXTENSION		= 255,
} ;

enum {
	KINPUT2_ATTRIBUTE_INPUTSTYLE_ROOTWINDOW		= 1,
	KINPUT2_ATTRIBUTE_INPUTSTYLE_OFFTHESPOT		= 2,
	KINPUT2_ATTRIBUTE_INPUTSTYLE_OVERTHESPOT	= 4,
} ;

enum {
	KINPUT2_ATTRIBUTE_EVENTSELECT_NONE	= 0,
	KINPUT2_ATTRIBUTE_EVENTSELECT_INPUT	= 1,
	KINPUT2_ATTRIBUTE_EVENTSELECT_FOCUS	= 2,
} ;

struct tagKinputClient {
	TLispClient				m_LispClient ;
	Widget					m_wgProtocol ;
	Window					m_wndRequestor ;	/* Ѵ׵Ф Window */
	Widget					m_wgTopFrame ;
	Boolean					m_fReserve ;
	Boolean					m_fProbe ;
	unsigned int			m_uAttributeMask ;
	Window					m_wndProbe ;
	Window					m_wndFocus ;
	Atom					m_atTarget ;
	Atom					m_atProperty ;
	Atom					m_atSelection ;
	struct tagKinputClient*	m_pNext ;
} ;

struct proprec {
	Atom					prop ;
	struct proprec*			prev ;
} ;

#endif

