/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (KinputClient_h)
#define	KinputClient_h

#include "TConvAttr.h"

struct tagKinputClient ;
typedef struct tagKinputClient	KinputClient ;

KinputClient*	KinputClient_New			(Widget, Window) ;
Window			KinputClient_GetRequestor	(KinputClient*) ;
Atom			KinputClient_GetSelection	(KinputClient*) ;
Atom			KinputClient_GetTarget		(KinputClient*) ;
Atom			KinputClient_GetProperty	(KinputClient*) ;
Widget			KinputClient_GetFrame		(KinputClient*) ;
void			KinputClient_SetNext		(KinputClient*, KinputClient*) ;
KinputClient*	KinputClient_GetNext		(KinputClient*) ;
Boolean			KinputClient_Initialize		(KinputClient*, Atom, Atom, Atom, Atom, Atom) ;
Boolean			KinputClient_Activate		(KinputClient*, Boolean) ;
Boolean			KinputClient_SetAttribute	(KinputClient*, TConversionAttribute*) ;
Boolean			KinputClient_GetAttributeFromProperty	(KinputClient*, Atom, Atom, TConversionAttribute*) ;
Boolean			KinputClient_GetAttributeFromEvent		(KinputClient*, XClientMessageEvent*, Atom, TConversionAttribute*) ;
void			KinputClient_Destroy		(KinputClient*) ;

#endif

