/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (cstring_h)
#define	cstring_h

#include "Char.h"

/*	inline functions */
extern inline	int
Cstrlen (
	register const Char* pCstring)
{
	register int		iLength ;

	assert (pCstring != NULL);

	iLength	= 0 ;
	while (!Char_IsNul (*pCstring)) {
		pCstring	++ ;
		iLength		++ ;
	}
	return	iLength ;
}

extern inline	int
Cstrcmp (
	register const Char*	pCstring1,
	register const Char*	pCstring2)
{
	register int	iDifference ;

	assert (pCstring1 != NULL) ;
	assert (pCstring2 != NULL) ;

	while (iDifference = Char_Difference (*pCstring1, *pCstring2),
		   iDifference == 0 && !Char_IsNul (*pCstring1)) {
		pCstring1	++ ;
		pCstring2	++ ;
	}

	return	iDifference ;
}

extern inline	int
Cstrncmp (
	register const Char*	pCstring1,
	register const Char*	pCstring2,
	register int			n)
{
	register int	iDifference ;

	assert (pCstring1 != NULL) ;
	assert (pCstring2 != NULL) ;

	iDifference	= 0 ;

	while (n > 0) {
		iDifference = Char_Difference (*pCstring1, *pCstring2) ;
		if (iDifference != 0 || Char_IsNul (*pCstring1))
			break ;
		pCstring1	++ ;
		pCstring2	++ ;
		n			-- ;
	}

	return	iDifference ;
}

extern inline	int
Cstrnccmp (
	register const Char*	pCstring1,
	register const char*	pString2,
	register int			n)
{
	register int	iDifference ;

	assert (pCstring1 != NULL) ;
	assert (pString2  != NULL) ;

	iDifference	= 0 ;

	while (n > 0) {
		iDifference = Char_Difference (*pCstring1, Char_ToAscii (*pString2)) ;
		if (iDifference != 0 || Char_IsNul (*pCstring1))
			break ;
		pCstring1	++ ;
		pString2	++ ;
		n			-- ;
	}

	return	iDifference ;
}

extern inline	Char*
Cstrcpy (
	register Char* 			pCdest,
	register const Char*	pCsrc)
{
	register Char*	pTop ;

	pTop	= pCdest ;
	while (!Char_IsNul (*pCsrc)) 
		*pCdest ++	= *pCsrc ++ ;
	*pCdest	= '\0' ;

	return	pTop ;
}

extern inline	Char*
Cstrncpy (
	register Char*			pCdest,
	register const Char*	pCsrc,
	register int			n)
{
	register Char*	pTop ;

	pTop	= pCdest ;
	while (n > 0 && !Char_IsNul (*pCsrc)) {
		*pCdest	++	= *pCsrc ++ ;
		n -- ;
	}
	if (n > 0)
		*pCdest	= '\0' ;

	return	pTop ;
}

/*
 *	pDest	ANSI ʸǼХåե
 *	pCsrc	NUL ü줿 C ʸ
 *	n		ANSI ʸǼХåե礭
 */
extern inline	char*
cstrtostr (
	register char*			pDest,
	register const Char*	pCsrc,
	register int			n)
{
	register char*	pTop ;

	pTop	= pDest ;

	while (n > 0 && !Char_IsNul (*pCsrc)) {
		if (Char_IsAscii (*pCsrc)) {
			*pDest ++	= (char) *pCsrc ;
			n	-- ;
		}
		pCsrc	++ ;
	}
	if (n > 0)
		*pDest	= '\0' ;

	return	pTop ;
}

extern inline	Char*
strtocstr (
	register Char*			pCdest,
	register const char*	pSrc,
	register int			n)
{
	register Char*	pTop ;

	pTop	= pCdest ;

	while (n > 0 && *pSrc != '\0') {
		*pCdest ++	= *pSrc ++ ;
		n	-- ;
	}
	if (n > 0)
		*pCdest	= '\0' ;

	return	pTop ;
}

extern inline	int
cmemcmp (
	register const Char*	pLeft,
	register int			nLeft,
	register const Char*	pRight,
	register int			nRight)
{
	register int	iDifference ;
	register int	nLoop	= (nLeft < nRight) ? nLeft : nRight ;

	assert (pLeft  != NULL || nLeft == 0) ;
	assert (pRight != NULL || nRight == 0) ;

	while (nLoop -- > 0) {
		iDifference = Char_Difference (*pLeft, *pRight) ;
		if (iDifference != 0)
			return	iDifference ;
		pLeft	++ ;
		pRight	++ ;
	}
	if (nLeft < nRight)
		return	*pRight ;
	if (nLeft > nRight)
		return	*pLeft ;		
	return	0 ;
}

extern inline	int
cmemccmp (
	register const Char*	pLeft,
	register int			nLeft,
	register const char*	pRight,
	register int			nRight)
{
	register int	iDifference ;
	register int	nLoop	= (nLeft < nRight) ? nLeft : nRight ;

	assert (pLeft  != NULL || nLeft == 0) ;
	assert (pRight != NULL || nRight == 0) ;

	while (nLoop -- > 0) {
		iDifference = Char_DifferenceAscii (*pLeft, *pRight) ;
		if (iDifference != 0)
			return	iDifference ;
		pLeft	++ ;
		pRight	++ ;
	}
	if (nLeft < nRight)
		return	Char_MakeAscii (*pRight) ;
	if (nLeft > nRight)
		return	*pLeft ;		
	return	0 ;
}

extern inline Boolean	
catoi (
	register const Char*	pString,
	register int			nLength,
	register long* const	plRetval)
{
	register long	lSign, lValue ;

	while (nLength > 0 && (*pString == ' ' || *pString == '\t')) {
		pString	++ ;
		nLength	-- ;
	}
	if (!Char_IsDigitNum (*pString)) 
		return	False ;

	lSign	= +1 ;
	if (*pString == '+') {
		pString	++ ;
		nLength	-- ;
	} else if (*pString == '-') {
		pString	++ ;
		nLength	-- ;
		lSign	= -1 ;
	}

	lValue	= 0 ;
	while (nLength > 0 && Char_IsDigitNum (*pString)) {
		lValue	= lValue * 10 + (*pString - '0') ;
		pString	++ ;
		nLength	-- ;
	}
	while (nLength > 0 && (*pString == ' ' || *pString == '\t')) {
		pString	++ ;
		nLength	-- ;
	}
	if (nLength != 0)
		return	False ;

	*plRetval	= lSign * lValue ;
	return	True ;
}

#endif

