/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

/*
 *	(window-frame WINDOW)
 *
 *	window WINDOW ¸ߤե졼४֥Ȥ֤
 */
TLMRESULT
lispMachineState_WindowFrame (
	register TLispMachine*		pLM)
{
	TLispEntity*	pArglist ;
	TLispEntity*	pWindowEntity ;
	TLispEntity*	pFrameEntity ;

	assert (pLM != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar (pLM->m_pLispMgr, pArglist, &pWindowEntity)) ||
		TFAILED (lispWindow_GetFrame (pWindowEntity, &pFrameEntity))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pFrameEntity) ;
	}
	return	LMR_RETURN ;
}

/*
 *	(window-buffer &optional WINDOW)
 *
 *	WINDOW ɽƤ buffer ֤
 */
TLMRESULT
lispMachineState_WindowBuffer (register TLispMachine* pLM)
{
	TLispEntity*	pArglist ;
	TLispEntity*	pWindowEntity ;
	TLispEntity*	pBufferEntity ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar (pLM->m_pLispMgr, pArglist, &pWindowEntity))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TSUCCEEDED (lispEntity_Nullp (pLM->m_pLispMgr, pWindowEntity))) 
		lispMachineCode_GetCurrentWindow (pLM, &pWindowEntity) ;
	assert (pWindowEntity != NULL) ;
	lispWindow_GetBuffer (pWindowEntity, &pBufferEntity) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pBufferEntity) ;
	return	LMR_RETURN ;
}

/*
 *	(selected-window)
 */
TLMRESULT
lispMachineState_SelectedWindow (register TLispMachine* pLM)
{
	TLispEntity*	pEntWindow ;

	lispMachineCode_GetCurrentWindow (pLM, &pEntWindow) ;
	if (pEntWindow != NULL) {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntWindow) ;
	} else {
		lispMachineCode_SetError (pLM) ;
	}
	return	LMR_RETURN ;
}

