/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

static	TLMRESULT	lispMachineState_readStringAfter (TLispMachine*) ;

/*
 *	δؿ STATE ѲΤաRETURN  STATE 
 *	PUSH ƤƤӽФȡ
 */
TLMRESULT
lispMachine_ReadStringStart (
	register TLispMachine*	pLM,
	register const Char*	pStrPrompt,
	register int			nLenPrompt,
	register TLispEntity*	pEntKeymap)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntModeline ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntWindow ;
	TLispEntity*	pEntOrgBuffer ;
	TLispEntity*	pEntOrgMiniBuffer ;
	TLispEntity*	pEntCurFrame ;
	TLispEntity*	pEntMiniWindow ;
	TLispEntity*	pEntNil ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	if (TFAILED (lispMgr_CreateBuffer (pLispMgr, &pEntBuffer)))
		return	LMR_ERROR ;
	lispMachine_InsertBuffer (pLM, pEntBuffer) ;

	/*	Modeline Ϥʤ*/
	pEntModeline	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_MODE_LINE_FORMAT) ;
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	lispBuffer_MakeSymbolValue (pLispMgr, pEntBuffer, pEntModeline) ;
	lispBuffer_SetSymbolValue (pLispMgr, pEntBuffer, pEntModeline, pEntNil) ;

	/* OK */
	lispMachineCode_PushLReg (pLM, LM_LREG_1) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_3) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_4) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_5) ;
	lispBuffer_SetKeymap (pLispMgr, pEntBuffer, pEntKeymap) ;
#if defined (DEBUG)
	fprintf (stderr, "keymap = ") ;
	lispEntity_Print (pLispMgr, pEntKeymap) ;
	fprintf (stderr, "\n") ;
#endif

	/*	Minibuffer ä PROMPT ήࡣ*/
	if (nLenPrompt > 0) 
		lispBuffer_SetPrompt (pLispMgr, pEntBuffer, pStrPrompt, nLenPrompt) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_1, pEntBuffer) ;

	/*	current frame 롣*/
	lispMachineCode_GetCurrentFrame (pLM, &pEntCurFrame) ;
	lispFrame_GetMinibufferWindow (pEntCurFrame, &pEntMiniWindow) ;

	/*	 mini-buffer 롣*/
	lispWindow_GetBuffer  (pEntMiniWindow, &pEntOrgMiniBuffer) ;
	lispWindow_SetBuffer  (pLispMgr, pEntMiniWindow, pEntBuffer) ;
	lispWindow_SetMessage (pLispMgr, pEntMiniWindow, pEntNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_2, pEntMiniWindow) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_3, pEntOrgMiniBuffer) ;

	lispMachineCode_GetCurrentWindow (pLM, &pEntWindow) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_4, pEntWindow) ;
	lispMachineCode_GetCurrentBuffer (pLM, &pEntOrgBuffer) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_5, pEntOrgBuffer) ;

	/*	ȡ*/
	lispMachineCode_SetCurrentWindow (pLM, pEntMiniWindow) ;
	lispMachineCode_SetCurrentBuffer (pLM, pEntBuffer) ;
	lispMachineCode_PushState (pLM, &lispMachineState_readStringAfter) ;

	/*	Focus ư롣*/
	lispWindow_SetFocus (pEntWindow,     False) ;
	lispWindow_SetFocus (pEntMiniWindow, True) ;
	pLM->m_pState	= &lispMachineState_WindowProc ;
	return	LMR_CONTINUE ;
}

/*
 *	(read-string PROMPT &optional INITIAL-INPUT HISTORY DEFAULT-VALUE INHERIT-INPUT-METHOD)
 *	Read a string from the minibuffer, prompting with string PROMPT.
 *	If non-nil, second arg INITIAL-INPUT is a string to insert before reading.
 *	The third arg HISTORY, if non-nil, specifies a history list
 *	and optionally the initial position in the list.
 *	See `read-from-minibuffer' for details of HISTORY argument.
 *	Fourth arg DEFAULT-VALUE is the default value.  If non-nil, it is used
 *	for history commands, and as the value to return if the user enters
 *	the empty string.
 *	Fifth arg INHERIT-INPUT-METHOD, if non-nil, means the minibuffer inherits
 *	the current input method and the setting of enable-multibyte-characters.
 */
TLMRESULT
lispMachineState_ReadString (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntKeymap ;
	TLispEntity*	pArglist ;
	TLispEntity*	pEntPrompt ;
	TLispEntity*	pValKeymap ;
	const Char*		pString ;
	int				nString ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	/*
	 *	ʳǤϰ Eval ϺѤǤ롣
	 *	ϥꥹȤȤʤäơACC äƤ롣
	 */
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;

	if (TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pEntPrompt)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntPrompt, &pString, &nString))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	pEntKeymap	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_MINIBUFFER_LOCAL_MAP) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntKeymap, &pValKeymap)) ||
		pValKeymap == NULL) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	return	lispMachine_ReadStringStart (pLM, pString, nString, pValKeymap) ;
}

TLMRESULT
lispMachineState_readStringAfter (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*		pEntBuffer ;
	TLispEntity*		pEntOrgBuffer ;
	TLispEntity*		pEntOrgMiniBuffer ;
	TLispEntity*		pEntString	= NULL ;
	TLispEntity*		pEntWindow ;
	TLispEntity*		pEntMiniWindow ;
	TVarbuffer			vbufSTRING ;
	TBufStringMarker	mkBuffer ;
	register Char*		pString ;
	int					nString ;
	register Boolean	fRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

#if defined (DEBUG)
	fprintf (stderr, "read-string-after (%p)\n", pLM) ;
#endif

	/*	minibuffer ʸȴФ*/
	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pEntBuffer) ;

	if (LISPMACHINE_EXCEPTIONP (pLM)) {
		TLispEntity*	pEntException ;
		TLispEntity*	pEntValue ;
		TLispEntity*	pEntExit ;

		lispMachineCode_GetException (pLM, &pEntException, &pEntValue) ;
		pEntExit	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_EXIT) ;
		if (TFAILED (lispEntity_Eq (pLispMgr, pEntException, pEntExit)))
			goto	exit_func ;

		/*	(throw 'exit t) ξˤϡQuiting 롣
		 */
		if (TFAILED (lispEntity_Nullp (pLispMgr, pEntValue))) {
			register TLispEntity*	pEntQuit ;
			pEntQuit	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_QUIT) ;
			lispMachineCode_SetSignal (pLM, pEntQuit, pEntValue) ;
		}
		/*	exit exception äƤȻפΤǡ*/
		lispMachineCode_ResetException (pLM) ;
	}
	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) 
		goto	exit_func ;

	lispBuffer_GetString (pLispMgr, pEntBuffer, &mkBuffer, &nString) ;
	if (TFAILED (TVarbuffer_Initialize (&vbufSTRING, sizeof (Char))) ||
		TFAILED (TVarbuffer_Require (&vbufSTRING, nString))) 
		return	LMR_ERROR ;
	pString	= TVarbuffer_GetBuffer (&vbufSTRING) ;
	while (nString -- > 0) {
		*pString ++	= TBufStringMarker_GetChar (&mkBuffer) ;
		TBufStringMarker_Forward (&mkBuffer, 1) ;
	}
	pString	= TVarbuffer_GetBuffer (&vbufSTRING) ;
	nString	= TVarbuffer_GetUsage  (&vbufSTRING) ;
	fRetval	= lispMgr_CreateString (pLispMgr, pString, nString, &pEntString) ;
	TVarbuffer_Uninitialize (&vbufSTRING) ;
	if (TFAILED (fRetval))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntString) ;

 exit_func:
	lispMachine_RemoveBuffer (pLM, pEntBuffer) ;
	/*	current-window 롣*/
	lispMachineCode_GetLReg (pLM, LM_LREG_4, &pEntWindow) ;
	lispMachineCode_SetCurrentWindow (pLM, pEntWindow) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_5, &pEntOrgBuffer) ;
	lispMachineCode_SetCurrentBuffer (pLM, pEntOrgBuffer) ;
	lispWindow_SetBuffer (pLispMgr, pEntWindow, pEntOrgBuffer) ;

	/*	current-buffer 롣*/
	lispMachineCode_GetLReg (pLM, LM_LREG_3, &pEntOrgMiniBuffer) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_2, &pEntMiniWindow) ;
	lispWindow_SetBuffer (pLispMgr, pEntMiniWindow, pEntOrgMiniBuffer) ;
	lispWindow_SetFocus (pEntMiniWindow, False) ;
	lispWindow_SetFocus (pEntWindow, True) ;

	lispMachineCode_PopLReg (pLM, LM_LREG_5) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_4) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_3) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_1) ;
	return	LMR_RETURN ;
}

/*
 *	(exit-recursive-edit)
 *
 *	exit-recursive-edit is an interactive built-in function.
 *
 *	Exit from the innermost recursive edit or minibuffer.
 *(*)
 *	exit-recursive-edit  exit-minibuffer ΰ㤤ʬ
 *	ʤ¬ʾκΤ
 */
TLMRESULT
lispMachineState_ExitRecursiveEdit (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntExit ;
	TLispEntity*	pEntNil ;

#if defined (DEBUG)
	fprintf (stderr, "exit-recursive-edit (%p)\n", pLM) ;
#endif

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	if (TFAILED (lispMgr_CreateNil (pLispMgr, &pEntNil)))
		return	LMR_ERROR ;
	pEntExit	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_EXIT) ;
	assert (pEntExit != NULL) ;
	lispMachineCode_SetException (pLM, pEntExit, pEntNil) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_AbortRecursiveEdit (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntExit ;
	register TLispEntity*	pEntQuit ;
	TLispEntity*	pEntT ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	if (TFAILED (lispMgr_CreateT (pLispMgr, &pEntT)))
		return	LMR_ERROR ;
	pEntExit	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_EXIT) ;
	assert (pEntExit != NULL) ;
	lispMachineCode_SetException (pLM, pEntExit, pEntT) ;
	return	LMR_RETURN ;
}

/*
 *	one-line å򥹥꡼κǲԤɽ롣ǽΰ
 *	ʸ format ǡĤ꤬ΰǡǤ롣ܺ٤ format
 *	򸫤뤳ȡ
 *
 *	ǽΰ nil ʤ顢¸ߤƤå򥯥ꥢ롣
 */
TLMRESULT
lispMachineState_Message (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	const Char*		pFormat ;
	int				nFormat ;
	TLispEntity*	pEntRetval ;
	TLispEntity*	pEntString ;

	assert (pLM      != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntString))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntString))) {
		lispMachineCode_SetMinibufferMessage (pLM, pEntString) ;
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntString) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_GetStringValue (pLispMgr, pEntString, &pFormat, &nFormat)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_Format (pLispMgr, pFormat, nFormat, pEntArglist, &pEntRetval))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	} else {
		lispMachineCode_SetMinibufferMessage (pLM, pEntRetval) ;
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
		return	LMR_RETURN ;
	}
}

/*
 *	(read-from-minibuffer PROMPT &optional INITIAL-CONTENTS KEYMAP READ HIST DEFAULT-VALUE INHERIT-INPUT-METHOD)
 */
TLMRESULT
lispMachineState_ReadFromMinibuffer (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntPrompt ;
	const Char*		pString ;
	int				nString ;
	TLispEntity*	pEntKeymap ;
	TLispEntity*	pEntInitialValue ;
	TLispEntity*	pEntBuffer ;
	TLMRESULT		retval ;
	const Char*		pStrInit ;
	int				nStrInit ;
	int				nPosition ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	/*
	 *	ʳǤϰ Eval ϺѤǤ롣
	 *	ϥꥹȤȤʤäơACC äƤ롣
	 */
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;

	(void) lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntPrompt) ;
	if (TFAILED (lispEntity_GetStringValue (pLispMgr, pEntPrompt, &pString, &nString)))
		goto	error ;
	(void) lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist) ;

	(void) lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntInitialValue) ;
	if (TFAILED (lispEntity_Nullp  (pLispMgr, pEntInitialValue))) {
		if (TSUCCEEDED (lispEntity_GetStringValue (pLispMgr, pEntInitialValue, &pStrInit, &nStrInit))) {
			nPosition	= -1 ;
		} else {
			TLispEntity*	pEntString ;
			TLispEntity*	pEntPosition ;
			long			lPosition ;
			if (TFAILED (lispEntity_Consp (pLispMgr, pEntInitialValue)))
				goto	error ;
			(void) lispEntity_GetCar (pLispMgr, pEntInitialValue, &pEntString) ;
			(void) lispEntity_GetCdr (pLispMgr, pEntInitialValue, &pEntPosition) ;
			if (TFAILED (lispEntity_GetStringValue (pLispMgr, pEntString, &pStrInit, &nStrInit)))
				goto	error ;
			if (TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntPosition, &lPosition)))
				goto	error ;
			nPosition	= lPosition ;
		}
	} else {
		pStrInit	= NULL ;
		nStrInit	= 0 ;
		nPosition	= -1 ;
	}
	(void) lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist) ;

	(void) lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntKeymap) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntKeymap))) {
		register TLispEntity*	pSymKeymap ;
		pSymKeymap	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_MINIBUFFER_LOCAL_MAP) ;
		if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pSymKeymap, &pEntKeymap)))
			goto	error ;
	}
	retval	= lispMachine_ReadStringStart (pLM, pString, nString, pEntKeymap) ;
	if (retval == LMR_ERROR)
		return	LMR_ERROR ;

	lispMachineCode_GetCurrentBuffer (pLM, &pEntBuffer) ;
	if (pStrInit != NULL && nStrInit > 0) {
		int		nPoint ;
		lispBuffer_Point (pLispMgr, pEntBuffer, &nPoint) ;
		lispBuffer_InsertString (pLispMgr, pEntBuffer, nPoint, pStrInit, nStrInit) ;
	}
	if (nPosition >= 0) {
		TLispEntity*	pMkPoint ;
		int				nPointMin, nPointMax ;
		lispBuffer_PointMin (pLispMgr, pEntBuffer, &nPointMin) ;
		lispBuffer_PointMax (pLispMgr, pEntBuffer, &nPointMax) ;
		if (nPosition < nPointMin)
			nPosition	= nPointMin ;
		if (nPosition > nPointMax)
			nPosition	= nPointMax ;
		lispBuffer_PointMarker (pLispMgr, pEntBuffer, &pMkPoint) ;
		lispMarker_SetBufferPosition (pLispMgr, pMkPoint, pEntBuffer, nPosition) ;
	}
	return	retval ;

  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

