/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

static	int	lispMachineState_keyBindingLookupKey (TLispMachine*, TLispEntity*, TLispEntity*, TLispEntity*, int, Boolean, Boolean, TLispEntity**) ;

/*
 *	(keymap CHARTABLE . ALIST) Ȥοޥåפä֤
 *	CHARTABLE ϼºݤˤ ASCII ʸ줿 char-table ʤΤ
 *	vector ѤƤ롣ALIST  function key  mouse event ʤ
 *	input stream ˤ¾βä assoc-list Ǥ롣
 *	ƤΥȥϺǽ nil ˡcommand undefinedפ̣Ƥ
 *	뤬Ƥ롣
 *
 *	optional  STRING ϥޥåפΥ˥塼̾ͿƤ롣x-popup-menu
 *	ǻȤ餷
 *
 *	(make-keymap &optional STRING)
 */
TLMRESULT
lispMachineState_MakeKeymap (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pString ;
	TLispEntity*	pKeymap ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pArglist, &pString))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMgr_CreateKeymap (pLispMgr, pString, &pKeymap))) 
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pKeymap) ;
	return	LMR_RETURN ;
}

/*
 *	(make-sparse-keymap &optional STRING)
 */
TLMRESULT
lispMachineState_MakeSparseKeymap (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pString ;
	TLispEntity*	pKeymap ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pArglist, &pString))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMgr_CreateSparseKeymap (pLispMgr, pString, &pKeymap))) 
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pKeymap) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_CopyKeymap (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntKeymap ;
	TLispEntity*	pEntRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntKeymap) ;
	if (TFAILED (lispMgr_CopyKeymap (pLispMgr, pEntKeymap, &pEntRetval))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	}
	return	LMR_RETURN ;
}

/*
 *	(keymapp OBJECT)
 *
 *	keymapp  built-in function Ǥ롣
 *	⤷ OBJECT ޥåפǤСt ֤
 *	ޥåפ (keymap . ALIST) ޤϡδؿޥåפǤ
 *	ܥǤ(θԤʸϤϰ̣)
 *	ALIST Ǥ (CHAR . DEFN) ޤ (SYMBOL . DEFN) Τ褦ʷ򤷤Ƥ
 *	롣vector λϡġ
 */
TLMRESULT
lispMachineState_Keymapp (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pEntity ;
	TLispEntity*	pRetval ;

	assert (pLM != NULL) ;

	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	/*
	 *	ʳǤϰ Eval ϺѤǤ롣
	 *	ϥꥹȤȤʤäơACC äƤ롣
	 */
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;

	if (TFAILED (lispEntity_GetCar (pLispMgr, pArglist, &pEntity))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TSUCCEEDED (lispEntity_Keymapp (pLispMgr, pEntity))) {
		lispMgr_CreateT   (pLispMgr, &pRetval) ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pRetval) ;
	return	LMR_RETURN ;
}

/*
 *
 */
TLMRESULT
lispMachineState_LookupKey (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pKey ;
	TLispEntity*	pKeymap ;
	TLispEntity*	pFunction ;
	TLispEntity*	pAcceptDefault ;
	Boolean			fAcceptDefault ;
	int				nMatch ;
	int				nLength ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	/*
	 *	ʳǤϰ Eval ϺѤǤ롣
	 *	ϥꥹȤȤʤäơACC äƤ롣
	 */
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	assert (pArglist != NULL) ;

	if (TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pKeymap)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pArglist, &pArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pKey)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pArglist, &pAcceptDefault))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_Nullp (pLispMgr, pAcceptDefault))) {
		fAcceptDefault	= True ;
	} else {
		fAcceptDefault	= False ;
	}
	/*	ACCEPT-DEFAULT Ϥޤʤ*/
	nMatch	= 0 ;
	if (TFAILED (lispKeymap_Lookup (pLispMgr, pKeymap, pKey, fAcceptDefault, False, &nMatch, &pFunction))) 
		lispMachineCode_SetError (pLM) ;

	(void) lispEntity_GetLength (pLispMgr, pKey, &nLength) ;
	if (nLength == nMatch) {
		/*	100% פˤϡ֤줿 function 򸫤롣*/
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pFunction) ;
	} else {
		TLispEntity*	hInteger ;
		
		/*	פʸ֤*/
		if (TFAILED (lispMgr_CreateInteger (pLispMgr, nMatch, &hInteger))) 
			return	LMR_ERROR ;
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, hInteger) ;
	}
	return	LMR_RETURN ;
}

/*
 *	(define-key KEYMAP KE DEF)
 *
 *	 KEYMAP, KEY, DEFKEYMAP   KEY 
 *	DEF Ȥ롣KEYMAP  keymap Ǥ롣KEY ʸޤ
 *	 symbol ʸΤΥ٥ȥǤ롣
 *	ASCII ʸ (127 Ķ)  vector ȤäƤʤޤ
 *	ȤǤ롣DEF  key Ǥ벿Ǥ롣
 *	nil  keymap ˤ
 *	command
 *	string
 *	keymap
 *	symbol
 *	cons (STRING . DEFN)
 *	... 
 */
TLMRESULT
lispMachineState_DefineKey (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pKEYMAP ;
	TLispEntity*	pKEY ;
	TLispEntity*	pDEF ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	assert (pArglist != NULL) ;

	if (TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pKEYMAP)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pArglist, &pArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pKEY)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pArglist, &pDEF))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	/*	pKEY  VECTOR ξϺϹͤƤʤ*/
	if (TSUCCEEDED (lispEntity_Vectorp (pLispMgr, pKEY))) {
		TLispEntity**	ppEntKeySeq ;
		int				nKeySeq ;

		(void) lispEntity_GetVectorValue (pLispMgr, pKEY, &ppEntKeySeq, &nKeySeq) ;
		if (TFAILED (lispKeymap_DefineKeyWithVector (pLispMgr, pKEYMAP, ppEntKeySeq, nKeySeq, pDEF)))
			lispMachineCode_SetError (pLM) ;
	} else {
		const Char*		pString ;
		int				nString ;

		if (TFAILED (lispEntity_GetStringValue (pLispMgr, pKEY, &pString, &nString))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
		if (TFAILED (lispKeymap_DefineKey (pLispMgr, pKEYMAP, pString, nString, pDEF))) 
			lispMachineCode_SetError (pLM) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pDEF) ;
	return	LMR_RETURN ;
}

/*
 *	(current-minor-mode-maps)
 *
 *	current-buffer  minor-modes ˳ƤƤ keymap Υꥹ
 *	֤
 *
 *	minor-mode-map-alist ˰פΤФơ
 *	(keymap1 keymap2 ...) Ȥ list 롣
 */
TLMRESULT
lispMachineState_CurrentMinorModeMaps (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntKeymaps ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	if (TFAILED (lispMachineCode_CurrentMinorModeMaps (pLM, &pEntKeymaps))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		lispMachineCode_SetLReg  (pLM, LM_LREG_1, pEntKeymaps) ;
	}
	return	LMR_RETURN ;
}

/*
 *	(use-local-map KEYMAP)
 *
 *	local keymap Ȥ KEYMAP 򤹤롣⤷ KEYMAP  nil ʤ
 *	local keymap ̵ˤ뤳Ȥ̣롣
 */
TLMRESULT
lispMachineState_UseLocalMap (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntKeymap ; 
	TLispEntity*	pEntCurBuffer ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntKeymap)) ||
		TFAILED (lispMachineCode_GetCurrentBuffer (pLM, &pEntCurBuffer))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispBuffer_SetKeymap (pLispMgr, pEntCurBuffer, pEntKeymap) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntKeymap) ;
	return	LMR_RETURN ;
}

/*
 *	(current-local-map)
 *
 *	current-buffer  local keymap ֤⤷äƤʤ
 *	nil ֤
 */
TLMRESULT
lispMachineState_CurrentLocalMap (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntCurBuffer ;
	TLispEntity*	pEntKeymap ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispMachineCode_GetCurrentBuffer (pLM, &pEntCurBuffer))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		if (TFAILED (lispBuffer_GetKeymap (pEntCurBuffer, &pEntKeymap)) ||
			pEntKeymap == NULL) 
			lispMgr_CreateNil (pLispMgr, &pEntKeymap) ;
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntKeymap) ;
	}
	return	LMR_RETURN ;
}

/*
 *	(where-is-internal DEFINITION &optional KEYMAP FIRSTONLY NOINDIRECT)
 *
 *	DEFINITION ƤӽФΥꥹȤ֤
 *	⤷ KEYMAP  nil ǤʤС KEYMAP  global keymap 
 *	롣
 *	⤷ KEYMAP  nil ʤС active  keymap Ƥ򸡺롣
 *	⤷ KEYMAP  keymap ΥꥹȤǤС keymap 򸡺
 *	롣
 *
 *	3ܤΰ FIRSTONLY  nil ǤʤСդäǽΥ
 *	󥹤֤(ƤΥ󥹤Ǥʤ)
 *	⤷ FIRSTONLY ܥ `non-ascii' ʤС줬Ǥ뤫ˤ
 *	餺ǽ˸դäХǥ󥰤֤
 *	FIRSTONLY ̤ non-nil value ǤСASCII ʸΥ󥹤֡
 *	˥塼Хǥ󥰤ϵݤ롣
 *	4ܤΰ NOINDIRECT  non-nil ʤС¾Υޥåפޤ slot 
 *	ؤδܻȤ˽ʤϴŪ򸡺뤳Ȥǽˤ롣
 *	If optional 4th arg NOINDIRECT is non-nil, don't follow indirections
 *	to other keymaps or slots.  This makes it possible to search for an
 *	indirect definition itself.
 *
 *	current-minor-mode-maps, current-local-map, global-map
 */
TLMRESULT
lispMachineState_WhereIsInternal (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntKeymap ;

	/*	not-implemented */
	lispMachineCode_GetCurrentBuffer (pLM, &pEntBuffer) ;
	return	LMR_RETURN ;
}

/*	built-in function
 *		(key-binding KEY &optional ACCEPT-DEFAULT)
 *
 *	ߤ keymap  KEY Ф륳ޥɤ֤KEY ʸޤ
 *	٥ȥޤϥȥǤ롣Хɤ¿ʬؿ
 *	äܥǤ
 *
 *	key-binding  default ΥХǥ󥰤Ȥư t 
 *	ФХǥ󥰤̵뤹롣
 */
TLMRESULT
lispMachineState_KeyBinding (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntKey ;
	TLispEntity*	pEntAcceptDefault ;
	TLispEntity*	pEntKeymap ;
	TLispEntity*	pEntFunc ;
	TLispEntity*	pEntSymGlobalMap ;
	TLispEntity*	pEntGlobalKeymap ;
	TLispEntity*	pEntCurBuffer ;
	Boolean			fAcceptDefault ;
	int				nLength ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntKey) ;
	lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntAcceptDefault) ;
	fAcceptDefault	= !lispEntity_Nullp (pLispMgr, pEntAcceptDefault) ;

	if (TFAILED (lispEntity_GetLength (pLispMgr, pEntKey, &nLength))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}

	lispMachineCode_GetCurrentBuffer (pLM, &pEntCurBuffer) ;
	assert (pEntCurBuffer != NULL) ;
	(void) lispBuffer_GetKeymap (pEntCurBuffer, &pEntKeymap) ;
	
	pEntSymGlobalMap	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_GLOBAL_MAP) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntSymGlobalMap, &pEntGlobalKeymap)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pEntGlobalKeymap))) 
		pEntGlobalKeymap	= NULL ;
	(void) lispMachineState_keyBindingLookupKey (pLM, pEntKeymap, pEntGlobalKeymap, pEntKey, nLength, False, fAcceptDefault, &pEntFunc) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntFunc) ;
	return	LMR_RETURN ;
}

/*	built-in function
 *		(j-key-binding KEY &optional ACCEPT-DEFAULT)
 *
 *	ߤ keymap  KEY Ф륳ޥɤ֤KEY ʸޤ
 *	٥ȥޤϥȥǤ롣Хɤ¿ʬؿ
 *	äܥǤ
 *
 *	key-binding  default ΥХǥ󥰤Ȥư t 
 *	ФХǥ󥰤̵뤹롣
 *
 *
 *	key-binding Ȥưΰ㤤ϡwindow-proc ƱͤΥȽ򤹤
 *	ȤǤ롣顢㤨С\C-\S-t  bind Ĵ٤ˤ 
 *	\C-\S-t  bind μ \C-t  bind 򸫤롣
 */
TLMRESULT
lispMachineState_JKeyBinding (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntKey ;
	TLispEntity*	pEntAcceptDefault ;
	TLispEntity*	pEntKeymap ;
	TLispEntity*	pEntFunc ;
	TLispEntity*	pEntSymGlobalMap ;
	TLispEntity*	pEntGlobalKeymap ;
	TLispEntity*	pEntCurBuffer ;
	Boolean			fAcceptDefault ;
	int				nLength ;
	register int	nMatch ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntKey) ;
	lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntAcceptDefault) ;
	fAcceptDefault	= !lispEntity_Nullp (pLispMgr, pEntAcceptDefault) ;

	if (TFAILED (lispEntity_GetLength (pLispMgr, pEntKey, &nLength))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}

	lispMachineCode_GetCurrentBuffer (pLM, &pEntCurBuffer) ;
	assert (pEntCurBuffer != NULL) ;
	(void) lispBuffer_GetKeymap (pEntCurBuffer, &pEntKeymap) ;
	
	pEntSymGlobalMap	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_GLOBAL_MAP) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntSymGlobalMap, &pEntGlobalKeymap)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pEntGlobalKeymap))) 
		pEntGlobalKeymap	= NULL ;
#if defined (DEBUG)
	fprintf (stderr, "key(%d, %d) = ", nLength, fAcceptDefault) ;
	lispEntity_Print (pLispMgr, pEntKey) ;
	fprintf (stderr, "\n") ;
#endif
	nMatch	= lispMachineState_keyBindingLookupKey (pLM, pEntKeymap, pEntGlobalKeymap, pEntKey, nLength, False, fAcceptDefault, &pEntFunc) ;
#if defined (DEBUG)
	fprintf (stderr, "[1] key-bind(%d) = ", nMatch) ;
	lispEntity_Print (pLispMgr, pEntFunc) ;
	fprintf (stderr, "\n") ;
#endif
	if (nMatch <= 0 || TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntFunc))) {
		nMatch	= lispMachineState_keyBindingLookupKey (pLM, pEntKeymap, pEntGlobalKeymap, pEntKey, nLength, True, fAcceptDefault, &pEntFunc) ;
#if defined (DEBUG)
		fprintf (stderr, "[2] key-bind(%d) = ", nMatch) ;
		lispEntity_Print (pLispMgr, pEntFunc) ;
		fprintf (stderr, "\n") ;
#endif
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntFunc) ;
	return	LMR_RETURN ;
}

int
lispMachineState_keyBindingLookupKey (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntLocalKeymap,
	register TLispEntity*	pEntGlobalKeymap,
	register TLispEntity*	pEntKey,
	register int			nLength,
	register Boolean		fNearMatch,
	register Boolean		fAcceptDefault,
	register TLispEntity**	ppEntRetval)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntFunc ;
	int				nMatch ;

	nMatch		= 0 ;
	pEntFunc	= NULL ;
	if (pEntLocalKeymap != NULL &&
		TSUCCEEDED (lispKeymap_Lookup (pLispMgr, pEntLocalKeymap, pEntKey, fAcceptDefault, fNearMatch, &nMatch, &pEntFunc)) &&
		TFAILED (lispEntity_Nullp (pLispMgr, pEntFunc)) &&
		nMatch > 0 && (nMatch == nLength || fAcceptDefault)) {
#if defined (DEBUG)
		fprintf (stderr, "[a] pEntFunc(%p), nMatch(%d), fAcceptDefault(%d), nLength(%d)\n",
				 pEntFunc, nMatch, fAcceptDefault, nLength) ;
#endif
		goto	keyhit ;
	}

	nMatch	= 0 ;
	if (pEntGlobalKeymap != NULL &&
		TFAILED (lispEntity_Voidp (pLispMgr, pEntGlobalKeymap))) {
		/*	ХåեˤޤäƤϤѤƥޥåפ*/
		lispKeymap_Lookup (pLispMgr, pEntGlobalKeymap, pEntKey, fAcceptDefault, fNearMatch, &nMatch, &pEntFunc) ;
#if defined (DEBUG)
		fprintf (stderr, "[b] pEntFunc(%p), nMatch(%d), fAcceptDefault(%d), nLength(%d)\n",
				 pEntFunc, nMatch, fAcceptDefault, nLength) ;
#endif
		if (pEntFunc == NULL || nMatch <= 0 || (nMatch != nLength && !fAcceptDefault)) 
			lispMgr_CreateNil (pLispMgr, &pEntFunc) ;
	} else {
#if defined (DEBUG)
		fprintf (stderr, "pEntGlobalKeymap (%p)\n", pEntGlobalKeymap) ;
#endif
		/*	ˤҥåȤʤС undefined Ǥ롣*/
		lispMgr_CreateNil (pLispMgr, &pEntFunc) ;
	}

 keyhit:
	if (ppEntRetval != NULL)
		*ppEntRetval	= pEntFunc ;
	return	nMatch ;
}


