/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

/*
 *	(selected-frame)
 *
 *	򤵤Ƥ frame ֤
 */
TLMRESULT
lispMachineState_SelectedFrame (register TLispMachine* pLM)
{
	TLispEntity*	pFrameEntity ;

	if (TFAILED (lispMachineCode_GetCurrentFrame (pLM, &pFrameEntity))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pFrameEntity) ;
	return	LMR_RETURN ;
}

/*
 *	(minibuffer-window &optional FRAME)
 *
 *	minibuffers Τ˺ȤäƤ window ֤⤷optional
 *	 FRAME ꤵƤС frame  minibuffer window
 *	֤
 */
TLMRESULT
lispMachineState_MinibufferWindow (
	register TLispMachine*	pLM)
{
	TLispEntity*	pArglist ;
	TLispEntity*	pFrameEntity ;
	TLispEntity*	pWindowEntity ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar (pLM->m_pLispMgr, pArglist, &pFrameEntity))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	/*
	 *	optional ꤵƤʤ current-frame  minibuffer 
	 *	ѤΤȲꤷƤ뤬줬Τɤʬʤ
	 */
	if (TSUCCEEDED (lispEntity_Nullp (pLM->m_pLispMgr, pFrameEntity))) 
		lispMachineCode_GetCurrentFrame (pLM, &pFrameEntity) ;

	if (TFAILED (lispFrame_GetMinibufferWindow (pFrameEntity, &pWindowEntity))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pWindowEntity) ;
	return	LMR_RETURN ;
}

/*
 *	(frame-list)
 *
 *	Ƥ frame ΥꥹȤ֤
 */
TLMRESULT
lispMachineState_FrameList (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pNil ;
	TLispEntity*	pFrameEntity ;
	TLispEntity*	pLastFrameEntity ;
	TLispEntity*	pNewNode ;
	TLispEntity*	pHead ;
	TLispEntity*	pTail ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetCurrentFrame (pLM, &pFrameEntity) ;
	assert (pFrameEntity != NULL) ;
	pLastFrameEntity	= pFrameEntity ;
	lispMgr_CreateNil (pLispMgr, &pNil) ;

	if (TFAILED (lispMgr_CreateConscell (pLispMgr, pFrameEntity, pNil, &pNewNode)))
		return	LMR_ERROR ;

	pHead	= pNewNode ;
	pTail	= pNewNode ;
	lispEntity_AddRef (pLispMgr, pHead) ;
	lispFrame_GetNext (pFrameEntity, &pFrameEntity) ;

	while (pFrameEntity != pLastFrameEntity) {
		if (TFAILED (lispMgr_CreateConscell (pLispMgr, pFrameEntity, pNil, &pNewNode))) {
			lispEntity_Release (pLispMgr, pHead) ;
			return	LMR_ERROR ;
		}
		(void) lispEntity_SetCdr (pLispMgr, pTail, pNewNode) ;
		pTail	= pNewNode ;
		lispFrame_GetNext (pFrameEntity, &pFrameEntity) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pHead) ;
	return	LMR_RETURN ;
}

/*
 *	(minibuffer-frame-list)
 *
 *	ʬȤ minibuffer äƤƤ frame ΥꥹȤ֤
 *[]
 *	ʬȤ minibuffer ʤ frame ¸ߤΤ
 *	Ĵ٤ƤߤȤFrame  Minibuffer Window ǡ
 *	Minibuffer Window  Window-Frame   Frame ǤΤ
 *	ФƤ褦̤ Frame ˤʤäƤȥХĤ餷
 */
TLMRESULT
lispMachineState_MinibufferFrameList (TLispMachine* pLM)
{
	return	LMR_ERROR ;
}

