/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include "jisyop.h"
#include "varbuffer.h"
#include "cstring.h"

#define	BUFSIZE				(512)
/* ''  '' ޤǡ*/
#define	MYCHAR_KANA_START	(Char_Make (KCHARSET_JISX0208_1983, 0x2421))
#define	MYCHAR_KANA_END		(Char_Make (KCHARSET_JISX0208_1983, 0x2473))
#define AFTER_KANA			(MYCHAR_KANA_END - MYCHAR_KANA_START + 1)
#define EOL					(0x0a)

#define	MYSTR1				";; okuri-ari entries."
#define	MYSTR2				" okuri-nasi entries."

/*
 *	Prototypes
 */
PSKKSORTEDJISYO	SkkSortedJisyo_Register (const Char*, int, int) ;
Boolean	SkkSortedJisyo_Unregister (const Char*, int) ;
static	Boolean	skkSortedJisyo_makeTab (PSKKSORTEDJISYO) ;
static	Boolean	skkSortedJisyo_makeNewTab (PSKKSORTEDJISYO) ;
static	Boolean	skkSortedJisyo_search (PSKKSORTEDJISYO, const Char*, int, int, long, TVarbuffer*) ;
static	Boolean	skkSortedJisyo_find (PSKKSORTEDJISYO, TVarbuffer*) ;
static	int		skkSortedJisyo_compare (Char, Char, int) ;

/*
 *	Global Variables
 */
static	PSKKSORTEDJISYO	pSortedjisyosTop	= NULL ;

/*
 *	Global Functions
 */
/*
 *	ȺѤ߼Ͽؿ
 */
PSKKSORTEDJISYO
SkkSortedJisyo_Register (
	register const Char*	pFileName,
	register int			nFileName,
	register int			nCodingSystem)
{
	TCHAR			strPath [PATH_MAX] ;
	PSKKSORTEDJISYO	pJisyo ;
	PSKKSORTEDJISYO	pPrevJisyo ;
	PSKKSORTEDJISYO	pNewJisyo ;
	int				nResult ;

	/*	ɽʸºݤ OS  filesystem ˻ȤäƤ coding system 
	 *	ʸѴ롣 ASCII ܤˤʤäƤ롣*/
	cstrtostr (strPath, pFileName, (nFileName < PATH_MAX)? nFileName : PATH_MAX) ;
	strPath [PATH_MAX - 1]	= '\0' ;

	/* ϿƤ뼭Ǥ뤫Ĵ٤롣*/
	pJisyo		= pSortedjisyosTop ;
	pPrevJisyo	= NULL ;
	while (pJisyo != NULL){
		nResult	= strcmp (pJisyo->m_tszPath, strPath) ;
		if (!nResult)
			return	pJisyo ;
		if (nResult > 0)
			break ;
		pPrevJisyo	= pJisyo ;
		pJisyo		= pJisyo->m_pNext ;
	}
	/* ե뤿Υǡΰݤ롣*/
	pNewJisyo	= MALLOC (sizeof (SKKSORTEDJISYO)) ;
	if (pNewJisyo == NULL)
		return	NULL ;

	strcpy (pNewJisyo->m_tszPath, strPath) ;
	KFile_Init (&pNewJisyo->m_JisyoFile) ;
	/* ե뤬¸ߤʤСϿ뤳ȤϽʤ*/
	if (!KFile_Open (&pNewJisyo->m_JisyoFile, pNewJisyo->m_tszPath, nCodingSystem)) 
		return	NULL ;

	/* ʸ沽ˡ򸡽Ф롣*/
	pNewJisyo->m_nCodingSystem	= KFile_GetCodingSystem (&pNewJisyo->m_JisyoFile) ;
	pNewJisyo->m_lFormat	= 0 ;
	/* ꥹȤ˲ä롣*/
	pNewJisyo->m_pNext		= pJisyo ;
	if (pPrevJisyo == NULL){
		pSortedjisyosTop	= pNewJisyo ;
	} else {
		pPrevJisyo->m_pNext	= pNewJisyo ;
	}
	/* 롣*/
	skkSortedJisyo_makeTab (pNewJisyo) ;
	return	pNewJisyo ;
}

/*
 *	ȺѤ߼鳰ؿ
 */
Boolean
SkkSortedJisyo_Unregister (
	register const Char*	pFileName,
	register int			nFileName)
{
	TCHAR			strPath [PATH_MAX] ;
	PSKKSORTEDJISYO	pJisyo ;
	PSKKSORTEDJISYO	pPrevJisyo ;
	int				nResult ;

	/*	ɽʸºݤ OS  filesystem ˻ȤäƤ coding system 
	 *	ʸѴ롣 ASCII ܤˤʤäƤ롣*/
	cstrtostr (strPath, pFileName, (nFileName < PATH_MAX)? nFileName : PATH_MAX) ;
	strPath [PATH_MAX - 1]	= '\0' ;

	pJisyo		= pSortedjisyosTop ;
	pPrevJisyo	= NULL ;
	while (pJisyo != NULL){
		nResult	= strcmp (pJisyo->m_tszPath, strPath) ;
		if (!nResult){
			if (pPrevJisyo == NULL){
				pSortedjisyosTop	= pJisyo->m_pNext ;
			} else {
				pPrevJisyo->m_pNext	= pJisyo->m_pNext ;
			}
			KFile_Close (&pJisyo->m_JisyoFile) ;
			FREE (pJisyo) ;
			return	True ;
		}
		if (nResult > 0)
			return	False ;
		pPrevJisyo	= pJisyo ;
		pJisyo		= pJisyo->m_pNext ;
	}
	return	False ;
}

PSKKSORTEDJISYO
SkkSortedJisyo_Find (
	register const Char*		pFileName,
	register int				nFileName)
{
	TCHAR						strPath [PATH_MAX] ;
	register PSKKSORTEDJISYO	pJisyo ;
	register int				nResult ;

	/*	ɽʸºݤ OS  filesystem ˻ȤäƤ coding system 
	 *	ʸѴ롣 ASCII ܤˤʤäƤ롣*/
	cstrtostr (strPath, pFileName, (nFileName < PATH_MAX)? nFileName : PATH_MAX) ;
	strPath [PATH_MAX - 1]	= '\0' ;

	pJisyo		= pSortedjisyosTop ;
	while (pJisyo != NULL){
		nResult	= strcmp (pJisyo->m_tszPath, strPath) ;
		if (!nResult)
			return	pJisyo ;
		if (nResult > 0)
			return	NULL ;
		pJisyo		= pJisyo->m_pNext ;
	}
	return	NULL ;
}

Boolean
SkkSortedJisyo_Search (
	register PSKKSORTEDJISYO	pJisyo,
	register const Char*		pKey,
	register int				nKey,
	register Boolean				fOkuri,
	register TVarbuffer*		pvbuf)
{
	Char		cc ;
	long		lStartPosition ;
	long		lEndPosition ;
	int			iSearchStyle ;

	if (pKey == NULL || nKey <= 0 || Char_IsNul (*pKey))
		return	True ;

	if (pJisyo->m_lFormat == 0){
		iSearchStyle	= 0 ;
	} else {
		iSearchStyle	= (fOkuri)? 1 : 2 ;
	}
	cc	= *pKey ;
	if ((iSearchStyle == 0) || (iSearchStyle == 2)) {
		if (cc < MYCHAR_KANA_START){
			if (iSearchStyle == 0){
				lStartPosition	= 0 ;
			} else { 
				lStartPosition	= pJisyo->m_lFormat ;
			}
			lEndPosition	= pJisyo->m_jtab2 [0] ;
		} else if (cc > MYCHAR_KANA_END){
			lStartPosition	= pJisyo->m_jtab2 [AFTER_KANA] ;
			lEndPosition	= pJisyo->m_jtab2 [AFTER_KANA + 1] ;
		} else {
			lStartPosition	= pJisyo->m_jtab2 [cc - MYCHAR_KANA_START] ;
			lEndPosition	= pJisyo->m_jtab2 [cc - MYCHAR_KANA_START + 1] ;
		} 
	} else {
		if (cc < MYCHAR_KANA_START) {
			lStartPosition	= pJisyo->m_jtab1 [AFTER_KANA] ;
			lEndPosition	= pJisyo->m_jtab1 [AFTER_KANA + 1] ;
		} else if (cc > MYCHAR_KANA_END){
			lStartPosition	= 0 ;
			lEndPosition	= pJisyo->m_jtab1 [0] ;
		} else {
			lStartPosition	= pJisyo->m_jtab1[MYCHAR_KANA_END - cc] ;
			lEndPosition	= pJisyo->m_jtab1[MYCHAR_KANA_END - cc + 1] ;
		}
	}
	KFile_Seekn (&pJisyo->m_JisyoFile, lStartPosition, SEEK_SET) ;
	return	skkSortedJisyo_search (pJisyo, pKey, nKey, iSearchStyle, lEndPosition, pvbuf) ;
}

/*
 *	Private Functions
 */
Boolean
skkSortedJisyo_makeTab (
	register PSKKSORTEDJISYO	pJisyo)
{
	register const char*	ptr ;
	register Char			cc ;

	KFile_Rewind (&pJisyo->m_JisyoFile) ;
  again:
	ptr	= MYSTR1 ;
	while (cc = KFile_Getc (&pJisyo->m_JisyoFile), cc != EOF && cc != '\n' && cc != '\r') {
		if (Char_DifferenceAscii (cc, *ptr))
			break ;
		ptr	++ ;
	}
	if (cc == EOF)
		return	False ;

	if (*ptr == '\0') {
		skkSortedJisyo_makeNewTab (pJisyo) ;
	} else if ((ptr - MYSTR1) > 2) {
		if (cc != '\n' && cc != '\r') 
			KFile_Nextline (&pJisyo->m_JisyoFile) ;
		goto	again ;
	} else {
#if 0
		skkSortedJisyo_makeOldTab (pJisyo) ;
#endif
		return	False ;
	}
	return	True ;
}

#if 0
BOOL	j_make_old_jisyo_tab (LPSKKSORTEDJISYO lpJisyo, unsigned char* pString)
{
	long*	pjtab ;
	int		c ;					/* one character */
	int		code ;				/* compared code */
	int		target ;			/* target code (2 bytes) */
	long	lFilePos ;

	pjtab		= lpJisyo->m_jtab2 ;
	code		= KANA_START ;
	target		= (*pString & 0xff) << 8 ;
	target		|= *++pString & 0xff ;

	while (target >= code && code <= KANA_END){
		*pjtab	++	= 0 ;
		code	++ ;
	}
    
	while ((c = winfgetc ((LPWINFILE)&(lpJisyo->m_JisyoFile))) != EOF){
		target		= ((c & 0xff) << 8) | (winfgetc ((LPWINFILE)&(lpJisyo->m_JisyoFile)) & 0xff) ;
		lFilePos	= winftell ((LPWINFILE)&(lpJisyo->m_JisyoFile)) ;
		while (target >= code && code <= KANA_END) {
			*pjtab	++	= lFilePos - 2 ;
			code	++ ;
		}
		while ((c = winfgetc ((LPWINFILE)&(lpJisyo->m_JisyoFile))) != EOF){
			if (c == EOL)
				break ;
			if (code > KANA_END) {
				lFilePos	= winftell ((LPWINFILE)&(lpJisyo->m_JisyoFile)) ;
				*pjtab	++	= lFilePos ;
				code	++ ;
				break;
			}
		}
	}
	lFilePos	= winftell ((LPWINFILE)&(lpJisyo->m_JisyoFile)) ;
	while (code <= KANA_END + 1) {
		*pjtab	++ = lFilePos ;
		code	++ ;
	}
	lFilePos	= winftell ((LPWINFILE)&(lpJisyo->m_JisyoFile)) ;
	*pjtab		= lFilePos ;		/* size of jisyo */
	winrewind ((LPWINFILE)&(lpJisyo->m_JisyoFile)) ;
	return	TRUE ;
}
#endif

Boolean
skkSortedJisyo_makeNewTab (
	register PSKKSORTEDJISYO	pJisyo)
{
	register const char*	ptr ;
	register Char			cc ;
	register Char			code ;			/* compared code */
	register Char			target ;		/* target code (2 bytes) */
	register long*			pjtab ;
	KFILEPOS				pos ;

	pjtab	= pJisyo->m_jtab1 ;
	code	= MYCHAR_KANA_END ;

	for ( ; ; ) {
		KFile_Tell (&pJisyo->m_JisyoFile, &pos) ;
		/*	ƬΣʸȴФ*/
		cc	= KFile_Getc (&pJisyo->m_JisyoFile) ;
		if (cc == EOF)
			break ;

		/*	ƬȤγϤ̣륻ߥ󤫡 */
		if (cc == ';'){
			/*	³ʸ˥ߥ󤫤ɤå롣*/
			cc	= KFile_Getc (&pJisyo->m_JisyoFile) ;
			if (cc == ';'){
				/*	ξˤ겾̵̾γϰ֤ɤå롣*/
				ptr	= MYSTR2 ;
				while (cc = KFile_Getc (&pJisyo->m_JisyoFile), cc != EOF && cc != EOL) {
					if (Char_DifferenceAscii (cc, *ptr))
						break ;
					ptr	++ ;
				}
				if (*ptr == '\0')
					break ;
				/*	겾̵̾γϰ֤Ǥ̵äΤǡιԤ̵뤹롣*/
				while (cc != EOF && cc != EOL)
					cc	= KFile_Getc (&pJisyo->m_JisyoFile) ;
				continue ;
			}			
		}
		/*	β̾ʸ  code ޤǤΥ򸽺ߤιƬꤹ롣*/
		target	= cc ;
		while (target <= code && MYCHAR_KANA_START <= code){ 
			*pjtab	++	= pos.m_lPosition ;
			code	-- ;
		}
		/*	ޤǥåפ롣*/
		while (cc = KFile_Getc (&pJisyo->m_JisyoFile), cc != EOF)
			if (cc == EOL)
				break ;

		/*	̾γϥɤޤ褿ˤȴ롣*/
		if (code < MYCHAR_KANA_START){
			KFile_Tell (&pJisyo->m_JisyoFile, &pos) ;
			*pjtab	++	= pos.m_lPosition ;
			code	++ ;
			break ;
		}
	}
	KFile_Tell (&pJisyo->m_JisyoFile, &pos) ;
	while (code >= MYCHAR_KANA_START - 1) {
		*pjtab	++	= pos.m_lPosition ;
		code	-- ;
	}
	*pjtab				= pos.m_lPosition ;
	pJisyo->m_lFormat	= pos.m_lPosition ;

	pjtab	= pJisyo->m_jtab2 ;
	code	= MYCHAR_KANA_START ;
	for ( ; ; ){
		KFile_Tell (&pJisyo->m_JisyoFile, &pos) ;
		/*	ƬΣʸȴФ*/
		cc	= KFile_Getc (&pJisyo->m_JisyoFile) ;
		if (cc == EOF)
			break ;

		target	= cc ;
		while (code <= target && code <= MYCHAR_KANA_END) { 
			*pjtab	++	= pos.m_lPosition ;
			code	++ ;
		}
		while (cc = KFile_Getc (&pJisyo->m_JisyoFile), cc != EOF)
			if (cc == EOL)
				break ;
		if (code > MYCHAR_KANA_END){
			KFile_Tell (&pJisyo->m_JisyoFile, &pos) ;
			*pjtab	++	= pos.m_lPosition ;
			code	++ ;
			break;
		}
	}
	KFile_Tell (&pJisyo->m_JisyoFile, &pos) ;
	while (code <= MYCHAR_KANA_END + 1) {
		*pjtab	++	= pos.m_lPosition ;
		code	++ ;
	}
	KFile_Tell (&pJisyo->m_JisyoFile, &pos) ;
	*pjtab		= pos.m_lPosition ;
	KFile_Rewind (&pJisyo->m_JisyoFile) ;
	return	True ;
}

Boolean
skkSortedJisyo_search (
	register PSKKSORTEDJISYO	pJisyo,
	register const Char*		pKey,
	register int				nKey,
	register int				iSearchStyle,
	register long				lEndPosition,
	register TVarbuffer*		pvbuf)
{
	register KFILE*				pFile = &pJisyo->m_JisyoFile ;
	register const Char*		ptr ;
	register int				nptr ;
	register Char				cc ;
	KFILEPOS					pos ;

	cc	= '\0' ;
	while (cc != EOF){
		ptr		= pKey ;
		nptr	= nKey ;
		while (nptr > 0) {
			cc	= KFile_Getc (pFile) ;
			if (cc == EOF)
				break ;
			if (*ptr != cc || cc == ' ' || cc == EOL)
				break ;
			ptr	 ++ ;
			nptr -- ;
		}
		if (nptr == 0) {
			cc	= KFile_Getc (pFile) ;
			if (cc == ' ') 
				return	skkSortedJisyo_find (pJisyo, pvbuf) ;
		}
		if (skkSortedJisyo_compare (*ptr, cc, iSearchStyle))
			break ; 

		while (cc = KFile_Getc (pFile), cc != EOF){
			if (cc == EOL)
				break ;
		}
		KFile_Tell (pFile, &pos) ;
		if (pos.m_lPosition > lEndPosition)
			break ;
	}
	return	True ;
}

int
skkSortedJisyo_compare (
	register Char	c1,
	register Char	c2,
	register int	f)
{
	if (c1 == ' ' || c1 == '\n')
		c1	= 0 ;
	if (c2 == ' ')
		c2	= 0 ;
	if (f != 1) {
		return	(c1 < c2) ;
	} else {
		return	(c1 > c2) ;
	}
}

Boolean
skkSortedJisyo_find (
	register PSKKSORTEDJISYO	pJisyo,
	register TVarbuffer*		pvbuf)
{
	Char			szBuffer [BUFSIZE] ;
	register KFILE*	pFile	= &pJisyo->m_JisyoFile ;
	register Char*	pDest ;
	register int	nDest ;
	register Char	cc ;

	pDest		= szBuffer ;
	nDest		= NELEMENTS (szBuffer) ;
	for ( ; ; ) {
		cc	= KFile_Getc (pFile) ;
		if (cc == EOL || cc == EOF)
			break ;
		if (nDest == 0) {
			if (TFAILED (TVarbuffer_Add (pvbuf, szBuffer, BUFSIZE)))
				return	False ;
			pDest	= szBuffer ;
			nDest	= NELEMENTS (szBuffer) ;
		}
		*pDest ++	= cc ;
		nDest  -- ;
	}
	if (nDest < NELEMENTS (szBuffer)) 
		if (TFAILED (TVarbuffer_Add (pvbuf, szBuffer, NELEMENTS (szBuffer) - nDest)))
			return	False ;
	return	True ;
}

