/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

/*
 *[ǽ]
 *	Lisp Machine  local ʥܥ(ѿ)롣ܥ̾
 *	Lisp  Entity Ϳ롣
 */
Boolean
lispMachine_MakeSymbolValue (
	register TLispMachine*	pLM,
	register TLispEntity*	pSymbol,
	register TLispBind**	ppBindReturn)
{
	assert (pLM      != NULL) ;
	assert (pSymbol  != NULL) ;

	return	lispBindTable_MakeEntry (pLM->m_pLispMgr, pLM->m_apVariableTable, NELEMENTS (pLM->m_apVariableTable), pSymbol, ppBindReturn) ;
}

/*
 *[ǽ]
 *	Lisp Machine  Local ʥܥ(ѿ)롣ܥ̾
 *	Char ʸͿ롣
 */
Boolean
lispMachine_MakeSymbolValueWithName (
	register TLispMachine*	pLM,
	register const Char*	pName,
	register const int		nName,
	register TLispBind**	ppBindReturn)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntSymbol ;
	assert (pLM      != NULL) ;

	pLispMgr	= pLM->m_pLispMgr ;
	if (TFAILED (lispMgr_InternSymbol (pLispMgr, pName, nName, &pEntSymbol)))
		return	False ;
	return	lispBindTable_MakeEntry (pLispMgr, pLM->m_apVariableTable, NELEMENTS (pLM->m_apVariableTable), pEntSymbol, ppBindReturn) ;
}

/*
 *[ǽ]
 *	Local ʤΤ֤˥ܥ(ѿ)¸ߤ뤫ǧơդä
 *	ܥФͤ򥻥åȤ롣
 *	Global ʥܥޤ¸ߤʤäˤϡGlobal ܥ
 *	ͤ򥻥åȤ롣
 */
Boolean
lispMachine_SetCurrentSymbolValue (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntSymbol,
	register TLispEntity*	pEntValue)
{
	assert (pLM        != NULL) ;
	assert (pEntSymbol != NULL) ;
	assert (pEntValue  != NULL) ;

	return	(lispMachine_SetCurrentBufferLocalSymbolValue (pLM, pEntSymbol, pEntValue) ||
			 lispMachine_SetGlobalSymbolValue      (pLM, pEntSymbol, pEntValue)) ;
}

/*
 *[ǽ]
 *	buffer-local-variable ͤꤹ롣
 *[]
 *	Lisp ̿ buffer-local-variable ؤơͤ򥻥åȤ
 *	Τ뤫ɤʬʤĴ­⤷ʤ
 */
Boolean
lispMachine_SetCurrentBufferLocalSymbolValue (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntSymbol,
	register TLispEntity*	pEntValue)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntBuffer ;

	assert (pLM        != NULL) ;
	assert (pEntSymbol != NULL) ;
	assert (pEntValue  != NULL) ;

	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr   != NULL) ;
	pEntBuffer	= pLM->m_pCurBuffer ;

	/*	ιԤϰŪʤΤ*/
	if (pEntBuffer == NULL)
		return	False ;

	return	lispBuffer_SetSymbolValue (pLispMgr, pEntBuffer, pEntSymbol, pEntValue) ;
}

/*
 *[ǽ]
 *	Lisp Machine  Local ʥܥͤ򥻥åȤ롣
 */
Boolean
lispMachine_SetGlobalSymbolValue (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntSymbol,
	register TLispEntity*	pEntValue)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispBind*	pBind ;

	assert (pLM             != NULL) ;
	assert (pLM->m_pLispMgr != NULL) ;
	assert (pEntSymbol      != NULL) ;

	if (TFAILED (lispBindTable_SearchEntry (pLispMgr, pLM->m_apVariableTable, NELEMENTS (pLM->m_apVariableTable), pEntSymbol, &pBind)) ||
		pBind == NULL) {
		if (TFAILED (lispBindTable_MakeEntry (pLispMgr, pLM->m_apVariableTable, NELEMENTS (pLM->m_apVariableTable), pEntSymbol, &pBind)))
			return	False ;
	}
	lispBind_SetValue (pLispMgr, pBind, pEntValue) ;
	return	True ;
}

/*
 *[ǽ]
 *	buffer-local-variable ͤ򥻥åȤ롣ܥ Char ʸͿ롣
 */
Boolean
lispMachine_SetCurrentBufferLocalSymbolValueWithName (
	register TLispMachine*	pLM,
	register const Char*	pName,
	register const int		nName,
	register TLispEntity*	pEntValue)
{
	assert (pLM       != NULL) ;
	assert (pName     != NULL && nName > 0) ;
	assert (pEntValue != NULL) ;

	/*	ιԤϰŪʤΤ*/
	if (pLM->m_pCurBuffer == NULL)
		return	False ;

	return	lispBuffer_SetSymbolValueWithName (pLM->m_pLispMgr, pLM->m_pCurBuffer, pName, nName, pEntValue) ;
}

/*
 *[ǽ]
 *	Lisp Machine  local ʥܥͤ򥻥åȤ롣ܥ Char ʸ
 *	ǻꤹ롣
 */
Boolean
lispMachine_SetGlobalSymbolValueWithName (
	register TLispMachine*	pLM,
	register const Char*	pName,
	register const int		nName,
	register TLispEntity*	pEntValue)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntSymbol ;
	TLispBind*		pBind ;

	assert (pLM             != NULL) ;
	assert (pLM->m_pLispMgr != NULL) ;
	assert (pName           != NULL && nName > 0) ;
	assert (pEntValue       != NULL) ;

	if (TFAILED (lispMgr_InternSymbol (pLispMgr, pName, nName, &pEntSymbol)))
		return	False ;

	if (TFAILED (lispBindTable_SearchEntry (pLispMgr, pLM->m_apVariableTable, NELEMENTS (pLM->m_apVariableTable), pEntSymbol, &pBind)) ||
		pBind == NULL) {
		if (TFAILED (lispBindTable_MakeEntry (pLispMgr, pLM->m_apVariableTable, NELEMENTS (pLM->m_apVariableTable), pEntSymbol, &pBind)))
			return	False ;
	}
	lispBind_SetValue (pLispMgr, pBind, pEntValue) ;
	return	True ;
}

/*
 *[ǽ]
 *	Symbol ̾ǤäơSymbol ͤƤ롣Local ʤΤ Global 
 *	ΤؤȽ֤ Symbol ͤƤƤ뤫Ƥ
 *	ǽŪï⤽ Symbol ͤƤƤʤСGlobal  Symbol 
 *	Value ȤͤƤ뤳Ȥˤʤ롣
 *	Buffer Local  Machine Local  Symbol ͤƤˤϡ
 *	ѰդƤɬפ롣
 */
Boolean
lispMachine_SetCurrentSymbolValueWithName (
	register TLispMachine*	pLM,
	register const Char*	pName,
	register const int		nName,
	register TLispEntity*	pEntValue)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntSymbol ;

	assert (pLM       != NULL) ;
	assert (pName     != NULL && nName > 0) ;
	assert (pEntValue != NULL) ;

	if (TFAILED (lispMgr_InternSymbol (pLispMgr, pName, nName, &pEntSymbol)))
		return	False ;

	return	(lispMachine_SetCurrentBufferLocalSymbolValue (pLM, pEntSymbol, pEntValue) ||
			 lispMachine_SetGlobalSymbolValue      (pLM, pEntSymbol, pEntValue)) ;
}

Boolean
lispMachine_SetCurrentSymbolValueWithNameA (
	register TLispMachine*	pLM,
	register const char*	pName,
	register const int		nName,
	register TLispEntity*	pEntValue)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntSymbol ;

	assert (pLM       != NULL) ;
	assert (pName     != NULL && nName > 0) ;
	assert (pEntValue != NULL) ;

	if (TFAILED (lispMgr_InternSymbolA (pLispMgr, pName, nName, &pEntSymbol)))
		return	False ;

	return	(lispMachine_SetCurrentBufferLocalSymbolValue (pLM, pEntSymbol, pEntValue) ||
			 lispMachine_SetGlobalSymbolValue      (pLM, pEntSymbol, pEntValue)) ;
}

/*
 *[ǽ]
 *	ܥ˳ƤƤͤ롣local ʤΤ֤˸
 *	դäȤǡΥܥͤ롣ܥ entity ǻ
 *	롣
 *[]
 *	entity ΥפܥǤʤХ顼ˤʤ롣
 */
Boolean
lispMachine_GetCurrentSymbolValue (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntTarget,
	register TLispEntity** const	ppEntReturn)
{
	assert (pLM         != NULL) ;
	assert (pEntTarget  != NULL) ;
	assert (ppEntReturn != NULL) ;

	return	(lispMachine_GetCurrentBufferLocalSymbolValue (pLM, pEntTarget, ppEntReturn) ||
			 lispMachine_GetGlobalSymbolValue (pLM, pEntTarget, ppEntReturn)) ;
}

Boolean
lispMachine_GetCurrentBufferLocalSymbolValue (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntTarget,
	register TLispEntity** const	ppEntReturn)
{
	return	lispMachine_GetBufferLocalSymbolValue (pLM, pLM->m_pCurBuffer, pEntTarget, ppEntReturn) ;
}

Boolean
lispMachine_GetGlobalSymbolValue (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntSymbol,
	register TLispEntity** const	ppEntReturn)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;

	assert (pLM             != NULL) ;
	assert (pLispMgr        != NULL) ;
	assert (pEntSymbol      != NULL) ;
	assert (ppEntReturn     != NULL) ;

	while (pLM != NULL) {
		if (TSUCCEEDED (lispBindTable_GetEntryValue (pLispMgr, pLM->m_apVariableTable, NELEMENTS (pLM->m_apVariableTable), pEntSymbol, ppEntReturn)))
			return	True ;
		pLM	= pLM->m_pMacParent ;
	}
	return	False ;
}

Boolean
lispMachine_GetSymbolValue (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntBuffer,
	register TLispEntity*			pEntTarget,
	register TLispEntity** const	ppEntReturn)
{
	return	(lispMachine_GetBufferLocalSymbolValue (pLM, pEntBuffer, pEntTarget, ppEntReturn) ||
			 lispMachine_GetGlobalSymbolValue (pLM, pEntTarget, ppEntReturn)) ;
}

Boolean
lispMachine_GetBufferLocalSymbolValue (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntBuffer,
	register TLispEntity*			pEntTarget,
	register TLispEntity** const	ppEntReturn)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register Boolean			fRetval ;
	TLispEntity*	pEntRetval ;

	assert (pLM         != NULL) ;
	assert (pEntTarget  != NULL) ;
	assert (pEntBuffer  != NULL) ;
	assert (ppEntReturn != NULL) ;

	fRetval	= lispBuffer_GetSymbolValue (pLispMgr, pEntBuffer, pEntTarget, &pEntRetval) ;
	if (TFAILED (fRetval) ||
		pEntRetval == NULL ||
		TSUCCEEDED (lispEntity_Emptyp (pLispMgr, pEntRetval)))
		return	False ;
	*ppEntReturn	= pEntRetval ;
	return	True ;
}

Boolean
lispMachine_GetCurrentSymbolValueWithName (
	register TLispMachine*			pLM,
	register const Char*			pName,
	register const int				nName,
	register TLispEntity** const	ppReturn)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntSymbol ;

	assert (pLM      != NULL) ;
	assert (ppReturn != NULL) ;

	if (TFAILED (lispMgr_InternSymbol (pLispMgr, pName, nName, &pEntSymbol)))
		return	False ;

	return	(lispMachine_GetCurrentBufferLocalSymbolValue (pLM, pEntSymbol, ppReturn) ||
			 lispMachine_GetGlobalSymbolValue (pLM, pEntSymbol, ppReturn)) ;
}

Boolean
lispMachine_GetCurrentBufferLocalSymbolValueWithName (
	register TLispMachine*			pLM,
	register const Char*			pName,
	register const int				nName,
	register TLispEntity** const	ppEntReturn)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntBuffer	= pLM->m_pCurBuffer ;
	register Boolean			fRetval ;
	TLispEntity*	pEntRetval ;

	assert (pLM      != NULL) ;
	assert (pName    != NULL && nName > 0) ;
	assert (ppEntReturn != NULL) ;

	/*	ιԤϰŪʤΤ*/
	if (pLM->m_pCurBuffer == NULL)
		return	False ;

	fRetval	= lispBuffer_GetSymbolValueWithName (pLispMgr, pEntBuffer, pName, nName, &pEntRetval) ;
	if (TFAILED (fRetval) ||
		pEntRetval == NULL ||
		TSUCCEEDED (lispEntity_Emptyp (pLispMgr, pEntRetval)))
		return	False ;
	*ppEntReturn	= pEntRetval ;
	return	True ;

}

Boolean
lispMachine_GetGlobalSymbolValueWithName (
	register TLispMachine*			pLM,
	register const Char*			pName,
	register const int				nName,
	register TLispEntity** const	ppEntReturn)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntSymbol ;

	assert (pLM             != NULL) ;
	assert (pLM->m_pLispMgr != NULL) ;

	if (TFAILED (lispMgr_InternSymbol (pLispMgr, pName, nName, &pEntSymbol)))
		return	False ;

	while (pLM != NULL) {
		if (TSUCCEEDED (lispBindTable_GetEntryValue (pLispMgr, pLM->m_apVariableTable, NELEMENTS (pLM->m_apVariableTable), pEntSymbol, ppEntReturn)))
			return	True ;
		pLM	= pLM->m_pMacParent ;
	}
	return	False ;
}

Boolean
lispMachine_SetSymbolFunctionValue (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntSymbol,
	register TLispEntity*			pEntValue)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispBind*	pBind ;

	assert (pLM         != NULL) ;
	assert (pEntSymbol  != NULL) ;
	assert (pEntValue   != NULL) ;

	if (TFAILED (lispBindTable_SearchEntry (pLispMgr, pLM->m_apFunctionTable, NELEMENTS (pLM->m_apFunctionTable), pEntSymbol, &pBind)) ||
		pBind == NULL) {
		if (TFAILED (lispBindTable_MakeEntry (pLispMgr, pLM->m_apFunctionTable, NELEMENTS (pLM->m_apFunctionTable), pEntSymbol, &pBind)))
			return	False ;
	}
	lispBind_SetValue (pLispMgr, pBind, pEntValue) ;
	return	True ;
}

Boolean
lispMachine_GetSymbolFunctionValue (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntTarget,
	register TLispEntity** const	ppEntReturn)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	const LMCMDINFO*	pProcInfo ;

	assert (pLM         != NULL) ;
	assert (pEntTarget  != NULL) ;
	assert (ppEntReturn != NULL) ;

	while (pLM != NULL) {
		if (TSUCCEEDED (lispBindTable_GetEntryValue (pLispMgr, pLM->m_apFunctionTable, NELEMENTS (pLM->m_apFunctionTable), pEntTarget, ppEntReturn)))
			return	True ;
		pLM	= pLM->m_pMacParent ;
	}
	/*	builtin function ˤʤĴ٤롣*/
	if (TFAILED (lispMachine_SearchBuiltinFunction (pLispMgr, pEntTarget, &pProcInfo)) ||
		pProcInfo == NULL) 
		return	False ;

	return	lispMgr_CreateSubr (pLispMgr, pProcInfo, ppEntReturn) ;
}

Boolean
lispMachine_GetFinalSymbolFunctionValue (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntTarget,
	register TLispEntity**	ppEntReturn)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntValue ;
	register int	nCount		= MAX_NEST_COUNT ;

	assert (pLM != NULL) ;
	assert (pEntTarget  != NULL) ;
	assert (ppEntReturn != NULL) ;

	pLispMgr	= pLM->m_pLispMgr ;
	while (TSUCCEEDED (lispEntity_Symbolp (pLispMgr, pEntTarget)) &&
		   nCount -- > 0) {
		if (TFAILED (lispMachine_GetSymbolFunctionValue (pLM, pEntTarget, &pEntValue))) {
#if 1
			fprintf (stderr, "void function: ") ;
			lispEntity_Print (pLispMgr, pEntTarget) ;
#endif
		}
		pEntTarget	= pEntValue ;
	}
	if (nCount == 0)
		return	False ;
	*ppEntReturn	= pEntValue ;
	return	True ;
}

Boolean
lispMachine_SetSymbolProperty (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntSymbol,
	register TLispEntity* 			pEntValue)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispBind*	pBind ;

	assert (pLM         != NULL) ;
	assert (pEntSymbol  != NULL) ;
	assert (pEntValue   != NULL) ;

	if (TFAILED (lispBindTable_SearchEntry (pLispMgr, pLM->m_apPropertyTable, NELEMENTS (pLM->m_apPropertyTable), pEntSymbol, &pBind)) ||
		pBind == NULL) {
		if (TFAILED (lispBindTable_MakeEntry (pLispMgr, pLM->m_apPropertyTable, NELEMENTS (pLM->m_apPropertyTable), pEntSymbol, &pBind)))
			return	False ;
	}
	lispBind_SetValue (pLispMgr, pBind, pEntValue) ;
	return	True ;
}

Boolean
lispMachine_GetSymbolProperty (
	register TLispMachine*			pLM,
	register TLispEntity*			pEntSymbol,
	register TLispEntity**			ppEntReturn)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;

	assert (pLM         != NULL) ;
	assert (pEntSymbol  != NULL) ;
	assert (ppEntReturn != NULL) ;

	while (pLM != NULL) {
		if (TSUCCEEDED (lispBindTable_GetEntryValue (pLispMgr, pLM->m_apPropertyTable, NELEMENTS (pLM->m_apPropertyTable), pEntSymbol, ppEntReturn)))
			return	True ;
		pLM	= pLM->m_pMacParent ;
	}
	return	False ;
}

