/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lmcode_h)
#define	lmcode_h

Boolean		lispMachineCode_PushVReg	(TLispMachine*, int) ;
Boolean		lispMachineCode_PopVReg		(TLispMachine*, int) ;
Boolean		lispMachineCode_SetVRegI	(TLispMachine*, int, long) ;
Boolean		lispMachineCode_SetVRegP	(TLispMachine*, int, void*) ;
Boolean		lispMachineCode_GetVRegI	(TLispMachine*, int, long*) ;
Boolean		lispMachineCode_GetVRegP	(TLispMachine*, int, void**) ;
Boolean		lispMachineCode_MoveVReg	(TLispMachine*, int, int) ;
Boolean		lispMachineCode_Evaln		(TLispMachine*, TLispEntity*, TLMRESULT (*)(TLispMachine*)) ;
Boolean		lispMachineCode_Car			(TLispMachine*, int, int) ;
Boolean		lispMachineCode_SetCurrentFrame	(TLispMachine*, TLispEntity*) ;
Boolean		lispMachineCode_GetCurrentFrame	(TLispMachine*, TLispEntity**) ;
Boolean		lispMachineCode_SetCurrentWindow(TLispMachine*, TLispEntity*) ;
Boolean		lispMachineCode_GetCurrentWindow(TLispMachine*, TLispEntity**) ;
Boolean		lispMachineCode_SetCurrentBuffer(TLispMachine*, TLispEntity*) ;
Boolean		lispMachineCode_GetCurrentBuffer(TLispMachine*, TLispEntity**) ;
Boolean		lispMachineCode_SetException	(TLispMachine*, TLispEntity*, TLispEntity*) ;
Boolean		lispMachineCode_GetException	(TLispMachine*, TLispEntity**, TLispEntity**) ;
Boolean		lispMachineCode_ResetException	(TLispMachine*) ;
Boolean		lispMachineCode_SetSignal		(TLispMachine*, TLispEntity*, TLispEntity*) ;
Boolean		lispMachineCode_GetSignal		(TLispMachine*, TLispEntity**, TLispEntity**) ;
Boolean		lispMachineCode_ResetSignal		(TLispMachine*) ;
Boolean		lispMachineCode_SetError		(TLispMachine*) ;
Boolean		lispMachineCode_SetErrorEx		(TLispMachine*, TLispEntity*) ;
Boolean		lispMachineCode_SetMessage		(TLispMachine*, TLispEntity*) ;
Boolean		lispMachineCode_CurrentMinorModeMaps (TLispMachine*, TLispEntity**) ;

Boolean		lispMachineCode_PushThisCommandKeys (TLispMachine*, const Char) ;
Boolean		lispMachineCode_GetThisCommandKeys (TLispMachine*, Char const **, int* const) ;
Boolean		lispMachineCode_ClearThisCommandKeys (TLispMachine*) ;

Boolean		lispMachineCode_SetRegmatchTarget (TLispMachine*, TLispEntity*) ;
Boolean		lispMachineCode_StringMatch		(TLispMachine*, const Char*, int, const Char*, int) ;
Boolean		lispMachineCode_SearchForward	(TLispMachine*, TLispEntity*, const Char*, int, int, int) ;
Boolean		lispMachineCode_SearchBackward	(TLispMachine*, TLispEntity*, const Char*, int, int, int) ;
Boolean		lispMachineCode_ReSearchForward	(TLispMachine*, TLispEntity*, const Char*, int, int, int) ;
Boolean		lispMachineCode_ReSearchBackward(TLispMachine*, TLispEntity*, const Char*, int, int, int) ;
Boolean		lispMachineCode_MatchBeginning	(TLispMachine*, int, int*) ;
Boolean		lispMachineCode_MatchEnd		(TLispMachine*, int, int*) ;
Boolean		lispMachineCode_MatchData		(TLispMachine*, TLispEntity**) ;
Boolean		lispMachineCode_CreateMarker	(TLispMachine*, TLispEntity*, int, TLispEntity**) ;
Boolean		lispMachineCode_Featurep		(TLispMachine*, TLispEntity*) ;
Boolean		lispMachineCode_Provide			(TLispMachine*, TLispEntity*) ;

#endif

