/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lispmachinep_h)
#define	lispmachinep_h

#include "lmachine.h"
#include "lmstate.h"
#include "lmcode.h"
#include "lmsymbol.h"
#if !defined (regcustom_h)
#define	regcustom_h
#include "regcustom.h"
#endif

#define	LISPMACHINE_EXCEPTIONP(pLM)				 ((pLM)->m_uStatusFlag & LMSTATE_EXCEPTION)
#define	LISPMACHINE_SIGNALP(pLM)				 ((pLM)->m_uStatusFlag & LMSTATE_SIGNAL)
#define	LISPMACHINE_EXIT_RECURSIVE_EDITP(pLM)	 ((pLM)->m_uStatusFlag & LMSTATE_EXIT_RECURSIVE_EDIT)
#define	LISPMACHINE_EXCEPTIONORSIGNALP(pLM) ((pLM)->m_uStatusFlag & (LMSTATE_EXCEPTION | LMSTATE_SIGNAL | LMSTATE_EXIT_RECURSIVE_EDIT))

#define	LISPMACHINE_RESET_EXCEPTION(pLM)	{ (pLM)->m_uStatusFlag &= ~LMSTATE_EXCEPTION ; }
#define	LISPMACHINE_RESET_SIGNAL(pLM)		{ (pLM)->m_uStatusFlag &= ~LMSTATE_SIGNAL ; }
#define	LISPMACHINE_RESET_ERROR(pLM)		{ (pLM)->m_uStatusFlag &= ~LMSTATE_ERROR ; }
#define	LISPMACHINE_RESET_EXIT_RECURSIVE_EDIT(pLM)	{ (pLM)->m_uStatusFlag &= ~LMSTATE_EXIT_RECURSIVE_EDIT ; }

enum {
	LISPCMD_ARGTYPE_NORMAL	= 0,
	LISPCMD_ARGTYPE_LOWER,
	LISPCMD_ARGTYPE_UPPER,
	LISPCMD_ARGTYPE_NOBOUND,
	LISPCMD_ARGTYPE_CDR,
	LISPCMD_ARGTYPE_LAMBDA,
	LISPCMD_ARGTYPE_MACRO,
	LISPCMD_ARGTYPE_SPECIAL,
} ;

enum {
	LMSTATE_SIGNAL				= 1 << 0,
	LMSTATE_EXCEPTION			= 1 << 1,
	LMSTATE_EXIT_RECURSIVE_EDIT	= 1 << 2,	/* abort  + SIGNAL  QUIT */
} ;

enum {
	LM_LREG_ACC			= 0,
	LM_LREG_1,
	LM_LREG_2,
	LM_LREG_3,
	LM_LREG_4,
	LM_LREG_5,
	LM_LREG_6,
	LM_LREG_7,
	LM_LREG_8,
	MAX_LISPOBJ_REGS,
} ;

enum {
	LM_VREG_1			= 0,
	LM_VREG_2,
	LM_VREG_3,
	LM_VREG_4,
	MAX_NONLISPOBJ_REGS,
} ;


#define	MAX_REGEXP_MATCHES		(32)

typedef union tagTNotLispValue {
	long		m_lValue ;
	void*		m_pvValue ;
	TLMRESULT	(*m_pState)(struct tagTLispMachine*) ;
}	TNotLispValue ;	/* not-lispobject value */

/*
 *	Lisp ۵
 */
struct tagTLispMachine {
	struct tagTLispManager*	m_pLispMgr ;

	struct tagTLispEntity*	m_apLREGS [MAX_LISPOBJ_REGS] ;
	union  tagTNotLispValue	m_alVREGS [MAX_NONLISPOBJ_REGS] ;

	struct tagTLispEntity*	m_pTarget ;			/* ɾ symbol */
	struct tagTLispEntity*	m_pEntSignal ;
	struct tagTLispEntity*	m_pEntSignalValue ;
	struct tagTLispEntity*	m_pEntException ;	/* 㳰*/
	struct tagTLispEntity*	m_pEntExceptionValue ;

	unsigned				m_uStatusFlag ;
	VStack					m_vstLispObj ;		/* Lisp Object Ѥ stack */
	VStack					m_vstNonLispObj ;	/*  Lisp Object Ѥ stack */
	Boolean					m_fCalledInteractively ;
	Boolean					m_fInteractive ;

	struct tagTLispEntity*	m_lstBuffer ;		/* ring list ˤ褦*/
	struct tagTLispEntity*	m_lstFrame ;		/* ring list ˤ褦*/

	struct tagTLispEntity*	m_pCurBuffer ;
	struct tagTLispEntity*	m_pCurWindow ;
	struct tagTLispEntity*	m_pCurFrame ;

	/*	Lisp Machine  Local ѿ Lisp 
	 *	ǤΤǤϤʤ*/
	struct tagTLispBind*	m_apVariableTable [SIZE_LISP_BIND_TABLE] ;
	struct tagTLispBind*	m_apFunctionTable [SIZE_LISP_BIND_TABLE] ;
	struct tagTLispBind*	m_apPropertyTable [SIZE_LISP_BIND_TABLE] ;

	TLMRESULT				(*m_pState)(struct tagTLispMachine*) ;
	struct tagTLispMachine*	m_pMacParent ;

	/*	LispMachine Ф볰Υ٥ȤǼХåե
	 *	Ĺ(̵̤ΰ礭᤮ƤǽϤ롣*/
	TVarbuffer				m_vbufCmdEvents ;

	/*	match-data оݤȤʤäenitityʸޤϥХåե롣*/
	struct tagTLispEntity*	m_pEntRegMatch ;
	regmatch_t				m_aRegMatch [MAX_REGEXP_MATCHES] ;
} ;

typedef struct tagLMCMDINFO {
	const Char*	m_pName ;
	const Char*	m_pInteractive ;
	int			m_iArgtype ;
	int			m_nMinArgNum ;
	int			m_nMaxArgNum ;
	TLMRESULT	(*m_pProc)(struct tagTLispMachine*) ;
}	LMCMDINFO ;

/*	Prototypes */
TLMRESULT	lispMachine_ExecuteLoop		(TLispMachine*) ;
Boolean		lispMachine_ActivateAllFrame(TLispMachine*, Boolean) ;
Boolean		lispMachine_CheckArgument	(TLispMachine*, TLispEntity*, LMCMDINFO const*, int*) ;
Boolean		lispMachine_Errorp			(TLispMachine*) ;
Boolean		lispMachine_ErrorExceptionOrSignalp	(TLispMachine*) ;
Boolean		lispMachine_ShowRegisterValue	(TLispMachine*) ;

Boolean		lispMachine_SearchBuiltinFunction	(TLispManager*, TLispEntity*, LMCMDINFO const **) ;

Boolean		lispMachine_InsertBuffer	(TLispMachine*, TLispEntity*) ;
Boolean		lispMachine_RemoveBuffer	(TLispMachine*, TLispEntity*) ;
Boolean		lispMachine_InsertFrame		(TLispMachine*, TLispEntity*) ;
Boolean		lispMachine_RemoveFrame		(TLispMachine*, TLispEntity*) ;
Boolean		lispMachine_QueueInEvent	(TLispMachine*, TLispEntity*, TLispEntity*) ;
Boolean		lispMachine_GetBuffer		(TLispMachine*, const Char*, int, TLispEntity**) ;
Boolean		lispMachine_GetFileBuffer	(TLispMachine*, const Char*, int, TLispEntity**) ;
Boolean		lispMachine_GenerateNewBufferName (TLispMachine*, const Char*, int, TLispEntity**) ;

TLMRESULT	lispMachine_ReadStringStart	(TLispMachine*, const Char*, int, TLispEntity*) ;

Boolean		lispMachine_UpdateCurrentFrame	(TLispMachine*) ;
Boolean		lispMachine_UpdateAllFrame		(TLispMachine*) ;
void		lispMachine_ScheduleUpdateAllFrame	(TLispMachine*) ;
Boolean		lispMachine_ResizeFrame			(TLispMachine*, TLispEntity*, const XRectangle*) ;
Boolean		lispMachine_UpdateWindow		(TLispMachine*, TLispEntity*, TLispEntity*) ;
Boolean		lispMachine_UpdateOverTheSpotFrameWindow(TLispMachine*, TLispEntity*, TLispEntity*) ;
Char		lispMachine_lispKeyEventSymbol2Char	(TLispManager* pLispMgr, TLispEntity*) ;

#include	"lmachine-inl.h"

#endif

