/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"

#define	lispEntity_GetConsPtr(ptr)	((TLispConscell *)((TLispEntity *)(ptr) + 1))

Boolean
lispMgr_CreateConscell (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntCar,
	register TLispEntity*			pEntCdr,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*			pEntity ;
	register TLispConscell*	pConscell ;

	assert (pLispMgr    != NULL) ;
	assert (pEntCar     != NULL) ;
	assert (pEntCdr     != NULL) ;
	assert (ppEntReturn != NULL) ;

#if defined (DEBUG_LV99)
	fprintf (stderr, "Garbage collecting ...") ;
	fflush (stderr) ;
	lispMgr_CollectGarbage (pLispMgr) ;
	fprintf (stderr, "done.\n") ;
#endif	
	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, sizeof (TLispConscell), &pEntity)))
		return	False ;
		
	pEntity->m_iType		= LISPENTITY_CONSCELL ;
	pEntity->m_lReferCount	= 0 ;	/* ľϻȥ󥿤 0*/
	pConscell				= lispEntity_GetConsPtr (pEntity) ;
	pConscell->m_pCar		= pEntCar ;
	pConscell->m_pCdr		= pEntCdr ;
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;

	*ppEntReturn	= pEntity ;
	return	True ;
}

Boolean
lispMgr_CreateList (
	register TLispManager*			pLispMgr,
	register TLispEntity**			ppEntities,
	register int					nEntities,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*			pNil ;
	TLispEntity*			pListTop ;
	register TLispEntity*	pListLast ;
	TLispEntity*			pNode ;

	assert (pLispMgr != NULL) ;
	assert ((nEntities >  0 && ppEntities != NULL) ||
			(nEntities == 0 && ppEntities == NULL)) ;
	assert (ppEntReturn != NULL) ;

	(void) lispMgr_CreateNil (pLispMgr, &pNil) ;
	if (nEntities > 0) {
		if (TFAILED (lispMgr_CreateConscell (pLispMgr, *ppEntities ++, pNil, &pListTop)))
			return	False ;
		nEntities	-- ;

		lispEntity_AddRef (pLispMgr, pListTop) ;
		pListLast	= pListTop ;
		while (nEntities > 0) {
			if (TFAILED (lispMgr_CreateConscell (pLispMgr, *ppEntities, pNil, &pNode))) {
				lispEntity_Release (pLispMgr, pListTop) ;
				return	False ;
			}
			lispEntity_SetCdr (pLispMgr, pListLast, pNode) ;
			pListLast	= pNode ;
			ppEntities	++ ;
			nEntities	-- ;
		}
		*ppEntReturn	= pListTop ;
		lispEntity_Release (pLispMgr, pListTop) ;
	} else {
		*ppEntReturn	= pNil ;
	}
	return	True ;
}

Boolean
lispEntity_PlistGet (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntPlist,
	register TLispEntity*			pEntProperty,
	register TLispEntity** const	ppEntRetval)
{
	TLispEntity*	pEntCar ;
	TLispEntity*	pEntCdr ;
	TLispEntity*	pEntRetval ;

	if (TFAILED (lispEntity_Consp (pLispMgr, pEntPlist))) 
		return	False ;

	lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntPlist))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntPlist, &pEntCar)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntPlist, &pEntCdr)) ||
			TFAILED (lispEntity_Consp  (pLispMgr, pEntCdr)))
			return	False ;
		if (TSUCCEEDED (lispEntity_Eq (pLispMgr, pEntCar, pEntProperty))) {
			lispEntity_GetCar (pLispMgr, pEntCdr, &pEntRetval) ;
			break ;
		}
		if (TFAILED (lispEntity_GetCdr (pLispMgr, pEntCdr, &pEntCdr)))
			return	False ;
		pEntPlist	= pEntCdr ;
	}
	*ppEntRetval	= pEntRetval ;
	return	True ;
}

Boolean
lispEntity_PlistPut (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntPlist,
	register TLispEntity*			pEntProperty,
	register TLispEntity*			pEntValue,
	register TLispEntity** const	ppEntRetval)
{
	TLispEntity*	pEntNewPlist ;
	TLispEntity*	apEntities [2] ;

	if (TSUCCEEDED (lispEntity_Consp (pLispMgr, pEntPlist))) {
		register TLispEntity*	pEntNode ;
		TLispEntity*	pEntNewTail ;
		TLispEntity*	pEntCar ;
		TLispEntity*	pEntCdr ;

		pEntNode	= pEntPlist ;
		while (TFAILED (lispEntity_Nullp (pLispMgr, pEntNode))) {
			if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntNode, &pEntCar)) ||
				TFAILED (lispEntity_GetCdr  (pLispMgr, pEntNode, &pEntCdr)) ||
				TFAILED (lispEntity_Consp   (pLispMgr, pEntCdr)))
				return	False ;
			if (TSUCCEEDED (lispEntity_Eq (pLispMgr, pEntCar, pEntProperty))) {
				lispEntity_SetCar (pLispMgr, pEntCdr, pEntValue) ;
				*ppEntRetval	= pEntPlist ;
				return	True ;
			}
			if (TFAILED (lispEntity_GetCdr (pLispMgr, pEntCdr, &pEntCdr)))
				return	False ;
			pEntNode	= pEntCdr ;
		}
		apEntities [0]	= pEntProperty ;
		apEntities [1]	= pEntValue ;
		if (TFAILED (lispMgr_CreateList (pLispMgr, apEntities, 2, &pEntNewTail)))
			return	False ;

		/*	list κǸ˲ä롣*/
		pEntNode	= pEntPlist ;
		while (TSUCCEEDED (lispEntity_GetCdr (pLispMgr, pEntNode, &pEntCdr)) &&
			   TFAILED (lispEntity_Nullp  (pLispMgr, pEntCdr)))
			pEntNode	= pEntCdr ;
		if (TFAILED (lispEntity_SetCdr (pLispMgr, pEntNode, pEntNewTail)))
			return	False ;
		*ppEntRetval	= pEntPlist ;
		return	True ;
	} else {
		apEntities [0]	= pEntProperty ;
		apEntities [1]	= pEntValue ;
		if (TFAILED (lispMgr_CreateList (pLispMgr, apEntities, 2, &pEntNewPlist)))
			return	False ;
		*ppEntRetval	= pEntNewPlist ;
		return	True ;
	}
}

Boolean
lispEntity_CopyList (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntList,
	register TLispEntity** const	ppEntRetval)
{
	register TLispEntity*	pEntHead ;
	register TLispEntity*	pEntTail ;
	TLispEntity*			pEntNewTail ;
	TLispEntity*			pEntNil ;
	TLispEntity*			pEntCar ;
	TLispEntity*			pEntCdr ;

	pEntHead	= NULL ;
	pEntTail	= NULL ;
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;

	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntList, &pEntCar)) ||
		TFAILED (lispEntity_GetCdr (pLispMgr, pEntList, &pEntCdr))) 
		return	False ;
	if (TFAILED (lispMgr_CreateConscell (pLispMgr, pEntCar, pEntNil, &pEntNewTail)))
		return	False ;
	pEntHead	= pEntNewTail ;
	pEntTail	= pEntNewTail ;
	lispEntity_AddRef (pLispMgr, pEntHead) ;
	pEntList	= pEntCdr ;

	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntList))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntList, &pEntCar)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntList, &pEntCdr))) 
			goto	error ;
		lispEntity_SetCdr (pLispMgr, pEntTail, pEntNewTail) ;
		pEntTail	= pEntNewTail ;
		pEntList	= pEntCdr ;
	}
	*ppEntRetval	= pEntHead ;
	lispEntity_Release (pLispMgr, pEntHead) ;
	return	True ;

  error:
	lispEntity_Release (pLispMgr, pEntHead) ;
	return	False ;
}

