/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*	Frame  Windows System  Window  View б롣
 *	Window ʬʬ Widget ¦˰ưΤȤ
 *	 Frame 礭ݤΤɤ򤹤٤
 */
#include "AfxWin.h"
#include <stdio.h>
#include "lispmgrp.h"
#include "TFontSet.h"
#include "TFrame.h"
#include "TTerminal.h"

#define	lispEntity_GetFramePtr(ptr)	((TLispFrame *)((TLispEntity *)(ptr) + 1))

/*
 *	(1) pEntBuffer != NULL
 *		(1.1) pEntMinibufWindow != NULL
 *			'(minibuffer . window) Ȥ߹碌
 *			minibuffer-window  pEntMinibufWindow Ϳ줿 Window
 *			Ƥ롣
 *		(1.2) pEntMinibufWindow == NULL
 *			(1.2.1) pEntMinibuf != NULL
 *				'(minibuffer . t) Ȥ߹碌
 *				minibuffer-window ơ buffer ˤ pEntMinibuf
 *				Ϳ롣
 *			(1.2.2) pEntMinibuf == NULL
 *				'(minibuffer . nil) Ȥ߹碌
 *				minibuffer-window ¸ߤʤ
 *	(2) pEntBuffer == NULL
 *		(2.1) pEntMinibufWindow != NULL
 *			ʤȤ߹碌顼
 *		(2.2) pEntMinibufWindow == NULL
 *			(2.2.1) pEntMinibuf == NULL
 *				ʤȤ߹碌顼
 *			(2.2.2) pEntMinibuf != NULL
 *				'(minibuffer . only) Ȥ߹碌
 */
Boolean
lispMgr_MakeFrame (
	register TLispManager*			pLispMgr, 			/* [in] */
	register Widget					gwFrame, 			/* [in] */
	register TLispEntity*			pEntBuffer, 		/* [in] */
	register TLispEntity*			pEntMinibuf, 		/* [in] */
	TLispEntity*					pEntMinibufWindow, 	/* [in] */
	register TLispEntity** const	ppEntReturn) 		/* [out] */
{
	TLispEntity*	pEntity ;
	TLispEntity*	pEntDefaultWindow ;
	TLispFrame*		pFrame ;
	XRectangle		arRect [2] ;
	int				nRect ;
	XRectangle		range ;
	TFontSet*		pFS ;

	assert (pLispMgr    != NULL) ;
	assert (gwFrame     != NULL) ;
	assert (ppEntReturn != NULL) ;
	assert (! (pEntBuffer == NULL &&
			   (pEntMinibufWindow != NULL ||
				(pEntMinibufWindow == NULL && pEntMinibuf == NULL)))) ;

	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, sizeof (TLispFrame), &pEntity)))
		return	False ;

	pEntity->m_iType	= LISPENTITY_FRAME ;
	pFrame				= lispEntity_GetFramePtr (pEntity) ;

	/*	Window System  Window 롣*/
	pFrame->m_wgWnd			= gwFrame ;
	pFrame->m_pPrevFrame	= NULL ;
	pFrame->m_pNextFrame	= NULL ;
	pFrame->m_lstEntWindow	= NULL ;
	pFrame->m_pEntMinibufWindow	= NULL ;
		
	/*	Frame  size Ȥ롣ޤǤϳꡣ*/
	nRect	= TFrame_GetRect (pFrame->m_wgWnd, arRect) ;
	if (nRect <= 0) {
		/*	Dummy Window Size */
		arRect [0].x		= 0 ;
		arRect [0].y		= 0 ;
		arRect [0].width	= 65535 ;
		arRect [0].height	= 65535 ;
	}

	pFS		= TFrame_GetFontSet (pFrame->m_wgWnd) ;

	if (pEntBuffer != NULL) {
		register Boolean	fInnerMinibuf	= False ;

		/*	Default Window 롣*/
		if (TFAILED (lispMgr_CreateWindow (pLispMgr, False, &pEntDefaultWindow)))
			return	False ;

		lispFrame_InsertWindow (pLispMgr, pEntity, pEntDefaultWindow) ;
		lispWindow_SetBuffer (pLispMgr, pEntDefaultWindow, pEntBuffer) ;
		lispWindow_SetFrame (pEntDefaultWindow, pEntity) ;

		if (pEntMinibufWindow == NULL && pEntMinibuf != NULL) {
			if (TFAILED (lispMgr_CreateWindow (pLispMgr, True, &pEntMinibufWindow)))
				return	False ;
			fInnerMinibuf	= True ;
		}
		pFrame->m_pEntMinibufWindow	= pEntMinibufWindow ;
		lispEntity_AddRef (pLispMgr, pEntMinibufWindow) ;
		if (fInnerMinibuf) {
			lispFrame_InsertWindow (pLispMgr, pEntity, pEntMinibufWindow) ;
			lispWindow_SetBuffer (pLispMgr, pEntMinibufWindow, pEntMinibuf) ;
		}
		
		/*	Window ΰ/롣*/
		range.x			= arRect [0].x ;
		range.y			= arRect [0].y ;
		range.width		= arRect [0].width ;
		range.height	= arRect [0].height ;
		if (fInnerMinibuf)
			range.height	-= pFS->m_iHeight ;
		lispWindow_SetArea  (pEntDefaultWindow, &range) ;

		if (pEntMinibufWindow != NULL && fInnerMinibuf) {
			range.y			= arRect [0].height - pFS->m_iHeight ;
			range.height	= pFS->m_iHeight ;
			lispWindow_SetArea  (pEntMinibufWindow, &range) ;
			lispWindow_SetFrame (pEntMinibufWindow, pEntity) ;
		}
		lispWindow_SetFocus (pEntDefaultWindow, True) ;
	} else {
		assert (pEntMinibufWindow == NULL) ;
		assert (pEntMinibuf != NULL) ;

		if (TFAILED (lispMgr_CreateWindow (pLispMgr, True, &pEntMinibufWindow)))
			return	False ;
		lispWindow_SetArea  (pEntMinibufWindow, &arRect [0]) ;
		lispWindow_SetFrame (pEntMinibufWindow, pEntity) ;
		lispFrame_InsertWindow (pLispMgr, pEntity, pEntMinibufWindow) ;
		lispWindow_SetBuffer (pLispMgr, pEntMinibufWindow, pEntMinibuf) ;
		pFrame->m_pEntMinibufWindow	= pEntMinibufWindow ;
		lispEntity_AddRef (pLispMgr, pEntMinibufWindow) ;
		lispWindow_SetFocus (pEntMinibufWindow, True) ;
	}
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;
	*ppEntReturn			= pEntity ;
	return	True ;
}

void
lispMgr_DestroyFrame (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntFrame)
{
	register TLispFrame*	pFrame ;

	assert (pLispMgr  != NULL) ;
	assert (pEntFrame != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;

#if defined (DEBUG) || 0
	fprintf (stderr, "lispMgr_DestroyFrame (%p, %p)\n", pLispMgr, pEntFrame) ;
#endif

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	/*	Window ˴롣*/
	if (pFrame->m_lstEntWindow != NULL) {
		register TLispEntity*	pEntWindow ;
		TLispEntity*			pEntNextWindow ;
		register Boolean		fExit ;

		pEntWindow	= pFrame->m_lstEntWindow ;
		do {
			lispWindow_GetNext (pEntWindow, &pEntNextWindow) ;
			fExit	= (pEntWindow == pEntNextWindow) ;
			lispFrame_RemoveWindow (pLispMgr, pEntFrame, pEntWindow) ;
			pEntWindow	= pEntNextWindow ;
		}	while (!fExit) ;

		pFrame->m_lstEntWindow	= NULL ;
	}
	if (pFrame->m_wgWnd != NULL) {
		XtDestroyWidget (pFrame->m_wgWnd) ;
		pFrame->m_wgWnd	= NULL ;
	}
	if (pFrame->m_pEntMinibufWindow != NULL) {
		lispEntity_Release (pLispMgr, pFrame->m_pEntMinibufWindow) ;
		pFrame->m_pEntMinibufWindow	= NULL;
	}
	return ;
}

Boolean
lispFrame_GetTopWindow (
	register TLispEntity*			pEntFrame,
	register TLispEntity** const	ppEntReturn)
{
	register TLispFrame*	pFrame ;

	assert (pEntFrame != NULL) ;
	assert (ppEntReturn     != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	if (pFrame->m_lstEntWindow == NULL)
		return	False ;
	*ppEntReturn	= pFrame->m_lstEntWindow ;
	return	True ;
}

/*
 *	(minibuffer-window &optional FRAME)
 *
 *	Minibuffer Window  Frame ФͿƤΤ餷
 *	˺ʤ褦ˡ(⤷ Minibuffer  Frame äȤƤ
 *	Frame ϿƤɤʡ)
 */
Boolean
lispFrame_GetMinibufferWindow (
	register TLispEntity*			pEntFrame,
	register TLispEntity** const	ppEntReturn)
{
	register TLispFrame*	pFrame ;

	assert (pEntFrame != NULL) ;
	assert (ppEntReturn     != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	if (pFrame->m_pEntMinibufWindow == NULL)
		return	False ;
	*ppEntReturn	= pFrame->m_pEntMinibufWindow ;
	return	True ;
}

Boolean
lispFrame_GetNext (
	register TLispEntity*			pEntFrame,
	register TLispEntity** const	ppEntReturn)
{
	register TLispFrame*	pFrame ;

	assert (pEntFrame != NULL) ;
	assert (ppEntReturn     != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	*ppEntReturn	= pFrame->m_pNextFrame ;
	return	True ;
}

Boolean
lispFrame_GetPrevious (
	register TLispEntity*			pEntFrame,
	register TLispEntity** const	ppEntReturn)
{
	register TLispFrame*	pFrame ;

	assert (pEntFrame != NULL) ;
	assert (ppEntReturn     != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	*ppEntReturn	= pFrame->m_pPrevFrame ;
	return	True ;
}

Boolean
lispFrame_SetNext (
	register TLispEntity*	pEntFrame,
	register TLispEntity*	pNextFrameEntity)
{
	register TLispFrame*	pFrame ;

	assert (pEntFrame != NULL) ;
	assert (pNextFrameEntity != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;
	assert (pNextFrameEntity->m_iType == LISPENTITY_FRAME) ;

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	pFrame->m_pNextFrame	= pNextFrameEntity ;
	return	True ;
}

Boolean
lispFrame_SetPrevious (
	register TLispEntity*	pEntFrame,
	register TLispEntity*	pPrevFrameEntity)
{
	register TLispFrame*	pFrame ;

	assert (pEntFrame != NULL) ;
	assert (pPrevFrameEntity != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;
	assert (pPrevFrameEntity->m_iType == LISPENTITY_FRAME) ;

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	pFrame->m_pPrevFrame	= pPrevFrameEntity ;
	return	True ;
}

/*
 *	Minibuffer Window ǤʤΤդ뤳ȡ
 */
Boolean
lispFrame_InsertWindow (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntFrame,
	register TLispEntity*	pWindowEntity)
{
	register TLispFrame*	pFrame ;

	assert (pLispMgr != NULL) ;
	assert (pEntFrame  != NULL) ;
	assert (pWindowEntity != NULL) ;
	assert (pEntFrame->m_iType  == LISPENTITY_FRAME) ;
	assert (pWindowEntity->m_iType == LISPENTITY_WINDOW) ;

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	if (pFrame->m_lstEntWindow == NULL) {
		lispWindow_SetNext     (pWindowEntity, pWindowEntity) ;
		lispWindow_SetPrevious (pWindowEntity, pWindowEntity) ;
		pFrame->m_lstEntWindow	= pWindowEntity ;
	} else {
		TLispEntity*	pPrevWindowEntity ;

		lispWindow_GetPrevious (pFrame->m_lstEntWindow, &pPrevWindowEntity) ;
		assert (pPrevWindowEntity != NULL) ;
		lispWindow_SetPrevious (pWindowEntity, pPrevWindowEntity) ;
		lispWindow_SetNext     (pWindowEntity, pFrame->m_lstEntWindow) ;
		lispWindow_SetNext     (pPrevWindowEntity, pWindowEntity) ;
		lispWindow_SetPrevious (pFrame->m_lstEntWindow, pWindowEntity) ;
	}
	lispEntity_AddRef (pLispMgr, pWindowEntity) ;
	return	True ;
}

Boolean
lispFrame_RemoveWindow (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntFrame,
	register TLispEntity*	pEntWindow)
{
	register TLispFrame*		pFrame ;
	TLispEntity*	pEntPrevWindow ;
	TLispEntity*	pEntNextWindow ;

	assert (pLispMgr != NULL) ;
	assert (pEntFrame  != NULL) ;
	assert (pEntWindow != NULL) ;
	assert (pEntFrame->m_iType  == LISPENTITY_FRAME) ;
	assert (pEntWindow->m_iType == LISPENTITY_WINDOW) ;

	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	assert (pFrame->m_lstEntWindow != NULL) ;

	lispWindow_GetNext     (pEntWindow, &pEntNextWindow) ;
	assert (pEntNextWindow != NULL) ;
	lispWindow_GetPrevious (pEntWindow, &pEntPrevWindow) ;
	assert (pEntPrevWindow != NULL) ;
	if (pEntNextWindow == pEntWindow) {
		assert (pEntPrevWindow == pEntWindow) ;
		assert (pFrame->m_lstEntWindow == pEntWindow) ;
		pFrame->m_lstEntWindow	= NULL ;
	} else {
		lispWindow_SetPrevious (pEntNextWindow, pEntPrevWindow) ;
		lispWindow_SetNext     (pEntPrevWindow, pEntNextWindow) ;
		if (pFrame->m_lstEntWindow == pEntWindow) 
			pFrame->m_lstEntWindow	= pEntNextWindow ;
	}
#if defined (DEBUG) || 0
	fprintf (stderr, "lispFrame_Remove: ") ;
	lispEntity_Print (pLispMgr, pEntWindow) ;
	fprintf (stderr, " -> ref(%ld)\n", pEntWindow->m_lReferCount) ;
#endif
	lispEntity_Release (pLispMgr, pEntWindow) ;
	return	True ;
}

/*
 *	(minibuffer-frame-list)
 *	`frame'  lisp function 餷
 *
 *	ʬȤ minibuffer ä frame ƤΥꥹȤ֤
 */

/*
 *	(make-initial-minibuffer-frame)
 *
 *	`frame'  lisp function 餷
 *
 *	ɥȤʤΤǲɤ⡢minibuffer-frame 뤳Ȥ
 *	ʬäƤ롣̤ Frame Ѥ Minibuffer ۤ
 *	ȤǤΤ⤷ʤ
 */

/*
 *	(frame-list)
 *
 *	Ƥ frame ΥꥹȤ֤ built-in function ʤΤǡ
 *	ȼʤФʤʤ
 *	LispMachine Ϥ frame ƴ˻ĤȤȤ
 */


Boolean
lispFrame_GetTerminal (
	register TLispEntity*		pEntFrame,
	register Widget* const		ppTerminal)
{
	register TLispFrame*		pFrame ;

	assert (pEntFrame != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;
	assert (ppTerminal   != NULL) ;
	
	pFrame			= lispEntity_GetFramePtr (pEntFrame) ;
	*ppTerminal		= pFrame->m_wgWnd ;
	return	True ;
}

void
lispFrame_Activate (
	register TLispManager*		pLispMgr,
	register TLispEntity*		pEntFrame,
	register Boolean			fActivate)
{
	register TLispFrame*		pFrame ;

	assert (pEntFrame != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;
	
	pFrame			= lispEntity_GetFramePtr (pEntFrame) ;
	assert (pFrame != NULL) ;
	assert (pFrame->m_wgWnd != NULL) ;
	TFrame_Activate (pFrame->m_wgWnd, fActivate) ;
	lispFrame_ScheduleUpdate (pLispMgr, pEntFrame) ;
	return ;
}

Boolean
lispFrame_NeedUpdatep (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntFrame)
{
	register TLispFrame*	pFrame ;
	register TLispEntity*	pEntWindow ;
	register TLispEntity*	pEntTopWindow ;
	TLispEntity*			pEntNextWindow ;

	assert (pLispMgr  != NULL) ;
	assert (pEntFrame != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;
	pFrame		= lispEntity_GetFramePtr (pEntFrame) ;
	assert (pFrame->m_lstEntWindow != NULL) ;

	pEntWindow		= NULL ;
	pEntTopWindow	= pFrame->m_lstEntWindow ;
	pEntNextWindow	= pEntTopWindow ;
	while (pEntWindow != pEntTopWindow) {
		pEntWindow	= pEntNextWindow ;
		if (TSUCCEEDED (lispWindow_NeedUpdatep (pLispMgr, pEntWindow)))
			return	True ;
		lispWindow_GetNext (pEntWindow, &pEntNextWindow) ;
	}
	return	False ;
}

void
lispFrame_ScheduleUpdate (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntFrame)
{
	register TLispFrame*	pFrame ;
	register TLispEntity*	pEntTopWindow ;

	assert (pLispMgr  != NULL) ;
	assert (pEntFrame != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;
	pFrame			= lispEntity_GetFramePtr (pEntFrame) ;
	assert (pFrame->m_lstEntWindow != NULL) ;
	pEntTopWindow	= pFrame->m_lstEntWindow ;
	lispWindow_Desync (pLispMgr, pEntTopWindow) ;
	return ;
}

