/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lispbind_h)
#define	lispbind_h

#include "lispmgr.h"

struct tagTLispEntity ;
struct tagTLispBind {
	struct tagTLispEntity*	m_pEntSymbol ;
	struct tagTLispEntity*	m_pEntValue ;
	struct tagTLispBind*	m_pLeft ;
	struct tagTLispBind*	m_pRight ;
} ;

typedef struct tagTLispBind		TLispBind ;

/*	Prototype */
Boolean	lispBind_Create					(TLispManager*, struct tagTLispEntity*, TLispBind**) ;
Boolean	lispBind_Destroy				(TLispManager*, TLispBind*) ;
Boolean	lispBind_GetValue				(TLispBind*, struct tagTLispEntity** const) ;
Boolean	lispBind_SetValue				(TLispManager*, TLispBind*, struct tagTLispEntity*) ;
/*Boolean	lispBind_Search				(TLispBind*, struct tagTLispEntity*, TLispBind** const, TLispBind** const) ;*/
Boolean	lispBind_Register				(TLispBind** const, TLispBind*) ;
Boolean	lispBind_Unregister				(TLispBind** const, TLispBind*) ;

Boolean	lispBindTable_Destroy			(TLispManager*, TLispBind** const, int) ;
Boolean	lispBindTable_MakeEntry			(TLispManager*, TLispBind** const, int, struct tagTLispEntity*, TLispBind** const) ;
Boolean	lispBindTable_SetEntryValue		(TLispManager*, TLispBind** const, int, struct tagTLispEntity*, struct tagTLispEntity*) ;
Boolean	lispBindTable_GetEntryValue		(TLispManager*, TLispBind** const, int, struct tagTLispEntity*, struct tagTLispEntity** const) ;
Boolean	lispBindTable_SearchEntry		(TLispManager*, TLispBind** const, int, struct tagTLispEntity*, TLispBind** const) ;

#endif

