/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(skkjishop_h)
#define	skkjishop_h

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <limits.h>
#include "kfile.h"

#if !defined (MAX_HOSTNAME)
#define	MAX_HOSTNAME	(1024)
#endif
#define KANAMOJI		(100)

/*
 *	Structures 
 */
typedef struct tagSKKSERVERJISYO {
	Boolean				m_fInit ;
	char				m_szHostname [MAX_HOSTNAME] ;
	int					m_nPortNum ;
	struct sockaddr_in	m_address ;
	struct hostent*		m_pHostent ;
	SOCKET				m_hSocket ;
	Boolean				m_fConnect ;
	Boolean				m_fUsed ;
	struct tagSKKSERVERJISYO*	m_pNext ;
}	SKKSERVERJISYO ;

/*
 *	SKK-JISYO.L Τ褦˥ȤƤ뼭빽¤Ρ
 *	ʸ沽ˡڤӥ򵭲롣
 */
typedef struct _tagSKKSORTEDJISYO {
	char							m_tszPath [PATH_MAX] ;
	int								m_nCodingSystem ;
	KFILE							m_JisyoFile ;
	long							m_lFormat ;
	long							m_jtab1 [KANAMOJI] ;
	long							m_jtab2 [KANAMOJI] ;
	struct _tagSKKSORTEDJISYO*		m_pNext ;
}	SKKSORTEDJISYO ;

/*
 *	.skk-jisyo Τ褦˥ȤƤʤ빽¤Ρ
 *	μʸ沽ˡ򵭲Ƥ
 */
typedef struct _tagSKKJISYO {
	char							m_tszPath [PATH_MAX] ;
	int								m_nCodingSystem ;
	struct _tagSKKJISYO*			m_pNext ;
}	SKKJISYO ;

#include "jisyo.h"

#endif

