/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "sysdep.h"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "varbuf.h"

/*
 *	ĹХåե롣
 */
BOOL
VarBuf_Init (PVARBUF pvarbuf, int nSize)
{
	assert (pvarbuf != NULL) ;
	assert (nSize > 0) ;

	pvarbuf->m_pBuffer	= pvarbuf->m_abInternal ;
	pvarbuf->m_nWidth	= nSize ;
	pvarbuf->m_nSize	= sizeof (pvarbuf->m_abInternal) / nSize ;
	pvarbuf->m_nUsage	= 0 ;
	return	TRUE ;
}

/*
 *	ĹХåե롣
 */
BOOL
VarBuf_Uninit (PVARBUF pvarbuf)
{
	assert (pvarbuf != NULL) ;

	if (pvarbuf->m_pBuffer != pvarbuf->m_abInternal) {
		FREE (pvarbuf->m_pBuffer) ;
		pvarbuf->m_pBuffer	= pvarbuf->m_abInternal ;
	}
	pvarbuf->m_nSize	= sizeof (pvarbuf->m_abInternal) ;
	pvarbuf->m_nWidth	= 1 ;
	pvarbuf->m_nUsage	= 0 ;
	return	TRUE ;
}

/*
 *	ĹХåե˥ǡࡣ
 */
BOOL
VarBuf_Puts (PVARBUF pvarbuf, void* pInput, int nLength)
{
	char*	pBuffer ;
	int		nPos ;
	int		iSize ;

	pBuffer	= (char *)pvarbuf->m_pBuffer ;
	nPos	= pvarbuf->m_nWidth * pvarbuf->m_nUsage ;

	if ((pvarbuf->m_nUsage + nLength) > pvarbuf->m_nSize) {
		iSize	= (pvarbuf->m_nUsage + nLength) * pvarbuf->m_nWidth + sizeof (pvarbuf->m_abInternal) - 1 ;
		iSize	= iSize - iSize % sizeof (pvarbuf->m_abInternal) ;
		assert (iSize > 0) ;

		pBuffer	= MALLOC (iSize) ;
		if (pBuffer == NULL)
			return	FALSE ;

		memcpy (pBuffer, pvarbuf->m_pBuffer, pvarbuf->m_nWidth * pvarbuf->m_nUsage) ;

		if (pvarbuf->m_pBuffer != pvarbuf->m_abInternal) 
			FREE (pvarbuf->m_pBuffer) ;

		pvarbuf->m_pBuffer	= (void *)pBuffer ;
		pvarbuf->m_nSize	= iSize / pvarbuf->m_nWidth ;
	}
	memcpy (pBuffer + nPos, pInput, pvarbuf->m_nWidth * nLength) ;
	pvarbuf->m_nUsage	+= nLength ;

	return	TRUE ;
}

/*
 *	ĹХåեλ̤롣
 */
int
VarBuf_GetUsage (PVARBUF pvarbuf)
{
	assert (pvarbuf != NULL) ;
	return	pvarbuf->m_nUsage ;
}

/*
 *	ĹХåեߤƤǡ1ʬ(礭)롣
 */
int
VarBuf_GetWidth (PVARBUF pvarbuf)
{
	assert (pvarbuf != NULL) ;
	return	pvarbuf->m_nWidth ;
}

/*
 *	ĹХåեߤƤǡ롣
 */
void*
VarBuf_GetBuffer (PVARBUF pvarbuf)
{
	assert (pvarbuf != NULL) ;
	return	pvarbuf->m_pBuffer ;
}

