/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (filebuf_h)
#define	filebuf_h

#include "Char.h"
#include "kanji.h"

/*========================================================================*
 *	
 *========================================================================*/
#define	FILEBUF_SIZE	(64)

/*========================================================================*
 *	
 *========================================================================*/

typedef struct {
	FILE*				m_fp ;
	KANJISTATEMACHINE	m_ksm ;
	Char				m_aiBuffer [FILEBUF_SIZE] ;
	int					m_iHead ;
	int					m_iUsage ;
}	FILEBUF ;

typedef FILEBUF	*PFILEBUF ;

/*========================================================================*
 *	ץȥ
 *========================================================================*/

int		FileBuf_Init (PFILEBUF pfbuf, FILE* fp, int iCodingSystem) ;
int		FileBuf_GetHead (PFILEBUF pfbuf) ;
int		FileBuf_GetUsage (PFILEBUF pfbuf) ;
Char	FileBuf_BufferedGetc (PFILEBUF pfbuf) ;
Char	FileBuf_Getc (PFILEBUF pfbuf) ;
int		FileBuf_Ungetc (PFILEBUF pfbuf, Char cc) ;
int		FileBuf_MoveHead (PFILEBUF pfbuf, int iHead) ;

#endif

